/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class StructureCheck {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_STRUCTURE = -1;
    private final ChunkScanAccess storageAccess;
    private final RegistryAccess registryAccess;
    private final StructureTemplateManager structureTemplateManager;
    private final ResourceKey<Level> dimension;
    private final ChunkGenerator chunkGenerator;
    private final RandomState randomState;
    private final LevelHeightAccessor heightAccessor;
    private final BiomeSource biomeSource;
    private final long seed;
    private final DataFixer fixerUpper;
    private final Long2ObjectMap<Object2IntMap<Structure>> loadedChunks = new Long2ObjectOpenHashMap();
    private final Map<Structure, Long2BooleanMap> featureChecks = new HashMap<Structure, Long2BooleanMap>();

    public StructureCheck(ChunkScanAccess var0, RegistryAccess var1, StructureTemplateManager var2, ResourceKey<Level> var3, ChunkGenerator var4, RandomState var5, LevelHeightAccessor var6, BiomeSource var7, long var8, DataFixer var10) {
        this.storageAccess = var0;
        this.registryAccess = var1;
        this.structureTemplateManager = var2;
        this.dimension = var3;
        this.chunkGenerator = var4;
        this.randomState = var5;
        this.heightAccessor = var6;
        this.biomeSource = var7;
        this.seed = var8;
        this.fixerUpper = var10;
    }

    public StructureCheckResult checkStart(ChunkPos var02, Structure var1, StructurePlacement var22, boolean var3) {
        long var4 = var02.toLong();
        Object2IntMap var6 = (Object2IntMap)this.loadedChunks.get(var4);
        if (var6 != null) {
            return this.checkStructureInfo((Object2IntMap<Structure>)var6, var1, var3);
        }
        StructureCheckResult var7 = this.tryLoadFromStorage(var02, var1, var3, var4);
        if (var7 != null) {
            return var7;
        }
        if (!var22.applyAdditionalChunkRestrictions(var02.x, var02.z, this.seed)) {
            return StructureCheckResult.START_NOT_PRESENT;
        }
        boolean var8 = this.featureChecks.computeIfAbsent(var1, var0 -> new Long2BooleanOpenHashMap()).computeIfAbsent(var4, var2 -> this.canCreateStructure(var02, var1));
        if (!var8) {
            return StructureCheckResult.START_NOT_PRESENT;
        }
        return StructureCheckResult.CHUNK_LOAD_NEEDED;
    }

    private boolean canCreateStructure(ChunkPos var0, Structure var1) {
        return var1.findValidGenerationPoint(new Structure.GenerationContext(this.registryAccess, this.chunkGenerator, this.biomeSource, this.randomState, this.structureTemplateManager, this.seed, var0, this.heightAccessor, var1.biomes()::contains)).isPresent();
    }

    @Nullable
    private StructureCheckResult tryLoadFromStorage(ChunkPos var0, Structure var1, boolean var2, long var3) {
        CompoundTag var9;
        CollectFields var5 = new CollectFields(new FieldSelector(IntTag.TYPE, "DataVersion"), new FieldSelector("Level", "Structures", CompoundTag.TYPE, "Starts"), new FieldSelector("structures", CompoundTag.TYPE, "starts"));
        try {
            this.storageAccess.scanChunk(var0, var5).join();
        }
        catch (Exception var6) {
            LOGGER.warn("Failed to read chunk {}", (Object)var0, (Object)var6);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Tag var6 = var5.getResult();
        if (!(var6 instanceof CompoundTag)) {
            return null;
        }
        CompoundTag var7 = (CompoundTag)var6;
        int var8 = ChunkStorage.getVersion(var7);
        if (var8 <= 1493) {
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        ChunkStorage.injectDatafixingContext(var7, this.dimension, this.chunkGenerator.getTypeNameForDataFixer());
        try {
            var9 = DataFixTypes.CHUNK.updateToCurrentVersion(this.fixerUpper, var7, var8);
        }
        catch (Exception var10) {
            LOGGER.warn("Failed to partially datafix chunk {}", (Object)var0, (Object)var10);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Object2IntMap<Structure> var10 = this.loadStructures(var9);
        if (var10 == null) {
            return null;
        }
        this.storeFullResults(var3, var10);
        return this.checkStructureInfo(var10, var1, var2);
    }

    @Nullable
    private Object2IntMap<Structure> loadStructures(CompoundTag var02) {
        Optional var1 = var02.getCompound("structures").flatMap(var0 -> var0.getCompound("starts"));
        if (var1.isEmpty()) {
            return null;
        }
        CompoundTag var2 = (CompoundTag)var1.get();
        if (var2.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap var3 = new Object2IntOpenHashMap();
        HolderLookup.RegistryLookup var4 = this.registryAccess.lookupOrThrow(Registries.STRUCTURE);
        var2.forEach((arg_0, arg_1) -> StructureCheck.lambda$loadStructures$4((Registry)var4, (Object2IntMap)var3, arg_0, arg_1));
        return var3;
    }

    private static Object2IntMap<Structure> deduplicateEmptyMap(Object2IntMap<Structure> var0) {
        return var0.isEmpty() ? Object2IntMaps.emptyMap() : var0;
    }

    private StructureCheckResult checkStructureInfo(Object2IntMap<Structure> var0, Structure var1, boolean var2) {
        int var3 = var0.getOrDefault((Object)var1, -1);
        return var3 != -1 && (!var2 || var3 == 0) ? StructureCheckResult.START_PRESENT : StructureCheckResult.START_NOT_PRESENT;
    }

    public void onStructureLoad(ChunkPos var0, Map<Structure, StructureStart> var1) {
        long var2 = var0.toLong();
        Object2IntOpenHashMap var4 = new Object2IntOpenHashMap();
        var1.forEach((arg_0, arg_1) -> StructureCheck.lambda$onStructureLoad$5((Object2IntMap)var4, arg_0, arg_1));
        this.storeFullResults(var2, (Object2IntMap<Structure>)var4);
    }

    private void storeFullResults(long var0, Object2IntMap<Structure> var22) {
        this.loadedChunks.put(var0, StructureCheck.deduplicateEmptyMap(var22));
        this.featureChecks.values().forEach(var2 -> var2.remove(var0));
    }

    public void incrementReference(ChunkPos var0, Structure var1) {
        this.loadedChunks.compute(var0.toLong(), (var12, var2) -> {
            if (var2 == null || var2.isEmpty()) {
                var2 = new Object2IntOpenHashMap();
            }
            var2.computeInt((Object)var1, (var0, var1) -> var1 == null ? 1 : var1 + 1);
            return var2;
        });
    }

    private static /* synthetic */ void lambda$onStructureLoad$5(Object2IntMap var0, Structure var1, StructureStart var2) {
        if (var2.isValid()) {
            var0.put((Object)var1, var2.getReferences());
        }
    }

    private static /* synthetic */ void lambda$loadStructures$4(Registry var0, Object2IntMap var1, String var22, Tag var3) {
        ResourceLocation var4 = ResourceLocation.tryParse(var22);
        if (var4 == null) {
            return;
        }
        Structure var5 = (Structure)var0.getValue(var4);
        if (var5 == null) {
            return;
        }
        var3.asCompound().ifPresent(var2 -> {
            String var3 = var2.getStringOr("id", "");
            if (!"INVALID".equals(var3)) {
                int var4 = var2.getIntOr("references", 0);
                var1.put((Object)var5, var4);
            }
        });
    }
}

