/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class FeaturePoolElement
extends StructurePoolElement {
    public static final MapCodec<FeaturePoolElement> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)PlacedFeature.CODEC.fieldOf("feature").forGetter(var0 -> var0.feature), FeaturePoolElement.projectionCodec()).apply((Applicative)var02, FeaturePoolElement::new));
    private static final ResourceLocation DEFAULT_JIGSAW_NAME = ResourceLocation.withDefaultNamespace("bottom");
    private final Holder<PlacedFeature> feature;
    private final CompoundTag defaultJigsawNBT;

    protected FeaturePoolElement(Holder<PlacedFeature> var0, StructureTemplatePool.Projection var1) {
        super(var1);
        this.feature = var0;
        this.defaultJigsawNBT = this.fillDefaultJigsawNBT();
    }

    private CompoundTag fillDefaultJigsawNBT() {
        CompoundTag var0 = new CompoundTag();
        var0.store("name", ResourceLocation.CODEC, DEFAULT_JIGSAW_NAME);
        var0.putString("final_state", "minecraft:air");
        var0.store("pool", JigsawBlockEntity.POOL_CODEC, Pools.EMPTY);
        var0.store("target", ResourceLocation.CODEC, JigsawBlockEntity.EMPTY_ID);
        var0.store("joint", JigsawBlockEntity.JointType.CODEC, JigsawBlockEntity.JointType.ROLLABLE);
        return var0;
    }

    @Override
    public Vec3i getSize(StructureTemplateManager var0, Rotation var1) {
        return Vec3i.ZERO;
    }

    @Override
    public List<StructureTemplate.JigsawBlockInfo> getShuffledJigsawBlocks(StructureTemplateManager var0, BlockPos var1, Rotation var2, RandomSource var3) {
        return List.of(StructureTemplate.JigsawBlockInfo.of(new StructureTemplate.StructureBlockInfo(var1, (BlockState)Blocks.JIGSAW.defaultBlockState().setValue(JigsawBlock.ORIENTATION, FrontAndTop.fromFrontAndTop(Direction.DOWN, Direction.SOUTH)), this.defaultJigsawNBT)));
    }

    @Override
    public BoundingBox getBoundingBox(StructureTemplateManager var0, BlockPos var1, Rotation var2) {
        Vec3i var3 = this.getSize(var0, var2);
        return new BoundingBox(var1.getX(), var1.getY(), var1.getZ(), var1.getX() + var3.getX(), var1.getY() + var3.getY(), var1.getZ() + var3.getZ());
    }

    @Override
    public boolean place(StructureTemplateManager var0, WorldGenLevel var1, StructureManager var2, ChunkGenerator var3, BlockPos var4, BlockPos var5, Rotation var6, BoundingBox var7, RandomSource var8, LiquidSettings var9, boolean var10) {
        return this.feature.value().place(var1, var3, var8, var4);
    }

    @Override
    public StructurePoolElementType<?> getType() {
        return StructurePoolElementType.FEATURE;
    }

    public String toString() {
        return "Feature[" + String.valueOf(this.feature) + "]";
    }
}

