/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class JigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int UNSET_HEIGHT = Integer.MIN_VALUE;

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext var02, Holder<StructureTemplatePool> var1, Optional<ResourceLocation> var2, int var3, BlockPos var4, boolean var5, Optional<Heightmap.Types> var6, int var7, PoolAliasLookup var8, DimensionPadding var9, LiquidSettings var10) {
        BlockPos var20;
        Optional<BlockPos> var22;
        Comparable<ResourceLocation> var21;
        RegistryAccess var11 = var02.registryAccess();
        ChunkGenerator var12 = var02.chunkGenerator();
        StructureTemplateManager var13 = var02.structureTemplateManager();
        LevelHeightAccessor var14 = var02.heightAccessor();
        WorldgenRandom var15 = var02.random();
        HolderLookup.RegistryLookup var16 = var11.lookupOrThrow(Registries.TEMPLATE_POOL);
        Rotation var17 = Rotation.getRandom(var15);
        StructureTemplatePool var18 = var1.unwrapKey().flatMap(arg_0 -> JigsawPlacement.lambda$addPieces$0((Registry)var16, var8, arg_0)).orElse(var1.value());
        StructurePoolElement var19 = var18.getRandomTemplate(var15);
        if (var19 == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if (var2.isPresent()) {
            var21 = var2.get();
            var22 = JigsawPlacement.getRandomNamedJigsaw(var19, (ResourceLocation)var21, var4, var17, var13, var15);
            if (var22.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)var21, (Object)var1.unwrapKey().map(var0 -> var0.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            var20 = (BlockPos)var22.get();
        } else {
            var20 = var4;
        }
        var21 = var20.subtract(var4);
        var22 = var4.subtract((Vec3i)var21);
        PoolElementStructurePiece var23 = new PoolElementStructurePiece(var13, var19, (BlockPos)((Object)var22), var19.getGroundLevelDelta(), var17, var19.getBoundingBox(var13, (BlockPos)((Object)var22), var17), var10);
        BoundingBox var24 = var23.getBoundingBox();
        int var25 = (var24.maxX() + var24.minX()) / 2;
        int var26 = (var24.maxZ() + var24.minZ()) / 2;
        int var27 = var6.isEmpty() ? ((Vec3i)((Object)var22)).getY() : var4.getY() + var12.getFirstFreeHeight(var25, var26, var6.get(), var14, var02.randomState());
        int var28 = var24.minY() + var23.getGroundLevelDelta();
        var23.move(0, var27 - var28, 0);
        if (JigsawPlacement.isStartTooCloseToWorldHeightLimits(var14, var9, var23.getBoundingBox())) {
            LOGGER.debug("Center piece {} with bounding box {} does not fit dimension padding {}", new Object[]{var19, var23.getBoundingBox(), var9});
            return Optional.empty();
        }
        int var29 = var27 + ((Vec3i)var21).getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos(var25, var29, var26), arg_0 -> JigsawPlacement.lambda$addPieces$2(var23, var3, var25, var7, var29, var14, var9, var26, var24, var02, var5, var12, var13, var15, (Registry)var16, var8, var10, arg_0)));
    }

    private static boolean isStartTooCloseToWorldHeightLimits(LevelHeightAccessor var0, DimensionPadding var1, BoundingBox var2) {
        if (var1 == DimensionPadding.ZERO) {
            return false;
        }
        int var3 = var0.getMinY() + var1.bottom();
        int var4 = var0.getMaxY() - var1.top();
        return var2.minY() < var3 || var2.maxY() > var4;
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement var0, ResourceLocation var1, BlockPos var2, Rotation var3, StructureTemplateManager var4, WorldgenRandom var5) {
        List<StructureTemplate.JigsawBlockInfo> var6 = var0.getShuffledJigsawBlocks(var4, var2, var3, var5);
        for (StructureTemplate.JigsawBlockInfo var8 : var6) {
            if (!var1.equals(var8.name())) continue;
            return Optional.of(var8.info().pos());
        }
        return Optional.empty();
    }

    private static void addPieces(RandomState var0, int var1, boolean var2, ChunkGenerator var3, StructureTemplateManager var4, LevelHeightAccessor var5, RandomSource var6, Registry<StructureTemplatePool> var7, PoolElementStructurePiece var8, List<PoolElementStructurePiece> var9, VoxelShape var10, PoolAliasLookup var11, LiquidSettings var12) {
        Placer var13 = new Placer(var7, var1, var3, var4, var9, var6);
        var13.tryPlacingChildren(var8, (MutableObject<VoxelShape>)new MutableObject((Object)var10), 0, var2, var5, var0, var11, var12);
        while (var13.placing.hasNext()) {
            PieceState var14 = (PieceState)var13.placing.next();
            var13.tryPlacingChildren(var14.piece, var14.free, var14.depth, var2, var5, var0, var11, var12);
        }
    }

    public static boolean generateJigsaw(ServerLevel var02, Holder<StructureTemplatePool> var1, ResourceLocation var2, int var3, BlockPos var4, boolean var5) {
        ChunkGenerator var6 = var02.getChunkSource().getGenerator();
        StructureTemplateManager var7 = var02.getStructureManager();
        StructureManager var8 = var02.structureManager();
        RandomSource var9 = var02.getRandom();
        Structure.GenerationContext var10 = new Structure.GenerationContext(var02.registryAccess(), var6, var6.getBiomeSource(), var02.getChunkSource().randomState(), var7, var02.getSeed(), new ChunkPos(var4), var02, var0 -> true);
        Optional<Structure.GenerationStub> var11 = JigsawPlacement.addPieces(var10, var1, Optional.of(var2), var3, var4, false, Optional.empty(), 128, PoolAliasLookup.EMPTY, JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS);
        if (var11.isPresent()) {
            StructurePiecesBuilder var12 = var11.get().getPiecesBuilder();
            for (StructurePiece var14 : var12.build().pieces()) {
                if (!(var14 instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece var15 = (PoolElementStructurePiece)var14;
                var15.place(var02, var8, var6, var9, BoundingBox.infinite(), var4, var5);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$addPieces$2(PoolElementStructurePiece var0, int var1, int var2, int var3, int var4, LevelHeightAccessor var5, DimensionPadding var6, int var7, BoundingBox var8, Structure.GenerationContext var9, boolean var10, ChunkGenerator var11, StructureTemplateManager var12, WorldgenRandom var13, Registry var14, PoolAliasLookup var15, LiquidSettings var16, StructurePiecesBuilder var17) {
        ArrayList var18 = Lists.newArrayList();
        var18.add(var0);
        if (var1 <= 0) {
            return;
        }
        AABB var19 = new AABB(var2 - var3, Math.max(var4 - var3, var5.getMinY() + var6.bottom()), var7 - var3, var2 + var3 + 1, Math.min(var4 + var3 + 1, var5.getMaxY() + 1 - var6.top()), var7 + var3 + 1);
        VoxelShape var20 = Shapes.join(Shapes.create(var19), Shapes.create(AABB.of(var8)), BooleanOp.ONLY_FIRST);
        JigsawPlacement.addPieces(var9.randomState(), var1, var10, var11, var12, var5, var13, var14, var0, var18, var20, var15, var16);
        var18.forEach(var17::addPiece);
    }

    private static /* synthetic */ Optional lambda$addPieces$0(Registry var0, PoolAliasLookup var1, ResourceKey var2) {
        return var0.getOptional(var1.lookup(var2));
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<PieceState> placing = new SequencedPriorityIterator();

        Placer(Registry<StructureTemplatePool> var0, int var1, ChunkGenerator var2, StructureTemplateManager var3, List<? super PoolElementStructurePiece> var4, RandomSource var5) {
            this.pools = var0;
            this.maxDepth = var1;
            this.chunkGenerator = var2;
            this.structureTemplateManager = var3;
            this.pieces = var4;
            this.random = var5;
        }

        void tryPlacingChildren(PoolElementStructurePiece var02, MutableObject<VoxelShape> var1, int var22, boolean var3, LevelHeightAccessor var4, RandomState var5, PoolAliasLookup var6, LiquidSettings var7) {
            StructurePoolElement var8 = var02.getElement();
            BlockPos var9 = var02.getPosition();
            Rotation var10 = var02.getRotation();
            StructureTemplatePool.Projection var11 = var8.getProjection();
            boolean var12 = var11 == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> var13 = new MutableObject<VoxelShape>();
            BoundingBox var14 = var02.getBoundingBox();
            int var15 = var14.minY();
            block0: for (StructureTemplate.JigsawBlockInfo var17 : var8.getShuffledJigsawBlocks(this.structureTemplateManager, var9, var10, this.random)) {
                StructurePoolElement var33;
                MutableObject<VoxelShape> var28;
                StructureTemplate.StructureBlockInfo var18 = var17.info();
                Direction var19 = JigsawBlock.getFrontFacing(var18.state());
                BlockPos var20 = var18.pos();
                BlockPos var21 = var20.relative(var19);
                int var222 = var20.getY() - var15;
                int var23 = Integer.MIN_VALUE;
                ResourceKey<StructureTemplatePool> var24 = var6.lookup(var17.pool());
                Optional var25 = this.pools.get(var24);
                if (var25.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)var24.location());
                    continue;
                }
                Holder var26 = (Holder)var25.get();
                if (((StructureTemplatePool)var26.value()).size() == 0 && !var26.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)var24.location());
                    continue;
                }
                Holder<StructureTemplatePool> var27 = ((StructureTemplatePool)var26.value()).getFallback();
                if (var27.value().size() == 0 && !var27.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)var27.unwrapKey().map(var0 -> var0.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean var29 = var14.isInside(var21);
                if (var29) {
                    var28 = var13;
                    if (var13.getValue() == null) {
                        var13.setValue((Object)Shapes.create(AABB.of(var14)));
                    }
                } else {
                    var28 = var1;
                }
                ArrayList var30 = Lists.newArrayList();
                if (var22 != this.maxDepth) {
                    var30.addAll(((StructureTemplatePool)var26.value()).getShuffledTemplates(this.random));
                }
                var30.addAll(var27.value().getShuffledTemplates(this.random));
                int var31 = var17.placementPriority();
                Iterator iterator = var30.iterator();
                while (iterator.hasNext() && (var33 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation var35 : Rotation.getShuffled(this.random)) {
                        List<StructureTemplate.JigsawBlockInfo> var36 = var33.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, var35, this.random);
                        BoundingBox var37 = var33.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, var35);
                        int var38 = !var3 || var37.getYSpan() > 16 ? 0 : var36.stream().mapToInt(var2 -> {
                            StructureTemplate.StructureBlockInfo var3 = var2.info();
                            if (!var37.isInside(var3.pos().relative(JigsawBlock.getFrontFacing(var3.state())))) {
                                return 0;
                            }
                            ResourceKey<StructureTemplatePool> var4 = var6.lookup(var2.pool());
                            Optional var5 = this.pools.get(var4);
                            Optional<Holder> var6 = var5.map(var0 -> ((StructureTemplatePool)var0.value()).getFallback());
                            int var7 = var5.map(var0 -> ((StructureTemplatePool)var0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            int var8 = var6.map(var0 -> ((StructureTemplatePool)var0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            return Math.max(var7, var8);
                        }).max().orElse(0);
                        for (StructureTemplate.JigsawBlockInfo var40 : var36) {
                            int var56;
                            int var53;
                            int var49;
                            if (!JigsawBlock.canAttach(var17, var40)) continue;
                            BlockPos var41 = var40.info().pos();
                            BlockPos var42 = var21.subtract(var41);
                            BoundingBox var43 = var33.getBoundingBox(this.structureTemplateManager, var42, var35);
                            int var44 = var43.minY();
                            StructureTemplatePool.Projection var45 = var33.getProjection();
                            boolean var46 = var45 == StructureTemplatePool.Projection.RIGID;
                            int var47 = var41.getY();
                            int var48 = var222 - var47 + JigsawBlock.getFrontFacing(var18.state()).getStepY();
                            if (var12 && var46) {
                                var49 = var15 + var48;
                            } else {
                                if (var23 == Integer.MIN_VALUE) {
                                    var23 = this.chunkGenerator.getFirstFreeHeight(var20.getX(), var20.getZ(), Heightmap.Types.WORLD_SURFACE_WG, var4, var5);
                                }
                                var49 = var23 - var47;
                            }
                            int var50 = var49 - var44;
                            BoundingBox var51 = var43.moved(0, var50, 0);
                            BlockPos var52 = var42.offset(0, var50, 0);
                            if (var38 > 0) {
                                var53 = Math.max(var38 + 1, var51.maxY() - var51.minY());
                                var51.encapsulate(new BlockPos(var51.minX(), var51.minY() + var53, var51.minZ()));
                            }
                            if (Shapes.joinIsNotEmpty((VoxelShape)var28.getValue(), Shapes.create(AABB.of(var51).deflate(0.25)), BooleanOp.ONLY_SECOND)) continue;
                            var28.setValue((Object)Shapes.joinUnoptimized((VoxelShape)var28.getValue(), Shapes.create(AABB.of(var51)), BooleanOp.ONLY_FIRST));
                            var53 = var02.getGroundLevelDelta();
                            int var54 = var46 ? var53 - var48 : var33.getGroundLevelDelta();
                            PoolElementStructurePiece var55 = new PoolElementStructurePiece(this.structureTemplateManager, var33, var52, var54, var35, var51, var7);
                            if (var12) {
                                var56 = var15 + var222;
                            } else if (var46) {
                                var56 = var49 + var47;
                            } else {
                                if (var23 == Integer.MIN_VALUE) {
                                    var23 = this.chunkGenerator.getFirstFreeHeight(var20.getX(), var20.getZ(), Heightmap.Types.WORLD_SURFACE_WG, var4, var5);
                                }
                                var56 = var23 + var48 / 2;
                            }
                            var02.addJunction(new JigsawJunction(var21.getX(), var56 - var222 + var53, var21.getZ(), var48, var45));
                            var55.addJunction(new JigsawJunction(var20.getX(), var56 - var47 + var54, var20.getZ(), -var48, var11));
                            this.pieces.add(var55);
                            if (var22 + 1 > this.maxDepth) continue block0;
                            PieceState var57 = new PieceState(var55, var28, var22 + 1);
                            this.placing.add(var57, var31);
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class PieceState
    extends Record {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece var0, MutableObject<VoxelShape> var1, int var2) {
            this.piece = var0;
            this.free = var1;
            this.depth = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PieceState.class, "piece;free;depth", "piece", "free", "depth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PieceState.class, "piece;free;depth", "piece", "free", "depth"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PieceState.class, "piece;free;depth", "piece", "free", "depth"}, this, var0);
        }

        public PoolElementStructurePiece piece() {
            return this.piece;
        }

        public MutableObject<VoxelShape> free() {
            return this.free;
        }

        public int depth() {
            return this.depth;
        }
    }
}

