/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.IglooPieces;

public class IglooStructure
extends Structure {
    public static final MapCodec<IglooStructure> CODEC = IglooStructure.simpleCodec(IglooStructure::new);

    public IglooStructure(Structure.StructureSettings var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        return IglooStructure.onTopOfChunkCenter(var0, Heightmap.Types.WORLD_SURFACE_WG, var1 -> this.generatePieces((StructurePiecesBuilder)var1, var0));
    }

    private void generatePieces(StructurePiecesBuilder var0, Structure.GenerationContext var1) {
        ChunkPos var2 = var1.chunkPos();
        WorldgenRandom var3 = var1.random();
        BlockPos var4 = new BlockPos(var2.getMinBlockX(), 90, var2.getMinBlockZ());
        Rotation var5 = Rotation.getRandom(var3);
        IglooPieces.addPieces(var1.structureTemplateManager(), var4, var5, var0, var3);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.IGLOO;
    }
}

