/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public final class ImprovedNoise {
    private static final float SHIFT_UP_EPSILON = 1.0E-7f;
    private final byte[] p;
    public final double xo;
    public final double yo;
    public final double zo;

    public ImprovedNoise(RandomSource var0) {
        int var1;
        this.xo = var0.nextDouble() * 256.0;
        this.yo = var0.nextDouble() * 256.0;
        this.zo = var0.nextDouble() * 256.0;
        this.p = new byte[256];
        for (var1 = 0; var1 < 256; ++var1) {
            this.p[var1] = (byte)var1;
        }
        for (var1 = 0; var1 < 256; ++var1) {
            int var2 = var0.nextInt(256 - var1);
            byte var3 = this.p[var1];
            this.p[var1] = this.p[var1 + var2];
            this.p[var1 + var2] = var3;
        }
    }

    public double noise(double var0, double var2, double var4) {
        return this.noise(var0, var2, var4, 0.0, 0.0);
    }

    @Deprecated
    public double noise(double var0, double var2, double var4, double var6, double var8) {
        double var25;
        double var10 = var0 + this.xo;
        double var12 = var2 + this.yo;
        double var14 = var4 + this.zo;
        int var16 = Mth.floor(var10);
        int var17 = Mth.floor(var12);
        int var18 = Mth.floor(var14);
        double var19 = var10 - (double)var16;
        double var21 = var12 - (double)var17;
        double var23 = var14 - (double)var18;
        if (var6 != 0.0) {
            double var27 = var8 >= 0.0 && var8 < var21 ? var8 : var21;
            var25 = (double)Mth.floor(var27 / var6 + (double)1.0E-7f) * var6;
        } else {
            var25 = 0.0;
        }
        return this.sampleAndLerp(var16, var17, var18, var19, var21 - var25, var23, var21);
    }

    public double noiseWithDerivative(double var0, double var2, double var4, double[] var6) {
        double var7 = var0 + this.xo;
        double var9 = var2 + this.yo;
        double var11 = var4 + this.zo;
        int var13 = Mth.floor(var7);
        int var14 = Mth.floor(var9);
        int var15 = Mth.floor(var11);
        double var16 = var7 - (double)var13;
        double var18 = var9 - (double)var14;
        double var20 = var11 - (double)var15;
        return this.sampleWithDerivative(var13, var14, var15, var16, var18, var20, var6);
    }

    private static double gradDot(int var0, double var1, double var3, double var5) {
        return SimplexNoise.dot(SimplexNoise.GRADIENT[var0 & 0xF], var1, var3, var5);
    }

    private int p(int var0) {
        return this.p[var0 & 0xFF] & 0xFF;
    }

    private double sampleAndLerp(int var0, int var1, int var2, double var3, double var5, double var7, double var9) {
        int var11 = this.p(var0);
        int var12 = this.p(var0 + 1);
        int var13 = this.p(var11 + var1);
        int var14 = this.p(var11 + var1 + 1);
        int var15 = this.p(var12 + var1);
        int var16 = this.p(var12 + var1 + 1);
        double var17 = ImprovedNoise.gradDot(this.p(var13 + var2), var3, var5, var7);
        double var19 = ImprovedNoise.gradDot(this.p(var15 + var2), var3 - 1.0, var5, var7);
        double var21 = ImprovedNoise.gradDot(this.p(var14 + var2), var3, var5 - 1.0, var7);
        double var23 = ImprovedNoise.gradDot(this.p(var16 + var2), var3 - 1.0, var5 - 1.0, var7);
        double var25 = ImprovedNoise.gradDot(this.p(var13 + var2 + 1), var3, var5, var7 - 1.0);
        double var27 = ImprovedNoise.gradDot(this.p(var15 + var2 + 1), var3 - 1.0, var5, var7 - 1.0);
        double var29 = ImprovedNoise.gradDot(this.p(var14 + var2 + 1), var3, var5 - 1.0, var7 - 1.0);
        double var31 = ImprovedNoise.gradDot(this.p(var16 + var2 + 1), var3 - 1.0, var5 - 1.0, var7 - 1.0);
        double var33 = Mth.smoothstep(var3);
        double var35 = Mth.smoothstep(var9);
        double var37 = Mth.smoothstep(var7);
        return Mth.lerp3(var33, var35, var37, var17, var19, var21, var23, var25, var27, var29, var31);
    }

    private double sampleWithDerivative(int var0, int var1, int var2, double var3, double var5, double var7, double[] var9) {
        int var10 = this.p(var0);
        int var11 = this.p(var0 + 1);
        int var12 = this.p(var10 + var1);
        int var13 = this.p(var10 + var1 + 1);
        int var14 = this.p(var11 + var1);
        int var15 = this.p(var11 + var1 + 1);
        int var16 = this.p(var12 + var2);
        int var17 = this.p(var14 + var2);
        int var18 = this.p(var13 + var2);
        int var19 = this.p(var15 + var2);
        int var20 = this.p(var12 + var2 + 1);
        int var21 = this.p(var14 + var2 + 1);
        int var22 = this.p(var13 + var2 + 1);
        int var23 = this.p(var15 + var2 + 1);
        int[] var24 = SimplexNoise.GRADIENT[var16 & 0xF];
        int[] var25 = SimplexNoise.GRADIENT[var17 & 0xF];
        int[] var26 = SimplexNoise.GRADIENT[var18 & 0xF];
        int[] var27 = SimplexNoise.GRADIENT[var19 & 0xF];
        int[] var28 = SimplexNoise.GRADIENT[var20 & 0xF];
        int[] var29 = SimplexNoise.GRADIENT[var21 & 0xF];
        int[] var30 = SimplexNoise.GRADIENT[var22 & 0xF];
        int[] var31 = SimplexNoise.GRADIENT[var23 & 0xF];
        double var32 = SimplexNoise.dot(var24, var3, var5, var7);
        double var34 = SimplexNoise.dot(var25, var3 - 1.0, var5, var7);
        double var36 = SimplexNoise.dot(var26, var3, var5 - 1.0, var7);
        double var38 = SimplexNoise.dot(var27, var3 - 1.0, var5 - 1.0, var7);
        double var40 = SimplexNoise.dot(var28, var3, var5, var7 - 1.0);
        double var42 = SimplexNoise.dot(var29, var3 - 1.0, var5, var7 - 1.0);
        double var44 = SimplexNoise.dot(var30, var3, var5 - 1.0, var7 - 1.0);
        double var46 = SimplexNoise.dot(var31, var3 - 1.0, var5 - 1.0, var7 - 1.0);
        double var48 = Mth.smoothstep(var3);
        double var50 = Mth.smoothstep(var5);
        double var52 = Mth.smoothstep(var7);
        double var54 = Mth.lerp3(var48, var50, var52, var24[0], var25[0], var26[0], var27[0], var28[0], var29[0], var30[0], var31[0]);
        double var56 = Mth.lerp3(var48, var50, var52, var24[1], var25[1], var26[1], var27[1], var28[1], var29[1], var30[1], var31[1]);
        double var58 = Mth.lerp3(var48, var50, var52, var24[2], var25[2], var26[2], var27[2], var28[2], var29[2], var30[2], var31[2]);
        double var60 = Mth.lerp2(var50, var52, var34 - var32, var38 - var36, var42 - var40, var46 - var44);
        double var62 = Mth.lerp2(var52, var48, var36 - var32, var44 - var40, var38 - var34, var46 - var42);
        double var64 = Mth.lerp2(var48, var50, var40 - var32, var42 - var34, var44 - var36, var46 - var38);
        double var66 = Mth.smoothstepDerivative(var3);
        double var68 = Mth.smoothstepDerivative(var5);
        double var70 = Mth.smoothstepDerivative(var7);
        double var72 = var54 + var66 * var60;
        double var74 = var56 + var68 * var62;
        double var76 = var58 + var70 * var64;
        var9[0] = var9[0] + var72;
        var9[1] = var9[1] + var74;
        var9[2] = var9[2] + var76;
        return Mth.lerp3(var48, var50, var52, var32, var34, var36, var38, var40, var42, var44, var46);
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder var0) {
        NoiseUtils.parityNoiseOctaveConfigString(var0, this.xo, this.yo, this.zo, this.p);
    }
}

