/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetWritableBookPagesFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetWritableBookPagesFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetWritableBookPagesFunction.commonFields(var02).and(var02.group((App)WritableBookContent.PAGES_CODEC.fieldOf("pages").forGetter(var0 -> var0.pages), (App)ListOperation.codec(100).forGetter(var0 -> var0.pageOperation))).apply((Applicative)var02, SetWritableBookPagesFunction::new));
    private final List<Filterable<String>> pages;
    private final ListOperation pageOperation;

    protected SetWritableBookPagesFunction(List<LootItemCondition> var0, List<Filterable<String>> var1, ListOperation var2) {
        super(var0);
        this.pages = var1;
        this.pageOperation = var2;
    }

    @Override
    protected ItemStack run(ItemStack var0, LootContext var1) {
        var0.update(DataComponents.WRITABLE_BOOK_CONTENT, WritableBookContent.EMPTY, this::apply);
        return var0;
    }

    public WritableBookContent apply(WritableBookContent var0) {
        List<Filterable<String>> var1 = this.pageOperation.apply(var0.pages(), this.pages, 100);
        return var0.withReplacedPages((List)var1);
    }

    public LootItemFunctionType<SetWritableBookPagesFunction> getType() {
        return LootItemFunctions.SET_WRITABLE_BOOK_PAGES;
    }
}

