/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Scoreboard;

public record EntityHasScoreCondition(Map<String, IntRange> scores, LootContext.EntityTarget entityTarget) implements LootItemCondition
{
    public static final MapCodec<EntityHasScoreCondition> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.unboundedMap((Codec)Codec.STRING, IntRange.CODEC).fieldOf("scores").forGetter(EntityHasScoreCondition::scores), (App)LootContext.EntityTarget.CODEC.fieldOf("entity").forGetter(EntityHasScoreCondition::entityTarget)).apply((Applicative)var0, EntityHasScoreCondition::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.ENTITY_SCORES;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return (Set)Stream.concat(Stream.of(this.entityTarget.getParam()), this.scores.values().stream().flatMap(var0 -> var0.getReferencedContextParams().stream())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean test(LootContext var0) {
        Entity var1 = var0.getOptionalParameter(this.entityTarget.getParam());
        if (var1 == null) {
            return false;
        }
        ServerScoreboard var2 = var0.getLevel().getScoreboard();
        for (Map.Entry<String, IntRange> var4 : this.scores.entrySet()) {
            if (this.hasScore(var0, var1, var2, var4.getKey(), var4.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean hasScore(LootContext var0, Entity var1, Scoreboard var2, String var3, IntRange var4) {
        Objective var5 = var2.getObjective(var3);
        if (var5 == null) {
            return false;
        }
        ReadOnlyScoreInfo var6 = var2.getPlayerScoreInfo(var1, var5);
        if (var6 == null) {
            return false;
        }
        return var4.test(var0, var6.value());
    }

    public static Builder hasScores(LootContext.EntityTarget var0) {
        return new Builder(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootContext)object);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final ImmutableMap.Builder<String, IntRange> scores = ImmutableMap.builder();
        private final LootContext.EntityTarget entityTarget;

        public Builder(LootContext.EntityTarget var0) {
            this.entityTarget = var0;
        }

        public Builder withScore(String var0, IntRange var1) {
            this.scores.put((Object)var0, (Object)var1);
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new EntityHasScoreCondition((Map<String, IntRange>)this.scores.build(), this.entityTarget);
        }
    }
}

