/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.MinecartCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CollisionContext {
    public static CollisionContext empty() {
        return EntityCollisionContext.EMPTY;
    }

    public static CollisionContext of(Entity var0) {
        Entity entity = var0;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractMinecart.class}, (Object)entity2, n)) {
            case 0 -> {
                AbstractMinecart var3 = (AbstractMinecart)entity2;
                if (AbstractMinecart.useExperimentalMovement(var3.level())) {
                    yield new MinecartCollisionContext(var3, false);
                }
                yield new EntityCollisionContext(var0, false, false);
            }
            default -> new EntityCollisionContext(var0, false, false);
        };
    }

    public static CollisionContext of(Entity var0, boolean var1) {
        return new EntityCollisionContext(var0, var1, false);
    }

    public static CollisionContext placementContext(@Nullable Player var02) {
        Predicate<FluidState> predicate;
        ItemStack itemStack;
        Player var12;
        boolean bl = var02 != null ? var02.isDescending() : false;
        double d = var02 != null ? var02.getY() : -1.7976931348623157E308;
        if (var02 instanceof LivingEntity) {
            var12 = var02;
            itemStack = var12.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (var02 instanceof LivingEntity) {
            var12 = var02;
            predicate = var1 -> var12.canStandOnFluid((FluidState)var1);
        } else {
            predicate = var0 -> false;
        }
        return new EntityCollisionContext(bl, true, d, itemStack, predicate, var02);
    }

    public static CollisionContext withPosition(@Nullable Entity var02, double var12) {
        Predicate<FluidState> predicate;
        ItemStack itemStack;
        LivingEntity var3;
        boolean bl = var02 != null ? var02.isDescending() : false;
        double d = var02 != null ? var12 : -1.7976931348623157E308;
        if (var02 instanceof LivingEntity) {
            var3 = (LivingEntity)var02;
            itemStack = var3.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (var02 instanceof LivingEntity) {
            var3 = (LivingEntity)var02;
            predicate = var1 -> var3.canStandOnFluid((FluidState)var1);
        } else {
            predicate = var0 -> false;
        }
        return new EntityCollisionContext(bl, true, d, itemStack, predicate, var02);
    }

    public boolean isDescending();

    public boolean isAbove(VoxelShape var1, BlockPos var2, boolean var3);

    public boolean isHoldingItem(Item var1);

    public boolean canStandOnFluid(FluidState var1, FluidState var2);

    public VoxelShape getCollisionShape(BlockState var1, CollisionGetter var2, BlockPos var3);

    default public boolean isPlacement() {
        return false;
    }
}

