/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import com.mojang.math.OctahedralGroup;
import com.mojang.math.Quadrant;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteCubeMerger;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.IdenticalMerger;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.IndirectMerger;
import net.minecraft.world.phys.shapes.NonOverlappingMerger;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Shapes {
    public static final double EPSILON = 1.0E-7;
    public static final double BIG_EPSILON = 1.0E-6;
    private static final VoxelShape BLOCK = Util.make(() -> {
        BitSetDiscreteVoxelShape var0 = new BitSetDiscreteVoxelShape(1, 1, 1);
        ((DiscreteVoxelShape)var0).fill(0, 0, 0);
        return new CubeVoxelShape(var0);
    });
    private static final Vec3 BLOCK_CENTER = new Vec3(0.5, 0.5, 0.5);
    public static final VoxelShape INFINITY = Shapes.box(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape EMPTY = new ArrayVoxelShape((DiscreteVoxelShape)new BitSetDiscreteVoxelShape(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));

    public static VoxelShape empty() {
        return EMPTY;
    }

    public static VoxelShape block() {
        return BLOCK;
    }

    public static VoxelShape box(double var0, double var2, double var4, double var6, double var8, double var10) {
        if (var0 > var6 || var2 > var8 || var4 > var10) {
            throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
        }
        return Shapes.create(var0, var2, var4, var6, var8, var10);
    }

    public static VoxelShape create(double var0, double var2, double var4, double var6, double var8, double var10) {
        if (var6 - var0 < 1.0E-7 || var8 - var2 < 1.0E-7 || var10 - var4 < 1.0E-7) {
            return Shapes.empty();
        }
        int var12 = Shapes.findBits(var0, var6);
        int var13 = Shapes.findBits(var2, var8);
        int var14 = Shapes.findBits(var4, var10);
        if (var12 < 0 || var13 < 0 || var14 < 0) {
            return new ArrayVoxelShape(Shapes.BLOCK.shape, (DoubleList)DoubleArrayList.wrap((double[])new double[]{var0, var6}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{var2, var8}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{var4, var10}));
        }
        if (var12 == 0 && var13 == 0 && var14 == 0) {
            return Shapes.block();
        }
        int var15 = 1 << var12;
        int var16 = 1 << var13;
        int var17 = 1 << var14;
        BitSetDiscreteVoxelShape var18 = BitSetDiscreteVoxelShape.withFilledBounds(var15, var16, var17, (int)Math.round(var0 * (double)var15), (int)Math.round(var2 * (double)var16), (int)Math.round(var4 * (double)var17), (int)Math.round(var6 * (double)var15), (int)Math.round(var8 * (double)var16), (int)Math.round(var10 * (double)var17));
        return new CubeVoxelShape(var18);
    }

    public static VoxelShape create(AABB var0) {
        return Shapes.create(var0.minX, var0.minY, var0.minZ, var0.maxX, var0.maxY, var0.maxZ);
    }

    @VisibleForTesting
    protected static int findBits(double var0, double var2) {
        if (var0 < -1.0E-7 || var2 > 1.0000001) {
            return -1;
        }
        for (int var4 = 0; var4 <= 3; ++var4) {
            boolean var11;
            int var5 = 1 << var4;
            double var6 = var0 * (double)var5;
            double var8 = var2 * (double)var5;
            boolean var10 = Math.abs(var6 - (double)Math.round(var6)) < 1.0E-7 * (double)var5;
            boolean bl = var11 = Math.abs(var8 - (double)Math.round(var8)) < 1.0E-7 * (double)var5;
            if (!var10 || !var11) continue;
            return var4;
        }
        return -1;
    }

    protected static long lcm(int var0, int var1) {
        return (long)var0 * (long)(var1 / IntMath.gcd((int)var0, (int)var1));
    }

    public static VoxelShape or(VoxelShape var0, VoxelShape var1) {
        return Shapes.join(var0, var1, BooleanOp.OR);
    }

    public static VoxelShape or(VoxelShape var0, VoxelShape ... var1) {
        return Arrays.stream(var1).reduce(var0, Shapes::or);
    }

    public static VoxelShape join(VoxelShape var0, VoxelShape var1, BooleanOp var2) {
        return Shapes.joinUnoptimized(var0, var1, var2).optimize();
    }

    public static VoxelShape joinUnoptimized(VoxelShape var0, VoxelShape var1, BooleanOp var2) {
        if (var2.apply(false, false)) {
            throw Util.pauseInIde(new IllegalArgumentException());
        }
        if (var0 == var1) {
            return var2.apply(true, true) ? var0 : Shapes.empty();
        }
        boolean var3 = var2.apply(true, false);
        boolean var4 = var2.apply(false, true);
        if (var0.isEmpty()) {
            return var4 ? var1 : Shapes.empty();
        }
        if (var1.isEmpty()) {
            return var3 ? var0 : Shapes.empty();
        }
        IndexMerger var5 = Shapes.createIndexMerger(1, var0.getCoords(Direction.Axis.X), var1.getCoords(Direction.Axis.X), var3, var4);
        IndexMerger var6 = Shapes.createIndexMerger(var5.size() - 1, var0.getCoords(Direction.Axis.Y), var1.getCoords(Direction.Axis.Y), var3, var4);
        IndexMerger var7 = Shapes.createIndexMerger((var5.size() - 1) * (var6.size() - 1), var0.getCoords(Direction.Axis.Z), var1.getCoords(Direction.Axis.Z), var3, var4);
        BitSetDiscreteVoxelShape var8 = BitSetDiscreteVoxelShape.join(var0.shape, var1.shape, var5, var6, var7, var2);
        if (var5 instanceof DiscreteCubeMerger && var6 instanceof DiscreteCubeMerger && var7 instanceof DiscreteCubeMerger) {
            return new CubeVoxelShape(var8);
        }
        return new ArrayVoxelShape((DiscreteVoxelShape)var8, var5.getList(), var6.getList(), var7.getList());
    }

    public static boolean joinIsNotEmpty(VoxelShape var0, VoxelShape var1, BooleanOp var2) {
        if (var2.apply(false, false)) {
            throw Util.pauseInIde(new IllegalArgumentException());
        }
        boolean var3 = var0.isEmpty();
        boolean var4 = var1.isEmpty();
        if (var3 || var4) {
            return var2.apply(!var3, !var4);
        }
        if (var0 == var1) {
            return var2.apply(true, true);
        }
        boolean var5 = var2.apply(true, false);
        boolean var6 = var2.apply(false, true);
        for (Direction.Axis var10 : AxisCycle.AXIS_VALUES) {
            if (var0.max(var10) < var1.min(var10) - 1.0E-7) {
                return var5 || var6;
            }
            if (!(var1.max(var10) < var0.min(var10) - 1.0E-7)) continue;
            return var5 || var6;
        }
        IndexMerger var7 = Shapes.createIndexMerger(1, var0.getCoords(Direction.Axis.X), var1.getCoords(Direction.Axis.X), var5, var6);
        IndexMerger var8 = Shapes.createIndexMerger(var7.size() - 1, var0.getCoords(Direction.Axis.Y), var1.getCoords(Direction.Axis.Y), var5, var6);
        IndexMerger var9 = Shapes.createIndexMerger((var7.size() - 1) * (var8.size() - 1), var0.getCoords(Direction.Axis.Z), var1.getCoords(Direction.Axis.Z), var5, var6);
        return Shapes.joinIsNotEmpty(var7, var8, var9, var0.shape, var1.shape, var2);
    }

    private static boolean joinIsNotEmpty(IndexMerger var0, IndexMerger var1, IndexMerger var2, DiscreteVoxelShape var3, DiscreteVoxelShape var4, BooleanOp var52) {
        return !var0.forMergedIndexes((var5, var62, var7) -> var1.forMergedIndexes((var6, var72, var82) -> var2.forMergedIndexes((var7, var8, var9) -> !var52.apply(var3.isFullWide(var5, var6, var7), var4.isFullWide(var62, var72, var8)))));
    }

    public static double collide(Direction.Axis var0, AABB var1, Iterable<VoxelShape> var2, double var3) {
        for (VoxelShape var6 : var2) {
            if (Math.abs(var3) < 1.0E-7) {
                return 0.0;
            }
            var3 = var6.collide(var0, var1, var3);
        }
        return var3;
    }

    public static boolean blockOccludes(VoxelShape var0, VoxelShape var1, Direction var2) {
        if (var0 == Shapes.block() && var1 == Shapes.block()) {
            return true;
        }
        if (var1.isEmpty()) {
            return false;
        }
        Direction.Axis var3 = var2.getAxis();
        Direction.AxisDirection var4 = var2.getAxisDirection();
        VoxelShape var5 = var4 == Direction.AxisDirection.POSITIVE ? var0 : var1;
        VoxelShape var6 = var4 == Direction.AxisDirection.POSITIVE ? var1 : var0;
        BooleanOp var7 = var4 == Direction.AxisDirection.POSITIVE ? BooleanOp.ONLY_FIRST : BooleanOp.ONLY_SECOND;
        return DoubleMath.fuzzyEquals((double)var5.max(var3), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)var6.min(var3), (double)0.0, (double)1.0E-7) && !Shapes.joinIsNotEmpty(new SliceShape(var5, var3, var5.shape.getSize(var3) - 1), new SliceShape(var6, var3, 0), var7);
    }

    public static boolean mergedFaceOccludes(VoxelShape var0, VoxelShape var1, Direction var2) {
        VoxelShape var6;
        if (var0 == Shapes.block() || var1 == Shapes.block()) {
            return true;
        }
        Direction.Axis var3 = var2.getAxis();
        Direction.AxisDirection var4 = var2.getAxisDirection();
        VoxelShape var5 = var4 == Direction.AxisDirection.POSITIVE ? var0 : var1;
        VoxelShape voxelShape = var6 = var4 == Direction.AxisDirection.POSITIVE ? var1 : var0;
        if (!DoubleMath.fuzzyEquals((double)var5.max(var3), (double)1.0, (double)1.0E-7)) {
            var5 = Shapes.empty();
        }
        if (!DoubleMath.fuzzyEquals((double)var6.min(var3), (double)0.0, (double)1.0E-7)) {
            var6 = Shapes.empty();
        }
        return !Shapes.joinIsNotEmpty(Shapes.block(), Shapes.joinUnoptimized(new SliceShape(var5, var3, var5.shape.getSize(var3) - 1), new SliceShape(var6, var3, 0), BooleanOp.OR), BooleanOp.ONLY_FIRST);
    }

    public static boolean faceShapeOccludes(VoxelShape var0, VoxelShape var1) {
        if (var0 == Shapes.block() || var1 == Shapes.block()) {
            return true;
        }
        if (var0.isEmpty() && var1.isEmpty()) {
            return false;
        }
        return !Shapes.joinIsNotEmpty(Shapes.block(), Shapes.joinUnoptimized(var0, var1, BooleanOp.OR), BooleanOp.ONLY_FIRST);
    }

    @VisibleForTesting
    protected static IndexMerger createIndexMerger(int var0, DoubleList var1, DoubleList var2, boolean var3, boolean var4) {
        long var7;
        int var5 = var1.size() - 1;
        int var6 = var2.size() - 1;
        if (var1 instanceof CubePointRange && var2 instanceof CubePointRange && (long)var0 * (var7 = Shapes.lcm(var5, var6)) <= 256L) {
            return new DiscreteCubeMerger(var5, var6);
        }
        if (var1.getDouble(var5) < var2.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(var1, var2, false);
        }
        if (var2.getDouble(var6) < var1.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(var2, var1, true);
        }
        if (var5 == var6 && Objects.equals(var1, var2)) {
            return new IdenticalMerger(var1);
        }
        return new IndirectMerger(var1, var2, var3, var4);
    }

    public static VoxelShape rotate(VoxelShape var0, OctahedralGroup var1) {
        return Shapes.rotate(var0, var1, BLOCK_CENTER);
    }

    public static VoxelShape rotate(VoxelShape var0, OctahedralGroup var1, Vec3 var2) {
        if (var1 == OctahedralGroup.IDENTITY) {
            return var0;
        }
        DiscreteVoxelShape var3 = var0.shape.rotate(var1);
        if (var0 instanceof CubeVoxelShape && BLOCK_CENTER.equals(var2)) {
            return new CubeVoxelShape(var3);
        }
        Direction.Axis var4 = var1.permute(Direction.Axis.X);
        Direction.Axis var5 = var1.permute(Direction.Axis.Y);
        Direction.Axis var6 = var1.permute(Direction.Axis.Z);
        DoubleList var7 = var0.getCoords(var4);
        DoubleList var8 = var0.getCoords(var5);
        DoubleList var9 = var0.getCoords(var6);
        boolean var10 = var1.inverts(var4);
        boolean var11 = var1.inverts(var5);
        boolean var12 = var1.inverts(var6);
        boolean var13 = var4.choose(var10, var11, var12);
        boolean var14 = var5.choose(var10, var11, var12);
        boolean var15 = var6.choose(var10, var11, var12);
        return new ArrayVoxelShape(var3, Shapes.makeAxis(var7, var13, var2.get(var4), var2.x), Shapes.makeAxis(var8, var14, var2.get(var5), var2.y), Shapes.makeAxis(var9, var15, var2.get(var6), var2.z));
    }

    @VisibleForTesting
    static DoubleList makeAxis(DoubleList var0, boolean var1, double var2, double var4) {
        int var9;
        if (!var1 && var2 == var4) {
            return var0;
        }
        int var6 = var0.size();
        DoubleArrayList var7 = new DoubleArrayList(var6);
        int var8 = var1 ? -1 : 1;
        int n = var9 = var1 ? var6 - 1 : 0;
        while (var9 >= 0 && var9 < var6) {
            var7.add(var4 + (double)var8 * (var0.getDouble(var9) - var2));
            var9 += var8;
        }
        return var7;
    }

    public static boolean equal(VoxelShape var0, VoxelShape var1) {
        return !Shapes.joinIsNotEmpty(var0, var1, BooleanOp.NOT_SAME);
    }

    public static Map<Direction.Axis, VoxelShape> rotateHorizontalAxis(VoxelShape var0) {
        return Shapes.rotateHorizontalAxis(var0, BLOCK_CENTER);
    }

    public static Map<Direction.Axis, VoxelShape> rotateHorizontalAxis(VoxelShape var0, Vec3 var1) {
        return Maps.newEnumMap(Map.of(Direction.Axis.Z, var0, Direction.Axis.X, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90), var1)));
    }

    public static Map<Direction.Axis, VoxelShape> rotateAllAxis(VoxelShape var0) {
        return Shapes.rotateAllAxis(var0, BLOCK_CENTER);
    }

    public static Map<Direction.Axis, VoxelShape> rotateAllAxis(VoxelShape var0, Vec3 var1) {
        return Maps.newEnumMap(Map.of(Direction.Axis.Z, var0, Direction.Axis.X, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90), var1), Direction.Axis.Y, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R90, Quadrant.R0), var1)));
    }

    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape var0) {
        return Shapes.rotateHorizontal(var0, BLOCK_CENTER);
    }

    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape var0, Vec3 var1) {
        return Maps.newEnumMap(Map.of(Direction.NORTH, var0, Direction.EAST, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90), var1), Direction.SOUTH, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R180), var1), Direction.WEST, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R270), var1)));
    }

    public static Map<Direction, VoxelShape> rotateAll(VoxelShape var0) {
        return Shapes.rotateAll(var0, BLOCK_CENTER);
    }

    public static Map<Direction, VoxelShape> rotateAll(VoxelShape var0, Vec3 var1) {
        return Maps.newEnumMap(Map.of(Direction.NORTH, var0, Direction.EAST, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90), var1), Direction.SOUTH, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R180), var1), Direction.WEST, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R270), var1), Direction.UP, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R270, Quadrant.R0), var1), Direction.DOWN, Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R90, Quadrant.R0), var1)));
    }

    public static Map<AttachFace, Map<Direction, VoxelShape>> rotateAttachFace(VoxelShape var0) {
        return Map.of(AttachFace.WALL, Shapes.rotateHorizontal(var0), AttachFace.FLOOR, Shapes.rotateHorizontal(Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R270, Quadrant.R0))), AttachFace.CEILING, Shapes.rotateHorizontal(Shapes.rotate(var0, OctahedralGroup.fromXYAngles(Quadrant.R90, Quadrant.R180))));
    }

    public static interface DoubleLineConsumer {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

