/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Attachable;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;

public final class CraftTripwire
extends CraftBlockData
implements Tripwire,
Attachable,
MultipleFacing,
Powerable {
    private static final BooleanProperty DISARMED = CraftTripwire.getBoolean(TripWireBlock.class, "disarmed");
    private static final BooleanProperty ATTACHED = CraftTripwire.getBoolean(TripWireBlock.class, "attached");
    private static final BooleanProperty[] FACES = new BooleanProperty[]{CraftTripwire.getBoolean(TripWireBlock.class, "north", true), CraftTripwire.getBoolean(TripWireBlock.class, "east", true), CraftTripwire.getBoolean(TripWireBlock.class, "south", true), CraftTripwire.getBoolean(TripWireBlock.class, "west", true), CraftTripwire.getBoolean(TripWireBlock.class, "up", true), CraftTripwire.getBoolean(TripWireBlock.class, "down", true)};
    private static final BooleanProperty POWERED = CraftTripwire.getBoolean(TripWireBlock.class, "powered");

    public CraftTripwire() {
    }

    public CraftTripwire(BlockState state) {
        super(state);
    }

    public boolean isDisarmed() {
        return this.get(DISARMED);
    }

    public void setDisarmed(boolean disarmed) {
        this.set(DISARMED, disarmed);
    }

    public boolean isAttached() {
        return this.get(ATTACHED);
    }

    public void setAttached(boolean attached) {
        this.set(ATTACHED, attached);
    }

    public boolean hasFace(BlockFace face) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null || !this.get(FACES[i]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }
}

