/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.monster.Vex;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;

public class CraftVex
extends CraftMonster
implements org.bukkit.entity.Vex {
    public CraftVex(CraftServer server, Vex entity) {
        super(server, entity);
    }

    @Override
    public Vex getHandle() {
        return (Vex)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftVex";
    }

    public boolean isCharging() {
        return this.getHandle().isCharging();
    }

    public void setCharging(boolean charging) {
        this.getHandle().setIsCharging(charging);
    }

    public Location getBound() {
        BlockPos blockPosition = this.getHandle().getBoundOrigin();
        return blockPosition == null ? null : CraftLocation.toBukkit(blockPosition, this.getWorld());
    }

    public void setBound(Location location) {
        if (location == null) {
            this.getHandle().setBoundOrigin(null);
        } else {
            Preconditions.checkArgument((boolean)this.getWorld().equals((Object)location.getWorld()), (Object)"The bound world cannot be different to the entity's world.");
            this.getHandle().setBoundOrigin(CraftLocation.toBlockPosition(location));
        }
    }

    public int getLifeTicks() {
        return this.getHandle().limitedLifeTicks;
    }

    public void setLifeTicks(int lifeTicks) {
        this.getHandle().setLimitedLife(lifeTicks);
        if (lifeTicks < 0) {
            this.getHandle().hasLimitedLife = false;
        }
    }

    public boolean hasLimitedLife() {
        return this.getHandle().hasLimitedLife;
    }
}

