/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.map;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Image;
import java.util.Arrays;
import org.bukkit.craftbukkit.v1_21_R5.map.CraftMapView;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;

public class CraftMapCanvas
implements MapCanvas {
    private final byte[] buffer = new byte[16384];
    private final CraftMapView mapView;
    private byte[] base;
    private MapCursorCollection cursors = new MapCursorCollection();

    protected CraftMapCanvas(CraftMapView mapView) {
        this.mapView = mapView;
        Arrays.fill(this.buffer, (byte)-1);
    }

    public CraftMapView getMapView() {
        return this.mapView;
    }

    public MapCursorCollection getCursors() {
        return this.cursors;
    }

    public void setCursors(MapCursorCollection cursors) {
        this.cursors = cursors;
    }

    public void setPixelColor(int x, int y, Color color) {
        this.setPixel(x, y, color == null ? (byte)-1 : (byte)MapPalette.matchColor((Color)color));
    }

    public Color getPixelColor(int x, int y) {
        byte pixel = this.getPixel(x, y);
        if (pixel == -1) {
            return null;
        }
        return MapPalette.getColor((byte)pixel);
    }

    public Color getBasePixelColor(int x, int y) {
        return MapPalette.getColor((byte)this.getBasePixel(x, y));
    }

    public void setPixel(int x, int y, byte color) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return;
        }
        if (this.buffer[y * 128 + x] != color) {
            this.buffer[y * 128 + x] = color;
            this.mapView.worldMap.setColorsDirty(x, y);
        }
    }

    public byte getPixel(int x, int y) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return 0;
        }
        return this.buffer[y * 128 + x];
    }

    public byte getBasePixel(int x, int y) {
        if (x < 0 || y < 0 || x >= 128 || y >= 128) {
            return 0;
        }
        return this.base[y * 128 + x];
    }

    protected void setBase(byte[] base) {
        this.base = base;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    public void drawImage(int x, int y, Image image) {
        byte[] bytes = MapPalette.imageToBytes((Image)image);
        for (int x2 = 0; x2 < image.getWidth(null); ++x2) {
            for (int y2 = 0; y2 < image.getHeight(null); ++y2) {
                this.setPixel(x + x2, y + y2, bytes[y2 * image.getWidth(null) + x2]);
            }
        }
    }

    public void drawText(int x, int y, MapFont font, String text) {
        int xStart = x;
        byte color = 44;
        Preconditions.checkArgument((boolean)font.isValid(text), (String)"text (%s) contains invalid characters", (Object)text);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                x = xStart;
                y += font.getHeight() + 1;
                continue;
            }
            if (ch == '\u00a7') {
                int j = text.indexOf(59, i);
                Preconditions.checkArgument((j >= 0 ? 1 : 0) != 0, (String)"text (%s) unterminated color string", (Object)text);
                try {
                    color = Byte.parseByte(text.substring(i + 1, j));
                    i = j;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MapFont.CharacterSprite sprite = font.getChar(text.charAt(i));
            for (int r = 0; r < font.getHeight(); ++r) {
                for (int c = 0; c < sprite.getWidth(); ++c) {
                    if (!sprite.get(r, c)) continue;
                    this.setPixel(x + c, y + r, color);
                }
            }
            x += sprite.getWidth() + 1;
        }
    }
}

