/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R5.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R5.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final PlayerTeam team;

    CraftTeam(CraftScoreboard scoreboard, PlayerTeam team) {
        super(scoreboard);
        this.team = team;
    }

    public String getName() {
        this.checkState();
        return this.team.getName();
    }

    public String getDisplayName() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.getDisplayName());
    }

    public void setDisplayName(String displayName) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        this.checkState();
        this.team.setDisplayName(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getPrefix() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.getPlayerPrefix());
    }

    public void setPrefix(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix cannot be null");
        this.checkState();
        this.team.setPlayerPrefix(CraftChatMessage.fromStringOrNull(prefix));
    }

    public String getSuffix() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.getPlayerSuffix());
    }

    public void setSuffix(String suffix) {
        Preconditions.checkArgument((suffix != null ? 1 : 0) != 0, (Object)"Suffix cannot be null");
        this.checkState();
        this.team.setPlayerSuffix(CraftChatMessage.fromStringOrNull(suffix));
    }

    public ChatColor getColor() {
        this.checkState();
        return CraftChatMessage.getColor(this.team.getColor());
    }

    public void setColor(ChatColor color) {
        Preconditions.checkArgument((color != null && !color.isFormat() ? 1 : 0) != 0, (Object)"Color cannot be null or a format");
        this.checkState();
        this.team.setColor(CraftChatMessage.getColor(color));
    }

    public boolean allowFriendlyFire() {
        this.checkState();
        return this.team.isAllowFriendlyFire();
    }

    public void setAllowFriendlyFire(boolean enabled) {
        this.checkState();
        this.team.setAllowFriendlyFire(enabled);
    }

    public boolean canSeeFriendlyInvisibles() {
        this.checkState();
        return this.team.canSeeFriendlyInvisibles();
    }

    public void setCanSeeFriendlyInvisibles(boolean enabled) {
        this.checkState();
        this.team.setSeeFriendlyInvisibles(enabled);
    }

    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        this.checkState();
        return CraftTeam.notchToBukkit(this.team.getNameTagVisibility());
    }

    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        this.checkState();
        this.team.setNameTagVisibility(CraftTeam.bukkitToNotch(visibility));
    }

    public Set<OfflinePlayer> getPlayers() {
        this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.getPlayers()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName));
        }
        return players.build();
    }

    public Set<String> getEntries() {
        this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.getPlayers()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    public int getSize() {
        this.checkState();
        return this.team.getPlayers().size();
    }

    public void addPlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    public void addEntry(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.addPlayerToTeam(entry, this.team);
    }

    public boolean removePlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    public boolean removeEntry(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.getPlayers().contains(entry)) {
            return false;
        }
        scoreboard.board.removePlayerFromTeam(entry, this.team);
        return true;
    }

    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        return this.team.getPlayers().contains(entry);
    }

    @Override
    public void unregister() {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.removePlayerTeam(this.team);
    }

    public Team.OptionStatus getOption(Team.Option option) {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.getNameTagVisibility().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.getDeathMessageVisibility().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.getCollisionRule().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + String.valueOf(option));
    }

    public void setOption(Team.Option option, Team.OptionStatus status) {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.setNameTagVisibility(Team.Visibility.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.setDeathMessageVisibility(Team.Visibility.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.setCollisionRule(Team.CollisionRule.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + String.valueOf(option));
            }
        }
    }

    public static Team.Visibility bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return Team.Visibility.ALWAYS;
            }
            case NEVER: {
                return Team.Visibility.NEVER;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return Team.Visibility.HIDE_FOR_OTHER_TEAMS;
            }
            case HIDE_FOR_OWN_TEAM: {
                return Team.Visibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + String.valueOf(visibility));
    }

    public static NameTagVisibility notchToBukkit(Team.Visibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return NameTagVisibility.ALWAYS;
            }
            case NEVER: {
                return NameTagVisibility.NEVER;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case HIDE_FOR_OWN_TEAM: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + String.valueOf(visibility));
    }

    @Override
    CraftScoreboard checkState() {
        Preconditions.checkState((this.getScoreboard().board.getPlayerTeam(this.team.getName()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

