/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftSound;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.util.HolderHandleable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftMusicInstrument
extends MusicInstrument
implements HolderHandleable<dco> {
    private final NamespacedKey key;
    private final jl<dco> handle;

    public static MusicInstrument minecraftToBukkit(dco minecraft) {
        return (MusicInstrument)CraftRegistry.minecraftToBukkit(minecraft, mn.aZ, Registry.INSTRUMENT);
    }

    public static MusicInstrument minecraftHolderToBukkit(jl<dco> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        if (minecraft instanceof jl.c) {
            jl.c holder = (jl.c)minecraft;
            MusicInstrument bukkit = (MusicInstrument)Registry.INSTRUMENT.get(CraftNamespacedKey.fromMinecraft(holder.h().a()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }
        return new CraftMusicInstrument(null, minecraft);
    }

    public static dco bukkitToMinecraft(MusicInstrument bukkit) {
        return (dco)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static jl<dco> bukkitToMinecraftHolder(MusicInstrument bukkit) {
        return ((HolderHandleable)bukkit).getHandleHolder();
    }

    public static String bukkitToString(MusicInstrument bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        jl<dco> holder = CraftMusicInstrument.bukkitToMinecraftHolder(bukkit);
        return ((JsonElement)dco.c.encodeStart(amc.a(JsonOps.INSTANCE, (jn.a)CraftRegistry.getMinecraftRegistry()), holder).result().get()).toString();
    }

    public static MusicInstrument stringToBukkit(String string) {
        MusicInstrument bukkit;
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        if (key != null && (bukkit = (MusicInstrument)Registry.INSTRUMENT.get(key)) != null) {
            return bukkit;
        }
        JsonElement json = JsonParser.parseString((String)string);
        DataResult result = dco.c.decode(amc.a(JsonOps.INSTANCE, (jn.a)CraftRegistry.getMinecraftRegistry()), (Object)json);
        return CraftMusicInstrument.minecraftHolderToBukkit((jl)((Pair)result.getOrThrow()).getFirst());
    }

    public CraftMusicInstrument(NamespacedKey key, jl<dco> handle) {
        this.key = key;
        this.handle = handle;
    }

    @Override
    public dco getHandle() {
        return this.handle.a();
    }

    @Override
    public jl<dco> getHandleHolder() {
        return this.handle;
    }

    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().d());
    }

    public float getDuration() {
        return this.getHandle().b();
    }

    public float getRange() {
        return this.getHandle().c();
    }

    public Sound getSoundEvent() {
        return CraftSound.minecraftHolderToBukkit(this.getHandle().a());
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof CraftMusicInstrument)) {
            return false;
        }
        CraftMusicInstrument other = (CraftMusicInstrument)o2;
        if (this.key != null && other.key != null) {
            return this.key.equals((Object)other.key);
        }
        return this.getHandle().equals(other.getHandle());
    }

    public int hashCode() {
        if (this.key != null) {
            return this.key.hashCode();
        }
        return this.getHandle().hashCode();
    }

    public String toString() {
        return "CraftMusicInstrument{key=" + String.valueOf(this.key) + ", handle=" + String.valueOf(this.handle) + "}";
    }

    @NotNull
    public NamespacedKey getKeyOrThrow() {
        Preconditions.checkState((boolean)this.isRegistered(), (Object)"Cannot get key of this registry item, because it is not registered. Use #isRegistered() before calling this method.");
        return this.key;
    }

    @Nullable
    public NamespacedKey getKeyOrNull() {
        return this.key;
    }

    public boolean isRegistered() {
        return this.key != null;
    }
}

