/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R5.CraftArt;
import org.bukkit.craftbukkit.v1_21_R5.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R5.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R5.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R5.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R5.CraftSound;
import org.bukkit.craftbukkit.v1_21_R5.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R5.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R5.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R5.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R5.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R5.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R5.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R5.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R5.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R5.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R5.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.util.Handleable;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static jz registry;
    private final Class<? super B> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final jy<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, jl<M>, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater;
    private boolean init;

    public static void setMinecraftRegistry(jz registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static jz getMinecraftRegistry() {
        return registry;
    }

    public static <E> jy<E> getMinecraftRegistry(amd<jy<E>> key) {
        return CraftRegistry.getMinecraftRegistry().f(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, amd<jy<M>> registryKey, Registry<B> bukkitRegistry) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        jy registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Keyed bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow(() -> new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft))).a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)bukkit).getHandle();
    }

    public static <B extends Keyed, M> jl<M> bukkitToMinecraftHolder(B bukkit, amd<jy<M>> registryKey) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        jy registry = CraftRegistry.getMinecraftRegistry(registryKey);
        jl jl2 = registry.e(CraftRegistry.bukkitToMinecraft(bukkit));
        if (jl2 instanceof jl.c) {
            jl.c holder = (jl.c)jl2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own registry entry with out properly registering it.");
    }

    private static <M, B> BiFunction<NamespacedKey, jl<M>, B> wrap(BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        return (namespacedKey, holder) -> minecraftToBukkit.apply((NamespacedKey)namespacedKey, (Object)holder.a());
    }

    public static <B extends Keyed> Registry<?> createRegistry(Class<? super B> bukkitClass, jz registryHolder) {
        if (bukkitClass == Art.class) {
            return new CraftRegistry<CraftArt, cqv>(Art.class, registryHolder.f(mn.be), CraftArt::new, FieldRename.NONE);
        }
        if (bukkitClass == Attribute.class) {
            return new CraftRegistry<CraftAttribute, cbn>(Attribute.class, registryHolder.f(mn.c), CraftAttribute::new, FieldRename.ATTRIBUTE_RENAME);
        }
        if (bukkitClass == Biome.class) {
            return new CraftRegistry<CraftBiome, dnx>(Biome.class, registryHolder.f(mn.aK), CraftBiome::new, FieldRename.BIOME_RENAME);
        }
        if (bukkitClass == Enchantment.class) {
            return new CraftRegistry<CraftEnchantment, dji>(Enchantment.class, registryHolder.f(mn.aW), CraftRegistry.wrap(CraftEnchantment::new), FieldRename.ENCHANTMENT_RENAME);
        }
        if (bukkitClass == Fluid.class) {
            return new CraftRegistry<CraftFluid, fak>(Fluid.class, registryHolder.f(mn.H), CraftFluid::new, FieldRename.NONE);
        }
        if (bukkitClass == GameEvent.class) {
            return new CraftRegistry<CraftGameEvent, ejb>(GameEvent.class, registryHolder.f(mn.J), CraftRegistry.wrap(CraftGameEvent::new), FieldRename.NONE);
        }
        if (bukkitClass == MusicInstrument.class) {
            return new CraftRegistry<CraftMusicInstrument, dco>(MusicInstrument.class, registryHolder.f(mn.aZ), CraftMusicInstrument::new, FieldRename.NONE);
        }
        if (bukkitClass == MenuType.class) {
            return new CraftRegistry(MenuType.class, registryHolder.f(mn.Y), CraftMenuType::new, FieldRename.NONE);
        }
        if (bukkitClass == PotionEffectType.class) {
            return new CraftRegistry<CraftPotionEffectType, byo>(PotionEffectType.class, registryHolder.f(mn.Z), CraftRegistry.wrap(CraftPotionEffectType::new), FieldRename.NONE);
        }
        if (bukkitClass == Sound.class) {
            return new CraftRegistry<CraftSound, ayy>(Sound.class, registryHolder.f(mn.as), CraftSound::new, FieldRename.NONE);
        }
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, euy>(Structure.class, registryHolder.f(mn.bj), CraftRegistry.wrap(CraftStructure::new), FieldRename.NONE);
        }
        if (bukkitClass == StructureType.class) {
            return new CraftRegistry<CraftStructureType, evh>(StructureType.class, registryHolder.f(mn.az), CraftRegistry.wrap(CraftStructureType::new), FieldRename.NONE);
        }
        if (bukkitClass == Villager.Type.class) {
            return new CraftRegistry<CraftVillager.CraftType, cuk>(Villager.Type.class, registryHolder.f(mn.aI), CraftVillager.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Villager.Profession.class) {
            return new CraftRegistry<CraftVillager.CraftProfession, cui>(Villager.Profession.class, registryHolder.f(mn.aH), CraftVillager.CraftProfession::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, dli>(TrimMaterial.class, registryHolder.f(mn.bp), CraftTrimMaterial::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, dlk>(TrimPattern.class, registryHolder.f(mn.bq), CraftTrimPattern::new, FieldRename.NONE);
        }
        if (bukkitClass == DamageType.class) {
            return new CraftRegistry<CraftDamageType, byd>(DamageType.class, registryHolder.f(mn.aR), CraftDamageType::new, FieldRename.NONE);
        }
        if (bukkitClass == JukeboxSong.class) {
            return new CraftRegistry<CraftJukeboxSong, ddb>(JukeboxSong.class, registryHolder.f(mn.ba), CraftJukeboxSong::new, FieldRename.NONE);
        }
        if (bukkitClass == Wolf.Variant.class) {
            return new CraftRegistry<CraftWolf.CraftVariant, cpm>(Wolf.Variant.class, registryHolder.f(mn.br), CraftWolf.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == BlockType.class) {
            return new CraftRegistry<CraftBlockType, dpz>(BlockType.class, registryHolder.f(mn.i), CraftBlockType::new, FieldRename.NONE);
        }
        if (bukkitClass == ItemType.class) {
            return new CraftRegistry<CraftItemType, dcr>(ItemType.class, registryHolder.f(mn.N), CraftItemType::new, FieldRename.NONE);
        }
        if (bukkitClass == Frog.Variant.class) {
            return new CraftRegistry<CraftFrog.CraftVariant, coe>(Frog.Variant.class, registryHolder.f(mn.aY), CraftFrog.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cat.Type.class) {
            return new CraftRegistry<CraftCat.CraftType, cmh>(Cat.Type.class, registryHolder.f(mn.aL), CraftCat.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Pig.Variant.class) {
            return new CraftRegistry<CraftPig.CraftVariant, cnb>(Pig.Variant.class, registryHolder.f(mn.bf), CraftPig.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cow.Variant.class) {
            return new CraftRegistry<CraftCow.CraftVariant, cmo>(Cow.Variant.class, registryHolder.f(mn.aQ), CraftCow.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Chicken.Variant.class) {
            return new CraftRegistry<CraftChicken.CraftVariant, cmk>(Chicken.Variant.class, registryHolder.f(mn.aN), CraftChicken.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == MapCursor.Type.class) {
            return new CraftRegistry<CraftMapCursor.CraftType, fcb>(MapCursor.Type.class, registryHolder.f(mn.U), CraftMapCursor.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == PatternType.class) {
            return new CraftRegistry<CraftPatternType, eao>(PatternType.class, registryHolder.f(mn.aJ), CraftPatternType::new, FieldRename.NONE);
        }
        return null;
    }

    public static <B extends Keyed> B get(Registry<B> bukkit, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(namespacedKey, apiVersion);
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == EntityType.class) {
                return (B)bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return (B)bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return (B)bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<? super B> bukkitClass, jy<M> minecraftRegistry, BiFunction<NamespacedKey, jl<M>, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.updater = updater;
    }

    public B get(NamespacedKey namespacedKey, ApiVersion apiVersion) {
        return this.get(this.updater.apply(namespacedKey, apiVersion));
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        if (!this.init) {
            this.init = true;
            try {
                Class.forName(this.bukkitClass.getName());
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("Could not load registry class " + String.valueOf(this.bukkitClass), e2);
            }
            return this.get(namespacedKey);
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.c(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public B getOrThrow(@NotNull NamespacedKey namespacedKey) {
        B object = this.get(namespacedKey);
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (String)"No %s registry entry found for key %s.", this.minecraftRegistry.g(), (Object)namespacedKey);
        return object;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.i().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, jl<M> minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }
}

