/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;

public class CraftWorldBorder
implements WorldBorder {
    private final World world;
    private final eft handle;

    public CraftWorldBorder(CraftWorld world) {
        this.world = world;
        this.handle = world.getHandle().F_();
    }

    public CraftWorldBorder(eft handle) {
        this.world = null;
        this.handle = handle;
    }

    public World getWorld() {
        return this.world;
    }

    public void reset() {
        this.getHandle().a(eft.d);
    }

    public double getSize() {
        return this.handle.i();
    }

    public void setSize(double newSize) {
        this.setSize(newSize, 0L);
    }

    public void setSize(double newSize, long time) {
        this.setSize(Math.min(this.getMaxSize(), Math.max(1.0, newSize)), TimeUnit.SECONDS, Math.min(9223372036854775L, Math.max(0L, time)));
    }

    public void setSize(double newSize, TimeUnit unit, long time) {
        Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (Object)"TimeUnit cannot be null.");
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (Object)"time cannot be lower than 0");
        Preconditions.checkArgument((newSize >= 1.0 && newSize <= this.getMaxSize() ? 1 : 0) != 0, (String)"newSize must be between 1.0D and %s", (Object)this.getMaxSize());
        if (time > 0L) {
            this.handle.a(this.handle.i(), newSize, unit.toMillis(time));
        } else {
            this.handle.a(newSize);
        }
    }

    public Location getCenter() {
        double x2 = this.handle.a();
        double z2 = this.handle.b();
        return new Location(this.world, x2, 0.0, z2);
    }

    public void setCenter(double x2, double z2) {
        Preconditions.checkArgument((Math.abs(x2) <= this.getMaxCenterCoordinate() ? 1 : 0) != 0, (String)"x coordinate cannot be outside +- %s", (Object)this.getMaxCenterCoordinate());
        Preconditions.checkArgument((Math.abs(z2) <= this.getMaxCenterCoordinate() ? 1 : 0) != 0, (String)"z coordinate cannot be outside +- %s", (Object)this.getMaxCenterCoordinate());
        this.handle.d(x2, z2);
    }

    public void setCenter(Location location) {
        this.setCenter(location.getX(), location.getZ());
    }

    public double getDamageBuffer() {
        return this.handle.n();
    }

    public void setDamageBuffer(double blocks) {
        this.handle.b(blocks);
    }

    public double getDamageAmount() {
        return this.handle.o();
    }

    public void setDamageAmount(double damage) {
        this.handle.c(damage);
    }

    public int getWarningTime() {
        return this.handle.q();
    }

    public void setWarningTime(int time) {
        this.handle.b(time);
    }

    public int getWarningDistance() {
        return this.handle.r();
    }

    public void setWarningDistance(int distance) {
        this.handle.c(distance);
    }

    public boolean isInside(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        return (this.world == null || location.getWorld().equals((Object)this.world)) && this.handle.a(jb.a(location.getX(), location.getY(), location.getZ()));
    }

    public double getMaxSize() {
        return 5.9999968E7;
    }

    public double getMaxCenterCoordinate() {
        return 2.9999984E7;
    }

    public eft getHandle() {
        return this.handle;
    }

    public boolean isVirtual() {
        return this.world == null;
    }
}

