/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R5.registry.CraftRegistryItem;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class CraftBlockType<B extends BlockData>
extends CraftRegistryItem<dpz>
implements BlockType.Typed<B> {
    private final Class<B> blockDataClass = CraftBlockData.fromData(((dpz)this.getHandle()).m()).getClass().getInterfaces()[0];
    private final boolean interactable = CraftBlockType.isInteractable((dpz)this.getHandle());
    private static final Class<?>[] USE_WITHOUT_ITEM_ARGS = new Class[]{eeb.class, dmu.class, jb.class, cut.class, fio.class};
    private static final Class<?>[] USE_ITEM_ON_ARGS = new Class[]{dcv.class, eeb.class, dmu.class, jb.class, cut.class, bxi.class, fio.class};

    public static Material minecraftToBukkit(dpz block) {
        return CraftMagicNumbers.getMaterial(block);
    }

    public static dpz bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getBlock(material);
    }

    public static BlockType minecraftToBukkitNew(dpz minecraft) {
        return (BlockType)CraftRegistry.minecraftToBukkit(minecraft, mn.i, Registry.BLOCK);
    }

    public static dpz bukkitToMinecraftNew(BlockType bukkit) {
        return (dpz)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    private static boolean hasMethod(Class<?> clazz, Class<?> ... params) {
        boolean hasMethod = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Arrays.equals(method.getParameterTypes(), params)) continue;
            Preconditions.checkArgument((!hasMethod ? 1 : 0) != 0, (String)"More than one matching method for %s, args %s", clazz, (Object)Arrays.toString(params));
            hasMethod = true;
        }
        return hasMethod;
    }

    private static boolean isInteractable(dpz block) {
        boolean hasMethod;
        Class<?> clazz = block.getClass();
        boolean bl2 = hasMethod = CraftBlockType.hasMethod(clazz, USE_WITHOUT_ITEM_ARGS) || CraftBlockType.hasMethod(clazz, USE_ITEM_ON_ARGS);
        if (!hasMethod && clazz.getSuperclass() != eea.class) {
            hasMethod = CraftBlockType.hasMethod(clazz = clazz.getSuperclass(), USE_WITHOUT_ITEM_ARGS) || CraftBlockType.hasMethod(clazz, USE_ITEM_ON_ARGS);
        }
        return hasMethod;
    }

    public CraftBlockType(NamespacedKey key, jl<dpz> handle) {
        super(key, handle);
    }

    @NotNull
    public BlockType.Typed<BlockData> typed() {
        return this.typed(BlockData.class);
    }

    @NotNull
    public <Other extends BlockData> BlockType.Typed<Other> typed(@NotNull Class<Other> blockDataType) {
        if (blockDataType.isAssignableFrom(this.blockDataClass)) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type block type " + String.valueOf(this.isRegistered() ? this.getKeyOrThrow() : this.toString()) + " to blockdata type " + blockDataType.getSimpleName());
    }

    public boolean hasItemType() {
        if (this == AIR) {
            return true;
        }
        return ((dpz)this.getHandle()).h() != dcz.a;
    }

    @NotNull
    public ItemType getItemType() {
        if (this == AIR) {
            return ItemType.AIR;
        }
        dcr item = ((dpz)this.getHandle()).h();
        Preconditions.checkArgument((item != dcz.a ? 1 : 0) != 0, (String)"The block type %s has no corresponding item type", (Object)(this.isRegistered() ? this.getKeyOrThrow() : this.toString()));
        return CraftItemType.minecraftToBukkitNew(item);
    }

    public Class<B> getBlockDataClass() {
        return this.blockDataClass;
    }

    public B createBlockData() {
        return this.createBlockData((String)null);
    }

    public B createBlockData(Consumer<? super B> consumer) {
        B data = this.createBlockData();
        if (consumer != null) {
            consumer.accept(data);
        }
        return data;
    }

    public B createBlockData(String data) {
        return (B)CraftBlockData.newData((BlockType)this, data);
    }

    public boolean isSolid() {
        return ((dpz)this.getHandle()).m().d();
    }

    public boolean isAir() {
        return ((dpz)this.getHandle()).m().l();
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return ((dpz)this.getHandle()).a(((CraftWorld)world).getHandle().L());
    }

    public boolean isFlammable() {
        return ((dpz)this.getHandle()).m().m();
    }

    public boolean isBurnable() {
        return ((dtc)dqb.cB).aa.getOrDefault(this.getHandle(), 0) > 0;
    }

    public boolean isOccluding() {
        return ((dpz)this.getHandle()).m().d(dmk.a, jb.c);
    }

    public boolean hasGravity() {
        return this.getHandle() instanceof dsx;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public float getHardness() {
        return ((dpz)this.getHandle()).m().p;
    }

    public float getBlastResistance() {
        return ((dpz)this.getHandle()).e();
    }

    public float getSlipperiness() {
        return ((dpz)this.getHandle()).g();
    }

    @NotNull
    public String getTranslationKey() {
        return ((dpz)this.getHandle()).v();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.getKeyOrThrow());
    }
}

