/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockSupport;
import org.bukkit.block.BlockType;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftSoundGroup;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockSupport;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockStateEnum;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftAmethystCluster;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftAnvil;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBamboo;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBanner;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBannerWall;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBarrel;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBarrier;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBed;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBeehive;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBeetroot;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBell;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBigDripleaf;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBigDripleafStem;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBrushable;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftBubbleColumn;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftButtonAbstract;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCactus;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCake;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCampfire;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCandle;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCandleCake;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCarrots;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCaveVines;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCaveVinesPlant;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCeilingHangingSign;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftChain;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftChest;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftChestTrapped;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftChiseledBookShelf;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftChorusFlower;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftChorusFruit;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCobbleWall;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCocoa;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCommand;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftComposter;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftConduit;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCopperBulb;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCoralDead;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCoralFan;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCoralFanAbstract;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCoralFanWall;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCoralFanWallAbstract;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCoralPlant;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCrafter;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCreakingHeart;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftCrops;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftDirtSnow;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftDoor;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftDriedGhast;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftDropper;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftEndRod;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftEnderChest;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftEnderPortalFrame;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftFence;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftFenceGate;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftFire;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftFloorSign;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftFlowerBed;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftFluids;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftFurnaceFurace;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftGlazedTerracotta;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftGlowLichen;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftGrass;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftGrindstone;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftHangingMoss;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftHangingRoots;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftHay;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftHeavyCore;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftHopper;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftHugeMushroom;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftIceFrost;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftInfestedRotatedPillar;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftIronBars;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftJigsaw;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftJukeBox;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftKelp;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLadder;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLantern;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLayeredCauldron;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLeafLitter;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLectern;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLever;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLight;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLightningRod;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftLoom;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftMangroveLeaves;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftMangrovePropagule;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftMangroveRoots;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftMinecartDetector;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftMinecartTrack;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftMossyCarpet;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftMultiface;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftMycel;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftNetherWart;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftNote;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftObserver;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPiglinWallSkull;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPiston;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPistonExtension;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPistonMoving;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPitcherCrop;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPointedDripstone;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPortal;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPotatoes;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPoweredRail;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPressurePlateBinary;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPressurePlateWeighted;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftPumpkinCarved;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRedstoneComparator;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRedstoneLamp;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRedstoneOre;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRedstoneTorch;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRedstoneTorchWall;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRedstoneWire;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftReed;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRepeater;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRespawnAnchor;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftRotatable;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSapling;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftScaffolding;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSculkVein;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSeaPickle;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSkullPlayer;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSkullPlayerWall;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSkullWall;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSmallDripleaf;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSmoker;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSnifferEgg;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSnow;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSoil;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftStainedGlassPane;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftStairs;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftStem;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftStemAttached;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftStepAbstract;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftStonecutter;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftSweetBerryBush;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTNT;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTallPlant;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTallPlantFlower;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTallSeagrass;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTarget;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTest;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTorchWall;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTorchflowerCrop;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTrapdoor;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTrialSpawner;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTripwire;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTripwireHook;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTurtleEgg;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftTwistingVines;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftUntintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftVault;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftVine;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWallHangingSign;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWallSign;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWaterloggedTransparent;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWeatheringCopperBulb;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWeatheringCopperDoor;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWeatheringCopperGrate;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWeatheringCopperSlab;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWeatheringCopperStair;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWeatheringCopperTrapDoor;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWeepingVines;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_21_R5.block.impl.CraftWitherSkullWall;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftBlockData
implements BlockData {
    private eeb state;
    private Map<efe<?>, Comparable<?>> parsedStates;
    private static final Map<Class<? extends dpz>, Function<eeb, CraftBlockData>> MAP = new HashMap<Class<? extends dpz>, Function<eeb, CraftBlockData>>();

    protected CraftBlockData() {
        throw new AssertionError((Object)"Template Constructor");
    }

    protected CraftBlockData(eeb state) {
        this.state = state;
    }

    public Material getMaterial() {
        return CraftBlockType.minecraftToBukkit(this.state.b());
    }

    public eeb getState() {
        return this.state;
    }

    protected <N extends Enum<N>, B extends Enum<B>> B get(CraftBlockStateEnum<N, B> nms) {
        return nms.toBukkit((Enum)this.state.c(nms.nms()));
    }

    protected <N extends Enum<N>, B extends Enum<B>> Set<B> getValues(CraftBlockStateEnum<N, B> nms) {
        return nms.getValues();
    }

    protected <N extends Enum<N>, B extends Enum<B>> void set(CraftBlockStateEnum<N, B> nms, B bukkit) {
        this.parsedStates = null;
        this.state = (eeb)this.state.b(nms.nms(), nms.toNMS(bukkit));
    }

    public BlockData merge(BlockData data) {
        CraftBlockData craft = (CraftBlockData)data;
        Preconditions.checkArgument((craft.parsedStates != null ? 1 : 0) != 0, (Object)"Data not created via string parsing");
        Preconditions.checkArgument((this.state.b() == craft.state.b() ? 1 : 0) != 0, (String)"States have different types (got %s, expected %s)", (Object)data, (Object)this);
        CraftBlockData clone = (CraftBlockData)this.clone();
        clone.parsedStates = null;
        for (efe<?> parsed : craft.parsedStates.keySet()) {
            clone.state = (eeb)clone.state.b(parsed, craft.state.c(parsed));
        }
        return clone;
    }

    public boolean matches(BlockData data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof CraftBlockData)) {
            return false;
        }
        CraftBlockData craft = (CraftBlockData)data;
        if (this.state.b() != craft.state.b()) {
            return false;
        }
        boolean exactMatch = this.equals(data);
        if (!exactMatch && craft.parsedStates != null) {
            return this.merge(data).equals((Object)this);
        }
        return exactMatch;
    }

    protected <T extends Comparable<T>> T get(efe<T> ibs) {
        return this.state.c(ibs);
    }

    public <T extends Comparable<T>, V extends T> void set(efe<T> ibs, V v2) {
        this.parsedStates = null;
        this.state = (eeb)this.state.b(ibs, v2);
    }

    public String getAsString() {
        return this.toString(this.state.G());
    }

    public String getAsString(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? this.toString(this.parsedStates) : this.getAsString();
    }

    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException ex2) {
            throw new AssertionError("Clone not supported", ex2);
        }
    }

    public String toString() {
        return "CraftBlockData{" + this.getAsString() + "}";
    }

    public String toString(Map<efe<?>, Comparable<?>> states) {
        StringBuilder stateString = new StringBuilder(mm.e.b(this.state.b()).toString());
        if (!states.isEmpty()) {
            stateString.append('[');
            stateString.append(states.entrySet().stream().map(eed.a).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    public Map<String, String> toStates(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? CraftBlockData.toStates(this.parsedStates) : CraftBlockData.toStates(this.state.G());
    }

    private static Map<String, String> toStates(Map<efe<?>, Comparable<?>> states) {
        HashMap<String, String> compound = new HashMap<String, String>();
        for (Map.Entry<efe<?>, Comparable<?>> entry : states.entrySet()) {
            efe<?> iblockstate = entry.getKey();
            compound.put(iblockstate.f(), iblockstate.b(entry.getValue()));
        }
        return compound;
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftBlockData && this.state.equals(((CraftBlockData)obj).state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    protected static ees getBoolean(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static ees getBoolean(String name, boolean optional) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(String name, Class<? extends Enum<B>> bukkit) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static efb getInteger(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static ees getBoolean(Class<? extends dpz> block, String name) {
        return (ees)CraftBlockData.getState(block, name, false);
    }

    protected static ees getBoolean(Class<? extends dpz> block, String name, boolean optional) {
        return (ees)CraftBlockData.getState(block, name, optional);
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(Class<? extends dpz> block, String name, Class<B> bukkit) {
        return new CraftBlockStateEnum((eez)CraftBlockData.getState(block, name, false), bukkit);
    }

    protected static efb getInteger(Class<? extends dpz> block, String name) {
        return (efb)CraftBlockData.getState(block, name, false);
    }

    private static efe<?> getState(Class<? extends dpz> block, String name, boolean optional) {
        efe<?> state = null;
        for (dpz instance : mm.e) {
            if (instance.getClass() != block) continue;
            if (state == null) {
                state = instance.l().a(name);
                continue;
            }
            efe<?> newState = instance.l().a(name);
            Preconditions.checkState((state == newState ? 1 : 0) != 0, (String)"State mistmatch %s,%s", state, newState);
        }
        Preconditions.checkState((optional || state != null ? 1 : 0) != 0, (String)"Null state for %s,%s", block, (Object)name);
        return state;
    }

    protected static int getMin(efb state) {
        return state.b;
    }

    protected static int getMax(efb state) {
        return state.c;
    }

    private static void register(Class<? extends dpz> nms, Function<eeb, CraftBlockData> bukkit) {
        Preconditions.checkState((MAP.put(nms, bukkit) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", nms, bukkit);
    }

    public static CraftBlockData newData(BlockType blockType, String data) {
        eeb blockData;
        dpz block = blockType == null ? null : (dpz)((CraftBlockType)blockType).getHandle();
        Map<efe<?>, Comparable<?>> parsed = null;
        if (data != null) {
            try {
                if (block != null) {
                    data = String.valueOf(mm.e.b(block)) + (String)data;
                }
                StringReader reader = new StringReader((String)data);
                gi.a arg = gi.a(CraftRegistry.getMinecraftRegistry(mn.i), reader, false);
                Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + (String)data));
                blockData = arg.a();
                parsed = arg.b();
            }
            catch (CommandSyntaxException ex2) {
                throw new IllegalArgumentException("Could not parse data: " + (String)data, ex2);
            }
        } else {
            blockData = block.m();
        }
        CraftBlockData craft = CraftBlockData.fromData(blockData);
        craft.parsedStates = parsed;
        return craft;
    }

    public static CraftBlockData fromData(eeb data) {
        return (CraftBlockData)MAP.getOrDefault(data.b().getClass(), (Function<eeb, CraftBlockData>)((Function)CraftBlockData::new)).apply((Object)data);
    }

    public SoundGroup getSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.state.A());
    }

    public int getLightEmission() {
        return this.state.k();
    }

    public boolean isOccluding() {
        return this.state.t();
    }

    public boolean requiresCorrectToolForDrops() {
        return this.state.C();
    }

    public boolean isPreferredTool(ItemStack tool) {
        Preconditions.checkArgument((tool != null ? 1 : 0) != 0, (Object)"tool must not be null");
        dcv nms = CraftItemStack.asNMSCopy(tool);
        return CraftBlockData.isPreferredTool(this.state, nms);
    }

    public static boolean isPreferredTool(eeb iblockdata, dcv nmsItem) {
        return !iblockdata.C() || nmsItem.b(iblockdata);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.state.r().ordinal());
    }

    public boolean isSupported(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        CraftBlock craftBlock = (CraftBlock)block;
        return this.state.a((dmx)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition());
    }

    public boolean isSupported(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location must not be null");
        CraftWorld world = (CraftWorld)location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"location must not have a null world");
        jb position = CraftLocation.toBlockPosition(location);
        return this.state.a((dmx)world.getHandle(), position);
    }

    public boolean isFaceSturdy(BlockFace face, BlockSupport support) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((support != null ? 1 : 0) != 0, (Object)"support must not be null");
        return this.state.a((dly)dmk.a, jb.c, CraftBlock.blockFaceToNotch(face), CraftBlockSupport.toNMS(support));
    }

    public Color getMapColor() {
        return Color.fromRGB((int)this.state.a(null, null).ak);
    }

    public Material getPlacementMaterial() {
        return CraftItemType.minecraftToBukkit(this.state.b().h());
    }

    public void rotate(StructureRotation rotation) {
        this.state = this.state.a(dwu.valueOf(rotation.name()));
    }

    public void mirror(Mirror mirror) {
        this.state = this.state.a(dvd.valueOf(mirror.name()));
    }

    public void copyTo(BlockData blockData) {
        CraftBlockData other = (CraftBlockData)blockData;
        eeb nms = other.state;
        for (efe<?> property : this.state.b().l().d()) {
            if (!nms.b(property)) continue;
            nms = this.copyProperty(this.state, nms, property);
        }
        other.state = nms;
    }

    private <T extends Comparable<T>> eeb copyProperty(eeb source, eeb target, efe<T> property) {
        return (eeb)target.b(property, source.c(property));
    }

    @NotNull
    public BlockState createBlockState() {
        return CraftBlockStates.getBlockState(this.state, null);
    }

    static {
        CraftBlockData.register(doy.class, (Function<eeb, CraftBlockData>)((Function)CraftAmethystCluster::new));
        CraftBlockData.register(dpw.class, (Function<eeb, CraftBlockData>)((Function)CraftBigDripleaf::new));
        CraftBlockData.register(dpx.class, (Function<eeb, CraftBlockData>)((Function)CraftBigDripleafStem::new));
        CraftBlockData.register(doz.class, (Function<eeb, CraftBlockData>)((Function)CraftAnvil::new));
        CraftBlockData.register(dpd.class, (Function<eeb, CraftBlockData>)((Function)CraftBamboo::new));
        CraftBlockData.register(dpe.class, (Function<eeb, CraftBlockData>)((Function)CraftBanner::new));
        CraftBlockData.register(dzn.class, (Function<eeb, CraftBlockData>)((Function)CraftBannerWall::new));
        CraftBlockData.register(dpf.class, (Function<eeb, CraftBlockData>)((Function)CraftBarrel::new));
        CraftBlockData.register(dpg.class, (Function<eeb, CraftBlockData>)((Function)CraftBarrier::new));
        CraftBlockData.register(dps.class, (Function<eeb, CraftBlockData>)((Function)CraftBed::new));
        CraftBlockData.register(dpt.class, (Function<eeb, CraftBlockData>)((Function)CraftBeehive::new));
        CraftBlockData.register(dpu.class, (Function<eeb, CraftBlockData>)((Function)CraftBeetroot::new));
        CraftBlockData.register(dpv.class, (Function<eeb, CraftBlockData>)((Function)CraftBell::new));
        CraftBlockData.register(dpy.class, (Function<eeb, CraftBlockData>)((Function)CraftBlastFurnace::new));
        CraftBlockData.register(dqe.class, (Function<eeb, CraftBlockData>)((Function)CraftBrewingStand::new));
        CraftBlockData.register(dqg.class, (Function<eeb, CraftBlockData>)((Function)CraftBubbleColumn::new));
        CraftBlockData.register(dqk.class, (Function<eeb, CraftBlockData>)((Function)CraftButtonAbstract::new));
        CraftBlockData.register(dql.class, (Function<eeb, CraftBlockData>)((Function)CraftCactus::new));
        CraftBlockData.register(dqn.class, (Function<eeb, CraftBlockData>)((Function)CraftCake::new));
        CraftBlockData.register(dqp.class, (Function<eeb, CraftBlockData>)((Function)CraftCampfire::new));
        CraftBlockData.register(dqt.class, (Function<eeb, CraftBlockData>)((Function)CraftCarrots::new));
        CraftBlockData.register(drb.class, (Function<eeb, CraftBlockData>)((Function)CraftChain::new));
        CraftBlockData.register(drd.class, (Function<eeb, CraftBlockData>)((Function)CraftChest::new));
        CraftBlockData.register(dzc.class, (Function<eeb, CraftBlockData>)((Function)CraftChestTrapped::new));
        CraftBlockData.register(drf.class, (Function<eeb, CraftBlockData>)((Function)CraftChorusFlower::new));
        CraftBlockData.register(drg.class, (Function<eeb, CraftBlockData>)((Function)CraftChorusFruit::new));
        CraftBlockData.register(dzo.class, (Function<eeb, CraftBlockData>)((Function)CraftCobbleWall::new));
        CraftBlockData.register(drh.class, (Function<eeb, CraftBlockData>)((Function)CraftCocoa::new));
        CraftBlockData.register(drj.class, (Function<eeb, CraftBlockData>)((Function)CraftCommand::new));
        CraftBlockData.register(drl.class, (Function<eeb, CraftBlockData>)((Function)CraftComposter::new));
        CraftBlockData.register(drn.class, (Function<eeb, CraftBlockData>)((Function)CraftConduit::new));
        CraftBlockData.register(dpi.class, (Function<eeb, CraftBlockData>)((Function)CraftCoralDead::new));
        CraftBlockData.register(drq.class, (Function<eeb, CraftBlockData>)((Function)CraftCoralFan::new));
        CraftBlockData.register(dph.class, (Function<eeb, CraftBlockData>)((Function)CraftCoralFanAbstract::new));
        CraftBlockData.register(drs.class, (Function<eeb, CraftBlockData>)((Function)CraftCoralFanWall::new));
        CraftBlockData.register(dpk.class, (Function<eeb, CraftBlockData>)((Function)CraftCoralFanWallAbstract::new));
        CraftBlockData.register(drr.class, (Function<eeb, CraftBlockData>)((Function)CraftCoralPlant::new));
        CraftBlockData.register(drw.class, (Function<eeb, CraftBlockData>)((Function)CraftCrops::new));
        CraftBlockData.register(drz.class, (Function<eeb, CraftBlockData>)((Function)CraftDaylightDetector::new));
        CraftBlockData.register(dxu.class, (Function<eeb, CraftBlockData>)((Function)CraftDirtSnow::new));
        CraftBlockData.register(dsf.class, (Function<eeb, CraftBlockData>)((Function)CraftDispenser::new));
        CraftBlockData.register(dsg.class, (Function<eeb, CraftBlockData>)((Function)CraftDoor::new));
        CraftBlockData.register(dsm.class, (Function<eeb, CraftBlockData>)((Function)CraftDropper::new));
        CraftBlockData.register(dss.class, (Function<eeb, CraftBlockData>)((Function)CraftEndRod::new));
        CraftBlockData.register(dst.class, (Function<eeb, CraftBlockData>)((Function)CraftEnderChest::new));
        CraftBlockData.register(dsr.class, (Function<eeb, CraftBlockData>)((Function)CraftEnderPortalFrame::new));
        CraftBlockData.register(dta.class, (Function<eeb, CraftBlockData>)((Function)CraftFence::new));
        CraftBlockData.register(dtb.class, (Function<eeb, CraftBlockData>)((Function)CraftFenceGate::new));
        CraftBlockData.register(dtc.class, (Function<eeb, CraftBlockData>)((Function)CraftFire::new));
        CraftBlockData.register(dyf.class, (Function<eeb, CraftBlockData>)((Function)CraftFloorSign::new));
        CraftBlockData.register(duw.class, (Function<eeb, CraftBlockData>)((Function)CraftFluids::new));
        CraftBlockData.register(dtl.class, (Function<eeb, CraftBlockData>)((Function)CraftFurnaceFurace::new));
        CraftBlockData.register(dtn.class, (Function<eeb, CraftBlockData>)((Function)CraftGlazedTerracotta::new));
        CraftBlockData.register(dtp.class, (Function<eeb, CraftBlockData>)((Function)CraftGrass::new));
        CraftBlockData.register(dtq.class, (Function<eeb, CraftBlockData>)((Function)CraftGrindstone::new));
        CraftBlockData.register(dtx.class, (Function<eeb, CraftBlockData>)((Function)CraftHay::new));
        CraftBlockData.register(dua.class, (Function<eeb, CraftBlockData>)((Function)CraftHopper::new));
        CraftBlockData.register(duc.class, (Function<eeb, CraftBlockData>)((Function)CraftHugeMushroom::new));
        CraftBlockData.register(dtj.class, (Function<eeb, CraftBlockData>)((Function)CraftIceFrost::new));
        CraftBlockData.register(dug.class, (Function<eeb, CraftBlockData>)((Function)CraftIronBars::new));
        CraftBlockData.register(duh.class, (Function<eeb, CraftBlockData>)((Function)CraftJigsaw::new));
        CraftBlockData.register(dui.class, (Function<eeb, CraftBlockData>)((Function)CraftJukeBox::new));
        CraftBlockData.register(duj.class, (Function<eeb, CraftBlockData>)((Function)CraftKelp::new));
        CraftBlockData.register(dul.class, (Function<eeb, CraftBlockData>)((Function)CraftLadder::new));
        CraftBlockData.register(dum.class, (Function<eeb, CraftBlockData>)((Function)CraftLantern::new));
        CraftBlockData.register(dur.class, (Function<eeb, CraftBlockData>)((Function)CraftLectern::new));
        CraftBlockData.register(dut.class, (Function<eeb, CraftBlockData>)((Function)CraftLever::new));
        CraftBlockData.register(duy.class, (Function<eeb, CraftBlockData>)((Function)CraftLoom::new));
        CraftBlockData.register(dsb.class, (Function<eeb, CraftBlockData>)((Function)CraftMinecartDetector::new));
        CraftBlockData.register(dwg.class, (Function<eeb, CraftBlockData>)((Function)CraftMinecartTrack::new));
        CraftBlockData.register(dvk.class, (Function<eeb, CraftBlockData>)((Function)CraftMycel::new));
        CraftBlockData.register(dvo.class, (Function<eeb, CraftBlockData>)((Function)CraftNetherWart::new));
        CraftBlockData.register(dvq.class, (Function<eeb, CraftBlockData>)((Function)CraftNote::new));
        CraftBlockData.register(dvs.class, (Function<eeb, CraftBlockData>)((Function)CraftObserver::new));
        CraftBlockData.register(dvl.class, (Function<eeb, CraftBlockData>)((Function)CraftPortal::new));
        CraftBlockData.register(dwa.class, (Function<eeb, CraftBlockData>)((Function)CraftPotatoes::new));
        CraftBlockData.register(dwd.class, (Function<eeb, CraftBlockData>)((Function)CraftPoweredRail::new));
        CraftBlockData.register(dwe.class, (Function<eeb, CraftBlockData>)((Function)CraftPressurePlateBinary::new));
        CraftBlockData.register(eag.class, (Function<eeb, CraftBlockData>)((Function)CraftPressurePlateWeighted::new));
        CraftBlockData.register(dqv.class, (Function<eeb, CraftBlockData>)((Function)CraftPumpkinCarved::new));
        CraftBlockData.register(drk.class, (Function<eeb, CraftBlockData>)((Function)CraftRedstoneComparator::new));
        CraftBlockData.register(dwk.class, (Function<eeb, CraftBlockData>)((Function)CraftRedstoneLamp::new));
        CraftBlockData.register(dwi.class, (Function<eeb, CraftBlockData>)((Function)CraftRedstoneOre::new));
        CraftBlockData.register(dwl.class, (Function<eeb, CraftBlockData>)((Function)CraftRedstoneTorch::new));
        CraftBlockData.register(dwm.class, (Function<eeb, CraftBlockData>)((Function)CraftRedstoneTorchWall::new));
        CraftBlockData.register(dwj.class, (Function<eeb, CraftBlockData>)((Function)CraftRedstoneWire::new));
        CraftBlockData.register(dyk.class, (Function<eeb, CraftBlockData>)((Function)CraftReed::new));
        CraftBlockData.register(dwo.class, (Function<eeb, CraftBlockData>)((Function)CraftRepeater::new));
        CraftBlockData.register(dwp.class, (Function<eeb, CraftBlockData>)((Function)CraftRespawnAnchor::new));
        CraftBlockData.register(dwt.class, (Function<eeb, CraftBlockData>)((Function)CraftRotatable::new));
        CraftBlockData.register(dww.class, (Function<eeb, CraftBlockData>)((Function)CraftSapling::new));
        CraftBlockData.register(dwx.class, (Function<eeb, CraftBlockData>)((Function)CraftScaffolding::new));
        CraftBlockData.register(dxf.class, (Function<eeb, CraftBlockData>)((Function)CraftSeaPickle::new));
        CraftBlockData.register(dxj.class, (Function<eeb, CraftBlockData>)((Function)CraftShulkerBox::new));
        CraftBlockData.register(dxm.class, (Function<eeb, CraftBlockData>)((Function)CraftSkull::new));
        CraftBlockData.register(dvw.class, (Function<eeb, CraftBlockData>)((Function)CraftSkullPlayer::new));
        CraftBlockData.register(dvx.class, (Function<eeb, CraftBlockData>)((Function)CraftSkullPlayerWall::new));
        CraftBlockData.register(dzr.class, (Function<eeb, CraftBlockData>)((Function)CraftSkullWall::new));
        CraftBlockData.register(dxr.class, (Function<eeb, CraftBlockData>)((Function)CraftSmoker::new));
        CraftBlockData.register(dxt.class, (Function<eeb, CraftBlockData>)((Function)CraftSnow::new));
        CraftBlockData.register(dsz.class, (Function<eeb, CraftBlockData>)((Function)CraftSoil::new));
        CraftBlockData.register(dyd.class, (Function<eeb, CraftBlockData>)((Function)CraftStainedGlassPane::new));
        CraftBlockData.register(dye.class, (Function<eeb, CraftBlockData>)((Function)CraftStairs::new));
        CraftBlockData.register(dyg.class, (Function<eeb, CraftBlockData>)((Function)CraftStem::new));
        CraftBlockData.register(dpa.class, (Function<eeb, CraftBlockData>)((Function)CraftStemAttached::new));
        CraftBlockData.register(dxn.class, (Function<eeb, CraftBlockData>)((Function)CraftStepAbstract::new));
        CraftBlockData.register(dyh.class, (Function<eeb, CraftBlockData>)((Function)CraftStonecutter::new));
        CraftBlockData.register(dyi.class, (Function<eeb, CraftBlockData>)((Function)CraftStructure::new));
        CraftBlockData.register(dyn.class, (Function<eeb, CraftBlockData>)((Function)CraftSweetBerryBush::new));
        CraftBlockData.register(dyx.class, (Function<eeb, CraftBlockData>)((Function)CraftTNT::new));
        CraftBlockData.register(dsi.class, (Function<eeb, CraftBlockData>)((Function)CraftTallPlant::new));
        CraftBlockData.register(dyp.class, (Function<eeb, CraftBlockData>)((Function)CraftTallPlantFlower::new));
        CraftBlockData.register(dys.class, (Function<eeb, CraftBlockData>)((Function)CraftTarget::new));
        CraftBlockData.register(dzs.class, (Function<eeb, CraftBlockData>)((Function)CraftTorchWall::new));
        CraftBlockData.register(dzb.class, (Function<eeb, CraftBlockData>)((Function)CraftTrapdoor::new));
        CraftBlockData.register(dze.class, (Function<eeb, CraftBlockData>)((Function)CraftTripwire::new));
        CraftBlockData.register(dzf.class, (Function<eeb, CraftBlockData>)((Function)CraftTripwireHook::new));
        CraftBlockData.register(dzg.class, (Function<eeb, CraftBlockData>)((Function)CraftTurtleEgg::new));
        CraftBlockData.register(dzh.class, (Function<eeb, CraftBlockData>)((Function)CraftTwistingVines::new));
        CraftBlockData.register(dzm.class, (Function<eeb, CraftBlockData>)((Function)CraftVine::new));
        CraftBlockData.register(dzq.class, (Function<eeb, CraftBlockData>)((Function)CraftWallSign::new));
        CraftBlockData.register(eae.class, (Function<eeb, CraftBlockData>)((Function)CraftWeepingVines::new));
        CraftBlockData.register(eaj.class, (Function<eeb, CraftBlockData>)((Function)CraftWitherSkull::new));
        CraftBlockData.register(eak.class, (Function<eeb, CraftBlockData>)((Function)CraftWitherSkullWall::new));
        CraftBlockData.register(dqf.class, (Function<eeb, CraftBlockData>)((Function)CraftBrushable::new));
        CraftBlockData.register(dqo.class, (Function<eeb, CraftBlockData>)((Function)CraftCalibratedSculkSensor::new));
        CraftBlockData.register(dqq.class, (Function<eeb, CraftBlockData>)((Function)CraftCandle::new));
        CraftBlockData.register(dqr.class, (Function<eeb, CraftBlockData>)((Function)CraftCandleCake::new));
        CraftBlockData.register(dqy.class, (Function<eeb, CraftBlockData>)((Function)CraftCaveVines::new));
        CraftBlockData.register(dqz.class, (Function<eeb, CraftBlockData>)((Function)CraftCaveVinesPlant::new));
        CraftBlockData.register(dra.class, (Function<eeb, CraftBlockData>)((Function)CraftCeilingHangingSign::new));
        CraftBlockData.register(dre.class, (Function<eeb, CraftBlockData>)((Function)CraftChiseledBookShelf::new));
        CraftBlockData.register(dro.class, (Function<eeb, CraftBlockData>)((Function)CraftCopperBulb::new));
        CraftBlockData.register(drt.class, (Function<eeb, CraftBlockData>)((Function)CraftCrafter::new));
        CraftBlockData.register(drv.class, (Function<eeb, CraftBlockData>)((Function)CraftCreakingHeart::new));
        CraftBlockData.register(dsa.class, (Function<eeb, CraftBlockData>)((Function)CraftDecoratedPot::new));
        CraftBlockData.register(dsk.class, (Function<eeb, CraftBlockData>)((Function)CraftDriedGhast::new));
        CraftBlockData.register(dtf.class, (Function<eeb, CraftBlockData>)((Function)CraftFlowerBed::new));
        CraftBlockData.register(dto.class, (Function<eeb, CraftBlockData>)((Function)CraftGlowLichen::new));
        CraftBlockData.register(dtv.class, (Function<eeb, CraftBlockData>)((Function)CraftHangingMoss::new));
        CraftBlockData.register(dtw.class, (Function<eeb, CraftBlockData>)((Function)CraftHangingRoots::new));
        CraftBlockData.register(dty.class, (Function<eeb, CraftBlockData>)((Function)CraftHeavyCore::new));
        CraftBlockData.register(duf.class, (Function<eeb, CraftBlockData>)((Function)CraftInfestedRotatedPillar::new));
        CraftBlockData.register(duo.class, (Function<eeb, CraftBlockData>)((Function)CraftLayeredCauldron::new));
        CraftBlockData.register(dup.class, (Function<eeb, CraftBlockData>)((Function)CraftLeafLitter::new));
        CraftBlockData.register(duu.class, (Function<eeb, CraftBlockData>)((Function)CraftLight::new));
        CraftBlockData.register(duv.class, (Function<eeb, CraftBlockData>)((Function)CraftLightningRod::new));
        CraftBlockData.register(dva.class, (Function<eeb, CraftBlockData>)((Function)CraftMangroveLeaves::new));
        CraftBlockData.register(dvb.class, (Function<eeb, CraftBlockData>)((Function)CraftMangrovePropagule::new));
        CraftBlockData.register(dvc.class, (Function<eeb, CraftBlockData>)((Function)CraftMangroveRoots::new));
        CraftBlockData.register(dve.class, (Function<eeb, CraftBlockData>)((Function)CraftMossyCarpet::new));
        CraftBlockData.register(dvg.class, (Function<eeb, CraftBlockData>)((Function)CraftMultiface::new));
        CraftBlockData.register(dvt.class, (Function<eeb, CraftBlockData>)((Function)CraftPiglinWallSkull::new));
        CraftBlockData.register(dvv.class, (Function<eeb, CraftBlockData>)((Function)CraftPitcherCrop::new));
        CraftBlockData.register(dvy.class, (Function<eeb, CraftBlockData>)((Function)CraftPointedDripstone::new));
        CraftBlockData.register(dxa.class, (Function<eeb, CraftBlockData>)((Function)CraftSculkCatalyst::new));
        CraftBlockData.register(dxb.class, (Function<eeb, CraftBlockData>)((Function)CraftSculkSensor::new));
        CraftBlockData.register(dxc.class, (Function<eeb, CraftBlockData>)((Function)CraftSculkShrieker::new));
        CraftBlockData.register(dxe.class, (Function<eeb, CraftBlockData>)((Function)CraftSculkVein::new));
        CraftBlockData.register(dxp.class, (Function<eeb, CraftBlockData>)((Function)CraftSmallDripleaf::new));
        CraftBlockData.register(dxs.class, (Function<eeb, CraftBlockData>)((Function)CraftSnifferEgg::new));
        CraftBlockData.register(dyr.class, (Function<eeb, CraftBlockData>)((Function)CraftTallSeagrass::new));
        CraftBlockData.register(dyt.class, (Function<eeb, CraftBlockData>)((Function)CraftTest::new));
        CraftBlockData.register(dyw.class, (Function<eeb, CraftBlockData>)((Function)CraftTintedParticleLeaves::new));
        CraftBlockData.register(dyz.class, (Function<eeb, CraftBlockData>)((Function)CraftTorchflowerCrop::new));
        CraftBlockData.register(dzd.class, (Function<eeb, CraftBlockData>)((Function)CraftTrialSpawner::new));
        CraftBlockData.register(dzj.class, (Function<eeb, CraftBlockData>)((Function)CraftUntintedParticleLeaves::new));
        CraftBlockData.register(dzk.class, (Function<eeb, CraftBlockData>)((Function)CraftVault::new));
        CraftBlockData.register(dzp.class, (Function<eeb, CraftBlockData>)((Function)CraftWallHangingSign::new));
        CraftBlockData.register(dzu.class, (Function<eeb, CraftBlockData>)((Function)CraftWaterloggedTransparent::new));
        CraftBlockData.register(dzw.class, (Function<eeb, CraftBlockData>)((Function)CraftWeatheringCopperBulb::new));
        CraftBlockData.register(dzx.class, (Function<eeb, CraftBlockData>)((Function)CraftWeatheringCopperDoor::new));
        CraftBlockData.register(dzz.class, (Function<eeb, CraftBlockData>)((Function)CraftWeatheringCopperGrate::new));
        CraftBlockData.register(eaa.class, (Function<eeb, CraftBlockData>)((Function)CraftWeatheringCopperSlab::new));
        CraftBlockData.register(eab.class, (Function<eeb, CraftBlockData>)((Function)CraftWeatheringCopperStair::new));
        CraftBlockData.register(eac.class, (Function<eeb, CraftBlockData>)((Function)CraftWeatheringCopperTrapDoor::new));
        CraftBlockData.register(edt.class, (Function<eeb, CraftBlockData>)((Function)CraftPiston::new));
        CraftBlockData.register(edu.class, (Function<eeb, CraftBlockData>)((Function)CraftPistonExtension::new));
        CraftBlockData.register(eds.class, (Function<eeb, CraftBlockData>)((Function)CraftPistonMoving::new));
    }
}

