/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class CraftDisplay
extends CraftEntity
implements Display {
    public CraftDisplay(CraftServer server, bzj entity) {
        super(server, entity);
    }

    @Override
    public bzj getHandle() {
        return (bzj)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftDisplay";
    }

    public Transformation getTransformation() {
        k nms = bzj.a(this.getHandle().au());
        return new Transformation(nms.e(), nms.f(), nms.g(), nms.h());
    }

    public void setTransformation(Transformation transformation) {
        Preconditions.checkArgument((transformation != null ? 1 : 0) != 0, (Object)"Transformation cannot be null");
        this.getHandle().a(new k(transformation.getTranslation(), transformation.getLeftRotation(), transformation.getScale(), transformation.getRightRotation()));
    }

    public void setTransformationMatrix(Matrix4f transformationMatrix) {
        Preconditions.checkArgument((transformationMatrix != null ? 1 : 0) != 0, (Object)"Transformation matrix cannot be null");
        this.getHandle().a(new k((Matrix4fc)transformationMatrix));
    }

    public int getInterpolationDuration() {
        return this.getHandle().l();
    }

    public void setInterpolationDuration(int duration) {
        this.getHandle().b(duration);
    }

    public int getTeleportDuration() {
        return this.getHandle().au().a(bzj.r);
    }

    public void setTeleportDuration(int duration) {
        Preconditions.checkArgument((duration >= 0 && duration <= 59 ? 1 : 0) != 0, (String)"duration (%s) cannot be lower than 0 or higher than 59", (int)duration);
        this.getHandle().au().a(bzj.r, duration);
    }

    public float getViewRange() {
        return this.getHandle().t();
    }

    public void setViewRange(float range) {
        this.getHandle().b(range);
    }

    public float getShadowRadius() {
        return this.getHandle().u();
    }

    public void setShadowRadius(float radius) {
        this.getHandle().c(radius);
    }

    public float getShadowStrength() {
        return this.getHandle().v();
    }

    public void setShadowStrength(float strength) {
        this.getHandle().d(strength);
    }

    public float getDisplayWidth() {
        return this.getHandle().w();
    }

    public void setDisplayWidth(float width) {
        this.getHandle().x(width);
    }

    public float getDisplayHeight() {
        return this.getHandle().y();
    }

    public void setDisplayHeight(float height) {
        this.getHandle().y(height);
    }

    public int getInterpolationDelay() {
        return this.getHandle().m();
    }

    public void setInterpolationDelay(int ticks) {
        this.getHandle().c(ticks);
    }

    public Display.Billboard getBillboard() {
        return Display.Billboard.valueOf((String)this.getHandle().p().name());
    }

    public void setBillboard(Display.Billboard billboard) {
        Preconditions.checkArgument((billboard != null ? 1 : 0) != 0, (Object)"Billboard cannot be null");
        this.getHandle().a(bzj.a.valueOf(billboard.name()));
    }

    public Color getGlowColorOverride() {
        int color = this.getHandle().x();
        return color == -1 ? null : Color.fromARGB((int)color);
    }

    public void setGlowColorOverride(Color color) {
        if (color == null) {
            this.getHandle().l(-1);
        } else {
            this.getHandle().l(color.asARGB());
        }
    }

    public Display.Brightness getBrightness() {
        bap nms = this.getHandle().q();
        return nms != null ? new Display.Brightness(nms.b(), nms.c()) : null;
    }

    public void setBrightness(Display.Brightness brightness) {
        if (brightness != null) {
            this.getHandle().a(new bap(brightness.getBlockLight(), brightness.getSkyLight()));
        } else {
            this.getHandle().a((bap)null);
        }
    }
}

