/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R5.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class CraftEntityType {
    public static EntityType minecraftToBukkit(bzv<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        jy registry = CraftRegistry.getMinecraftRegistry(mn.D);
        EntityType bukkit = (EntityType)Registry.ENTITY_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static bzv<?> bukkitToMinecraft(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (bzv)CraftRegistry.getMinecraftRegistry(mn.D).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static jl<bzv<?>> bukkitToMinecraftHolder(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        jy registry = CraftRegistry.getMinecraftRegistry(mn.D);
        jl<bzv<?>> jl2 = registry.e(CraftEntityType.bukkitToMinecraft(bukkit));
        if (jl2 instanceof jl.c) {
            jl.c holder = (jl.c)jl2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static EntityType stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEntityTypeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (EntityType)CraftRegistry.get(Registry.ENTITY_TYPE, key, ApiVersion.CURRENT);
    }
}

