/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAllay;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAreaEffectCloud;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftArmadillo;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAxolotl;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftBat;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftBee;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftBlaze;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftBlockDisplay;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftBogged;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftBreeze;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftBreezeWindCharge;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCamel;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCod;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCreaking;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftDolphin;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftDonkey;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftDragonFireball;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftDrowned;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftElderGuardian;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnderPearl;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEndermite;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEvoker;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEvokerFangs;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftFox;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftGiant;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftGlowItemFrame;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftGlowSquid;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftGoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftGuardian;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHappyGhast;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHoglin;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHorse;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHusk;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftIllusioner;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftInteraction;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftIronGolem;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftItemDisplay;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftItemFrame;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLargeFireball;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLeash;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLingeringPotion;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLlama;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLlamaSpit;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMagmaCube;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMarker;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMinecartChest;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMinecartFurnace;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMinecartHopper;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMinecartMobSpawner;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMinecartRideable;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMinecartTNT;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMule;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMushroomCow;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftOcelot;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftOminousItemSpawner;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPainting;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPanda;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftParrot;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPhantom;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPigZombie;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPiglinBrute;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPillager;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPolarBear;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPufferFish;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftRabbit;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftRavager;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSalmon;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSheep;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftShulkerBullet;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSilverfish;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSkeleton;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSkeletonHorse;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSlime;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSmallFireball;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSniffer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSnowball;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSnowman;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSpectralArrow;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSpider;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSplashPotion;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSquid;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftStray;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftStrider;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftTadpole;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftTextDisplay;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftThrownExpBottle;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftTraderLlama;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftTurtle;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVex;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVillagerZombie;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVindicator;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWanderingTrader;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWarden;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWindCharge;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWitch;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWither;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWitherSkeleton;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftZoglin;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftZombieHorse;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftAcaciaBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftAcaciaChestBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftBambooChestRaft;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftBambooRaft;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftBirchBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftBirchChestBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftCherryBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftCherryChestBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftDarkOakBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftDarkOakChestBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftJungleBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftJungleChestBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftMangroveBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftMangroveChestBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftOakBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftOakChestBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftPaleOakBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftPaleOakChestBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftSpruceBoat;
import org.bukkit.craftbukkit.v1_21_R5.entity.boat.CraftSpruceChestBoat;
import org.bukkit.entity.Allay;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Breeze;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creaking;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.OminousItemSpawner;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spider;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Warden;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.boat.AcaciaBoat;
import org.bukkit.entity.boat.AcaciaChestBoat;
import org.bukkit.entity.boat.BambooChestRaft;
import org.bukkit.entity.boat.BambooRaft;
import org.bukkit.entity.boat.BirchBoat;
import org.bukkit.entity.boat.BirchChestBoat;
import org.bukkit.entity.boat.CherryBoat;
import org.bukkit.entity.boat.CherryChestBoat;
import org.bukkit.entity.boat.DarkOakBoat;
import org.bukkit.entity.boat.DarkOakChestBoat;
import org.bukkit.entity.boat.JungleBoat;
import org.bukkit.entity.boat.JungleChestBoat;
import org.bukkit.entity.boat.MangroveBoat;
import org.bukkit.entity.boat.MangroveChestBoat;
import org.bukkit.entity.boat.OakBoat;
import org.bukkit.entity.boat.OakChestBoat;
import org.bukkit.entity.boat.PaleOakBoat;
import org.bukkit.entity.boat.PaleOakChestBoat;
import org.bukkit.entity.boat.SpruceBoat;
import org.bukkit.entity.boat.SpruceChestBoat;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.util.Vector;

public final class CraftEntityTypes {
    private static final BiConsumer<SpawnData, bzm> POS = (spawnData, entity) -> entity.a_(spawnData.x(), spawnData.y(), spawnData.z());
    private static final BiConsumer<SpawnData, bzm> ABS_MOVE = (spawnData, entity) -> {
        entity.a(spawnData.x(), spawnData.y(), spawnData.z(), spawnData.yaw(), spawnData.pitch());
        entity.r(spawnData.yaw());
    };
    private static final BiConsumer<SpawnData, bzm> MOVE = (spawnData, entity) -> entity.b(spawnData.x(), spawnData.y(), spawnData.z(), spawnData.yaw(), spawnData.pitch());
    private static final BiConsumer<SpawnData, bzm> MOVE_EMPTY_ROT = (spawnData, entity) -> entity.b(spawnData.x(), spawnData.y(), spawnData.z(), 0.0f, 0.0f);
    private static final BiConsumer<SpawnData, cvc> DIRECTION = (spawnData, entity) -> {
        Vector direction = spawnData.location().getDirection();
        entity.a(new fis(direction.getX(), direction.getY(), direction.getZ()), 1.0);
    };
    private static final Map<Class<?>, EntityTypeData<?, ?>> CLASS_TYPE_DATA = new HashMap();
    private static final Map<EntityType, EntityTypeData<?, ?>> ENTITY_TYPE_DATA = new HashMap();

    private static void register(EntityTypeData<?, ?> typeData) {
        EntityTypeData<?, ?> other = CLASS_TYPE_DATA.put(typeData.entityClass(), typeData);
        if (other != null) {
            Bukkit.getLogger().warning(String.format("Found multiple entity type data for class %s, replacing '%s' with new value '%s'", typeData.entityClass().getName(), other, typeData));
        }
        if ((other = ENTITY_TYPE_DATA.put(typeData.entityType(), typeData)) != null) {
            Bukkit.getLogger().warning(String.format("Found multiple entity type data for entity type %s, replacing '%s' with new value '%s'", typeData.entityType().getKey(), other, typeData));
        }
    }

    private static <R extends bzm> Function<SpawnData, R> fromEntityType(bzv<R> entityTypes) {
        return spawnData -> entityTypes.a(spawnData.minecraftWorld(), bzu.n);
    }

    private static <R extends cam> Function<SpawnData, R> createLiving(bzv<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), ABS_MOVE);
    }

    private static <R extends cvc> Function<SpawnData, R> createFireball(bzv<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.createAndMove(entityTypes), DIRECTION);
    }

    private static <R extends cxg> Function<SpawnData, R> createMinecart(bzv<R> entityTypes) {
        return spawnData -> {
            if (spawnData.normalWorld()) {
                return cxg.a(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), entityTypes, bzu.k, dcv.l, null);
            }
            return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), (spawnData2, entity) -> entity.p(spawnData.x(), spawnData.y(), spawnData.z())).apply((SpawnData)spawnData);
        };
    }

    private static <R extends bzm> Function<SpawnData, R> createAndMove(bzv<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), MOVE);
    }

    private static <R extends bzm> Function<SpawnData, R> createAndMoveEmptyRot(bzv<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), MOVE_EMPTY_ROT);
    }

    private static <R extends bzm> Function<SpawnData, R> createAndSetPos(bzv<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), POS);
    }

    private static <E extends Hanging, R extends cqr> Function<SpawnData, R> createHanging(Class<E> clazz, BiFunction<SpawnData, HangingData, R> spawnFunction) {
        return spawnData -> {
            boolean randomizeData = spawnData.randomizeData();
            BlockFace face = BlockFace.SELF;
            BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
            int width = 16;
            int height = 16;
            if (ItemFrame.class.isAssignableFrom(clazz)) {
                width = 12;
                height = 12;
                faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN};
            }
            jb pos = jb.a(spawnData.x(), spawnData.y(), spawnData.z());
            for (BlockFace dir2 : faces) {
                eeb nmsBlock = spawnData.world().a_(pos.a(CraftBlock.blockFaceToNotch(dir2)));
                if (!nmsBlock.e() && !dsc.n(nmsBlock)) continue;
                boolean taken = false;
                fin bb2 = ItemFrame.class.isAssignableFrom(clazz) ? cqs.calculateBoundingBoxStatic(pos, CraftBlock.blockFaceToNotch(dir2).g()) : cqu.calculateBoundingBoxStatic(pos, CraftBlock.blockFaceToNotch(dir2).g(), width, height);
                List<bzm> list = spawnData.world().a_(null, bb2);
                Iterator<bzm> it = list.iterator();
                while (!taken && it.hasNext()) {
                    bzm e2 = it.next();
                    if (!(e2 instanceof cqr)) continue;
                    taken = true;
                }
                if (taken) continue;
                face = dir2;
                break;
            }
            if (face == BlockFace.SELF) {
                face = BlockFace.SOUTH;
                randomizeData = false;
            }
            jh dir3 = CraftBlock.blockFaceToNotch(face).g();
            return (cqr)spawnFunction.apply((SpawnData)spawnData, new HangingData(randomizeData, pos, dir3));
        };
    }

    private static <T, R> Function<T, R> combine(Function<T, R> before, BiConsumer<T, ? super R> after) {
        return t2 -> {
            Object r2 = before.apply(t2);
            after.accept((Object)t2, (Object)r2);
            return r2;
        };
    }

    public static <E extends Entity, M extends bzm> EntityTypeData<E, M> getEntityTypeData(EntityType entityType) {
        return ENTITY_TYPE_DATA.get(entityType);
    }

    public static <E extends Entity, M extends bzm> EntityTypeData<E, M> getEntityTypeData(Class<E> entityClass) {
        return CLASS_TYPE_DATA.get(entityClass);
    }

    private CraftEntityTypes() {
    }

    static {
        CraftEntityTypes.register(new EntityTypeData<ElderGuardian, crk>(EntityType.ELDER_GUARDIAN, ElderGuardian.class, CraftElderGuardian::new, CraftEntityTypes.createLiving(bzv.N)));
        CraftEntityTypes.register(new EntityTypeData<WitherSkeleton, csm>(EntityType.WITHER_SKELETON, WitherSkeleton.class, CraftWitherSkeleton::new, CraftEntityTypes.createLiving(bzv.bM)));
        CraftEntityTypes.register(new EntityTypeData<Stray, csh>(EntityType.STRAY, Stray.class, CraftStray::new, CraftEntityTypes.createLiving(bzv.bu)));
        CraftEntityTypes.register(new EntityTypeData<Bogged, crf>(EntityType.BOGGED, Bogged.class, CraftBogged::new, CraftEntityTypes.createLiving(bzv.r)));
        CraftEntityTypes.register(new EntityTypeData<Husk, crs>(EntityType.HUSK, Husk.class, CraftHusk::new, CraftEntityTypes.createLiving(bzv.ao)));
        CraftEntityTypes.register(new EntityTypeData<ZombieVillager, csp>(EntityType.ZOMBIE_VILLAGER, ZombieVillager.class, CraftVillagerZombie::new, CraftEntityTypes.createLiving(bzv.bS)));
        CraftEntityTypes.register(new EntityTypeData<SkeletonHorse, cow>(EntityType.SKELETON_HORSE, SkeletonHorse.class, CraftSkeletonHorse::new, CraftEntityTypes.createLiving(bzv.bi)));
        CraftEntityTypes.register(new EntityTypeData<ZombieHorse, cpa>(EntityType.ZOMBIE_HORSE, ZombieHorse.class, CraftZombieHorse::new, CraftEntityTypes.createLiving(bzv.bR)));
        CraftEntityTypes.register(new EntityTypeData<ArmorStand, cqo>(EntityType.ARMOR_STAND, ArmorStand.class, CraftArmorStand::new, CraftEntityTypes.createLiving(bzv.g)));
        CraftEntityTypes.register(new EntityTypeData<Donkey, cor>(EntityType.DONKEY, Donkey.class, CraftDonkey::new, CraftEntityTypes.createLiving(bzv.J)));
        CraftEntityTypes.register(new EntityTypeData<Mule, cov>(EntityType.MULE, Mule.class, CraftMule::new, CraftEntityTypes.createLiving(bzv.aH)));
        CraftEntityTypes.register(new EntityTypeData<Evoker, cro>(EntityType.EVOKER, Evoker.class, CraftEvoker::new, CraftEntityTypes.createLiving(bzv.T)));
        CraftEntityTypes.register(new EntityTypeData<Vex, csj>(EntityType.VEX, Vex.class, CraftVex::new, CraftEntityTypes.createLiving(bzv.bE)));
        CraftEntityTypes.register(new EntityTypeData<Vindicator, csk>(EntityType.VINDICATOR, Vindicator.class, CraftVindicator::new, CraftEntityTypes.createLiving(bzv.bG)));
        CraftEntityTypes.register(new EntityTypeData<Illusioner, crt>(EntityType.ILLUSIONER, Illusioner.class, CraftIllusioner::new, CraftEntityTypes.createLiving(bzv.ap)));
        CraftEntityTypes.register(new EntityTypeData<Creeper, crh>(EntityType.CREEPER, Creeper.class, CraftCreeper::new, CraftEntityTypes.createLiving(bzv.F)));
        CraftEntityTypes.register(new EntityTypeData<Skeleton, csd>(EntityType.SKELETON, Skeleton.class, CraftSkeleton::new, CraftEntityTypes.createLiving(bzv.bh)));
        CraftEntityTypes.register(new EntityTypeData<Spider, csg>(EntityType.SPIDER, Spider.class, CraftSpider::new, CraftEntityTypes.createLiving(bzv.bq)));
        CraftEntityTypes.register(new EntityTypeData<Giant, crq>(EntityType.GIANT, Giant.class, CraftGiant::new, CraftEntityTypes.createLiving(bzv.ag)));
        CraftEntityTypes.register(new EntityTypeData<Zombie, cso>(EntityType.ZOMBIE, Zombie.class, CraftZombie::new, CraftEntityTypes.createLiving(bzv.bQ)));
        CraftEntityTypes.register(new EntityTypeData<Slime, cse>(EntityType.SLIME, Slime.class, CraftSlime::new, CraftEntityTypes.createLiving(bzv.bj)));
        CraftEntityTypes.register(new EntityTypeData<Ghast, crp>(EntityType.GHAST, Ghast.class, CraftGhast::new, CraftEntityTypes.createLiving(bzv.ae)));
        CraftEntityTypes.register(new EntityTypeData<HappyGhast, cmt>(EntityType.HAPPY_GHAST, HappyGhast.class, CraftHappyGhast::new, CraftEntityTypes.createLiving(bzv.af)));
        CraftEntityTypes.register(new EntityTypeData<PigZombie, csq>(EntityType.ZOMBIFIED_PIGLIN, PigZombie.class, CraftPigZombie::new, CraftEntityTypes.createLiving(bzv.bT)));
        CraftEntityTypes.register(new EntityTypeData<Enderman, crl>(EntityType.ENDERMAN, Enderman.class, CraftEnderman::new, CraftEntityTypes.createLiving(bzv.O)));
        CraftEntityTypes.register(new EntityTypeData<CaveSpider, crg>(EntityType.CAVE_SPIDER, CaveSpider.class, CraftCaveSpider::new, CraftEntityTypes.createLiving(bzv.w)));
        CraftEntityTypes.register(new EntityTypeData<Silverfish, csc>(EntityType.SILVERFISH, Silverfish.class, CraftSilverfish::new, CraftEntityTypes.createLiving(bzv.bg)));
        CraftEntityTypes.register(new EntityTypeData<Blaze, cre>(EntityType.BLAZE, Blaze.class, CraftBlaze::new, CraftEntityTypes.createLiving(bzv.p)));
        CraftEntityTypes.register(new EntityTypeData<MagmaCube, cru>(EntityType.MAGMA_CUBE, MagmaCube.class, CraftMagmaCube::new, CraftEntityTypes.createLiving(bzv.aB)));
        CraftEntityTypes.register(new EntityTypeData<Wither, cqm>(EntityType.WITHER, Wither.class, CraftWither::new, CraftEntityTypes.createLiving(bzv.bL)));
        CraftEntityTypes.register(new EntityTypeData<Bat, clw>(EntityType.BAT, Bat.class, CraftBat::new, CraftEntityTypes.createLiving(bzv.l)));
        CraftEntityTypes.register(new EntityTypeData<Witch, csl>(EntityType.WITCH, Witch.class, CraftWitch::new, CraftEntityTypes.createLiving(bzv.bK)));
        CraftEntityTypes.register(new EntityTypeData<Endermite, crm>(EntityType.ENDERMITE, Endermite.class, CraftEndermite::new, CraftEntityTypes.createLiving(bzv.P)));
        CraftEntityTypes.register(new EntityTypeData<Guardian, crr>(EntityType.GUARDIAN, Guardian.class, CraftGuardian::new, CraftEntityTypes.createLiving(bzv.ak)));
        CraftEntityTypes.register(new EntityTypeData<Shulker, csb>(EntityType.SHULKER, Shulker.class, CraftShulker::new, CraftEntityTypes.createLiving(bzv.be)));
        CraftEntityTypes.register(new EntityTypeData<Pig, cna>(EntityType.PIG, Pig.class, CraftPig::new, CraftEntityTypes.createLiving(bzv.aS)));
        CraftEntityTypes.register(new EntityTypeData<Sheep, cpd>(EntityType.SHEEP, Sheep.class, CraftSheep::new, CraftEntityTypes.createLiving(bzv.bd)));
        CraftEntityTypes.register(new EntityTypeData<Cow, cmn>(EntityType.COW, Cow.class, CraftCow::new, CraftEntityTypes.createLiving(bzv.D)));
        CraftEntityTypes.register(new EntityTypeData<Chicken, cmj>(EntityType.CHICKEN, Chicken.class, CraftChicken::new, CraftEntityTypes.createLiving(bzv.A)));
        CraftEntityTypes.register(new EntityTypeData<Squid, cnj>(EntityType.SQUID, Squid.class, CraftSquid::new, CraftEntityTypes.createLiving(bzv.bt)));
        CraftEntityTypes.register(new EntityTypeData<Wolf, cpj>(EntityType.WOLF, Wolf.class, CraftWolf::new, CraftEntityTypes.createLiving(bzv.bO)));
        CraftEntityTypes.register(new EntityTypeData<MushroomCow, cmw>(EntityType.MOOSHROOM, MushroomCow.class, CraftMushroomCow::new, CraftEntityTypes.createLiving(bzv.aG)));
        CraftEntityTypes.register(new EntityTypeData<Snowman, cni>(EntityType.SNOW_GOLEM, Snowman.class, CraftSnowman::new, CraftEntityTypes.createLiving(bzv.bn)));
        CraftEntityTypes.register(new EntityTypeData<Ocelot, cmx>(EntityType.OCELOT, Ocelot.class, CraftOcelot::new, CraftEntityTypes.createLiving(bzv.aK)));
        CraftEntityTypes.register(new EntityTypeData<IronGolem, cmv>(EntityType.IRON_GOLEM, IronGolem.class, CraftIronGolem::new, CraftEntityTypes.createLiving(bzv.ar)));
        CraftEntityTypes.register(new EntityTypeData<Horse, cos>(EntityType.HORSE, Horse.class, CraftHorse::new, CraftEntityTypes.createLiving(bzv.an)));
        CraftEntityTypes.register(new EntityTypeData<Rabbit, cnf>(EntityType.RABBIT, Rabbit.class, CraftRabbit::new, CraftEntityTypes.createLiving(bzv.ba)));
        CraftEntityTypes.register(new EntityTypeData<PolarBear, cnd>(EntityType.POLAR_BEAR, PolarBear.class, CraftPolarBear::new, CraftEntityTypes.createLiving(bzv.aW)));
        CraftEntityTypes.register(new EntityTypeData<Llama, cot>(EntityType.LLAMA, Llama.class, CraftLlama::new, CraftEntityTypes.createLiving(bzv.az)));
        CraftEntityTypes.register(new EntityTypeData<Parrot, cmz>(EntityType.PARROT, Parrot.class, CraftParrot::new, CraftEntityTypes.createLiving(bzv.aQ)));
        CraftEntityTypes.register(new EntityTypeData<Villager, cuf>(EntityType.VILLAGER, Villager.class, CraftVillager::new, CraftEntityTypes.createLiving(bzv.bF)));
        CraftEntityTypes.register(new EntityTypeData<Turtle, cnm>(EntityType.TURTLE, Turtle.class, CraftTurtle::new, CraftEntityTypes.createLiving(bzv.bD)));
        CraftEntityTypes.register(new EntityTypeData<Phantom, crx>(EntityType.PHANTOM, Phantom.class, CraftPhantom::new, CraftEntityTypes.createLiving(bzv.aR)));
        CraftEntityTypes.register(new EntityTypeData<Cod, cmm>(EntityType.COD, Cod.class, CraftCod::new, CraftEntityTypes.createLiving(bzv.B)));
        CraftEntityTypes.register(new EntityTypeData<Salmon, cng>(EntityType.SALMON, Salmon.class, CraftSalmon::new, CraftEntityTypes.createLiving(bzv.bc)));
        CraftEntityTypes.register(new EntityTypeData<PufferFish, cne>(EntityType.PUFFERFISH, PufferFish.class, CraftPufferFish::new, CraftEntityTypes.createLiving(bzv.aZ)));
        CraftEntityTypes.register(new EntityTypeData<TropicalFish, cnl>(EntityType.TROPICAL_FISH, TropicalFish.class, CraftTropicalFish::new, CraftEntityTypes.createLiving(bzv.bC)));
        CraftEntityTypes.register(new EntityTypeData<Drowned, crj>(EntityType.DROWNED, Drowned.class, CraftDrowned::new, CraftEntityTypes.createLiving(bzv.L)));
        CraftEntityTypes.register(new EntityTypeData<Dolphin, cmq>(EntityType.DOLPHIN, Dolphin.class, CraftDolphin::new, CraftEntityTypes.createLiving(bzv.I)));
        CraftEntityTypes.register(new EntityTypeData<Cat, cmg>(EntityType.CAT, Cat.class, CraftCat::new, CraftEntityTypes.createLiving(bzv.v)));
        CraftEntityTypes.register(new EntityTypeData<Panda, cmy>(EntityType.PANDA, Panda.class, CraftPanda::new, CraftEntityTypes.createLiving(bzv.aP)));
        CraftEntityTypes.register(new EntityTypeData<Pillager, cry>(EntityType.PILLAGER, Pillager.class, CraftPillager::new, CraftEntityTypes.createLiving(bzv.aV)));
        CraftEntityTypes.register(new EntityTypeData<Ravager, csa>(EntityType.RAVAGER, Ravager.class, CraftRavager::new, CraftEntityTypes.createLiving(bzv.bb)));
        CraftEntityTypes.register(new EntityTypeData<TraderLlama, coy>(EntityType.TRADER_LLAMA, TraderLlama.class, CraftTraderLlama::new, CraftEntityTypes.createLiving(bzv.bA)));
        CraftEntityTypes.register(new EntityTypeData<WanderingTrader, cul>(EntityType.WANDERING_TRADER, WanderingTrader.class, CraftWanderingTrader::new, CraftEntityTypes.createLiving(bzv.bH)));
        CraftEntityTypes.register(new EntityTypeData<Fox, cms>(EntityType.FOX, Fox.class, CraftFox::new, CraftEntityTypes.createLiving(bzv.ab)));
        CraftEntityTypes.register(new EntityTypeData<Bee, cme>(EntityType.BEE, Bee.class, CraftBee::new, CraftEntityTypes.createLiving(bzv.m)));
        CraftEntityTypes.register(new EntityTypeData<Hoglin, ctc>(EntityType.HOGLIN, Hoglin.class, CraftHoglin::new, CraftEntityTypes.createLiving(bzv.al)));
        CraftEntityTypes.register(new EntityTypeData<Piglin, cti>(EntityType.PIGLIN, Piglin.class, CraftPiglin::new, CraftEntityTypes.createLiving(bzv.aT)));
        CraftEntityTypes.register(new EntityTypeData<Strider, csi>(EntityType.STRIDER, Strider.class, CraftStrider::new, CraftEntityTypes.createLiving(bzv.bv)));
        CraftEntityTypes.register(new EntityTypeData<Zoglin, csn>(EntityType.ZOGLIN, Zoglin.class, CraftZoglin::new, CraftEntityTypes.createLiving(bzv.bP)));
        CraftEntityTypes.register(new EntityTypeData<PiglinBrute, ctl>(EntityType.PIGLIN_BRUTE, PiglinBrute.class, CraftPiglinBrute::new, CraftEntityTypes.createLiving(bzv.aU)));
        CraftEntityTypes.register(new EntityTypeData<Axolotl, cnu>(EntityType.AXOLOTL, Axolotl.class, CraftAxolotl::new, CraftEntityTypes.createLiving(bzv.i)));
        CraftEntityTypes.register(new EntityTypeData<GlowSquid, cab>(EntityType.GLOW_SQUID, GlowSquid.class, CraftGlowSquid::new, CraftEntityTypes.createLiving(bzv.ai)));
        CraftEntityTypes.register(new EntityTypeData<Goat, cok>(EntityType.GOAT, Goat.class, CraftGoat::new, CraftEntityTypes.createLiving(bzv.aj)));
        CraftEntityTypes.register(new EntityTypeData<Allay, cno>(EntityType.ALLAY, Allay.class, CraftAllay::new, CraftEntityTypes.createLiving(bzv.d)));
        CraftEntityTypes.register(new EntityTypeData<Frog, coc>(EntityType.FROG, Frog.class, CraftFrog::new, CraftEntityTypes.createLiving(bzv.ac)));
        CraftEntityTypes.register(new EntityTypeData<Tadpole, coh>(EntityType.TADPOLE, Tadpole.class, CraftTadpole::new, CraftEntityTypes.createLiving(bzv.bw)));
        CraftEntityTypes.register(new EntityTypeData<Warden, ctw>(EntityType.WARDEN, Warden.class, CraftWarden::new, CraftEntityTypes.createLiving(bzv.bI)));
        CraftEntityTypes.register(new EntityTypeData<Camel, cnz>(EntityType.CAMEL, Camel.class, CraftCamel::new, CraftEntityTypes.createLiving(bzv.u)));
        CraftEntityTypes.register(new EntityTypeData<Sniffer, cpg>(EntityType.SNIFFER, Sniffer.class, CraftSniffer::new, CraftEntityTypes.createLiving(bzv.bl)));
        CraftEntityTypes.register(new EntityTypeData<Breeze, csr>(EntityType.BREEZE, Breeze.class, CraftBreeze::new, CraftEntityTypes.createLiving(bzv.s)));
        CraftEntityTypes.register(new EntityTypeData<Armadillo, cnr>(EntityType.ARMADILLO, Armadillo.class, CraftArmadillo::new, CraftEntityTypes.createLiving(bzv.f)));
        CraftEntityTypes.register(new EntityTypeData<Creaking, csz>(EntityType.CREAKING, Creaking.class, CraftCreaking::new, CraftEntityTypes.createLiving(bzv.E)));
        Function<SpawnData, cps> dragonFunction = CraftEntityTypes.createLiving(bzv.Q);
        CraftEntityTypes.register(new EntityTypeData<EnderDragon, cps>(EntityType.ENDER_DRAGON, EnderDragon.class, CraftEnderDragon::new, spawnData -> {
            Preconditions.checkArgument((boolean)spawnData.normalWorld(), (String)"Cannot spawn entity %s during world generation", (Object)EnderDragon.class.getName());
            return (cps)dragonFunction.apply((SpawnData)spawnData);
        }));
        CraftEntityTypes.register(new EntityTypeData<LargeFireball, cvm>(EntityType.FIREBALL, LargeFireball.class, CraftLargeFireball::new, CraftEntityTypes.createFireball(bzv.Z)));
        CraftEntityTypes.register(new EntityTypeData<SmallFireball, cvs>(EntityType.SMALL_FIREBALL, SmallFireball.class, CraftSmallFireball::new, CraftEntityTypes.createFireball(bzv.bk)));
        CraftEntityTypes.register(new EntityTypeData<WitherSkull, cwd>(EntityType.WITHER_SKULL, WitherSkull.class, CraftWitherSkull::new, CraftEntityTypes.createFireball(bzv.bN)));
        CraftEntityTypes.register(new EntityTypeData<DragonFireball, cvf>(EntityType.DRAGON_FIREBALL, DragonFireball.class, CraftDragonFireball::new, CraftEntityTypes.createFireball(bzv.K)));
        CraftEntityTypes.register(new EntityTypeData<WindCharge, cwh>(EntityType.WIND_CHARGE, WindCharge.class, CraftWindCharge::new, CraftEntityTypes.createFireball(bzv.bJ)));
        CraftEntityTypes.register(new EntityTypeData<BreezeWindCharge, cwg>(EntityType.BREEZE_WIND_CHARGE, BreezeWindCharge.class, CraftBreezeWindCharge::new, CraftEntityTypes.createFireball(bzv.t)));
        CraftEntityTypes.register(new EntityTypeData<Painting, cqu>(EntityType.PAINTING, Painting.class, CraftPainting::new, CraftEntityTypes.createHanging(Painting.class, (spawnData, hangingData) -> {
            if (spawnData.normalWorld && hangingData.randomize()) {
                return cqu.a(spawnData.minecraftWorld(), hangingData.position(), hangingData.direction()).orElse(null);
            }
            cqu entity = new cqu((bzv<? extends cqu>)bzv.aM, spawnData.minecraftWorld());
            entity.a(spawnData.x(), spawnData.y(), spawnData.z(), spawnData.yaw(), spawnData.pitch());
            entity.b(hangingData.direction());
            return entity;
        })));
        CraftEntityTypes.register(new EntityTypeData<ItemFrame, cqs>(EntityType.ITEM_FRAME, ItemFrame.class, CraftItemFrame::new, CraftEntityTypes.createHanging(ItemFrame.class, (spawnData, hangingData) -> new cqs(spawnData.minecraftWorld(), hangingData.position(), hangingData.direction()))));
        CraftEntityTypes.register(new EntityTypeData<GlowItemFrame, cqq>(EntityType.GLOW_ITEM_FRAME, GlowItemFrame.class, CraftGlowItemFrame::new, CraftEntityTypes.createHanging(GlowItemFrame.class, (spawnData, hangingData) -> new cqq(spawnData.minecraftWorld(), hangingData.position(), hangingData.direction()))));
        CraftEntityTypes.register(new EntityTypeData<Arrow, cve>(EntityType.ARROW, Arrow.class, CraftArrow::new, CraftEntityTypes.createAndMoveEmptyRot(bzv.h)));
        CraftEntityTypes.register(new EntityTypeData<EnderPearl, cvy>(EntityType.ENDER_PEARL, EnderPearl.class, CraftEnderPearl::new, CraftEntityTypes.createAndMoveEmptyRot(bzv.R)));
        CraftEntityTypes.register(new EntityTypeData<ThrownExpBottle, cvz>(EntityType.EXPERIENCE_BOTTLE, ThrownExpBottle.class, CraftThrownExpBottle::new, CraftEntityTypes.createAndMoveEmptyRot(bzv.V)));
        CraftEntityTypes.register(new EntityTypeData<SpectralArrow, cvu>(EntityType.SPECTRAL_ARROW, SpectralArrow.class, CraftSpectralArrow::new, CraftEntityTypes.createAndMoveEmptyRot(bzv.bp)));
        CraftEntityTypes.register(new EntityTypeData<EnderCrystal, cpr>(EntityType.END_CRYSTAL, EnderCrystal.class, CraftEnderCrystal::new, CraftEntityTypes.createAndMoveEmptyRot(bzv.S)));
        CraftEntityTypes.register(new EntityTypeData<Trident, cwc>(EntityType.TRIDENT, Trident.class, CraftTrident::new, CraftEntityTypes.createAndMoveEmptyRot(bzv.bB)));
        CraftEntityTypes.register(new EntityTypeData<LightningStrike, cal>(EntityType.LIGHTNING_BOLT, LightningStrike.class, CraftLightningStrike::new, CraftEntityTypes.createAndMoveEmptyRot(bzv.ay)));
        CraftEntityTypes.register(new EntityTypeData<ShulkerBullet, cvr>(EntityType.SHULKER_BULLET, ShulkerBullet.class, CraftShulkerBullet::new, CraftEntityTypes.createAndMove(bzv.bf)));
        CraftEntityTypes.register(new EntityTypeData<LlamaSpit, cvn>(EntityType.LLAMA_SPIT, LlamaSpit.class, CraftLlamaSpit::new, CraftEntityTypes.createAndMove(bzv.aA)));
        CraftEntityTypes.register(new EntityTypeData<OminousItemSpawner, cas>(EntityType.OMINOUS_ITEM_SPAWNER, OminousItemSpawner.class, CraftOminousItemSpawner::new, CraftEntityTypes.createAndMove(bzv.aL)));
        CraftEntityTypes.register(new EntityTypeData<AcaciaBoat, cxi>(EntityType.ACACIA_BOAT, AcaciaBoat.class, CraftAcaciaBoat::new, CraftEntityTypes.createAndMove(bzv.b)));
        CraftEntityTypes.register(new EntityTypeData<AcaciaChestBoat, cxj>(EntityType.ACACIA_CHEST_BOAT, AcaciaChestBoat.class, CraftAcaciaChestBoat::new, CraftEntityTypes.createAndMove(bzv.c)));
        CraftEntityTypes.register(new EntityTypeData<BambooRaft, cxx>(EntityType.BAMBOO_RAFT, BambooRaft.class, CraftBambooRaft::new, CraftEntityTypes.createAndMove(bzv.k)));
        CraftEntityTypes.register(new EntityTypeData<BambooChestRaft, cxk>(EntityType.BAMBOO_CHEST_RAFT, BambooChestRaft.class, CraftBambooChestRaft::new, CraftEntityTypes.createAndMove(bzv.j)));
        CraftEntityTypes.register(new EntityTypeData<BirchBoat, cxi>(EntityType.BIRCH_BOAT, BirchBoat.class, CraftBirchBoat::new, CraftEntityTypes.createAndMove(bzv.n)));
        CraftEntityTypes.register(new EntityTypeData<BirchChestBoat, cxj>(EntityType.BIRCH_CHEST_BOAT, BirchChestBoat.class, CraftBirchChestBoat::new, CraftEntityTypes.createAndMove(bzv.o)));
        CraftEntityTypes.register(new EntityTypeData<CherryBoat, cxi>(EntityType.CHERRY_BOAT, CherryBoat.class, CraftCherryBoat::new, CraftEntityTypes.createAndMove(bzv.x)));
        CraftEntityTypes.register(new EntityTypeData<CherryChestBoat, cxj>(EntityType.CHERRY_CHEST_BOAT, CherryChestBoat.class, CraftCherryChestBoat::new, CraftEntityTypes.createAndMove(bzv.y)));
        CraftEntityTypes.register(new EntityTypeData<DarkOakBoat, cxi>(EntityType.DARK_OAK_BOAT, DarkOakBoat.class, CraftDarkOakBoat::new, CraftEntityTypes.createAndMove(bzv.G)));
        CraftEntityTypes.register(new EntityTypeData<DarkOakChestBoat, cxj>(EntityType.DARK_OAK_CHEST_BOAT, DarkOakChestBoat.class, CraftDarkOakChestBoat::new, CraftEntityTypes.createAndMove(bzv.H)));
        CraftEntityTypes.register(new EntityTypeData<JungleBoat, cxi>(EntityType.JUNGLE_BOAT, JungleBoat.class, CraftJungleBoat::new, CraftEntityTypes.createAndMove(bzv.av)));
        CraftEntityTypes.register(new EntityTypeData<JungleChestBoat, cxj>(EntityType.JUNGLE_CHEST_BOAT, JungleChestBoat.class, CraftJungleChestBoat::new, CraftEntityTypes.createAndMove(bzv.aw)));
        CraftEntityTypes.register(new EntityTypeData<MangroveBoat, cxi>(EntityType.MANGROVE_BOAT, MangroveBoat.class, CraftMangroveBoat::new, CraftEntityTypes.createAndMove(bzv.aC)));
        CraftEntityTypes.register(new EntityTypeData<MangroveChestBoat, cxj>(EntityType.MANGROVE_CHEST_BOAT, MangroveChestBoat.class, CraftMangroveChestBoat::new, CraftEntityTypes.createAndMove(bzv.aD)));
        CraftEntityTypes.register(new EntityTypeData<OakBoat, cxi>(EntityType.OAK_BOAT, OakBoat.class, CraftOakBoat::new, CraftEntityTypes.createAndMove(bzv.aI)));
        CraftEntityTypes.register(new EntityTypeData<OakChestBoat, cxj>(EntityType.OAK_CHEST_BOAT, OakChestBoat.class, CraftOakChestBoat::new, CraftEntityTypes.createAndMove(bzv.aJ)));
        CraftEntityTypes.register(new EntityTypeData<PaleOakBoat, cxi>(EntityType.PALE_OAK_BOAT, PaleOakBoat.class, CraftPaleOakBoat::new, CraftEntityTypes.createAndMove(bzv.aN)));
        CraftEntityTypes.register(new EntityTypeData<PaleOakChestBoat, cxj>(EntityType.PALE_OAK_CHEST_BOAT, PaleOakChestBoat.class, CraftPaleOakChestBoat::new, CraftEntityTypes.createAndMove(bzv.aO)));
        CraftEntityTypes.register(new EntityTypeData<SpruceBoat, cxi>(EntityType.SPRUCE_BOAT, SpruceBoat.class, CraftSpruceBoat::new, CraftEntityTypes.createAndMove(bzv.br)));
        CraftEntityTypes.register(new EntityTypeData<SpruceChestBoat, cxj>(EntityType.SPRUCE_CHEST_BOAT, SpruceChestBoat.class, CraftSpruceChestBoat::new, CraftEntityTypes.createAndMove(bzv.bs)));
        CraftEntityTypes.register(new EntityTypeData<Marker, can>(EntityType.MARKER, Marker.class, CraftMarker::new, CraftEntityTypes.createAndSetPos(bzv.aE)));
        CraftEntityTypes.register(new EntityTypeData<BlockDisplay, bzj.b>(EntityType.BLOCK_DISPLAY, BlockDisplay.class, CraftBlockDisplay::new, CraftEntityTypes.createAndSetPos(bzv.q)));
        CraftEntityTypes.register(new EntityTypeData<Interaction, cag>(EntityType.INTERACTION, Interaction.class, CraftInteraction::new, CraftEntityTypes.createAndSetPos(bzv.aq)));
        CraftEntityTypes.register(new EntityTypeData<ItemDisplay, bzj.g>(EntityType.ITEM_DISPLAY, ItemDisplay.class, CraftItemDisplay::new, CraftEntityTypes.createAndSetPos(bzv.at)));
        CraftEntityTypes.register(new EntityTypeData<TextDisplay, bzj.k>(EntityType.TEXT_DISPLAY, TextDisplay.class, CraftTextDisplay::new, CraftEntityTypes.createAndSetPos(bzv.bx)));
        CraftEntityTypes.register(new EntityTypeData<Item, cqz>(EntityType.ITEM, Item.class, CraftItem::new, spawnData -> {
            dcv itemStack = new dcv(dcz.b);
            cqz item = new cqz(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), itemStack);
            item.b(10);
            return item;
        }));
        CraftEntityTypes.register(new EntityTypeData<ExperienceOrb, caa>(EntityType.EXPERIENCE_ORB, ExperienceOrb.class, CraftExperienceOrb::new, spawnData -> new caa(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), 0)));
        CraftEntityTypes.register(new EntityTypeData<AreaEffectCloud, bze>(EntityType.AREA_EFFECT_CLOUD, AreaEffectCloud.class, CraftAreaEffectCloud::new, spawnData -> new bze(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z())));
        CraftEntityTypes.register(new EntityTypeData<Egg, cvx>(EntityType.EGG, Egg.class, CraftEgg::new, spawnData -> new cvx(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), new dcv(dcz.rY))));
        CraftEntityTypes.register(new EntityTypeData<LeashHitch, cqt>(EntityType.LEASH_KNOT, LeashHitch.class, CraftLeash::new, spawnData -> new cqt(spawnData.minecraftWorld(), jb.a(spawnData.x(), spawnData.y(), spawnData.z()))));
        CraftEntityTypes.register(new EntityTypeData<Snowball, cvt>(EntityType.SNOWBALL, Snowball.class, CraftSnowball::new, spawnData -> new cvt(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), new dcv(dcz.rJ))));
        CraftEntityTypes.register(new EntityTypeData<EnderSignal, cvh>(EntityType.EYE_OF_ENDER, EnderSignal.class, CraftEnderSignal::new, spawnData -> new cvh(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z())));
        CraftEntityTypes.register(new EntityTypeData<SplashPotion, cvd>(EntityType.SPLASH_POTION, SplashPotion.class, CraftSplashPotion::new, spawnData -> {
            cwb entity = new cwb(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), new dcv(dcz.wR));
            return entity;
        }));
        CraftEntityTypes.register(new EntityTypeData<LingeringPotion, cvd>(EntityType.LINGERING_POTION, LingeringPotion.class, CraftLingeringPotion::new, spawnData -> {
            cwa entity = new cwa(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), new dcv(dcz.wU));
            return entity;
        }));
        CraftEntityTypes.register(new EntityTypeData<TNTPrimed, cra>(EntityType.TNT, TNTPrimed.class, CraftTNTPrimed::new, spawnData -> new cra(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), null)));
        CraftEntityTypes.register(new EntityTypeData<FallingBlock, cqy>(EntityType.FALLING_BLOCK, FallingBlock.class, CraftFallingBlock::new, spawnData -> {
            jb pos = jb.a(spawnData.x(), spawnData.y(), spawnData.z());
            return cqy.a(spawnData.minecraftWorld(), pos, spawnData.world().a_(pos));
        }));
        CraftEntityTypes.register(new EntityTypeData<Firework, cvj>(EntityType.FIREWORK_ROCKET, Firework.class, CraftFirework::new, spawnData -> new cvj(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), dcv.l)));
        CraftEntityTypes.register(new EntityTypeData<EvokerFangs, cvg>(EntityType.EVOKER_FANGS, EvokerFangs.class, CraftEvokerFangs::new, spawnData -> new cvg(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), (float)Math.toRadians(spawnData.yaw()), 0, null)));
        CraftEntityTypes.register(new EntityTypeData<CommandMinecart, cxq>(EntityType.COMMAND_BLOCK_MINECART, CommandMinecart.class, CraftMinecartCommand::new, CraftEntityTypes.createMinecart(bzv.C)));
        CraftEntityTypes.register(new EntityTypeData<RideableMinecart, cxn>(EntityType.MINECART, RideableMinecart.class, CraftMinecartRideable::new, CraftEntityTypes.createMinecart(bzv.aF)));
        CraftEntityTypes.register(new EntityTypeData<StorageMinecart, cxp>(EntityType.CHEST_MINECART, StorageMinecart.class, CraftMinecartChest::new, CraftEntityTypes.createMinecart(bzv.z)));
        CraftEntityTypes.register(new EntityTypeData<PoweredMinecart, cxr>(EntityType.FURNACE_MINECART, PoweredMinecart.class, CraftMinecartFurnace::new, CraftEntityTypes.createMinecart(bzv.ad)));
        CraftEntityTypes.register(new EntityTypeData<ExplosiveMinecart, cxu>(EntityType.TNT_MINECART, ExplosiveMinecart.class, CraftMinecartTNT::new, CraftEntityTypes.createMinecart(bzv.bz)));
        CraftEntityTypes.register(new EntityTypeData<HopperMinecart, cxs>(EntityType.HOPPER_MINECART, HopperMinecart.class, CraftMinecartHopper::new, CraftEntityTypes.createMinecart(bzv.am)));
        CraftEntityTypes.register(new EntityTypeData<SpawnerMinecart, cxt>(EntityType.SPAWNER_MINECART, SpawnerMinecart.class, CraftMinecartMobSpawner::new, CraftEntityTypes.createMinecart(bzv.bo)));
        CraftEntityTypes.register(new EntityTypeData<FishHook, cvk>(EntityType.FISHING_BOBBER, FishHook.class, CraftFishHook::new, null));
        CraftEntityTypes.register(new EntityTypeData<Player, auc>(EntityType.PLAYER, Player.class, CraftPlayer::new, null));
    }

    public record EntityTypeData<E extends Entity, M extends bzm>(EntityType entityType, Class<E> entityClass, BiFunction<CraftServer, M, E> convertFunction, Function<SpawnData, M> spawnFunction) {
    }

    public record SpawnData(dnt world, Location location, boolean randomizeData, boolean normalWorld) {
        double x() {
            return this.location().getX();
        }

        double y() {
            return this.location().getY();
        }

        double z() {
            return this.location().getZ();
        }

        float yaw() {
            return this.location().getYaw();
        }

        float pitch() {
            return this.location().getPitch();
        }

        dmu minecraftWorld() {
            return this.world().getMinecraftWorld();
        }
    }

    private record HangingData(boolean randomize, jb position, jh direction) {
    }
}

