/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAnimals;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Player;

public class CraftFox
extends CraftAnimals
implements Fox {
    public CraftFox(CraftServer server, cms entity) {
        super(server, entity);
    }

    @Override
    public cms getHandle() {
        return (cms)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftFox";
    }

    public Fox.Type getFoxType() {
        return Fox.Type.values()[this.getHandle().n().ordinal()];
    }

    public void setFoxType(Fox.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        this.getHandle().a(cms.v.values()[type.ordinal()]);
    }

    public boolean isCrouching() {
        return this.getHandle().cl();
    }

    public void setCrouching(boolean crouching) {
        this.getHandle().z(crouching);
    }

    public boolean isSitting() {
        return this.getHandle().t();
    }

    public void setSitting(boolean sitting) {
        this.getHandle().x(sitting);
    }

    public void setSleeping(boolean sleeping) {
        this.getHandle().D(sleeping);
    }

    public AnimalTamer getFirstTrustedPlayer() {
        UUID uuid = this.getHandle().au().a(cms.cu).map(bzs::c).orElse(null);
        if (uuid == null) {
            return null;
        }
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    public void setFirstTrustedPlayer(AnimalTamer player) {
        if (player == null) {
            Preconditions.checkState((boolean)this.getHandle().au().a(cms.cv).isEmpty(), (Object)"Must remove second trusted player first");
        }
        this.getHandle().au().a(cms.cu, player == null ? Optional.empty() : Optional.of(new bzs(player.getUniqueId())));
    }

    public AnimalTamer getSecondTrustedPlayer() {
        UUID uuid = this.getHandle().au().a(cms.cv).map(bzs::c).orElse(null);
        if (uuid == null) {
            return null;
        }
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    public void setSecondTrustedPlayer(AnimalTamer player) {
        if (player != null) {
            Preconditions.checkState((boolean)this.getHandle().au().a(cms.cu).isPresent(), (Object)"Must add first trusted player first");
        }
        this.getHandle().au().a(cms.cv, player == null ? Optional.empty() : Optional.of(new bzs(player.getUniqueId())));
    }

    public boolean isFaceplanted() {
        return this.getHandle().gH();
    }
}

