/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftSound;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.v1_21_R5.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractWindCharge;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, cam entity) {
        super(server, entity);
        if (entity instanceof cao || entity instanceof cqo) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().eL()), this.getMaxHealth());
    }

    public void setHealth(double health) {
        Preconditions.checkArgument(((health = (double)((float)health)) >= 0.0 && health <= this.getMaxHealth() ? 1 : 0) != 0, (String)"Health value (%s) must be between 0 and %s", (Object)health, (Object)this.getMaxHealth());
        if (this.getHandle().generation && health == 0.0) {
            this.getHandle().discard(null);
            return;
        }
        this.getHandle().x((float)health);
        if (health == 0.0) {
            this.getHandle().a(this.getHandle().ea().p());
        }
    }

    public double getAbsorptionAmount() {
        return this.getHandle().fD();
    }

    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.getHandle().E((float)amount);
    }

    public double getMaxHealth() {
        return this.getHandle().fa();
    }

    public void setMaxHealth(double amount) {
        Preconditions.checkArgument((amount > 0.0 ? 1 : 0) != 0, (String)"Max health amount (%s) must be greater than 0", (Object)amount);
        this.getHandle().h(cbs.t).a(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().h(cbs.t).a().a().a());
    }

    public double getEyeHeight() {
        return this.getHandle().cW();
    }

    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot get line of sight during world generation");
        if (transparent == null) {
            transparent = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.CAVE_AIR, Material.VOID_AIR});
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (transparent.contains(material = block.getType())) continue;
            break;
        }
        return blocks;
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    public Block getTargetBlockExact(int maxDistance) {
        return this.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
    }

    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.rayTraceBlocks(maxDistance, FluidCollisionMode.NEVER);
    }

    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot ray tray blocks during world generation");
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    public int getRemainingAir() {
        return this.getHandle().cw();
    }

    public void setRemainingAir(int ticks) {
        this.getHandle().j(ticks);
    }

    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    public ItemStack getItemInUse() {
        dcv item = this.getHandle().fI();
        return item.f() ? null : CraftItemStack.asCraftMirror(item);
    }

    public int getItemInUseTicks() {
        return this.getHandle().fJ();
    }

    public void setItemInUseTicks(int ticks) {
        this.getHandle().bJ = ticks;
    }

    public int getArrowCooldown() {
        return this.getHandle().bh;
    }

    public void setArrowCooldown(int ticks) {
        this.getHandle().bh = ticks;
    }

    public int getArrowsInBody() {
        return this.getHandle().fc();
    }

    public void setArrowsInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        this.getHandle().au().a(cam.bX, count);
    }

    @Override
    public boolean isInvulnerable() {
        return this.getHandle().a((aub)this.getHandle().ai(), this.getHandle().ea().p());
    }

    public void damage(double amount) {
        this.damage(amount, this.getHandle().ea().p());
    }

    public void damage(double amount, Entity source) {
        byb reason = this.getHandle().ea().p();
        if (source instanceof HumanEntity) {
            reason = this.getHandle().ea().a(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = this.getHandle().ea().b(((CraftLivingEntity)source).getHandle());
        }
        this.damage(amount, reason);
    }

    public void damage(double amount, DamageSource damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        this.damage(amount, ((CraftDamageSource)damageSource).getHandle());
    }

    private void damage(double amount, byb damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot damage entity during world generation");
        this.entity.a(damageSource, (float)amount);
    }

    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    public int getMaximumNoDamageTicks() {
        return this.getHandle().bq;
    }

    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().bq = ticks;
    }

    public double getLastDamage() {
        return this.getHandle().bA;
    }

    public void setLastDamage(double damage) {
        this.getHandle().bA = (float)damage;
    }

    public int getNoDamageTicks() {
        return this.getHandle().aw;
    }

    public void setNoDamageTicks(int ticks) {
        this.getHandle().aw = ticks;
    }

    public int getNoActionTicks() {
        return this.getHandle().eB();
    }

    public void setNoActionTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().n(ticks);
    }

    @Override
    public cam getHandle() {
        return (cam)this.entity;
    }

    public void setHandle(cam entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + "}";
    }

    public Player getKiller() {
        cut lastHurtByPlayer = this.getHandle().ex();
        return lastHurtByPlayer == null ? null : (Player)lastHurtByPlayer.getBukkitEntity();
    }

    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        this.getHandle().addEffect(new byq(CraftPotionEffectType.bukkitToMinecraftHolder(effect.getType()), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles()), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().d(CraftPotionEffectType.bukkitToMinecraftHolder(type));
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        byq handle = this.getHandle().e(CraftPotionEffectType.bukkitToMinecraftHolder(type));
        return handle == null ? null : new PotionEffect(CraftPotionEffectType.minecraftHolderToBukkit(handle.c()), handle.d(), handle.e(), handle.f(), handle.g());
    }

    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(CraftPotionEffectType.bukkitToMinecraftHolder(type), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (byq handle : this.getHandle().ce.values()) {
            effects.add(new PotionEffect(CraftPotionEffectType.minecraftHolderToBukkit(handle.c()), handle.d(), handle.e(), handle.f(), handle.g()));
        }
        return effects;
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot launch projectile during world generation");
        aub world = ((CraftWorld)this.getWorld()).getHandle();
        cvo launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new cvt(world, this.getHandle(), new dcv(dcz.rJ));
            ((cvw)launch).a(this.getHandle(), this.getHandle().dR(), this.getHandle().dP(), 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new cvx(world, this.getHandle(), new dcv(dcz.rY));
            ((cvw)launch).a(this.getHandle(), this.getHandle().dR(), this.getHandle().dP(), 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new cvy(world, this.getHandle(), new dcv(dcz.tE));
            ((cvw)launch).a(this.getHandle(), this.getHandle().dR(), this.getHandle().dP(), 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new cve(world, this.getHandle(), new dcv(dcz.pB), null);
                ((Arrow)launch.getBukkitEntity()).setBasePotionType(PotionType.WATER);
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new cvu(world, this.getHandle(), new dcv(dcz.wS), null) : (Trident.class.isAssignableFrom(projectile) ? new cwc(world, this.getHandle(), new dcv(dcz.xx)) : new cve(world, this.getHandle(), new dcv(dcz.pB), null));
            }
            ((cvb)launch).a(this.getHandle(), this.getHandle().dR(), this.getHandle().dP(), 0.0f, 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            launch = LingeringPotion.class.isAssignableFrom(projectile) ? new cwa(world, this.getHandle(), new dcv(dcz.wU)) : new cwb(world, this.getHandle(), new dcv(dcz.wR));
            ((cvw)launch).a(this.getHandle(), this.getHandle().dR(), this.getHandle().dP(), -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new cvz(world, this.getHandle(), new dcv(dcz.vx));
            ((cvw)launch).a(this.getHandle(), this.getHandle().dR(), this.getHandle().dP(), -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof cut) {
            launch = new cvk((cut)this.getHandle(), (dmu)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            fis vec = new fis(direction.getX(), direction.getY(), direction.getZ());
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new cvs(world, this.getHandle(), vec);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = new cwd(world, this.getHandle(), vec);
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = new cvf(world, this.getHandle(), vec);
            } else if (AbstractWindCharge.class.isAssignableFrom(projectile)) {
                launch = BreezeWindCharge.class.isAssignableFrom(projectile) ? bzv.t.a(world, bzu.k) : bzv.bJ.a(world, bzu.k);
                ((cwf)launch).c(this.getHandle());
                ((cwf)launch).a(this.getHandle(), this.getHandle().dR(), this.getHandle().dP(), 0.0f, 1.5f, 1.0f);
            } else {
                launch = new cvm(world, this.getHandle(), vec, 1);
            }
            ((cvc)launch).projectileSource = this;
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = bzv.aA.a(world, bzu.k);
            ((cvn)launch).c(this.getHandle());
            ((cvn)launch).c(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new cvr(world, this.getHandle(), null, null);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (Firework.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new cvj(world, dcv.l, this.getHandle());
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Preconditions.checkArgument((launch != null ? 1 : 0) != 0, (String)"Projectile (%s) not supported", (Object)projectile.getName());
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }

    public boolean hasLineOfSight(Entity other) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check line of sight during world generation");
        return this.getHandle().F(((CraftEntity)other).getHandle());
    }

    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof cao && !((cao)this.getHandle()).gq();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof cao) {
            ((cao)this.getHandle()).setPersistenceRequired(!remove);
        }
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof cao) {
            ((cao)this.getHandle()).a_(pickup);
        } else {
            this.getHandle().bukkitPickUpLoot = pickup;
        }
    }

    public boolean getCanPickupItems() {
        if (this.getHandle() instanceof cao) {
            return ((cao)this.getHandle()).fU();
        }
        return this.getHandle().bukkitPickUpLoot;
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    public boolean isLeashed() {
        if (!(this.getHandle() instanceof cao)) {
            return false;
        }
        return ((cao)this.getHandle()).aj_() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isLeashed(), (Object)"Entity not leashed");
        return ((cao)this.getHandle()).aj_().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        ((cao)this.getHandle()).x();
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation || this.getHandle() instanceof cqm || !(this.getHandle() instanceof cao)) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        ((cao)this.getHandle()).a_(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    public boolean isGliding() {
        return this.getHandle().i(7);
    }

    public void setGliding(boolean gliding) {
        this.getHandle().b(7, gliding);
    }

    public boolean isSwimming() {
        return this.getHandle().cn();
    }

    public void setSwimming(boolean swimming) {
        this.getHandle().j(swimming);
    }

    public boolean isRiptiding() {
        return this.getHandle().fC();
    }

    public void setRiptiding(boolean riptiding) {
        this.getHandle().c(4, riptiding);
    }

    public boolean isSleeping() {
        return this.getHandle().fY();
    }

    public boolean isClimbing() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check if climbing during world generation");
        return this.getHandle().eV();
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().craftAttributes.getAttribute(attribute);
    }

    public void setAI(boolean ai2) {
        if (this.getHandle() instanceof cao) {
            ((cao)this.getHandle()).u(!ai2);
        }
    }

    public boolean hasAI() {
        return this.getHandle() instanceof cao ? !((cao)this.getHandle()).gw() : false;
    }

    public void attack(Entity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target == null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot attack during world generation");
        if (this.getHandle() instanceof cut) {
            ((cut)this.getHandle()).e(((CraftEntity)target).getHandle());
        } else {
            this.getHandle().c((aub)((CraftEntity)target).getHandle().ai(), ((CraftEntity)target).getHandle());
        }
    }

    public void swingMainHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(bxi.a, true);
    }

    public void swingOffHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(bxi.b, true);
    }

    public void playHurtAnimation(float yaw) {
        dmu dmu2 = this.getHandle().ai();
        if (dmu2 instanceof aub) {
            aub world = (aub)dmu2;
            float actualYaw = yaw + 90.0f;
            adz packet = new adz(this.getEntityId(), actualYaw);
            world.n().a(this.getHandle(), packet);
        }
    }

    public void setCollidable(boolean collidable) {
        this.getHandle().collides = collidable;
    }

    public boolean isCollidable() {
        return this.getHandle().collides;
    }

    public Set<UUID> getCollidableExemptions() {
        return this.getHandle().collidableExemptions;
    }

    public <T> T getMemory(MemoryKey<T> memoryKey) {
        return this.getHandle().eh().c(CraftMemoryKey.bukkitToMinecraft(memoryKey)).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public <T> void setMemory(MemoryKey<T> memoryKey, T t2) {
        this.getHandle().eh().a(CraftMemoryKey.bukkitToMinecraft(memoryKey), CraftMemoryMapper.toNms(t2));
    }

    public Sound getHurtSound() {
        ayy sound = this.getHandle().getHurtSound0(this.getHandle().ea().p());
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getDeathSound() {
        ayy sound = this.getHandle().getDeathSound0();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getFallDamageSound(int fallHeight) {
        return CraftSound.minecraftToBukkit(this.getHandle().getFallDamageSound0(fallHeight));
    }

    public Sound getFallDamageSoundSmall() {
        return CraftSound.minecraftToBukkit(this.getHandle().eT().a());
    }

    public Sound getFallDamageSoundBig() {
        return CraftSound.minecraftToBukkit(this.getHandle().eT().b());
    }

    public Sound getDrinkingSound(ItemStack itemStack) {
        return this.getEatingSound(itemStack);
    }

    public Sound getEatingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        dcv nms = CraftItemStack.asNMSCopy(itemStack);
        dfa consumable = nms.a(kq.w);
        ayy soundeffect = ayz.kP.a();
        if (consumable != null) {
            cam cam2 = this.getHandle();
            if (cam2 instanceof dfa.b) {
                dfa.b consumable_b = (dfa.b)((Object)cam2);
                soundeffect = consumable_b.j(nms);
            } else {
                soundeffect = consumable.e().a();
            }
        }
        return CraftSound.minecraftToBukkit(soundeffect);
    }

    public boolean canBreatheUnderwater() {
        return this.getHandle().ek();
    }

    public EntityCategory getCategory() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    public boolean isInvisible() {
        return this.getHandle().cs();
    }

    public void setInvisible(boolean invisible) {
        this.getHandle().persistentInvisibility = invisible;
        this.getHandle().b(5, invisible);
    }

    public Color getWaypointColor() {
        return this.getHandle().gf().e.map(Color::fromRGB).orElse(null);
    }

    public void setWaypointColor(Color color) {
        this.mutateIcon(icon -> {
            icon.e = Optional.ofNullable(color).map(Color::asRGB);
        });
    }

    public NamespacedKey getWaypointStyle() {
        return CraftNamespacedKey.fromMinecraft(this.getHandle().gf().d.a());
    }

    public void setWaypointStyle(NamespacedKey key) {
        this.mutateIcon(icon -> {
            icon.d = Optional.ofNullable(key).map(k2 -> amd.a(fkw.a, CraftNamespacedKey.toMinecraft(k2))).orElse(fkw.b);
        });
    }

    private void mutateIcon(Consumer<fkt.a> consumer) {
        cam handle = this.getHandle();
        aub worldserver = (aub)handle.ai();
        worldserver.h().c(handle);
        consumer.accept(handle.gf());
        worldserver.h().a(handle);
    }
}

