/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R5.registry.CraftOldEnumRegistryItem;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.Handleable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, cuf entity) {
        super(server, entity);
    }

    @Override
    public cuf getHandle() {
        return (cuf)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public void remove() {
        this.getHandle().hk();
        super.remove();
    }

    public Villager.Profession getProfession() {
        return CraftProfession.minecraftHolderToBukkit(this.getHandle().gR().b());
    }

    public void setProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Profession cannot be null");
        this.getHandle().a(this.getHandle().gR().b(CraftProfession.bukkitToMinecraftHolder(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().gR().a());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.getHandle().a(this.getHandle().gR().a(CraftType.bukkitToMinecraftHolder(type)));
    }

    public int getVillagerLevel() {
        return this.getHandle().gR().c();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (String)"level (%s) must be between [1, 5]", (int)level);
        this.getHandle().a(this.getHandle().gR().a(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().t();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (String)"Experience (%s) must be positive", (int)experience);
        this.getHandle().t(experience);
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        jb position = CraftLocation.toBlockPosition(location);
        eeb iblockdata = this.getHandle().ai().a_(position);
        if (!(iblockdata.b() instanceof dps)) {
            return false;
        }
        this.getHandle().b(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().fZ();
    }

    public void shakeHead() {
        this.getHandle().hd();
    }

    public ZombieVillager zombify() {
        csp entityzombievillager = cso.convertVillagerToZombieVillager(this.getHandle().ai().getMinecraftWorld(), this.getHandle(), this.getHandle().dx(), this.isSilent(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)entityzombievillager.getBukkitEntity() : null;
    }

    public int getReputation(UUID uuid, Villager.ReputationType reputationType) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        return this.getHandle().hc().getReputation(uuid, Predicate.isEqual(CraftReputationType.bukkitToMinecraft(reputationType)), false);
    }

    public int getWeightedReputation(UUID uuid, Villager.ReputationType reputationType) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        return this.getHandle().hc().getReputation(uuid, Predicate.isEqual(CraftReputationType.bukkitToMinecraft(reputationType)), true);
    }

    public int getReputation(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        return this.getHandle().hc().a(uuid, reputationType -> true);
    }

    public void addReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.addReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void addReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().hc().add(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void removeReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.removeReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void removeReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().hc().remove(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void setReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.setReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void setReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().hc().set(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void setGossipDecayTime(long ticks) {
        this.getHandle().gossipDecayInterval = ticks;
    }

    public long getGossipDecayTime() {
        return this.getHandle().gossipDecayInterval;
    }

    public static class CraftProfession
    extends CraftOldEnumRegistryItem<Villager.Profession, cui>
    implements Villager.Profession {
        private static int count = 0;

        public static Villager.Profession minecraftToBukkit(cui minecraft) {
            return (Villager.Profession)CraftRegistry.minecraftToBukkit(minecraft, mn.aH, Registry.VILLAGER_PROFESSION);
        }

        public static Villager.Profession minecraftHolderToBukkit(jl<cui> minecraft) {
            return CraftProfession.minecraftToBukkit(minecraft.a());
        }

        public static cui bukkitToMinecraft(Villager.Profession bukkit) {
            return (cui)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static jl<cui> bukkitToMinecraftHolder(Villager.Profession bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            jy registry = CraftRegistry.getMinecraftRegistry(mn.aH);
            jl<cui> jl2 = registry.e(CraftProfession.bukkitToMinecraft(bukkit));
            if (jl2 instanceof jl.c) {
                jl.c holder = (jl.c)jl2;
                return holder;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own villager profession without properly registering it.");
        }

        public CraftProfession(NamespacedKey key, jl<cui> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }

    public static class CraftType
    extends CraftOldEnumRegistryItem<Villager.Type, cuk>
    implements Villager.Type {
        private static int count = 0;

        public static Villager.Type minecraftToBukkit(cuk minecraft) {
            return (Villager.Type)CraftRegistry.minecraftToBukkit(minecraft, mn.aI, Registry.VILLAGER_TYPE);
        }

        public static Villager.Type minecraftHolderToBukkit(jl<cuk> minecraft) {
            return CraftType.minecraftToBukkit(minecraft.a());
        }

        public static cuk bukkitToMinecraft(Villager.Type bukkit) {
            return (cuk)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static jl<cuk> bukkitToMinecraftHolder(Villager.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            jy registry = CraftRegistry.getMinecraftRegistry(mn.aI);
            jl<cuk> jl2 = registry.e(CraftType.bukkitToMinecraft(bukkit));
            if (jl2 instanceof jl.c) {
                jl.c holder = (jl.c)jl2;
                return holder;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own villager type without properly registering it.");
        }

        public CraftType(NamespacedKey key, jl<cuk> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }

    public static class CraftReputationType
    implements Villager.ReputationType,
    Handleable<cjl> {
        public static final Map<String, CraftReputationType> BY_ID = Stream.of(cjl.values()).collect(Collectors.toMap(reputationType -> reputationType.i, CraftReputationType::new));
        private final cjl handle;

        public CraftReputationType(cjl handle) {
            this.handle = handle;
        }

        @Override
        public cjl getHandle() {
            return this.handle;
        }

        public int getMaxValue() {
            return this.handle.k;
        }

        public int getWeight() {
            return this.handle.j;
        }

        public static cjl bukkitToMinecraft(Villager.ReputationType bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return ((CraftReputationType)bukkit).getHandle();
        }

        public static Villager.ReputationType minecraftToBukkit(cjl minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            return switch (minecraft) {
                default -> throw new MatchException(null, null);
                case cjl.a -> Villager.ReputationType.MAJOR_NEGATIVE;
                case cjl.b -> Villager.ReputationType.MINOR_NEGATIVE;
                case cjl.c -> Villager.ReputationType.MINOR_POSITIVE;
                case cjl.d -> Villager.ReputationType.MAJOR_POSITIVE;
                case cjl.e -> Villager.ReputationType.TRADING;
            };
        }
    }

    public static class CraftReputationEvent
    implements Villager.ReputationEvent,
    Handleable<clm> {
        private static final Map<String, Villager.ReputationEvent> ALL = Maps.newHashMap();
        private final clm handle;

        public CraftReputationEvent(clm handle) {
            this.handle = handle;
            ALL.put(handle.toString(), this);
        }

        @Override
        public clm getHandle() {
            return this.handle;
        }

        public static clm bukkitToMinecraft(Villager.ReputationEvent bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return ((CraftReputationEvent)bukkit).getHandle();
        }

        public static Villager.ReputationEvent minecraftToBukkit(clm minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            Villager.ReputationEvent bukkit = ALL.get(minecraft.toString());
            return bukkit == null ? new CraftReputationEvent(minecraft) : bukkit;
        }
    }
}

