/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.v1_21_R5.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftEntityEquipment
implements EntityEquipment {
    private final CraftLivingEntity entity;

    public CraftEntityEquipment(CraftLivingEntity entity) {
        this.entity = entity;
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        this.setItem(slot, item, false);
    }

    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        bzw nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.setEquipment(nmsSlot, item, silent);
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        bzw nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getEquipment(nmsSlot);
    }

    public ItemStack getItemInMainHand() {
        return this.getEquipment(bzw.a);
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setEquipment(bzw.a, item, silent);
    }

    public ItemStack getItemInOffHand() {
        return this.getEquipment(bzw.b);
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setEquipment(bzw.b, item, silent);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.getEquipment(bzw.f);
    }

    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setEquipment(bzw.f, helmet, silent);
    }

    public ItemStack getChestplate() {
        return this.getEquipment(bzw.e);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setEquipment(bzw.e, chestplate, silent);
    }

    public ItemStack getLeggings() {
        return this.getEquipment(bzw.d);
    }

    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setEquipment(bzw.d, leggings, silent);
    }

    public ItemStack getBoots() {
        return this.getEquipment(bzw.c);
    }

    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.setEquipment(bzw.c, boots, silent);
    }

    public ItemStack[] getArmorContents() {
        ItemStack[] armor = new ItemStack[]{this.getEquipment(bzw.c), this.getEquipment(bzw.d), this.getEquipment(bzw.e), this.getEquipment(bzw.f)};
        return armor;
    }

    public void setArmorContents(ItemStack[] items) {
        this.setEquipment(bzw.c, items.length >= 1 ? items[0] : null, false);
        this.setEquipment(bzw.d, items.length >= 2 ? items[1] : null, false);
        this.setEquipment(bzw.e, items.length >= 3 ? items[2] : null, false);
        this.setEquipment(bzw.f, items.length >= 4 ? items[3] : null, false);
    }

    private ItemStack getEquipment(bzw slot) {
        return CraftItemStack.asBukkitCopy(this.entity.getHandle().a(slot));
    }

    private void setEquipment(bzw slot, ItemStack stack, boolean silent) {
        this.entity.getHandle().setItemSlot(slot, CraftItemStack.asNMSCopy(stack), silent);
    }

    public void clear() {
        for (bzw slot : bzw.values()) {
            this.setEquipment(slot, null, false);
        }
    }

    public Entity getHolder() {
        return this.entity;
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return this.getDropChance(bzw.a);
    }

    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(bzw.a, chance);
    }

    public float getItemInOffHandDropChance() {
        return this.getDropChance(bzw.b);
    }

    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(bzw.b, chance);
    }

    public float getHelmetDropChance() {
        return this.getDropChance(bzw.f);
    }

    public void setHelmetDropChance(float chance) {
        this.setDropChance(bzw.f, chance);
    }

    public float getChestplateDropChance() {
        return this.getDropChance(bzw.e);
    }

    public void setChestplateDropChance(float chance) {
        this.setDropChance(bzw.e, chance);
    }

    public float getLeggingsDropChance() {
        return this.getDropChance(bzw.d);
    }

    public void setLeggingsDropChance(float chance) {
        this.setDropChance(bzw.d, chance);
    }

    public float getBootsDropChance() {
        return this.getDropChance(bzw.c);
    }

    public void setBootsDropChance(float chance) {
        this.setDropChance(bzw.c, chance);
    }

    private void setDropChance(bzw slot, float chance) {
        Preconditions.checkArgument((boolean)(this.entity.getHandle() instanceof cao), (Object)"Cannot set drop chance for non-Mob entity");
        ((cao)this.entity.getHandle()).a(slot, chance);
    }

    private float getDropChance(bzw slot) {
        if (!(this.entity.getHandle() instanceof cao)) {
            return 1.0f;
        }
        return ((cao)this.entity.getHandle()).go().b(slot);
    }
}

