/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.inventory.recipe.CraftingBookCategory;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public Optional<dhi> toNMSOptional(RecipeChoice bukkit, boolean requireNotEmpty) {
        return bukkit == null ? Optional.empty() : Optional.of(this.toNMS(bukkit, requireNotEmpty));
    }

    default public dhi toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        dhi stack;
        if (bukkit == null) {
            stack = dhi.a(new dmt[0]);
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = dhi.a(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> CraftItemType.bukkitToMinecraft(mat)));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = dhi.ofStacks(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> CraftItemStack.asNMSCopy(mat)).toList());
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + String.valueOf(bukkit));
        }
        if (requireNotEmpty) {
            Preconditions.checkArgument((!stack.b() ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    default public dip toNMS(ItemStack stack) {
        dcv nms = CraftItemStack.asNMSCopy(stack);
        return new dip(nms.i(), nms.M(), nms.d());
    }

    public static RecipeChoice toBukkit(Optional<dhi> list) {
        return list.map(CraftRecipe::toBukkit).orElse(null);
    }

    public static RecipeChoice toBukkit(dhi list) {
        if (list.b()) {
            return null;
        }
        if (list.isExact()) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.itemStacks().size());
            for (dcv i3 : list.itemStacks()) {
                choices.add(CraftItemStack.asBukkitCopy(i3));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        List<Material> choices = list.a().map(i2 -> CraftItemType.minecraftToBukkit((dcr)i2.a())).toList();
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static ItemStack toBukkit(dip transmute) {
        dcv nms = new dcv(transmute.b(), transmute.c(), transmute.d());
        return CraftItemStack.asBukkitCopy(nms);
    }

    public static dgz getCategory(CraftingBookCategory bukkit) {
        return dgz.valueOf(bukkit.name());
    }

    public static CraftingBookCategory getCategory(dgz nms) {
        return CraftingBookCategory.valueOf((String)nms.name());
    }

    public static dgy getCategory(CookingBookCategory bukkit) {
        return dgy.valueOf(bukkit.name());
    }

    public static CookingBookCategory getCategory(dgy nms) {
        return CookingBookCategory.valueOf((String)nms.name());
    }

    public static amd<dhm<?>> toMinecraft(NamespacedKey key) {
        return amd.a(mn.bA, CraftNamespacedKey.toMinecraft(key));
    }
}

