/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory.view.builder;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R5.inventory.view.builder.CraftAbstractInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;

public class CraftMerchantInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractInventoryViewBuilder<V>
implements MerchantInventoryViewBuilder<V> {
    private dlp merchant;

    public CraftMerchantInventoryViewBuilder(czv<?> handle) {
        super(handle);
    }

    @Override
    public MerchantInventoryViewBuilder<V> title(String title) {
        return (MerchantInventoryViewBuilder)super.title(title);
    }

    public MerchantInventoryViewBuilder<V> merchant(Merchant merchant) {
        this.merchant = ((CraftMerchant)merchant).getMerchant();
        return this;
    }

    public MerchantInventoryViewBuilder<V> checkReachable(boolean checkReachable) {
        this.checkReachable = checkReachable;
        return this;
    }

    @Override
    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((this.title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof auc), (Object)"The given player must be an EntityPlayer");
        auc serverPlayer = (auc)craftHuman.getHandle();
        czx container = this.merchant == null ? new czx(serverPlayer.nextContainerCounter(), serverPlayer.gs(), new CraftMerchantCustom(this.title).getMerchant()) : new czx(serverPlayer.nextContainerCounter(), serverPlayer.gs(), this.merchant);
        container.checkReachable = this.checkReachable;
        container.setTitle(CraftChatMessage.fromString(this.title)[0]);
        return (V)container.getBukkitView();
    }

    @Override
    protected cym buildContainer(auc player) {
        throw new UnsupportedOperationException("buildContainer is not supported for CraftMerchantInventoryViewBuilder");
    }

    public MerchantInventoryViewBuilder<V> copy() {
        CraftMerchantInventoryViewBuilder<V> copy = new CraftMerchantInventoryViewBuilder<V>(this.handle);
        copy.checkReachable = this.checkReachable;
        copy.merchant = this.merchant;
        copy.title = this.title;
        return copy;
    }
}

