/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R5.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R5.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final fjs team;

    CraftTeam(CraftScoreboard scoreboard, fjs team) {
        super(scoreboard);
        this.team = team;
    }

    public String getName() {
        this.checkState();
        return this.team.c();
    }

    public String getDisplayName() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.d());
    }

    public void setDisplayName(String displayName) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        this.checkState();
        this.team.a(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getPrefix() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.f());
    }

    public void setPrefix(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix cannot be null");
        this.checkState();
        this.team.b(CraftChatMessage.fromStringOrNull(prefix));
    }

    public String getSuffix() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.g());
    }

    public void setSuffix(String suffix) {
        Preconditions.checkArgument((suffix != null ? 1 : 0) != 0, (Object)"Suffix cannot be null");
        this.checkState();
        this.team.c(CraftChatMessage.fromStringOrNull(suffix));
    }

    public ChatColor getColor() {
        this.checkState();
        return CraftChatMessage.getColor(this.team.o());
    }

    public void setColor(ChatColor color) {
        Preconditions.checkArgument((color != null && !color.isFormat() ? 1 : 0) != 0, (Object)"Color cannot be null or a format");
        this.checkState();
        this.team.a(CraftChatMessage.getColor(color));
    }

    public boolean allowFriendlyFire() {
        this.checkState();
        return this.team.i();
    }

    public void setAllowFriendlyFire(boolean enabled) {
        this.checkState();
        this.team.a(enabled);
    }

    public boolean canSeeFriendlyInvisibles() {
        this.checkState();
        return this.team.j();
    }

    public void setCanSeeFriendlyInvisibles(boolean enabled) {
        this.checkState();
        this.team.b(enabled);
    }

    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        this.checkState();
        return CraftTeam.notchToBukkit(this.team.k());
    }

    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        this.checkState();
        this.team.a(CraftTeam.bukkitToNotch(visibility));
    }

    public Set<OfflinePlayer> getPlayers() {
        this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.h()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName));
        }
        return players.build();
    }

    public Set<String> getEntries() {
        this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.h()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    public int getSize() {
        this.checkState();
        return this.team.h().size();
    }

    public void addPlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    public void addEntry(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.a(entry, this.team);
    }

    public boolean removePlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    public boolean removeEntry(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.h().contains(entry)) {
            return false;
        }
        scoreboard.board.b(entry, this.team);
        return true;
    }

    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        return this.team.h().contains(entry);
    }

    @Override
    public void unregister() {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.d(this.team);
    }

    public Team.OptionStatus getOption(Team.Option option) {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.k().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.l().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.m().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + String.valueOf(option));
    }

    public void setOption(Team.Option option, Team.OptionStatus status) {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.a(fjz.b.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.b(fjz.b.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.a(fjz.a.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + String.valueOf(option));
            }
        }
    }

    public static fjz.b bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return fjz.b.a;
            }
            case NEVER: {
                return fjz.b.b;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return fjz.b.c;
            }
            case HIDE_FOR_OWN_TEAM: {
                return fjz.b.d;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + String.valueOf(visibility));
    }

    public static NameTagVisibility notchToBukkit(fjz.b visibility) {
        switch (visibility) {
            case a: {
                return NameTagVisibility.ALWAYS;
            }
            case b: {
                return NameTagVisibility.NEVER;
            }
            case c: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case d: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + String.valueOf(visibility));
    }

    @Override
    CraftScoreboard checkState() {
        Preconditions.checkState((this.getScoreboard().board.b(this.team.c()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

