/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.AbstractIterator;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Immutable
public class BlockPosition
extends BaseBlockPosition {
    public static final Codec<BlockPosition> a = Codec.INT_STREAM.comapFlatMap(var02 -> SystemUtils.a(var02, 3).map(var0 -> new BlockPosition(var0[0], var0[1], var0[2])), var0 -> IntStream.of(var0.u(), var0.v(), var0.w())).stable();
    public static final StreamCodec<ByteBuf, BlockPosition> b = new StreamCodec<ByteBuf, BlockPosition>(){

        public BlockPosition a(ByteBuf var0) {
            return PacketDataSerializer.c(var0);
        }

        public void a(ByteBuf var0, BlockPosition var1) {
            PacketDataSerializer.a(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.a((ByteBuf)object, (BlockPosition)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.a((ByteBuf)object);
        }
    };
    private static final Logger j = LogUtils.getLogger();
    public static final BlockPosition c = new BlockPosition(0, 0, 0);
    public static final int d = 1 + MathHelper.g(MathHelper.c(30000000));
    public static final int e = 64 - 2 * d;
    private static final long k = (1L << d) - 1L;
    private static final long l = (1L << e) - 1L;
    private static final long m = (1L << d) - 1L;
    private static final int n = 0;
    private static final int o = e;
    private static final int p = e + d;
    public static final int f = (1 << d) / 2 - 1;

    public BlockPosition(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    public BlockPosition(BaseBlockPosition var0) {
        this(var0.u(), var0.v(), var0.w());
    }

    public static long a(long var0, EnumDirection var2) {
        return BlockPosition.a(var0, var2.j(), var2.k(), var2.l());
    }

    public static long a(long var0, int var2, int var3, int var4) {
        return BlockPosition.a(BlockPosition.a(var0) + var2, BlockPosition.b(var0) + var3, BlockPosition.c(var0) + var4);
    }

    public static int a(long var0) {
        return (int)(var0 << 64 - p - d >> 64 - d);
    }

    public static int b(long var0) {
        return (int)(var0 << 64 - e >> 64 - e);
    }

    public static int c(long var0) {
        return (int)(var0 << 64 - o - d >> 64 - d);
    }

    public static BlockPosition d(long var0) {
        return new BlockPosition(BlockPosition.a(var0), BlockPosition.b(var0), BlockPosition.c(var0));
    }

    public static BlockPosition a(double var0, double var2, double var4) {
        return new BlockPosition(MathHelper.a(var0), MathHelper.a(var2), MathHelper.a(var4));
    }

    public static BlockPosition a(IPosition var0) {
        return BlockPosition.a(var0.a(), var0.b(), var0.c());
    }

    public static BlockPosition a(BlockPosition var0, BlockPosition var1) {
        return new BlockPosition(Math.min(var0.u(), var1.u()), Math.min(var0.v(), var1.v()), Math.min(var0.w(), var1.w()));
    }

    public static BlockPosition b(BlockPosition var0, BlockPosition var1) {
        return new BlockPosition(Math.max(var0.u(), var1.u()), Math.max(var0.v(), var1.v()), Math.max(var0.w(), var1.w()));
    }

    public long a() {
        return BlockPosition.a(this.u(), this.v(), this.w());
    }

    public static long a(int var0, int var1, int var2) {
        long var3 = 0L;
        var3 |= ((long)var0 & k) << p;
        var3 |= ((long)var1 & l) << 0;
        return var3 |= ((long)var2 & m) << o;
    }

    public static long e(long var0) {
        return var0 & 0xFFFFFFFFFFFFFFF0L;
    }

    public BlockPosition b(int var0, int var1, int var2) {
        if (var0 == 0 && var1 == 0 && var2 == 0) {
            return this;
        }
        return new BlockPosition(this.u() + var0, this.v() + var1, this.w() + var2);
    }

    public Vec3D b() {
        return Vec3D.b(this);
    }

    public Vec3D c() {
        return Vec3D.c(this);
    }

    public BlockPosition a(BaseBlockPosition var0) {
        return this.b(var0.u(), var0.v(), var0.w());
    }

    public BlockPosition b(BaseBlockPosition var0) {
        return this.b(-var0.u(), -var0.v(), -var0.w());
    }

    public BlockPosition a(int var0) {
        if (var0 == 1) {
            return this;
        }
        if (var0 == 0) {
            return c;
        }
        return new BlockPosition(this.u() * var0, this.v() * var0, this.w() * var0);
    }

    public BlockPosition d() {
        return this.a(EnumDirection.b);
    }

    public BlockPosition b(int var0) {
        return this.a(EnumDirection.b, var0);
    }

    public BlockPosition e() {
        return this.a(EnumDirection.a);
    }

    public BlockPosition c(int var0) {
        return this.a(EnumDirection.a, var0);
    }

    public BlockPosition f() {
        return this.a(EnumDirection.c);
    }

    public BlockPosition d(int var0) {
        return this.a(EnumDirection.c, var0);
    }

    public BlockPosition g() {
        return this.a(EnumDirection.d);
    }

    public BlockPosition e(int var0) {
        return this.a(EnumDirection.d, var0);
    }

    public BlockPosition h() {
        return this.a(EnumDirection.e);
    }

    public BlockPosition f(int var0) {
        return this.a(EnumDirection.e, var0);
    }

    public BlockPosition i() {
        return this.a(EnumDirection.f);
    }

    public BlockPosition g(int var0) {
        return this.a(EnumDirection.f, var0);
    }

    public BlockPosition a(EnumDirection var0) {
        return new BlockPosition(this.u() + var0.j(), this.v() + var0.k(), this.w() + var0.l());
    }

    public BlockPosition a(EnumDirection var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        return new BlockPosition(this.u() + var0.j() * var1, this.v() + var0.k() * var1, this.w() + var0.l() * var1);
    }

    public BlockPosition a(EnumDirection.EnumAxis var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        int var2 = var0 == EnumDirection.EnumAxis.a ? var1 : 0;
        int var3 = var0 == EnumDirection.EnumAxis.b ? var1 : 0;
        int var4 = var0 == EnumDirection.EnumAxis.c ? var1 : 0;
        return new BlockPosition(this.u() + var2, this.v() + var3, this.w() + var4);
    }

    public BlockPosition a(EnumBlockRotation var0) {
        switch (var0) {
            default: {
                return this;
            }
            case b: {
                return new BlockPosition(-this.w(), this.v(), this.u());
            }
            case c: {
                return new BlockPosition(-this.u(), this.v(), -this.w());
            }
            case d: 
        }
        return new BlockPosition(this.w(), this.v(), -this.u());
    }

    public BlockPosition c(BaseBlockPosition var0) {
        return new BlockPosition(this.v() * var0.w() - this.w() * var0.v(), this.w() * var0.u() - this.u() * var0.w(), this.u() * var0.v() - this.v() * var0.u());
    }

    public BlockPosition h(int var0) {
        return new BlockPosition(this.u(), var0, this.w());
    }

    public BlockPosition j() {
        return this;
    }

    public MutableBlockPosition k() {
        return new MutableBlockPosition(this.u(), this.v(), this.w());
    }

    public Vec3D a(Vec3D var0) {
        return new Vec3D(MathHelper.a(var0.d, (double)((float)this.u() + 1.0E-5f), (double)this.u() + 1.0 - (double)1.0E-5f), MathHelper.a(var0.e, (double)((float)this.v() + 1.0E-5f), (double)this.v() + 1.0 - (double)1.0E-5f), MathHelper.a(var0.f, (double)((float)this.w() + 1.0E-5f), (double)this.w() + 1.0 - (double)1.0E-5f));
    }

    public static Iterable<BlockPosition> a(RandomSource var0, int var1, BlockPosition var2, int var3) {
        return BlockPosition.a(var0, var1, var2.u() - var3, var2.v() - var3, var2.w() - var3, var2.u() + var3, var2.v() + var3, var2.w() + var3);
    }

    @Deprecated
    public static Stream<BlockPosition> a(BlockPosition var0) {
        return Stream.of(var0, var0.g(), var0.i(), var0.g().i());
    }

    public static Iterable<BlockPosition> a(final RandomSource var0, final int var1, final int var2, final int var3, final int var4, int var5, int var6, int var7) {
        final int var8 = var5 - var2 + 1;
        final int var9 = var6 - var3 + 1;
        final int var10 = var7 - var4 + 1;
        return () -> new AbstractIterator<BlockPosition>(){
            final MutableBlockPosition a = new MutableBlockPosition();
            int b = var1;

            protected BlockPosition a() {
                if (this.b <= 0) {
                    return (BlockPosition)this.endOfData();
                }
                MutableBlockPosition var02 = this.a.d(var2 + var0.a(var8), var3 + var0.a(var9), var4 + var0.a(var10));
                --this.b;
                return var02;
            }

            protected /* synthetic */ Object computeNext() {
                return this.a();
            }
        };
    }

    public static Iterable<BlockPosition> a(BlockPosition var0, final int var1, final int var2, final int var3) {
        final int var4 = var1 + var2 + var3;
        final int var5 = var0.u();
        final int var6 = var0.v();
        final int var7 = var0.w();
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition h = new MutableBlockPosition();
            private int i;
            private int j;
            private int k;
            private int l;
            private int m;
            private boolean n;

            protected BlockPosition a() {
                if (this.n) {
                    this.n = false;
                    this.h.r(var7 - (this.h.w() - var7));
                    return this.h;
                }
                MutableBlockPosition var0 = null;
                while (var0 == null) {
                    if (this.m > this.k) {
                        ++this.l;
                        if (this.l > this.j) {
                            ++this.i;
                            if (this.i > var4) {
                                return (BlockPosition)this.endOfData();
                            }
                            this.j = Math.min(var1, this.i);
                            this.l = -this.j;
                        }
                        this.k = Math.min(var2, this.i - Math.abs(this.l));
                        this.m = -this.k;
                    }
                    int var12 = this.l;
                    int var22 = this.m;
                    int var32 = this.i - Math.abs(var12) - Math.abs(var22);
                    if (var32 <= var3) {
                        this.n = var32 != 0;
                        var0 = this.h.d(var5 + var12, var6 + var22, var7 + var32);
                    }
                    ++this.m;
                }
                return var0;
            }

            protected /* synthetic */ Object computeNext() {
                return this.a();
            }
        };
    }

    public static Optional<BlockPosition> a(BlockPosition var0, int var1, int var2, Predicate<BlockPosition> var3) {
        for (BlockPosition var5 : BlockPosition.a(var0, var1, var2, var1)) {
            if (!var3.test(var5)) continue;
            return Optional.of(var5);
        }
        return Optional.empty();
    }

    public static Stream<BlockPosition> b(BlockPosition var0, int var1, int var2, int var3) {
        return StreamSupport.stream(BlockPosition.a(var0, var1, var2, var3).spliterator(), false);
    }

    public static Iterable<BlockPosition> a(AxisAlignedBB var0) {
        BlockPosition var1 = BlockPosition.a(var0.a, var0.b, var0.c);
        BlockPosition var2 = BlockPosition.a(var0.d, var0.e, var0.f);
        return BlockPosition.c(var1, var2);
    }

    public static Iterable<BlockPosition> c(BlockPosition var0, BlockPosition var1) {
        return BlockPosition.b(Math.min(var0.u(), var1.u()), Math.min(var0.v(), var1.v()), Math.min(var0.w(), var1.w()), Math.max(var0.u(), var1.u()), Math.max(var0.v(), var1.v()), Math.max(var0.w(), var1.w()));
    }

    public static Stream<BlockPosition> d(BlockPosition var0, BlockPosition var1) {
        return StreamSupport.stream(BlockPosition.c(var0, var1).spliterator(), false);
    }

    public static Stream<BlockPosition> a(StructureBoundingBox var0) {
        return BlockPosition.a(Math.min(var0.h(), var0.k()), Math.min(var0.i(), var0.l()), Math.min(var0.j(), var0.m()), Math.max(var0.h(), var0.k()), Math.max(var0.i(), var0.l()), Math.max(var0.j(), var0.m()));
    }

    public static Stream<BlockPosition> b(AxisAlignedBB var0) {
        return BlockPosition.a(MathHelper.a(var0.a), MathHelper.a(var0.b), MathHelper.a(var0.c), MathHelper.a(var0.d), MathHelper.a(var0.e), MathHelper.a(var0.f));
    }

    public static Stream<BlockPosition> a(int var0, int var1, int var2, int var3, int var4, int var5) {
        return StreamSupport.stream(BlockPosition.b(var0, var1, var2, var3, var4, var5).spliterator(), false);
    }

    public static Iterable<BlockPosition> b(final int var0, final int var1, final int var2, int var3, int var4, int var5) {
        final int var6 = var3 - var0 + 1;
        final int var7 = var4 - var1 + 1;
        int var8 = var5 - var2 + 1;
        final int var9 = var6 * var7 * var8;
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition g = new MutableBlockPosition();
            private int h;

            protected BlockPosition a() {
                if (this.h == var9) {
                    return (BlockPosition)this.endOfData();
                }
                int var02 = this.h % var6;
                int var12 = this.h / var6;
                int var22 = var12 % var7;
                int var3 = var12 / var7;
                ++this.h;
                return this.g.d(var0 + var02, var1 + var22, var2 + var3);
            }

            protected /* synthetic */ Object computeNext() {
                return this.a();
            }
        };
    }

    public static Iterable<MutableBlockPosition> a(final BlockPosition var0, final int var1, final EnumDirection var2, final EnumDirection var3) {
        Validate.validState((var2.o() != var3.o() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<MutableBlockPosition>(){
            private final EnumDirection[] e;
            private final MutableBlockPosition f;
            private final int g;
            private int h;
            private int i;
            private int j;
            private int k;
            private int l;
            private int m;
            {
                this.e = new EnumDirection[]{var2, var3, var2.g(), var3.g()};
                this.f = var0.k().c(var3);
                this.g = 4 * var1;
                this.h = -1;
                this.k = this.f.u();
                this.l = this.f.v();
                this.m = this.f.w();
            }

            protected MutableBlockPosition a() {
                this.f.d(this.k, this.l, this.m).c(this.e[(this.h + 4) % 4]);
                this.k = this.f.u();
                this.l = this.f.v();
                this.m = this.f.w();
                if (this.j >= this.i) {
                    if (this.h >= this.g) {
                        return (MutableBlockPosition)this.endOfData();
                    }
                    ++this.h;
                    this.j = 0;
                    this.i = this.h / 2 + 1;
                }
                ++this.j;
                return this.f;
            }

            protected /* synthetic */ Object computeNext() {
                return this.a();
            }
        };
    }

    public static int a(BlockPosition var0, int var1, int var22, BiConsumer<BlockPosition, Consumer<BlockPosition>> var3, Function<BlockPosition, b> var4) {
        ArrayDeque<Pair> var5 = new ArrayDeque<Pair>();
        LongOpenHashSet var6 = new LongOpenHashSet();
        var5.add(Pair.of((Object)var0, (Object)0));
        int var7 = 0;
        while (!var5.isEmpty()) {
            b var13;
            Pair var8 = (Pair)var5.poll();
            BlockPosition var9 = (BlockPosition)var8.getLeft();
            int var10 = (Integer)var8.getRight();
            long var11 = var9.a();
            if (!var6.add(var11) || (var13 = var4.apply(var9)) == net.minecraft.core.BlockPosition$b.b) continue;
            if (var13 == net.minecraft.core.BlockPosition$b.c) break;
            if (++var7 >= var22) {
                return var7;
            }
            if (var10 >= var1) continue;
            var3.accept(var9, var2 -> var5.add(Pair.of((Object)var2, (Object)(var10 + 1))));
        }
        return var7;
    }

    @Override
    public /* synthetic */ BaseBlockPosition d(BaseBlockPosition baseBlockPosition) {
        return this.c(baseBlockPosition);
    }

    @Override
    public /* synthetic */ BaseBlockPosition b(EnumDirection.EnumAxis enumAxis, int n2) {
        return this.a(enumAxis, n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition b(EnumDirection enumDirection, int n2) {
        return this.a(enumDirection, n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition b(EnumDirection enumDirection) {
        return this.a(enumDirection);
    }

    @Override
    public /* synthetic */ BaseBlockPosition i(int n2) {
        return this.g(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition l() {
        return this.i();
    }

    @Override
    public /* synthetic */ BaseBlockPosition j(int n2) {
        return this.f(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition m() {
        return this.h();
    }

    @Override
    public /* synthetic */ BaseBlockPosition k(int n2) {
        return this.e(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition n() {
        return this.g();
    }

    @Override
    public /* synthetic */ BaseBlockPosition l(int n2) {
        return this.d(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition o() {
        return this.f();
    }

    @Override
    public /* synthetic */ BaseBlockPosition m(int n2) {
        return this.c(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition p() {
        return this.e();
    }

    @Override
    public /* synthetic */ BaseBlockPosition n(int n2) {
        return this.b(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition q() {
        return this.d();
    }

    @Override
    public /* synthetic */ BaseBlockPosition o(int n2) {
        return this.a(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition e(BaseBlockPosition baseBlockPosition) {
        return this.b(baseBlockPosition);
    }

    @Override
    public /* synthetic */ BaseBlockPosition f(BaseBlockPosition baseBlockPosition) {
        return this.a(baseBlockPosition);
    }

    @Override
    public /* synthetic */ BaseBlockPosition c(int n2, int n3, int n4) {
        return this.b(n2, n3, n4);
    }

    public static class MutableBlockPosition
    extends BlockPosition {
        public MutableBlockPosition() {
            this(0, 0, 0);
        }

        public MutableBlockPosition(int var0, int var1, int var2) {
            super(var0, var1, var2);
        }

        public MutableBlockPosition(double var0, double var2, double var4) {
            this(MathHelper.a(var0), MathHelper.a(var2), MathHelper.a(var4));
        }

        @Override
        public BlockPosition b(int var0, int var1, int var2) {
            return super.b(var0, var1, var2).j();
        }

        @Override
        public BlockPosition a(int var0) {
            return super.a(var0).j();
        }

        @Override
        public BlockPosition a(EnumDirection var0, int var1) {
            return super.a(var0, var1).j();
        }

        @Override
        public BlockPosition a(EnumDirection.EnumAxis var0, int var1) {
            return super.a(var0, var1).j();
        }

        @Override
        public BlockPosition a(EnumBlockRotation var0) {
            return super.a(var0).j();
        }

        public MutableBlockPosition d(int var0, int var1, int var2) {
            this.p(var0);
            this.q(var1);
            this.r(var2);
            return this;
        }

        public MutableBlockPosition b(double var0, double var2, double var4) {
            return this.d(MathHelper.a(var0), MathHelper.a(var2), MathHelper.a(var4));
        }

        public MutableBlockPosition g(BaseBlockPosition var0) {
            return this.d(var0.u(), var0.v(), var0.w());
        }

        public MutableBlockPosition f(long var0) {
            return this.d(MutableBlockPosition.a(var0), MutableBlockPosition.b(var0), MutableBlockPosition.c(var0));
        }

        public MutableBlockPosition a(EnumAxisCycle var0, int var1, int var2, int var3) {
            return this.d(var0.a(var1, var2, var3, EnumDirection.EnumAxis.a), var0.a(var1, var2, var3, EnumDirection.EnumAxis.b), var0.a(var1, var2, var3, EnumDirection.EnumAxis.c));
        }

        public MutableBlockPosition a(BaseBlockPosition var0, EnumDirection var1) {
            return this.d(var0.u() + var1.j(), var0.v() + var1.k(), var0.w() + var1.l());
        }

        public MutableBlockPosition a(BaseBlockPosition var0, int var1, int var2, int var3) {
            return this.d(var0.u() + var1, var0.v() + var2, var0.w() + var3);
        }

        public MutableBlockPosition a(BaseBlockPosition var0, BaseBlockPosition var1) {
            return this.d(var0.u() + var1.u(), var0.v() + var1.v(), var0.w() + var1.w());
        }

        public MutableBlockPosition c(EnumDirection var0) {
            return this.c(var0, 1);
        }

        public MutableBlockPosition c(EnumDirection var0, int var1) {
            return this.d(this.u() + var0.j() * var1, this.v() + var0.k() * var1, this.w() + var0.l() * var1);
        }

        public MutableBlockPosition e(int var0, int var1, int var2) {
            return this.d(this.u() + var0, this.v() + var1, this.w() + var2);
        }

        public MutableBlockPosition h(BaseBlockPosition var0) {
            return this.d(this.u() + var0.u(), this.v() + var0.v(), this.w() + var0.w());
        }

        public MutableBlockPosition a(EnumDirection.EnumAxis var0, int var1, int var2) {
            switch (var0) {
                case a: {
                    return this.d(MathHelper.a(this.u(), var1, var2), this.v(), this.w());
                }
                case b: {
                    return this.d(this.u(), MathHelper.a(this.v(), var1, var2), this.w());
                }
                case c: {
                    return this.d(this.u(), this.v(), MathHelper.a(this.w(), var1, var2));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + String.valueOf(var0));
        }

        public MutableBlockPosition p(int var0) {
            super.u(var0);
            return this;
        }

        public MutableBlockPosition q(int var0) {
            super.t(var0);
            return this;
        }

        public MutableBlockPosition r(int var0) {
            super.s(var0);
            return this;
        }

        @Override
        public BlockPosition j() {
            return new BlockPosition(this);
        }

        @Override
        public /* synthetic */ BaseBlockPosition d(BaseBlockPosition baseBlockPosition) {
            return super.c(baseBlockPosition);
        }

        @Override
        public /* synthetic */ BaseBlockPosition b(EnumDirection.EnumAxis enumAxis, int n2) {
            return this.a(enumAxis, n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition b(EnumDirection enumDirection, int n2) {
            return this.a(enumDirection, n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition b(EnumDirection enumDirection) {
            return super.a(enumDirection);
        }

        @Override
        public /* synthetic */ BaseBlockPosition i(int n2) {
            return super.g(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition l() {
            return super.i();
        }

        @Override
        public /* synthetic */ BaseBlockPosition j(int n2) {
            return super.f(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition m() {
            return super.h();
        }

        @Override
        public /* synthetic */ BaseBlockPosition k(int n2) {
            return super.e(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition n() {
            return super.g();
        }

        @Override
        public /* synthetic */ BaseBlockPosition l(int n2) {
            return super.d(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition o() {
            return super.f();
        }

        @Override
        public /* synthetic */ BaseBlockPosition m(int n2) {
            return super.c(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition p() {
            return super.e();
        }

        @Override
        public /* synthetic */ BaseBlockPosition n(int n2) {
            return super.b(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition q() {
            return super.d();
        }

        @Override
        public /* synthetic */ BaseBlockPosition o(int n2) {
            return this.a(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition e(BaseBlockPosition baseBlockPosition) {
            return super.b(baseBlockPosition);
        }

        @Override
        public /* synthetic */ BaseBlockPosition f(BaseBlockPosition baseBlockPosition) {
            return super.a(baseBlockPosition);
        }

        @Override
        public /* synthetic */ BaseBlockPosition c(int n2, int n3, int n4) {
            return this.b(n2, n3, n4);
        }

        @Override
        public /* synthetic */ BaseBlockPosition s(int n2) {
            return this.r(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition t(int n2) {
            return this.q(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition u(int n2) {
            return this.p(n2);
        }
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b();
        public static final /* enum */ b b = new b();
        public static final /* enum */ b c = new b();
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b, c};
        }

        static {
            d = net.minecraft.core.BlockPosition$b.a();
        }
    }
}

