/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class NBTTagLongArray
implements NBTList {
    private static final int b = 24;
    public static final NBTTagType<NBTTagLongArray> a = new NBTTagType.b<NBTTagLongArray>(){

        public NBTTagLongArray a(DataInput var0, NBTReadLimiter var1) throws IOException {
            return new NBTTagLongArray(1.d(var0, var1));
        }

        @Override
        public StreamTagVisitor.b a(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.a(1.d(var0, var2));
        }

        private static long[] d(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.b(24L);
            int var2 = var0.readInt();
            var1.a(8L, var2);
            long[] var3 = new long[var2];
            for (int var4 = 0; var4 < var2; ++var4) {
                var3[var4] = var0.readLong();
            }
            return var3;
        }

        @Override
        public void b(DataInput var0, NBTReadLimiter var1) throws IOException {
            var0.skipBytes(var0.readInt() * 8);
        }

        @Override
        public String a() {
            return "LONG[]";
        }

        @Override
        public String b() {
            return "TAG_Long_Array";
        }

        @Override
        public /* synthetic */ NBTBase c(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.a(dataInput, nBTReadLimiter);
        }
    };
    private long[] c;

    public NBTTagLongArray(long[] var0) {
        this.c = var0;
    }

    @Override
    public void a(DataOutput var0) throws IOException {
        var0.writeInt(this.c.length);
        for (long var4 : this.c) {
            var0.writeLong(var4);
        }
    }

    @Override
    public int a() {
        return 24 + 8 * this.c.length;
    }

    @Override
    public byte b() {
        return 12;
    }

    public NBTTagType<NBTTagLongArray> c() {
        return a;
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.a(this);
        return var0.a();
    }

    public NBTTagLongArray e() {
        long[] var0 = new long[this.c.length];
        System.arraycopy(this.c, 0, var0, 0, this.c.length);
        return new NBTTagLongArray(var0);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagLongArray && Arrays.equals(this.c, ((NBTTagLongArray)var0).c);
    }

    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    public void a(TagVisitor var0) {
        var0.a(this);
    }

    public long[] g() {
        return this.c;
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagLong a(int var0) {
        return NBTTagLong.a(this.c[var0]);
    }

    @Override
    public boolean a(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)var1;
            this.c[var0] = var2.g();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)var1;
            this.c = ArrayUtils.add((long[])this.c, (int)var0, (long)var2.g());
            return true;
        }
        return false;
    }

    public NBTTagLong b(int var0) {
        long var1 = this.c[var0];
        this.c = ArrayUtils.remove((long[])this.c, (int)var0);
        return NBTTagLong.a(var1);
    }

    @Override
    public void clear() {
        this.c = new long[0];
    }

    @Override
    public Optional<long[]> r_() {
        return Optional.of(this.c);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor var0) {
        return var0.a(this.c);
    }

    @Override
    public /* synthetic */ NBTBase c(int n2) {
        return this.a(n2);
    }

    @Override
    public /* synthetic */ NBTBase d(int n2) {
        return this.b(n2);
    }

    @Override
    public /* synthetic */ NBTBase d() {
        return this.e();
    }
}

