/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.util.Either;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.FormattedString;
import net.minecraft.world.level.ChunkCoordIntPair;

public interface IChatBaseComponent
extends Message,
IChatFormatted,
Iterable<IChatBaseComponent> {
    default public Stream<IChatBaseComponent> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.c().stream().flatMap(IChatBaseComponent::stream)});
    }

    @Override
    default public Iterator<IChatBaseComponent> iterator() {
        return this.stream().iterator();
    }

    public ChatModifier a();

    public ComponentContents b();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String a(int i2) {
        StringBuilder stringbuilder = new StringBuilder();
        this.a((String s2) -> {
            int j2 = i2 - stringbuilder.length();
            if (j2 <= 0) {
                return a;
            }
            stringbuilder.append(s2.length() <= j2 ? s2 : s2.substring(0, j2));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<IChatBaseComponent> c();

    @Nullable
    default public String d() {
        ComponentContents componentcontents = this.b();
        if (componentcontents instanceof LiteralContents) {
            LiteralContents literalcontents = (LiteralContents)componentcontents;
            if (this.c().isEmpty() && this.a().h()) {
                return literalcontents.b();
            }
        }
        return null;
    }

    default public IChatMutableComponent e() {
        return IChatMutableComponent.a(this.b());
    }

    default public IChatMutableComponent f() {
        return new IChatMutableComponent(this.b(), new ArrayList<IChatBaseComponent>(this.c()), this.a());
    }

    public FormattedString g();

    @Override
    default public <T> Optional<T> a(IChatFormatted.b<T> ichatformatted_b, ChatModifier chatmodifier) {
        ChatModifier chatmodifier1 = this.a().a(chatmodifier);
        Optional<T> optional = this.b().a(ichatformatted_b, chatmodifier1);
        if (optional.isPresent()) {
            return optional;
        }
        for (IChatBaseComponent ichatbasecomponent : this.c()) {
            Optional<T> optional1 = ichatbasecomponent.a(ichatformatted_b, chatmodifier1);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> a(IChatFormatted.a<T> ichatformatted_a) {
        Optional<T> optional = this.b().a(ichatformatted_a);
        if (optional.isPresent()) {
            return optional;
        }
        for (IChatBaseComponent ichatbasecomponent : this.c()) {
            Optional<T> optional1 = ichatbasecomponent.a(ichatformatted_a);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public List<IChatBaseComponent> h() {
        return this.a(ChatModifier.a);
    }

    default public List<IChatBaseComponent> a(ChatModifier chatmodifier) {
        ArrayList list = Lists.newArrayList();
        this.a((chatmodifier1, s2) -> {
            if (!s2.isEmpty()) {
                list.add(IChatBaseComponent.b(s2).c(chatmodifier1));
            }
            return Optional.empty();
        }, chatmodifier);
        return list;
    }

    default public boolean a(IChatBaseComponent ichatbasecomponent) {
        List<IChatBaseComponent> list1;
        if (this.equals(ichatbasecomponent)) {
            return true;
        }
        List<IChatBaseComponent> list = this.h();
        return Collections.indexOfSubList(list, list1 = ichatbasecomponent.a(this.a())) != -1;
    }

    public static IChatBaseComponent a(@Nullable String s2) {
        return s2 != null ? IChatBaseComponent.b(s2) : CommonComponents.a;
    }

    public static IChatMutableComponent b(String s2) {
        return IChatMutableComponent.a(LiteralContents.a(s2));
    }

    public static IChatMutableComponent c(String s2) {
        return IChatMutableComponent.a(new TranslatableContents(s2, null, TranslatableContents.a));
    }

    public static IChatMutableComponent a(String s2, Object ... aobject) {
        return IChatMutableComponent.a(new TranslatableContents(s2, null, aobject));
    }

    public static IChatMutableComponent b(String s2, Object ... aobject) {
        for (int i2 = 0; i2 < aobject.length; ++i2) {
            Object object = aobject[i2];
            if (TranslatableContents.a(object) || object instanceof IChatBaseComponent) continue;
            aobject[i2] = String.valueOf(object);
        }
        return IChatBaseComponent.a(s2, aobject);
    }

    public static IChatMutableComponent a(String s2, @Nullable String s1) {
        return IChatMutableComponent.a(new TranslatableContents(s2, s1, TranslatableContents.a));
    }

    public static IChatMutableComponent a(String s2, @Nullable String s1, Object ... aobject) {
        return IChatMutableComponent.a(new TranslatableContents(s2, s1, aobject));
    }

    public static IChatMutableComponent i() {
        return IChatMutableComponent.a(LiteralContents.c);
    }

    public static IChatMutableComponent d(String s2) {
        return IChatMutableComponent.a(new KeybindContents(s2));
    }

    public static IChatMutableComponent a(String s2, boolean flag, Optional<IChatBaseComponent> optional, DataSource datasource) {
        return IChatMutableComponent.a(new NbtContents(s2, flag, optional, datasource));
    }

    public static IChatMutableComponent a(SelectorPattern selectorpattern, String s2) {
        return IChatMutableComponent.a(new ScoreContents((Either<SelectorPattern, String>)Either.left((Object)selectorpattern), s2));
    }

    public static IChatMutableComponent b(String s2, String s1) {
        return IChatMutableComponent.a(new ScoreContents((Either<SelectorPattern, String>)Either.right((Object)s2), s1));
    }

    public static IChatMutableComponent a(SelectorPattern selectorpattern, Optional<IChatBaseComponent> optional) {
        return IChatMutableComponent.a(new SelectorContents(selectorpattern, optional));
    }

    public static IChatBaseComponent a(Date date) {
        return IChatBaseComponent.b(date.toString());
    }

    public static IChatBaseComponent a(Message message) {
        IChatBaseComponent object;
        if (message instanceof IChatBaseComponent) {
            IChatBaseComponent ichatbasecomponent = (IChatBaseComponent)message;
            object = ichatbasecomponent;
        } else {
            object = IChatBaseComponent.b(message.getString());
        }
        return object;
    }

    public static IChatBaseComponent a(UUID uuid) {
        return IChatBaseComponent.b(uuid.toString());
    }

    public static IChatBaseComponent a(MinecraftKey minecraftkey) {
        return IChatBaseComponent.b(minecraftkey.toString());
    }

    public static IChatBaseComponent a(ChunkCoordIntPair chunkcoordintpair) {
        return IChatBaseComponent.b(chunkcoordintpair.toString());
    }

    public static IChatBaseComponent a(URI uri) {
        return IChatBaseComponent.b(uri.toString());
    }
}

