/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.LookAt;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandTeleport {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.teleport.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalcommandnode = commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("teleport").requires(net.minecraft.commands.CommandDispatcher.a(2))).then(net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, null)))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.a("rotation", ArgumentRotation.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), ArgumentRotation.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("facing").then(net.minecraft.commands.CommandDispatcher.b("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facingEntity", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new LookAt.a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("facingAnchor", ArgumentAnchor.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new LookAt.a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.a("facingLocation", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new LookAt.b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination")))))));
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("tp").requires(net.minecraft.commands.CommandDispatcher.a(2))).redirect(literalcommandnode)));
    }

    private static int a(CommandListenerWrapper commandlistenerwrapper, Collection<? extends net.minecraft.world.entity.Entity> collection, net.minecraft.world.entity.Entity entity) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity2 : collection) {
            CommandTeleport.a(commandlistenerwrapper, entity2, (WorldServer)entity.ai(), entity.dC(), entity.dE(), entity.dI(), EnumSet.noneOf(Relative.class), entity.dP(), entity.dR(), null);
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)collection.iterator().next()).Q_(), entity.Q_()), true);
        } else {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.multiple", collection.size(), entity.Q_()), true);
        }
        return collection.size();
    }

    private static int a(CommandListenerWrapper commandlistenerwrapper, Collection<? extends net.minecraft.world.entity.Entity> collection, WorldServer worldserver, IVectorPosition ivectorposition, @Nullable IVectorPosition ivectorposition1, @Nullable LookAt lookat) throws CommandSyntaxException {
        Vec3D vec3d = ivectorposition.a(commandlistenerwrapper);
        Vec2F vec2f = ivectorposition1 == null ? null : ivectorposition1.b(commandlistenerwrapper);
        for (net.minecraft.world.entity.Entity entity : collection) {
            Set<Relative> set = CommandTeleport.a(ivectorposition, ivectorposition1, entity.ai().aj() == worldserver.aj());
            if (vec2f == null) {
                CommandTeleport.a(commandlistenerwrapper, entity, worldserver, vec3d.d, vec3d.e, vec3d.f, set, entity.dP(), entity.dR(), lookat);
                continue;
            }
            CommandTeleport.a(commandlistenerwrapper, entity, worldserver, vec3d.d, vec3d.e, vec3d.f, set, vec2f.k, vec2f.j, lookat);
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)collection.iterator().next()).Q_(), CommandTeleport.a(vec3d.d), CommandTeleport.a(vec3d.e), CommandTeleport.a(vec3d.f)), true);
        } else {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.teleport.success.location.multiple", collection.size(), CommandTeleport.a(vec3d.d), CommandTeleport.a(vec3d.e), CommandTeleport.a(vec3d.f)), true);
        }
        return collection.size();
    }

    private static Set<Relative> a(IVectorPosition ivectorposition, @Nullable IVectorPosition ivectorposition1, boolean flag) {
        EnumSet<Relative> set = EnumSet.noneOf(Relative.class);
        if (ivectorposition.a()) {
            set.add(Relative.f);
            if (flag) {
                set.add(Relative.a);
            }
        }
        if (ivectorposition.b()) {
            set.add(Relative.g);
            if (flag) {
                set.add(Relative.b);
            }
        }
        if (ivectorposition.c()) {
            set.add(Relative.h);
            if (flag) {
                set.add(Relative.c);
            }
        }
        if (ivectorposition1 == null || ivectorposition1.a()) {
            set.add(Relative.e);
        }
        if (ivectorposition1 == null || ivectorposition1.b()) {
            set.add(Relative.d);
        }
        return set;
    }

    private static String a(double d0) {
        return String.format(Locale.ROOT, "%f", d0);
    }

    private static void a(CommandListenerWrapper commandlistenerwrapper, net.minecraft.world.entity.Entity entity, WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, @Nullable LookAt lookat) throws CommandSyntaxException {
        boolean result;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        if (!World.l(blockposition)) {
            throw a.create();
        }
        double d3 = set.contains((Object)Relative.a) ? d0 - entity.dC() : d0;
        double d4 = set.contains((Object)Relative.b) ? d1 - entity.dE() : d1;
        double d5 = set.contains((Object)Relative.c) ? d2 - entity.dI() : d2;
        float f22 = set.contains((Object)Relative.d) ? f2 - entity.dP() : f2;
        float f3 = set.contains((Object)Relative.e) ? f1 - entity.dR() : f1;
        float f4 = MathHelper.h(f22);
        float f5 = MathHelper.h(f3);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            result = player.teleportTo(worldserver, d3, d4, d5, set, f4, f5, true, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((org.bukkit.World)worldserver.getWorld(), d3, d4, d5, f4, f5);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)entity.getBukkitEntity(), entity.getBukkitEntity().getLocation(), to);
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            d3 = to.getX();
            d4 = to.getY();
            d5 = to.getZ();
            f4 = to.getYaw();
            f5 = to.getPitch();
            worldserver = ((CraftWorld)to.getWorld()).getHandle();
            result = entity.a(worldserver, d3, d4, d5, set, f4, f5, true);
        }
        if (result) {
            EntityLiving entityliving;
            if (lookat != null) {
                lookat.perform(commandlistenerwrapper, entity);
            }
            if (!(entity instanceof EntityLiving) || !(entityliving = (EntityLiving)entity).fQ()) {
                entity.i(entity.dA().d(1.0, 0.0, 1.0));
                entity.e(true);
            }
            if (entity instanceof EntityCreature) {
                EntityCreature entitycreature = (EntityCreature)entity;
                entitycreature.S().n();
            }
        }
    }
}

