/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.FileUtils;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FileZipper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import org.slf4j.Logger;

public class PerfCommand {
    private static final Logger a = LogUtils.getLogger();
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.perf.notRunning"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.perf.alreadyRunning"));

    public static void a(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("perf").requires(net.minecraft.commands.CommandDispatcher.a(4))).then(net.minecraft.commands.CommandDispatcher.b("start").executes(var0 -> PerfCommand.a((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("stop").executes(var0 -> PerfCommand.b((CommandListenerWrapper)var0.getSource())))));
    }

    private static int a(CommandListenerWrapper var0) throws CommandSyntaxException {
        MinecraftServer var12 = var0.l();
        if (var12.aT()) {
            throw c.create();
        }
        Consumer<MethodProfilerResults> var22 = var1 -> PerfCommand.a(var0, var1);
        Consumer<Path> var3 = var2 -> PerfCommand.a(var0, var2, var12);
        var12.a(var22, var3);
        var0.a(() -> IChatBaseComponent.c("commands.perf.started"), false);
        return 0;
    }

    private static int b(CommandListenerWrapper var0) throws CommandSyntaxException {
        MinecraftServer var1 = var0.l();
        if (!var1.aT()) {
            throw b.create();
        }
        var1.aV();
        return 0;
    }

    private static void a(CommandListenerWrapper var0, Path var1, MinecraftServer var2) {
        String var4;
        String var3 = String.format(Locale.ROOT, "%s-%s-%s", SystemUtils.f(), var2.aZ().e(), SharedConstants.b().b());
        try {
            var4 = FileUtils.a(MetricsPersister.a, var3, ".zip");
        }
        catch (IOException var5) {
            var0.b(IChatBaseComponent.c("commands.perf.reportFailed"));
            a.error("Failed to create report name", (Throwable)var5);
            return;
        }
        try (FileZipper var5 = new FileZipper(MetricsPersister.a.resolve(var4));){
            var5.a(Paths.get("system.txt", new String[0]), var2.b(new SystemReport()).a());
            var5.a(var1);
        }
        try {
            org.apache.commons.io.FileUtils.forceDelete((File)var1.toFile());
        }
        catch (IOException var6) {
            a.warn("Failed to delete temporary profiling file {}", (Object)var1, (Object)var6);
        }
        var0.a(() -> IChatBaseComponent.a("commands.perf.reportSaved", new Object[]{var4}), false);
    }

    private static void a(CommandListenerWrapper var0, MethodProfilerResults var1) {
        if (var1 == MethodProfilerResultsEmpty.a) {
            return;
        }
        int var2 = var1.f();
        double var3 = (double)var1.g() / (double)TimeRange.a;
        var0.a(() -> IChatBaseComponent.a("commands.perf.stopped", new Object[]{String.format(Locale.ROOT, "%.2f", var3), var2, String.format(Locale.ROOT, "%.2f", (double)var2 / var3)}), false);
    }
}

