/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.HashOps;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman {
    private static final Logger cM = LogUtils.getLogger();
    private static final int cN = 32;
    private static final int cO = 10;
    private static final int cP = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    public static final String f = "Dimension";
    private static final AttributeModifier cQ = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cR = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    private static final IChatBaseComponent cS = IChatBaseComponent.c("block.minecraft.set_spawn");
    private static final AttributeModifier cT = new AttributeModifier(MinecraftKey.b("waypoint_transmit_range_crouch"), -1.0, AttributeModifier.Operation.c);
    private static final boolean cU = false;
    private static final boolean cV = false;
    public PlayerConnection g;
    public final MinecraftServer cW;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cX;
    private final ServerStatisticManager cY;
    private float cZ = Float.MIN_VALUE;
    private int da = Integer.MIN_VALUE;
    private int db = Integer.MIN_VALUE;
    private int dc = Integer.MIN_VALUE;
    private int dd = Integer.MIN_VALUE;
    private int de = Integer.MIN_VALUE;
    private float df = -1.0E8f;
    private int dg = -99999999;
    private boolean dh = true;
    public int di = -99999999;
    private EnumChatVisibility dj = EnumChatVisibility.a;
    private ParticleStatus dk = ParticleStatus.a;
    private boolean dl = true;
    private long dm = SystemUtils.c();
    @Nullable
    private Entity dn;
    public boolean do;
    public boolean i = false;
    private final RecipeBookServer dp;
    @Nullable
    private Vec3D dq;
    private int dr;
    private boolean ds;
    private int dt = 2;
    public String du = "en_us";
    @Nullable
    private Vec3D dv;
    @Nullable
    private Vec3D dw;
    @Nullable
    private Vec3D dx;
    private SectionPosition dy = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView dz = ChunkTrackingView.a;
    @Nullable
    private RespawnConfig dA;
    private final ITextFilter dB;
    private boolean dC;
    private boolean dD;
    private boolean dE = false;
    private WardenSpawnTracker dF = new WardenSpawnTracker();
    @Nullable
    private BlockPosition dG;
    private Vec3D dH = Vec3D.c;
    private Input dI = Input.b;
    private final Set<EntityEnderPearl> dJ = new HashSet<EntityEnderPearl>();
    private final ContainerSynchronizer dK = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> b = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> b;
            {
                this.b = EntityPlayer.this.eb().a(HashOps.c);
            }

            public Integer a(TypedDataComponent<?> typeddatacomponent) {
                return ((HashCode)typeddatacomponent.a(this.b).getOrThrow(s2 -> {
                    String s1 = String.valueOf(typeddatacomponent);
                    return new IllegalArgumentException("Failed to hash " + s1 + ": " + s2);
                })).asInt();
            }
        });

        @Override
        public void a(Container container, List<ItemStack> list, ItemStack itemstack, int[] aint) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowItems(container.l, container.k(), list, itemstack));
            for (int i2 = 0; i2 < aint.length; ++i2) {
                this.b(container, i2, aint[i2]);
            }
        }

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            EntityPlayer.this.g.b(new PacketPlayOutSetSlot(container.l, container.k(), i2, itemstack));
        }

        @Override
        public void a(Container container, ItemStack itemstack) {
            EntityPlayer.this.g.b(new ClientboundSetCursorItemPacket(itemstack));
        }

        @Override
        public void a(Container container, int i2, int j2) {
            this.b(container, i2, j2);
        }

        private void b(Container container, int i2, int j2) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowData(container.l, i2, j2));
        }

        @Override
        public RemoteSlot a() {
            LoadingCache<TypedDataComponent<?>, Integer> loadingcache = this.b;
            Objects.requireNonNull(this.b);
            return new RemoteSlot.a(arg_0 -> loadingcache.getUnchecked(arg_0));
        }
    };
    private final ICrafting dL = new ICrafting(){

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            Slot slot = container.b(i2);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gs()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gs(), itemstack);
            }
        }

        @Override
        public void a(Container container, int i2, int j2) {
        }
    };
    @Nullable
    private RemoteChatSession dM;
    @Nullable
    public final Object j;
    private final ICommandListener dN = new ICommandListener(){

        @Override
        public boolean x_() {
            return EntityPlayer.this.y().P().c(GameRules.q);
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }

        @Override
        public void a(IChatBaseComponent ichatbasecomponent) {
            EntityPlayer.this.a(ichatbasecomponent);
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return EntityPlayer.this.getBukkitEntity();
        }
    };
    private int dO;
    public boolean k;
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public String kickLeaveMessage = null;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public EntityPlayer(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile, ClientInformation clientinformation) {
        super(worldserver, gameprofile);
        this.dB = minecraftserver.a(this);
        this.h = minecraftserver.b(this);
        this.dp = new RecipeBookServer((resourcekey, consumer) -> minecraftserver.aI().a(resourcekey, consumer));
        this.cW = minecraftserver;
        this.cY = minecraftserver.ag().getPlayerStats(this);
        this.cX = minecraftserver.ag().f(this);
        this.a(clientinformation);
        this.j = null;
        this.displayName = this.cM();
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.fa();
    }

    public void resendItemInHands() {
        this.cn.b(this.gs(), this.gs().f()).ifPresent(s2 -> this.dK.a(this.cn, s2, this.fh()));
        this.dK.a((Container)this.cm, 45, this.fi());
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.ab();
        if (worldserver.G_().g() && worldserver.L.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.cW.a(worldserver));
            int j2 = MathHelper.a(worldserver.F_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    @Override
    public BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        AxisAlignedBB axisalignedbb = this.a(EntityPose.a).a(Vec3D.c);
        BlockPosition blockposition1 = blockposition;
        if (worldserver.G_().g() && worldserver.L.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.cW.a(worldserver));
            int j2 = MathHelper.a(worldserver.F_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                int l22 = blockposition.u() + j22 - i2;
                int i3 = blockposition.w() + k22 - i2;
                try {
                    blockposition1 = WorldProviderNormal.a(worldserver, l22, i3);
                    if (blockposition1 == null || !this.a(worldserver, axisalignedbb.c(blockposition1.c()))) continue;
                    return blockposition1;
                }
                catch (Exception exception) {
                    CrashReport crashreport = CrashReport.a(exception, "Searching for spawn");
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Spawn Lookup");
                    Objects.requireNonNull(blockposition);
                    crashreportsystemdetails.a("Origin", blockposition::toString);
                    int finalI = i2;
                    crashreportsystemdetails.a("Radius", () -> Integer.toString(finalI));
                    crashreportsystemdetails.a("Candidate", () -> "[" + l22 + "," + i3 + "]");
                    int finalL1 = l1;
                    crashreportsystemdetails.a("Progress", () -> finalL1 + " out of " + i1);
                    throw new ReportedException(crashreport);
                }
            }
            blockposition1 = blockposition;
        }
        while (!this.a(worldserver, axisalignedbb.c(blockposition1.c())) && blockposition1.v() < worldserver.ao()) {
            blockposition1 = blockposition1.d();
        }
        while (this.a(worldserver, axisalignedbb.c(blockposition1.e().c())) && blockposition1.v() > worldserver.L_() + 1) {
            blockposition1 = blockposition1.e();
        }
        return blockposition1;
    }

    private boolean a(WorldServer worldserver, AxisAlignedBB axisalignedbb) {
        return worldserver.a((Entity)this, axisalignedbb, true);
    }

    private int t(int i2) {
        return i2 <= 16 ? i2 - 1 : 17;
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.dF = valueinput.a("warden_spawn_tracker", WardenSpawnTracker.a).orElseGet(WardenSpawnTracker::new);
        this.dw = valueinput.a("entered_nether_pos", Vec3D.a).orElse(null);
        this.i = valueinput.a("seenCredits", false);
        valueinput.a("recipeBook", RecipeBookServer.b.a).ifPresent(recipebookserver_b -> this.dp.a((RecipeBookServer.b)recipebookserver_b, (ResourceKey<IRecipe<?>> resourcekey) -> this.cW.aI().b((ResourceKey<IRecipe<?>>)resourcekey).isPresent()));
        this.getBukkitEntity().readExtraData(valueinput);
        if (this.fY()) {
            this.fZ();
        }
        this.dA = valueinput.a("respawn", RespawnConfig.a).orElse(null);
        String spawnWorld = valueinput.a("SpawnWorld", "");
        CraftWorld oldWorld = (CraftWorld)Bukkit.getWorld((String)spawnWorld);
        if (oldWorld != null) {
            RespawnConfig respawnConfig = this.dA;
            this.dA = new RespawnConfig(oldWorld.getHandle().aj(), respawnConfig.b(), respawnConfig.c(), respawnConfig.d());
        }
        this.dE = valueinput.a("spawn_extra_particles_on_fall", false);
        this.dG = valueinput.a("raid_omen_position", BlockPosition.a).orElse(null);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("warden_spawn_tracker", WardenSpawnTracker.a, this.dF);
        this.g(valueoutput);
        valueoutput.a("seenCredits", this.i);
        valueoutput.b("entered_nether_pos", Vec3D.a, this.dw);
        this.e(valueoutput);
        valueoutput.a("recipeBook", RecipeBookServer.b.a, this.dp.b());
        valueoutput.a(f, this.y().aj().a().toString());
        valueoutput.b("respawn", RespawnConfig.a, this.dA);
        this.getBukkitEntity().setExtraData(valueoutput);
        valueoutput.a("spawn_extra_particles_on_fall", this.dE);
        valueoutput.b("raid_omen_position", BlockPosition.a, this.dG);
        this.f(valueoutput);
    }

    private void e(ValueOutput valueoutput) {
        Entity entity = this.dh();
        Entity entity1 = this.dm();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (Entity vehicle = entity1; vehicle != null; vehicle = vehicle.dm()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.dg()) {
            ValueOutput valueoutput1 = valueoutput.a("RootVehicle");
            valueoutput1.a("Attach", UUIDUtil.a, entity1.cK());
            entity.c(valueoutput1.a("Entity"));
        }
    }

    public void b(ValueInput valueinput) {
        Optional<ValueInput> optional = valueinput.a("RootVehicle");
        if (!optional.isEmpty()) {
            WorldServer worldserver = this.y();
            Entity entity = EntityTypes.a(optional.get().b("Entity"), (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c((Entity)entity1) ? null : entity1);
            if (entity != null) {
                UUID uuid = optional.get().a("Attach", UUIDUtil.a).orElse(null);
                if (entity.cK().equals(uuid)) {
                    this.a(entity, true);
                } else {
                    for (Entity entity12 : entity.de()) {
                        if (!entity12.cK().equals(uuid)) continue;
                        this.a(entity12, true);
                        break;
                    }
                }
                if (!this.cc()) {
                    cM.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity2 : entity.de()) {
                        entity2.discard(null);
                    }
                }
            }
        }
    }

    private void f(ValueOutput valueoutput) {
        if (!this.dJ.isEmpty()) {
            ValueOutput.b valueoutput_b = valueoutput.b(d);
            for (EntityEnderPearl entityenderpearl : this.dJ) {
                if (entityenderpearl.dU()) {
                    cM.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                ValueOutput valueoutput1 = valueoutput_b.a();
                entityenderpearl.c(valueoutput1);
                valueoutput1.a(e, net.minecraft.world.level.World.h, entityenderpearl.ai().aj());
            }
        }
    }

    public void c(ValueInput valueinput) {
        valueinput.d(d).forEach(this::f);
    }

    private void f(ValueInput valueinput) {
        Optional<ResourceKey<net.minecraft.world.level.World>> optional = valueinput.a(e, net.minecraft.world.level.World.h);
        if (!optional.isEmpty()) {
            WorldServer worldserver = this.y().q().a(optional.get());
            if (worldserver != null) {
                Entity entity = EntityTypes.a(valueinput, (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c((Entity)entity1) ? null : entity1);
                if (entity != null) {
                    EntityPlayer.a(worldserver, entity.dz());
                } else {
                    cM.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                }
            } else {
                cM.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
            }
        }
    }

    public void spawnIn(net.minecraft.world.level.World world, boolean flag) {
        this.a(world);
        if (world == null) {
            this.dW();
            TeleportTransition teleporttransition = this.findRespawnPositionAndUseSpawnBlock(!flag, TeleportTransition.a, null);
            this.a((net.minecraft.world.level.World)teleporttransition.b());
            this.b(teleporttransition.c());
        }
        this.h.a((WorldServer)world);
    }

    public void a(int i2) {
        float f2 = this.gC();
        float f1 = (f2 - 1.0f) / f2;
        this.cD = MathHelper.a((float)i2 / f2, 0.0f, f1);
        this.di = -1;
    }

    public void b(int i2) {
        this.cB = i2;
        this.di = -1;
    }

    @Override
    public void c(int i2) {
        super.c(i2);
        this.di = -1;
    }

    @Override
    public void a(ItemStack itemstack, int i2) {
        super.a(itemstack, i2);
        this.di = -1;
    }

    public void a(Container container) {
        container.a(this.dL);
        container.a(this.dK);
        container.startOpen();
    }

    public void c() {
        this.a(this.cm);
    }

    @Override
    public void h_() {
        super.h_();
        this.g.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void P_() {
        super.P_();
        this.g.b(new ClientboundPlayerCombatEndPacket(this.eY()));
    }

    @Override
    public void a(IBlockData iblockdata) {
        CriterionTriggers.e.a(this, iblockdata);
    }

    @Override
    protected ItemCooldown f() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void g() {
        Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.gU();
        this.h.a();
        this.dF.a();
        if (this.aw > 0) {
            --this.aw;
        }
        this.cn.d();
        if (!this.cn.b(this)) {
            this.p();
            this.cn = this.cm;
        }
        if ((entity = this.L()) != this) {
            if (entity.bO()) {
                this.a(entity.dC(), entity.dE(), entity.dI(), entity.dP(), entity.dR());
                this.y().n().a(this);
                if (this.gi()) {
                    this.d((Entity)this);
                }
            } else {
                this.d((Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.dq != null) {
            CriterionTriggers.v.a(this, this.dq, this.as - this.dr);
        }
        this.k();
        this.l();
        this.hc();
        this.cX.a(this, true);
    }

    private void hc() {
        AttributeModifiable attributemodifiable2;
        AttributeModifiable attributemodifiable1;
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.g);
        if (attributemodifiable != null) {
            if (this.gI()) {
                attributemodifiable.a(cQ);
            } else {
                attributemodifiable.e(cQ);
            }
        }
        if ((attributemodifiable1 = this.h(GenericAttributes.k)) != null) {
            if (this.gI()) {
                attributemodifiable1.a(cR);
            } else {
                attributemodifiable1.e(cR);
            }
        }
        if ((attributemodifiable2 = this.h(GenericAttributes.H)) != null) {
            if (this.cl()) {
                attributemodifiable2.a(cT);
            } else {
                attributemodifiable2.e(cT);
            }
        }
    }

    public void h() {
        try {
            if (!this.am() || !this.dq()) {
                super.g();
            }
            for (int i2 = 0; i2 < this.gs().b(); ++i2) {
                ItemStack itemstack = this.gs().a(i2);
                if (itemstack.f()) continue;
                this.i(itemstack);
            }
            if (this.eL() != this.df || this.dg != this.co.a() || this.co.c() == 0.0f != this.dh) {
                this.g.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.co.a(), this.co.c()));
                this.df = this.eL();
                this.dg = this.co.a();
                boolean bl = this.dh = this.co.c() == 0.0f;
            }
            if (this.eL() + this.fD() != this.cZ) {
                this.cZ = this.eL() + this.fD();
                this.a(IScoreboardCriteria.h, MathHelper.f(this.cZ));
            }
            if (this.co.a() != this.da) {
                this.da = this.co.a();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.da));
            }
            if (this.cw() != this.db) {
                this.db = this.cw();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.db));
            }
            if (this.eX() != this.dc) {
                this.dc = this.eX();
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.dc));
            }
            if (this.cC != this.de) {
                this.de = this.cC;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.de));
            }
            if (this.maxHealthCache != (double)this.fa()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cB != this.dd) {
                this.dd = this.cB;
                this.a(IScoreboardCriteria.m, MathHelper.f((float)this.dd));
            }
            if (this.cC != this.di) {
                this.di = this.cC;
                this.g.b(new PacketPlayOutExperience(this.cD, this.cC, this.cB));
            }
            if (this.as % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cB;
            }
            if (this.oldLevel != this.cB) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cB);
                this.oldLevel = this.cB;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    private void i(ItemStack itemstack) {
        Packet<?> packet;
        MapId mapid = itemstack.a(DataComponents.M);
        WorldMap worldmap = ItemWorldMap.a(mapid, (net.minecraft.world.level.World)this.y());
        if (worldmap != null && (packet = worldmap.a(mapid, this)) != null) {
            this.g.b(packet);
        }
    }

    @Override
    protected void i() {
        if (this.y().an() == EnumDifficulty.a && this.y().P().c(GameRules.l)) {
            if (this.as % 20 == 0) {
                float f2;
                if (this.eL() < this.fa()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((f2 = this.co.c()) < 20.0f) {
                    this.co.b(f2 + 1.0f);
                }
            }
            if (this.as % 10 == 0 && this.co.b()) {
                this.co.a(this.co.a() + 1);
            }
        }
    }

    @Override
    public void j() {
        if (this.eL() > 0.0f && this.dv != null) {
            CriterionTriggers.Y.a(this, this.dv);
        }
        this.dv = null;
        super.j();
    }

    public void k() {
        if (this.am > 0.0 && this.dv == null) {
            this.dv = this.dv();
            if (this.cI != null && this.cI.e <= this.dv.e) {
                CriterionTriggers.af.a(this, this.cI, this.cJ);
            }
        }
    }

    public void l() {
        if (this.dm() != null && this.dm().bA()) {
            if (this.dx == null) {
                this.dx = this.dv();
            } else {
                CriterionTriggers.Z.a(this, this.dx);
            }
        }
        if (!(this.dx == null || this.dm() != null && this.dm().bA())) {
            this.dx = null;
        }
    }

    private void a(IScoreboardCriteria iscoreboardcriteria, int i2) {
        this.y().getCraftServer().getScoreboardManager().forAllObjectives(iscoreboardcriteria, this, scoreaccess -> scoreaccess.a(i2));
    }

    @Override
    public void a(DamageSource damagesource) {
        String deathMessage;
        boolean keepInventory;
        this.c(GameEvent.p);
        boolean flag = this.y().P().c(GameRules.o);
        if (this.dU()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.gs().b());
        boolean bl = keepInventory = this.y().P().c(GameRules.e) || this.am();
        if (!keepInventory) {
            for (ItemStack item : this.gs()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(CraftItemStack.asCraftMirror(item).markForInventoryDrop());
            }
        }
        this.b(this.y(), damagesource, this.bx > 0);
        this.a(this.y(), damagesource, flag);
        loot.addAll(this.drops);
        this.drops.clear();
        IChatBaseComponent defaultMessage = this.eY().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damagesource, loot, deathmessage, keepInventory);
        if (this.cn != this.cm) {
            this.p();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            IChatBaseComponent ichatbasecomponent = deathMessage.equals(deathmessage) ? this.eY().a() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.g.a(new ClientboundPlayerCombatKillPacket(this.ar(), ichatbasecomponent), PacketSendListener.a(() -> {
                int i2 = 256;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatbasecomponent2 = IChatBaseComponent.a("death.attack.even_more_magic", this.Q_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable.e(ichatbasecomponent1)));
                return new ClientboundPlayerCombatKillPacket(this.ar(), ichatbasecomponent2);
            }));
            ScoreboardTeam scoreboardteambase = this.cu();
            if (scoreboardteambase != null && ((ScoreboardTeamBase)scoreboardteambase).l() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (((ScoreboardTeamBase)scoreboardteambase).l() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.cW.ag().a((EntityHuman)this, ichatbasecomponent);
                } else if (((ScoreboardTeamBase)scoreboardteambase).l() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.cW.ag().b(this, ichatbasecomponent);
                }
            } else {
                this.cW.ag().a(ichatbasecomponent, false);
            }
        } else {
            this.g.b(new ClientboundPlayerCombatKillPacket(this.ar(), CommonComponents.a));
        }
        this.gH();
        if (this.y().P().c(GameRules.P)) {
            this.hd();
        }
        this.b(this.y(), damagesource.d());
        if (!event.getKeepInventory()) {
            this.gs().a();
        }
        this.d((Entity)this);
        this.y().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
        EntityLiving entityliving = this.eZ();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ap()));
            entityliving.a((Entity)this, damagesource);
            this.e(entityliving);
        }
        this.y().a((Entity)this, (byte)3);
        this.a(StatisticList.O);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aI();
        this.k(0);
        this.d(false);
        this.eY().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.y().aj(), this.dx())));
        this.w(false);
    }

    private void hd() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.dx()).c(32.0, 10.0, 32.0);
        this.y().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this.y(), this));
    }

    @Override
    public void a(Entity entity, DamageSource damagesource) {
        if (entity != this) {
            super.a(entity, damagesource);
            this.y().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.g, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.R);
                this.y().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.P);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.n);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.o);
            CriterionTriggers.c.a(this, entity, damagesource);
        }
    }

    private void a(ScoreHolder scoreholder, ScoreHolder scoreholder1, IScoreboardCriteria[] aiscoreboardcriteria) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gJ().e(scoreholder1.cM());
        if (scoreboardteam != null && (i2 = scoreboardteam.o().b()) >= 0 && i2 < aiscoreboardcriteria.length) {
            this.y().getCraftServer().getScoreboardManager().forAllObjectives(aiscoreboardcriteria[i2], scoreholder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        Entity entity1;
        EntityHuman entityhuman;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).ah_()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        return super.a(worldserver, damagesource, f2);
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return !this.he() ? false : super.a(entityhuman);
    }

    private boolean he() {
        return this.y().pvpMode;
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean flag, TeleportTransition.a teleporttransition_a, PlayerRespawnEvent.RespawnReason reason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        RespawnConfig entityplayer_respawnconfig = this.T();
        WorldServer worldserver = this.cW.a(RespawnConfig.b(entityplayer_respawnconfig));
        if (worldserver != null && entityplayer_respawnconfig != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(worldserver, entityplayer_respawnconfig, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(worldserver, entityplayer_respawnposangle.a(), Vec3D.c, entityplayer_respawnposangle.b(), 0.0f, teleporttransition_a);
            } else {
                teleportTransition = TeleportTransition.a(this.cW.J(), this, teleporttransition_a);
            }
        } else {
            teleportTransition = new TeleportTransition(this.cW.J(), this, teleporttransition_a);
        }
        if (reason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (World)teleportTransition.b().getWorld(), teleportTransition.e(), teleportTransition.f());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason);
        this.y().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.g.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause());
    }

    public boolean m() {
        return this.i(GenericAttributes.I) > 0.0;
    }

    @Override
    protected void a(Holder<AttributeBase> holder) {
        if (holder.a(GenericAttributes.I)) {
            ServerWaypointManager serverwaypointmanager = this.y().h();
            if (this.fg().c(holder) > 0.0) {
                serverwaypointmanager.a(this);
            } else {
                serverwaypointmanager.c(this);
            }
        }
        super.a(holder);
    }

    public static Optional<RespawnPosAngle> a(WorldServer worldserver, RespawnConfig entityplayer_respawnconfig, boolean flag) {
        BlockPosition blockposition = entityplayer_respawnconfig.c;
        float f2 = entityplayer_respawnconfig.d;
        boolean flag1 = entityplayer_respawnconfig.e;
        IBlockData iblockdata = worldserver.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (flag1 || iblockdata.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(worldserver)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bU, worldserver, blockposition);
            if (!flag1 && flag && optional.isPresent()) {
                worldserver.a(blockposition, (IBlockData)iblockdata.b(BlockRespawnAnchor.d, iblockdata.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, false, true));
        }
        if (block instanceof BlockBed && BlockBed.a(worldserver)) {
            return BlockBed.a(EntityTypes.bU, (ICollisionAccess)worldserver, blockposition, (EnumDirection)iblockdata.c(BlockBed.f), f2).map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, true, false));
        }
        if (!flag1) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = worldserver.a_(blockposition.d());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3D((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.1, (double)blockposition.w() + 0.5), f2, false, false)) : Optional.empty();
    }

    public void n() {
        this.an();
        this.y().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    @Nullable
    public EntityPlayer a(TeleportTransition teleporttransition) {
        if (this.fY()) {
            return null;
        }
        if (this.dU()) {
            return null;
        }
        if (teleporttransition.g()) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer worldserver = teleporttransition.b();
        WorldServer worldserver1 = this.y();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(absolutePosition.a(), (World)worldserver.getWorld(), absolutePosition.c(), absolutePosition.d());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, teleporttransition.cause());
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            worldserver = ((CraftWorld)newExit.getWorld()).getHandle();
            teleporttransition = new TeleportTransition(worldserver, CraftLocation.toVec3D(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleporttransition.g(), teleporttransition.h(), Set.of(), teleporttransition.j(), teleporttransition.cause());
        }
        if (!teleporttransition.h()) {
            this.ab();
        }
        if (worldserver != null && worldserver.aj() == worldserver1.aj()) {
            this.g.internalTeleport(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
            this.g.l();
            teleporttransition.j().onTransition(this);
            return this;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("moving");
        if (worldserver != null && resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
            this.dw = this.dv();
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("placing");
        this.do = true;
        WorldData worlddata = worldserver.D_();
        this.g.b(new PacketPlayOutRespawn(this.b(worldserver), 3));
        this.g.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        PlayerList playerlist = this.cW.ag();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dW();
        this.a(worldserver);
        this.g.internalTeleport(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        this.g.l();
        worldserver.d(this);
        gameprofilerfiller.c();
        this.g(worldserver1);
        this.fM();
        this.g.b(new PacketPlayOutAbilities(this.gt()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        playerlist.c(this);
        teleporttransition.j().onTransition(this);
        this.di = -1;
        this.df = -1.0f;
        this.dg = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.y().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        this.a(teleporttransition, worldserver1);
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void a(float f2, float f1) {
        this.g.b(new ClientboundPlayerRotationPacket(f2, f1));
    }

    public void g(WorldServer worldserver) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = worldserver.aj();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.y().aj();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(worldserver);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.y());
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.w.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.j && maindimensionkey1 == net.minecraft.world.level.World.i && this.dw != null) {
            CriterionTriggers.D.a(this, this.dw);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.j) {
            this.dw = null;
        }
    }

    @Override
    public boolean a(EntityPlayer entityplayer) {
        return entityplayer.am() ? this.L() == this : (this.am() ? false : super.a(entityplayer));
    }

    @Override
    public void a(Entity entity, int i2) {
        super.a(entity, i2);
        this.cn.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fY() && this.bO()) {
            if (!this.y().G_().j() || !this.y().G_().l()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.a));
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.c));
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.d));
            }
            this.setRespawnPosition(new RespawnConfig(this.y().aj(), blockposition, this.dP(), false), true, PlayerSpawnChangeEvent.Cause.BED);
            if (this.y().W()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.b));
            }
            if (!this.gI()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.y().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.a(this.y(), this));
                if (!list.isEmpty()) {
                    return Either.left((Object)((Object)EntityHuman.EnumBedResult.f));
                }
            }
            return Either.right((Object)((Object)Unit.a));
        }
        return Either.left((Object)((Object)EntityHuman.EnumBedResult.e));
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.y().a_(blockposition).c(BlockFacingHorizontal.f);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right((Object)((Object)Unit.a));
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.aq);
            CriterionTriggers.r.a(this);
        });
        if (!this.y().e()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        this.y().f();
        return either;
    }

    @Override
    public void b(BlockPosition blockposition) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(blockposition);
    }

    private boolean a(BlockPosition blockposition, EnumDirection enumdirection) {
        return this.i(blockposition) || this.i(blockposition.a(enumdirection.g()));
    }

    private boolean i(BlockPosition blockposition) {
        Vec3D vec3d = Vec3D.c(blockposition);
        return Math.abs(this.dC() - vec3d.a()) <= 3.0 && Math.abs(this.dE() - vec3d.b()) <= 2.0 && Math.abs(this.dI() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.d();
        return !this.h(blockposition1) || !this.h(blockposition1.a(enumdirection.g()));
    }

    @Override
    public void a(boolean flag, boolean flag1) {
        if (!this.fY()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fW().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.y().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.y().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.y().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fY()) {
            this.y().n().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(flag, flag1);
        if (this.g != null) {
            this.g.teleport(this.dC(), this.dE(), this.dI(), this.dP(), this.dR(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return super.a(worldserver, damagesource) || this.Q() && !damagesource.a(DamageTypes.m) || !this.gT();
    }

    @Override
    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        if (!this.am()) {
            super.b(worldserver, blockposition);
        }
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.dE && flag && this.am > 0.0) {
            Vec3D vec3d = blockposition.b().b(0.0, 0.5, 0.0);
            int i2 = (int)MathHelper.a(50.0 * this.am, 0.0, 200.0);
            this.y().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.d, vec3d.e, vec3d.f, i2, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            this.dE = false;
        }
        super.a(d0, flag, iblockdata, blockposition);
    }

    @Override
    public void a(@Nullable Entity entity) {
        super.a(entity);
        this.cI = this.dv();
        this.cJ = entity;
        this.x(entity != null && entity.ap() == EntityTypes.bJ);
    }

    @Override
    protected void o() {
        if (this.y().v().i()) {
            super.o();
        }
    }

    @Override
    public void a(TileEntitySign tileentitysign, boolean flag) {
        this.g.b(new PacketPlayOutBlockChange(this.y(), tileentitysign.aA_()));
        this.g.b(new PacketPlayOutOpenSignEditor(tileentitysign.aA_(), flag));
    }

    @Override
    public void b(Holder<Dialog> holder) {
        this.g.b(new ClientboundShowDialogPacket(holder));
    }

    public int nextContainerCounter() {
        this.dO = this.dO % 100 + 1;
        return this.dO;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        if (itileinventory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = itileinventory.createMenu(this.dO, this.gs(), this);
        if (container != null) {
            container.setTitle(itileinventory.Q_());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (itileinventory instanceof IInventory) {
                    ((IInventory)((Object)itileinventory)).c(this);
                } else if (itileinventory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)itileinventory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.am()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cn = container;
        this.g.b(new PacketPlayOutOpenWindow(container.l, container.a(), container.getTitle()));
        this.a(container);
        return OptionalInt.of(this.dO);
    }

    @Override
    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
        this.g.b(new PacketPlayOutOpenWindowMerchant(i2, merchantrecipelist, j2, k2, flag, flag1));
    }

    @Override
    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dO, this.gs(), iinventory, entityhorseabstract, entityhorseabstract.ac_());
        container.setTitle(entityhorseabstract.Q_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            iinventory.c(this);
            return;
        }
        if (this.cn != this.cm) {
            this.p();
        }
        int i2 = entityhorseabstract.ac_();
        this.g.b(new PacketPlayOutOpenWindowHorse(this.dO, i2, entityhorseabstract.ar()));
        this.cn = container;
        this.a(this.cn);
    }

    @Override
    public void a(ItemStack itemstack, EnumHand enumhand) {
        if (itemstack.c(DataComponents.V)) {
            if (WrittenBookContent.a(itemstack, this.A(), this)) {
                this.cn.d();
            }
            this.g.b(new PacketPlayOutOpenBook(enumhand));
        }
    }

    @Override
    public void a(TileEntityCommand tileentitycommand) {
        this.g.b(PacketPlayOutTileEntityData.a(tileentitycommand, TileEntity::d));
    }

    @Override
    public void p() {
        CraftEventFactory.handleInventoryCloseEvent(this);
        this.g.b(new PacketPlayOutCloseWindow(this.cn.l));
        this.q();
    }

    @Override
    public void q() {
        this.cn.a(this);
        this.cm.a(this.cn);
        this.cn = this.cm;
    }

    @Override
    public void r() {
        double d0 = this.dC();
        double d1 = this.dE();
        double d2 = this.dI();
        super.r();
        this.q(this.dC() - d0, this.dE() - d1, this.dI() - d2);
    }

    public void a(double d0, double d1, double d2) {
        if (!this.cc() && !EntityPlayer.r(d0, d1, d2)) {
            if (this.cn()) {
                int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.D, i2);
                    this.causeFoodExhaustion(this.y().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.a)) {
                int j2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (j2 > 0) {
                    this.a(StatisticList.w, j2);
                    this.causeFoodExhaustion(this.y().spigotConfig.swimMultiplier * (float)j2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bm()) {
                int k2 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (k2 > 0) {
                    this.a(StatisticList.s, k2);
                    this.causeFoodExhaustion(this.y().spigotConfig.swimMultiplier * (float)k2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.eV()) {
                if (d1 > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(d1 * 100.0));
                }
            } else if (this.aK()) {
                int l2 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (l2 > 0) {
                    if (this.cm()) {
                        this.a(StatisticList.r, l2);
                        this.causeFoodExhaustion(this.y().spigotConfig.sprintMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.cl()) {
                        this.a(StatisticList.q, l2);
                        this.causeFoodExhaustion(this.y().spigotConfig.otherMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, l2);
                        this.causeFoodExhaustion(this.y().spigotConfig.otherMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fQ()) {
                int i1 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                this.a(StatisticList.C, i1);
            } else {
                int j1 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (j1 > 25) {
                    this.a(StatisticList.v, j1);
                }
            }
        }
    }

    private void q(double d0, double d1, double d2) {
        if (this.cc() && !EntityPlayer.r(d0, d1, d2)) {
            int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
            Entity entity = this.dm();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof AbstractBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.B, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.E, i2);
            } else if (entity instanceof HappyGhast) {
                this.a(StatisticList.A, i2);
            }
        }
    }

    private static boolean r(double d0, double d1, double d2) {
        return d0 == 0.0 && d1 == 0.0 && d2 == 0.0;
    }

    @Override
    public void a(Statistic<?> statistic, int i2) {
        this.cY.b(this, statistic, i2);
        this.y().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, scoreaccess -> scoreaccess.b(i2));
    }

    @Override
    public void a(Statistic<?> statistic) {
        this.cY.a(this, statistic, 0);
        this.y().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> collection) {
        return this.dp.a(collection, this);
    }

    @Override
    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
        CriterionTriggers.ad.a(this, recipeholder.a(), list);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> list) {
        List<RecipeHolder<?>> list1 = list.stream().flatMap(resourcekey -> this.cW.aI().b((ResourceKey<IRecipe<?>>)resourcekey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list1);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> collection) {
        return this.dp.b(collection, this);
    }

    @Override
    public void s() {
        super.s();
        this.a(StatisticList.F);
        if (this.cm()) {
            this.causeFoodExhaustion(this.y().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.y().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int i2) {
        super.d(i2);
        this.di = -1;
    }

    public void t() {
        this.ds = true;
        this.bR();
        if (this.fY()) {
            this.a(true, false);
        }
    }

    public boolean u() {
        return this.ds;
    }

    public void v() {
        this.df = -1.0E8f;
        this.di = -1;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.b(ichatbasecomponent, flag);
    }

    @Override
    protected void w() {
        if (!this.bI.f() && this.fG()) {
            this.g.b(new PacketPlayOutEntityStatus(this, 9));
            super.w();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.g.b(new PacketPlayOutLookAt(argumentanchor_anchor, vec3d.d, vec3d.e, vec3d.f));
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Entity entity, ArgumentAnchor.Anchor argumentanchor_anchor1) {
        Vec3D vec3d = argumentanchor_anchor1.a(entity);
        super.a(argumentanchor_anchor, vec3d);
        this.g.b(new PacketPlayOutLookAt(argumentanchor_anchor, entity, argumentanchor_anchor1));
    }

    public void a(EntityPlayer entityplayer, boolean flag) {
        this.dF = entityplayer.dF;
        this.dM = entityplayer.dM;
        this.h.a(entityplayer.h.b(), entityplayer.h.c());
        this.x();
        if (flag) {
            this.fg().b(entityplayer.fg());
            this.x(entityplayer.eL());
            this.co = entityplayer.co;
            for (MobEffect mobEffect : entityplayer.eI()) {
            }
            this.gs().a(entityplayer.gs());
            this.cB = entityplayer.cB;
            this.cC = entityplayer.cC;
            this.cD = entityplayer.cD;
            this.q(entityplayer.gm());
            this.aF = entityplayer.aF;
        } else {
            this.fg().b(entityplayer.fg());
            if (this.y().P().c(GameRules.e) || entityplayer.am()) {
                this.gs().a(entityplayer.gs());
                this.cB = entityplayer.cB;
                this.cC = entityplayer.cC;
                this.cD = entityplayer.cD;
                this.q(entityplayer.gm());
            }
        }
        this.cE = entityplayer.cE;
        this.cl = entityplayer.cl;
        this.au().a(cg, (Byte)entityplayer.au().a(cg));
        this.di = -1;
        this.df = -1.0f;
        this.dg = -1;
        this.i = entityplayer.i;
        this.dw = entityplayer.dw;
        this.dz = entityplayer.dz;
        this.b(entityplayer.gL());
        this.c(entityplayer.gM());
        ((EntityHuman)this).a(entityplayer.gS());
    }

    @Override
    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        super.a(mobeffect, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.ar(), mobeffect, true));
        if (mobeffect.a(MobEffects.y)) {
            this.dr = this.as;
            this.dq = this.dv();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        super.a(mobeffect, flag, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.ar(), mobeffect, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void c(Collection<MobEffect> collection) {
        super.c(collection);
        for (MobEffect mobeffect : collection) {
            this.g.b(new PacketPlayOutRemoveEntityEffect(this.ar(), mobeffect.c()));
            if (!mobeffect.a(MobEffects.y)) continue;
            this.dq = null;
        }
        CriterionTriggers.B.a(this, (Entity)null);
    }

    @Override
    public void b(double d0, double d1, double d2) {
        this.g.a(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k));
    }

    @Override
    public void c(double d0, double d1, double d2) {
        this.g.a(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag1;
        if (this.fY()) {
            this.a(true, true);
        }
        if (flag) {
            this.d((Entity)this);
        }
        if (flag1 = super.teleportTo(worldserver, d0, d1, d2, set, f2, f1, flag, cause)) {
            this.r(set.contains((Object)Relative.d) ? this.cE() + f2 : f2);
        }
        return flag1;
    }

    @Override
    public void d(double d0, double d1, double d2) {
        super.d(d0, d1, d2);
        this.g.l();
    }

    @Override
    public void b(Entity entity) {
        this.y().n().a(this, new PacketPlayOutAnimation(entity, 4));
    }

    @Override
    public void c(Entity entity) {
        this.y().n().a(this, new PacketPlayOutAnimation(entity, 5));
    }

    @Override
    public void x() {
        if (this.g != null) {
            this.g.b(new PacketPlayOutAbilities(this.gt()));
            this.K();
        }
    }

    public WorldServer y() {
        return (WorldServer)super.ai();
    }

    public boolean a(EnumGamemode enumgamemode) {
        boolean flag = this.am();
        if (!this.h.a(enumgamemode)) {
            return false;
        }
        this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, enumgamemode.a()));
        if (enumgamemode == EnumGamemode.d) {
            this.gH();
            this.bS();
            EnchantmentManager.a(this);
        } else {
            this.d((Entity)this);
            if (flag) {
                EnchantmentManager.a(this.y(), (EntityLiving)this);
            }
        }
        this.x();
        this.fE();
        return true;
    }

    @Override
    @Nonnull
    public EnumGamemode a() {
        return this.h.b();
    }

    public ICommandListener z() {
        return this.dN;
    }

    public CommandListenerWrapper A() {
        return new CommandListenerWrapper(this.z(), this.dv(), this.bX(), this.y(), this.G(), this.aj().getString(), this.Q_(), this.cW, this);
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        this.b(ichatbasecomponent, false);
    }

    public void b(IChatBaseComponent ichatbasecomponent, boolean flag) {
        if (this.y(flag)) {
            this.g.a(new ClientboundSystemChatPacket(ichatbasecomponent, flag), PacketSendListener.a(() -> {
                if (this.y(false)) {
                    int i2 = 256;
                    String s2 = ichatbasecomponent.a(256);
                    IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatbasecomponent1).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatMessageType.a chatmessagetype_a) {
        if (this.hg()) {
            outgoingchatmessage.a(this, flag, chatmessagetype_a);
        }
    }

    public String B() {
        SocketAddress socketaddress = this.g.m();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void a(ClientInformation clientinformation) {
        PlayerChangedMainHandEvent event;
        if (this.fF() != clientinformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fF() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.cW.server.getPluginManager().callEvent((Event)event);
        }
        if (!this.du.equals(clientinformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientinformation.b());
            this.cW.server.getPluginManager().callEvent((Event)event);
        }
        this.du = clientinformation.b();
        this.dt = clientinformation.c();
        this.dj = clientinformation.d();
        this.dl = clientinformation.e();
        this.dC = clientinformation.h();
        this.dD = clientinformation.i();
        this.dk = clientinformation.j();
        this.au().a(cg, (byte)clientinformation.f());
        this.au().a(ch, (byte)clientinformation.g().b());
    }

    public ClientInformation C() {
        byte i2 = (Byte)this.au().a(cg);
        EnumMainHand enummainhand = EnumMainHand.d.apply(((Byte)this.au().a(ch)).byteValue());
        return new ClientInformation(this.du, this.dt, this.dj, this.dl, i2, enummainhand, this.dC, this.dD, this.dk);
    }

    public boolean D() {
        return this.dl;
    }

    public EnumChatVisibility E() {
        return this.dj;
    }

    private boolean y(boolean flag) {
        return this.dj == EnumChatVisibility.c ? flag : true;
    }

    private boolean hg() {
        return this.dj == EnumChatVisibility.a;
    }

    public int F() {
        return this.dt;
    }

    public void a(ServerPing serverping) {
        this.g.b(new ClientboundServerDataPacket(serverping.a(), serverping.d().map(ServerPing.a::a)));
    }

    @Override
    public int G() {
        return this.cW.c(this.gr());
    }

    public void H() {
        this.dm = SystemUtils.c();
    }

    public ServerStatisticManager I() {
        return this.cY;
    }

    public RecipeBookServer J() {
        return this.dp;
    }

    @Override
    protected void K() {
        if (this.am()) {
            this.eG();
            this.l(true);
        } else {
            super.K();
        }
    }

    public Entity L() {
        return this.dn == null ? this : this.dn;
    }

    public void d(@Nullable Entity entity) {
        Entity entity1 = this.L();
        Entity entity2 = this.dn = entity == null ? this : entity;
        if (entity1 != this.dn) {
            WorldServer worldserver;
            boolean result;
            net.minecraft.world.level.World world = this.dn.ai();
            if (world instanceof WorldServer && !(result = this.teleportTo(worldserver = (WorldServer)world, this.dn.dC(), this.dn.dE(), this.dn.dI(), Set.of(), this.dP(), this.dR(), false, PlayerTeleportEvent.TeleportCause.SPECTATE))) {
                this.dn = entity1;
                return;
            }
            if (entity != null) {
                this.y().n().a(this);
            }
            this.g.b(new PacketPlayOutCamera(this.dn));
            this.g.l();
        }
    }

    @Override
    protected void M() {
        if (!this.do) {
            super.M();
        }
    }

    @Override
    public void e(Entity entity) {
        if (this.am()) {
            this.d(entity);
        } else {
            super.e(entity);
        }
    }

    public long N() {
        return this.dm;
    }

    @Nullable
    public IChatBaseComponent O() {
        return this.listName;
    }

    public int P() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand enumhand) {
        super.a(enumhand);
        this.gO();
    }

    public boolean Q() {
        return this.do;
    }

    public void R() {
        this.do = false;
    }

    public AdvancementDataPlayer S() {
        return this.cX;
    }

    @Nullable
    public RespawnConfig T() {
        return this.dA;
    }

    public void b(EntityPlayer entityplayer) {
        this.a(entityplayer.dA, false);
    }

    public void a(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag) {
        this.setRespawnPosition(entityplayer_respawnconfig, flag, PlayerSpawnChangeEvent.Cause.UNKNOWN);
    }

    public void setRespawnPosition(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag, PlayerSpawnChangeEvent.Cause cause) {
        Location newSpawn = null;
        boolean forced = false;
        if (entityplayer_respawnconfig != null) {
            WorldServer newWorld = this.cW.a(entityplayer_respawnconfig.a());
            newSpawn = CraftLocation.toBukkit(entityplayer_respawnconfig.b(), (World)newWorld.getWorld(), entityplayer_respawnconfig.c(), 0.0f);
            forced = entityplayer_respawnconfig.d();
        }
        PlayerSpawnChangeEvent event = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), newSpawn, forced, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        newSpawn = event.getNewSpawn();
        entityplayer_respawnconfig = newSpawn != null ? new RespawnConfig(((CraftWorld)newSpawn.getWorld()).getHandle().aj(), BlockPosition.a(newSpawn.getX(), newSpawn.getY(), newSpawn.getZ()), newSpawn.getYaw(), event.isForced()) : null;
        if (flag && entityplayer_respawnconfig != null && !entityplayer_respawnconfig.a(this.dA)) {
            this.a(cS);
        }
        this.dA = entityplayer_respawnconfig;
    }

    public SectionPosition U() {
        return this.dy;
    }

    public void a(SectionPosition sectionposition) {
        this.dy = sectionposition;
    }

    public ChunkTrackingView V() {
        return this.dz;
    }

    public void a(ChunkTrackingView chunktrackingview) {
        this.dz = chunktrackingview;
    }

    @Override
    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.g.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundeffect), soundcategory, this.dC(), this.dE(), this.dI(), f2, f1, this.ar.g()));
    }

    @Override
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        EntityItem entityitem = super.drop(itemstack, flag, flag1, callEvent);
        if (flag1) {
            ItemStack itemstack1;
            ItemStack itemStack = itemstack1 = entityitem != null ? entityitem.e() : ItemStack.l;
            if (!itemstack1.f()) {
                this.a(StatisticList.f.b(itemstack1.h()), itemstack.M());
                this.a(StatisticList.G);
            }
        }
        return entityitem;
    }

    public ITextFilter W() {
        return this.dB;
    }

    public void a(WorldServer worldserver) {
        this.a((net.minecraft.world.level.World)worldserver);
        this.h.a(worldserver);
    }

    @Nullable
    private static EnumGamemode a(@Nullable ValueInput valueinput, String s2) {
        return valueinput != null ? (EnumGamemode)valueinput.a(s2, EnumGamemode.h).orElse(null) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode enumgamemode) {
        EnumGamemode enumgamemode1 = this.cW.bd();
        return enumgamemode1 != null ? enumgamemode1 : (enumgamemode != null ? enumgamemode : this.cW.u());
    }

    public void d(@Nullable ValueInput valueinput) {
        this.h.a(this.b(EntityPlayer.a(valueinput, "playerGameType")), EntityPlayer.a(valueinput, "previousPlayerGameType"));
    }

    private void g(ValueOutput valueoutput) {
        valueoutput.a("playerGameType", EnumGamemode.h, this.h.b());
        EnumGamemode enumgamemode = this.h.c();
        valueoutput.b("previousPlayerGameType", EnumGamemode.h, enumgamemode);
    }

    @Override
    public boolean X() {
        return this.dC;
    }

    public boolean c(EntityPlayer entityplayer) {
        return entityplayer == this ? false : this.dC || entityplayer.dC;
    }

    @Override
    public boolean c(WorldServer worldserver, BlockPosition blockposition) {
        return super.c(worldserver, blockposition) && worldserver.a((Entity)this, blockposition);
    }

    @Override
    protected void a(ItemStack itemstack) {
        CriterionTriggers.X.a(this, itemstack);
        super.a(itemstack);
    }

    public boolean a(boolean flag) {
        PlayerInventory playerinventory = this.gs();
        ItemStack itemstack = playerinventory.a(flag);
        this.cn.b(playerinventory, playerinventory.f()).ifPresent(i2 -> this.cn.a(i2, playerinventory.g()));
        return this.a(itemstack, false, true) != null;
    }

    @Override
    public void b(ItemStack itemstack) {
        if (!this.gs().g(itemstack)) {
            this.a(itemstack, false);
        }
    }

    public boolean Y() {
        return this.dD;
    }

    @Override
    public Optional<WardenSpawnTracker> Z() {
        return Optional.of(this.dF);
    }

    public void b(boolean flag) {
        this.dE = flag;
    }

    @Override
    public void a(EntityItem entityitem) {
        super.a(entityitem);
        Entity entity = entityitem.ah_();
        if (entity != null) {
            CriterionTriggers.S.a(this, entityitem.e(), entity);
        }
    }

    public void a(RemoteChatSession remotechatsession) {
        this.dM = remotechatsession;
    }

    @Nullable
    public RemoteChatSession aa() {
        return this.dM != null && this.dM.b() ? null : this.dM;
    }

    @Override
    public void a(double d0, double d1) {
        this.cH = (float)(MathHelper.d(d1, d0) * 57.2957763671875 - (double)this.dP());
        this.g.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(Entity entity, boolean flag) {
        if (super.a(entity, flag)) {
            entity.k(this);
            this.g.a(new PositionMoveRotation(this.dv(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.cW.ag().a(entityliving, this.g);
            }
            this.g.b(new PacketPlayOutMount(entity));
            return true;
        }
        return false;
    }

    @Override
    public void ab() {
        Entity entity = this.dm();
        super.ab();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eI()) {
                this.g.b(new PacketPlayOutRemoveEntityEffect(entity.ar(), mobeffect.c()));
            }
        }
        if (entity != null) {
            this.g.b(new PacketPlayOutMount(entity));
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer worldserver) {
        return new CommonPlayerSpawnInfo(worldserver.ai(), worldserver.aj(), BiomeManager.a(worldserver.F()), this.h.b(), this.h.c(), worldserver.ak(), worldserver.E(), this.gS(), this.aC(), worldserver.Q());
    }

    public void c(BlockPosition blockposition) {
        this.dG = blockposition;
    }

    public void ac() {
        this.dG = null;
    }

    @Nullable
    public BlockPosition ad() {
        return this.dG;
    }

    @Override
    public Vec3D ae() {
        Entity entity = this.dm();
        return entity != null && entity.cY() != this ? entity.ae() : this.dH;
    }

    public void a(Vec3D vec3d) {
        this.dH = vec3d;
    }

    @Override
    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return EnchantmentManager.a(this.y(), this.ed(), entity, damagesource, f2);
    }

    @Override
    public void a(Item item, EnumItemSlot enumitemslot) {
        super.a(item, enumitemslot);
        this.b(StatisticList.d.b(item));
    }

    public Input af() {
        return this.dI;
    }

    public void a(Input input) {
        this.dI = input;
    }

    public Vec3D ag() {
        float f2;
        float f3 = this.dI.c() == this.dI.d() ? 0.0f : (f2 = this.dI.c() ? 1.0f : -1.0f);
        float f1 = this.dI.a() == this.dI.b() ? 0.0f : (this.dI.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.dP());
    }

    public void a(EntityEnderPearl entityenderpearl) {
        this.dJ.add(entityenderpearl);
    }

    public void b(EntityEnderPearl entityenderpearl) {
        this.dJ.remove(entityenderpearl);
    }

    public Set<EntityEnderPearl> ah() {
        return this.dJ;
    }

    public long c(EntityEnderPearl entityenderpearl) {
        net.minecraft.world.level.World world = entityenderpearl.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ChunkCoordIntPair chunkcoordintpair = entityenderpearl.dz();
            this.a(entityenderpearl);
            worldserver.j();
            return EntityPlayer.a(worldserver, chunkcoordintpair) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer worldserver, ChunkCoordIntPair chunkcoordintpair) {
        worldserver.n().a(TicketType.h, chunkcoordintpair, 2);
        return TicketType.h.d();
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.y().af() + this.timeOffset;
        }
        return this.y().af() - this.y().af() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.y().D_().i() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cM() + " at " + this.dC() + "," + this.dE() + "," + this.dI() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.g.l();
    }

    @Override
    public boolean fm() {
        return super.fm() || !this.getBukkitEntity().isOnline();
    }

    @Override
    public Scoreboard gJ() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.cD;
            this.newTotalExp = this.cC;
            this.newLevel = this.cB;
        }
        this.x(this.fa());
        this.fM();
        this.h(0);
        this.am = 0.0;
        this.co = new FoodMetaData();
        this.cB = this.newLevel;
        this.cC = this.newTotalExp;
        this.cD = 0.0f;
        this.bl = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.ch = true;
        this.cn = this.cm;
        this.bw = null;
        this.ci = null;
        this.cd = new CombatTracker(this);
        this.di = -1;
        if (this.keepLevel) {
            this.cD = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.n(0.0, 0.0, 0.0);
        this.cv = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public static final class RespawnConfig
    extends Record {
        private final ResourceKey<net.minecraft.world.level.World> b;
        private final BlockPosition c;
        private final float d;
        private final boolean e;
        public static final Codec<RespawnConfig> a = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.level.World.h.optionalFieldOf("dimension", net.minecraft.world.level.World.i).forGetter(RespawnConfig::a), (App)BlockPosition.a.fieldOf("pos").forGetter(RespawnConfig::b), (App)Codec.FLOAT.optionalFieldOf("angle", (Object)Float.valueOf(0.0f)).forGetter(RespawnConfig::c), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::d)).apply((Applicative)instance, RespawnConfig::new));

        public RespawnConfig(ResourceKey<net.minecraft.world.level.World> dimension, BlockPosition pos, float angle, boolean forced) {
            this.b = dimension;
            this.c = pos;
            this.d = angle;
            this.e = forced;
        }

        static ResourceKey<net.minecraft.world.level.World> b(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null ? entityplayer_respawnconfig.a() : net.minecraft.world.level.World.i;
        }

        public boolean a(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null && this.b == entityplayer_respawnconfig.b && this.c.equals(entityplayer_respawnconfig.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this, o2);
        }

        public ResourceKey<net.minecraft.world.level.World> a() {
            return this.b;
        }

        public BlockPosition b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }

        public boolean d() {
            return this.e;
        }
    }

    public record RespawnPosAngle(Vec3D a, float b, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D vec3d, BlockPosition blockposition, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.b(vec3d, blockposition), isBedSpawn, isAnchorSpawn);
        }

        private static float b(Vec3D vec3d, BlockPosition blockposition) {
            Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
            return (float)MathHelper.d(MathHelper.d(vec3d1.f, vec3d1.d) * 57.2957763671875 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }
}

