/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundMoveMinecartPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger b = LogUtils.getLogger();
    private static final int c = 1;
    private static final double d = 7.62939453125E-6;
    public static final int a = 60;
    private static final int e = 400;
    private final WorldServer f;
    private final Entity g;
    private final int h;
    private final boolean i;
    private final Consumer<Packet<?>> j;
    private final BiConsumer<Packet<?>, List<UUID>> k;
    private final VecDeltaCodec l = new VecDeltaCodec();
    private byte m;
    private byte n;
    private byte o;
    private Vec3D p;
    private int q;
    private int r;
    private List<Entity> s = Collections.emptyList();
    private boolean t;
    private boolean u;
    @Nullable
    private List<DataWatcher.c<?>> v;
    private final Set<ServerPlayerConnection> trackedPlayers;

    public EntityTrackerEntry(WorldServer worldserver, Entity entity, int i2, boolean flag, Consumer<Packet<?>> consumer, BiConsumer<Packet<?>, List<UUID>> biconsumer, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.f = worldserver;
        this.j = consumer;
        this.g = entity;
        this.h = i2;
        this.i = flag;
        this.k = biconsumer;
        this.l.e(entity.dw());
        this.p = entity.dA();
        this.m = MathHelper.g(entity.dP());
        this.n = MathHelper.g(entity.dR());
        this.o = MathHelper.g(entity.cE());
        this.u = entity.aK();
        this.v = entity.au().c();
    }

    public void a() {
        Entity entity;
        List<Entity> list = this.g.da();
        if (!list.equals(this.s)) {
            List<UUID> list1 = this.a(list).map(Entity::cK).toList();
            this.broadcastWithIgnoreAndSend(new PacketPlayOutMount(this.g), list1);
            this.s = list;
        }
        if ((entity = this.g) instanceof EntityItemFrame) {
            MapId mapid;
            WorldMap worldmap;
            EntityItemFrame entityitemframe = (EntityItemFrame)entity;
            ItemStack itemstack = entityitemframe.v();
            if (this.q % 10 == 0 && itemstack.h() instanceof ItemWorldMap && (worldmap = ItemWorldMap.a(mapid = itemstack.a(DataComponents.M), (World)this.f)) != null) {
                for (ServerPlayerConnection connection : this.trackedPlayers) {
                    EntityPlayer entityplayer = connection.o();
                    worldmap.a(entityplayer, itemstack);
                    Packet<?> packet = worldmap.a(mapid, entityplayer);
                    if (packet == null) continue;
                    entityplayer.g.b(packet);
                }
            }
            this.g();
        }
        if (this.q % this.h == 0 || this.g.aE || this.g.au().a()) {
            boolean flag;
            byte b0 = MathHelper.g(this.g.dP());
            byte b1 = MathHelper.g(this.g.dR());
            boolean bl = flag = Math.abs(b0 - this.m) >= 1 || Math.abs(b1 - this.n) >= 1;
            if (this.g.cc()) {
                if (flag) {
                    this.j.accept(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.ar(), b0, b1, this.g.aK()));
                    this.m = b0;
                    this.n = b1;
                }
                this.l.e(this.g.dw());
                this.g();
                this.t = true;
            } else {
                EntityMinecartAbstract entityminecartabstract;
                MinecartBehavior minecartbehavior;
                Entity entity1 = this.g;
                if (entity1 instanceof EntityMinecartAbstract && (minecartbehavior = (entityminecartabstract = (EntityMinecartAbstract)entity1).f()) instanceof NewMinecartBehavior) {
                    NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartbehavior;
                    this.a(newminecartbehavior, b0, b1, flag);
                } else {
                    Vec3D vec3d1;
                    double d0;
                    boolean flag5;
                    ++this.r;
                    Vec3D vec3d = this.g.dw();
                    boolean flag1 = this.l.d(vec3d).h() >= 7.62939453125E-6;
                    Packet<PacketListenerPlayOut> packet1 = null;
                    boolean flag2 = flag1 || this.q % 60 == 0;
                    boolean flag3 = false;
                    boolean flag4 = false;
                    long i2 = this.l.a(vec3d);
                    long j2 = this.l.b(vec3d);
                    long k2 = this.l.c(vec3d);
                    boolean bl2 = flag5 = i2 < -32768L || i2 > 32767L || j2 < -32768L || j2 > 32767L || k2 < -32768L || k2 > 32767L;
                    if (!(this.g.aq() || flag5 || this.r > 400 || this.t || this.u != this.g.aK())) {
                        if (!(flag2 && flag || this.g instanceof EntityArrow)) {
                            if (flag2) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.g.ar(), (short)i2, (short)j2, (short)k2, this.g.aK());
                                flag3 = true;
                            } else if (flag) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.ar(), b0, b1, this.g.aK());
                                flag4 = true;
                            }
                        } else {
                            packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.g.ar(), (short)i2, (short)j2, (short)k2, b0, b1, this.g.aK());
                            flag3 = true;
                            flag4 = true;
                        }
                    } else {
                        this.u = this.g.aK();
                        this.r = 0;
                        packet1 = ClientboundEntityPositionSyncPacket.a(this.g);
                        flag3 = true;
                        flag4 = true;
                    }
                    if ((this.g.aE || this.i || this.g instanceof EntityLiving && ((EntityLiving)this.g).fQ()) && ((d0 = (vec3d1 = this.g.dA()).g(this.p)) > 1.0E-7 || d0 > 0.0 && vec3d1.h() == 0.0)) {
                        this.p = vec3d1;
                        Entity entity2 = this.g;
                        if (entity2 instanceof EntityFireball) {
                            EntityFireball entityfireball = (EntityFireball)entity2;
                            this.j.accept(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new PacketPlayOutEntityVelocity(this.g.ar(), this.p), new ClientboundProjectilePowerPacket(entityfireball.ar(), entityfireball.c))));
                        } else {
                            this.j.accept(new PacketPlayOutEntityVelocity(this.g.ar(), this.p));
                        }
                    }
                    if (packet1 != null) {
                        this.j.accept(packet1);
                    }
                    this.g();
                    if (flag3) {
                        this.l.e(vec3d);
                    }
                    if (flag4) {
                        this.m = b0;
                        this.n = b1;
                    }
                    this.t = false;
                }
            }
            byte b2 = MathHelper.g(this.g.cE());
            if (Math.abs(b2 - this.o) >= 1) {
                this.j.accept(new PacketPlayOutEntityHeadRotation(this.g, b2));
                this.o = b2;
            }
            this.g.aE = false;
        }
        ++this.q;
        if (this.g.ag) {
            boolean cancelled = false;
            if (this.g instanceof EntityPlayer) {
                Player player = (Player)this.g.getBukkitEntity();
                Vector velocity = player.getVelocity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                this.g.ai().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player.setVelocity(event.getVelocity());
                }
            }
            if (cancelled) {
                return;
            }
            this.g.ag = false;
            this.a(new PacketPlayOutEntityVelocity(this.g));
        }
    }

    private Stream<Entity> a(List<Entity> list) {
        return Streams.concat((Stream[])new Stream[]{this.s.stream().filter(entity -> !list.contains(entity)), list.stream().filter(entity -> !this.s.contains(entity))});
    }

    private void a(NewMinecartBehavior newminecartbehavior, byte b0, byte b1, boolean flag) {
        this.g();
        if (newminecartbehavior.e.isEmpty()) {
            boolean flag2;
            Vec3D vec3d = this.g.dA();
            double d0 = vec3d.g(this.p);
            Vec3D vec3d1 = this.g.dw();
            boolean flag1 = this.l.d(vec3d1).h() >= 7.62939453125E-6;
            boolean bl = flag2 = flag1 || this.q % 60 == 0;
            if (flag2 || flag || d0 > 1.0E-7) {
                this.j.accept(new ClientboundMoveMinecartPacket(this.g.ar(), List.of(new NewMinecartBehavior.a(this.g.dv(), this.g.dA(), this.g.dP(), this.g.dR(), 1.0f))));
            }
        } else {
            this.j.accept(new ClientboundMoveMinecartPacket(this.g.ar(), List.copyOf(newminecartbehavior.e)));
            newminecartbehavior.e.clear();
        }
        this.m = b0;
        this.n = b1;
        this.l.e(this.g.dv());
    }

    public void a(EntityPlayer entityplayer) {
        this.g.e(entityplayer);
        entityplayer.g.b(new PacketPlayOutEntityDestroy(this.g.ar()));
    }

    public void b(EntityPlayer entityplayer) {
        ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
        Objects.requireNonNull(list);
        this.a(entityplayer, list::add);
        entityplayer.g.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        this.g.d(entityplayer);
    }

    public void a(EntityPlayer entityplayer, Consumer<Packet<PacketListenerPlayOut>> consumer) {
        Leashable leashable;
        Entity entity;
        if (this.g.dU()) {
            return;
        }
        Packet<PacketListenerPlayOut> packet = this.g.a(this);
        consumer.accept(packet);
        if (this.v != null) {
            consumer.accept(new PacketPlayOutEntityMetadata(this.g.ar(), this.v));
        }
        if ((entity = this.g) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            Collection<AttributeModifiable> collection = entityliving.fg().c();
            if (this.g.ar() == entityplayer.ar()) {
                ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(collection, false);
            }
            if (!collection.isEmpty()) {
                consumer.accept(new PacketPlayOutUpdateAttributes(this.g.ar(), collection));
            }
        }
        if ((entity = this.g) instanceof EntityLiving) {
            EntityLiving entityliving1 = (EntityLiving)entity;
            ArrayList list = Lists.newArrayList();
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                ItemStack itemstack = entityliving1.a(enumitemslot);
                if (itemstack.f()) continue;
                list.add(Pair.of((Object)enumitemslot, (Object)itemstack.v()));
            }
            if (!list.isEmpty()) {
                consumer.accept(new PacketPlayOutEntityEquipment(this.g.ar(), list));
            }
            ((EntityLiving)this.g).detectEquipmentUpdatesPublic();
        }
        if (!this.g.da().isEmpty()) {
            consumer.accept(new PacketPlayOutMount(this.g));
        }
        if (this.g.cc()) {
            consumer.accept(new PacketPlayOutMount(this.g.dm()));
        }
        if ((entity = this.g) instanceof Leashable && (leashable = (Leashable)((Object)entity)).R_()) {
            consumer.accept(new PacketPlayOutAttachEntity(this.g, leashable.aj_()));
        }
    }

    public Vec3D b() {
        return this.l.a();
    }

    public Vec3D c() {
        return this.p;
    }

    public float d() {
        return MathHelper.a(this.n);
    }

    public float e() {
        return MathHelper.a(this.m);
    }

    public float f() {
        return MathHelper.a(this.o);
    }

    private void g() {
        DataWatcher datawatcher = this.g.au();
        List<DataWatcher.c<?>> list = datawatcher.b();
        if (list != null) {
            this.v = datawatcher.c();
            this.a(new PacketPlayOutEntityMetadata(this.g.ar(), list));
        }
        if (this.g instanceof EntityLiving) {
            Set<AttributeModifiable> set = ((EntityLiving)this.g).fg().a();
            if (!set.isEmpty()) {
                if (this.g instanceof EntityPlayer) {
                    ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(set, false);
                }
                this.a(new PacketPlayOutUpdateAttributes(this.g.ar(), set));
            }
            set.clear();
        }
    }

    private void a(Packet<?> packet) {
        this.j.accept(packet);
        if (this.g instanceof EntityPlayer) {
            ((EntityPlayer)this.g).g.b(packet);
        }
    }

    private void broadcastWithIgnoreAndSend(Packet<?> packet, List<UUID> list) {
        this.k.accept(packet, list);
        if (this.g instanceof EntityPlayer) {
            ((EntityPlayer)this.g).g.b(packet);
        }
    }
}

