/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class PlayerChunk
extends GenerationChunkHolder {
    public static final ChunkResult<Chunk> a = ChunkResult.a("Unloaded level chunk");
    private static final CompletableFuture<ChunkResult<Chunk>> e = CompletableFuture.completedFuture(a);
    private final LevelHeightAccessor f;
    private volatile CompletableFuture<ChunkResult<Chunk>> g = e;
    private volatile CompletableFuture<ChunkResult<Chunk>> h = e;
    private volatile CompletableFuture<ChunkResult<Chunk>> i = e;
    public int j;
    private int k;
    private int l;
    private boolean m;
    private final ShortSet[] n;
    private final BitSet o = new BitSet();
    private final BitSet p = new BitSet();
    private final LevelLightEngine q;
    private final a r;
    public final b s;
    private boolean t;
    private CompletableFuture<?> u = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> v = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> w = CompletableFuture.completedFuture(null);

    public PlayerChunk(ChunkCoordIntPair chunkcoordintpair, int i2, LevelHeightAccessor levelheightaccessor, LevelLightEngine levellightengine, a playerchunk_a, b playerchunk_b) {
        super(chunkcoordintpair);
        this.f = levelheightaccessor;
        this.q = levellightengine;
        this.r = playerchunk_a;
        this.s = playerchunk_b;
        this.k = this.j = ChunkLevel.b + 1;
        this.l = this.j;
        this.a(i2);
        this.n = new ShortSet[levelheightaccessor.ap()];
    }

    public Chunk getFullChunkNow() {
        if (!ChunkLevel.c(this.j).a(FullChunkStatus.b)) {
            return null;
        }
        return this.getFullChunkNowUnchecked();
    }

    public Chunk getFullChunkNowUnchecked() {
        return (Chunk)this.a(ChunkStatus.n);
    }

    public CompletableFuture<ChunkResult<Chunk>> a() {
        return this.h;
    }

    public CompletableFuture<ChunkResult<Chunk>> b() {
        return this.i;
    }

    public CompletableFuture<ChunkResult<Chunk>> c() {
        return this.g;
    }

    @Nullable
    public Chunk d() {
        return this.a().getNow(a).b((Chunk)null);
    }

    @Nullable
    public Chunk e() {
        return !this.v.isDone() ? null : this.d();
    }

    public CompletableFuture<?> f() {
        return this.v;
    }

    public void a(CompletableFuture<?> completablefuture) {
        this.v = this.v.isDone() ? completablefuture : this.v.thenCombine(completablefuture, (object, object1) -> null);
    }

    public CompletableFuture<?> g() {
        return this.w;
    }

    public boolean h() {
        return this.w.isDone();
    }

    @Override
    protected void b(CompletableFuture<?> completablefuture) {
        this.w = this.w.isDone() ? completablefuture : this.w.thenCombine(completablefuture, (object, object1) -> null);
    }

    public boolean a(BlockPosition blockposition) {
        Chunk chunk = this.d();
        if (chunk == null) {
            return false;
        }
        boolean flag = this.m;
        int i2 = this.f.f(blockposition.v());
        if (i2 < 0 || i2 >= this.n.length) {
            return false;
        }
        if (this.n[i2] == null) {
            this.m = true;
            this.n[i2] = new ShortOpenHashSet();
        }
        this.n[i2].add(SectionPosition.b(blockposition));
        return !flag;
    }

    public boolean a(EnumSkyBlock enumskyblock, int i2) {
        IChunkAccess ichunkaccess = this.b(ChunkStatus.k);
        if (ichunkaccess == null) {
            return false;
        }
        ichunkaccess.i();
        Chunk chunk = this.d();
        if (chunk == null) {
            return false;
        }
        int j2 = this.q.d();
        int k2 = this.q.e();
        if (i2 >= j2 && i2 <= k2) {
            int l2;
            BitSet bitset = enumskyblock == EnumSkyBlock.a ? this.p : this.o;
            if (!bitset.get(l2 = i2 - j2)) {
                bitset.set(l2);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean i() {
        return this.m || !this.p.isEmpty() || !this.o.isEmpty();
    }

    public void a(Chunk chunk) {
        if (this.i()) {
            World world = chunk.I();
            if (!this.p.isEmpty() || !this.o.isEmpty()) {
                List<EntityPlayer> list = this.s.a(this.d, true);
                if (!list.isEmpty()) {
                    PacketPlayOutLightUpdate packetplayoutlightupdate = new PacketPlayOutLightUpdate(chunk.f(), this.q, this.p, this.o);
                    this.a(list, packetplayoutlightupdate);
                }
                this.p.clear();
                this.o.clear();
            }
            if (this.m) {
                List<EntityPlayer> list1 = this.s.a(this.d, false);
                for (int i2 = 0; i2 < this.n.length; ++i2) {
                    ShortSet shortset = this.n[i2];
                    if (shortset == null) continue;
                    this.n[i2] = null;
                    if (list1.isEmpty()) continue;
                    int j2 = this.f.h(i2);
                    SectionPosition sectionposition = SectionPosition.a(chunk.f(), j2);
                    if (shortset.size() == 1) {
                        BlockPosition blockposition = sectionposition.g(shortset.iterator().nextShort());
                        IBlockData iblockdata = world.a_(blockposition);
                        this.a(list1, new PacketPlayOutBlockChange(blockposition, iblockdata));
                        this.a(list1, world, blockposition, iblockdata);
                        continue;
                    }
                    ChunkSection chunksection = chunk.b(i2);
                    PacketPlayOutMultiBlockChange packetplayoutmultiblockchange = new PacketPlayOutMultiBlockChange(sectionposition, shortset, chunksection);
                    this.a(list1, packetplayoutmultiblockchange);
                    packetplayoutmultiblockchange.a((BlockPosition blockposition1, IBlockData iblockdata1) -> this.a(list1, world, (BlockPosition)blockposition1, (IBlockData)iblockdata1));
                }
                this.m = false;
            }
        }
    }

    private void a(List<EntityPlayer> list, World world, BlockPosition blockposition, IBlockData iblockdata) {
        if (iblockdata.x()) {
            this.a(list, world, blockposition);
        }
    }

    private void a(List<EntityPlayer> list, World world, BlockPosition blockposition) {
        Packet<PacketListenerPlayOut> packet;
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity != null && (packet = tileentity.ax_()) != null) {
            this.a(list, packet);
        }
    }

    private void a(List<EntityPlayer> list, Packet<?> packet) {
        list.forEach(entityplayer -> entityplayer.g.b(packet));
    }

    @Override
    public int j() {
        return this.k;
    }

    @Override
    public int k() {
        return this.l;
    }

    private void b(int i2) {
        this.l = i2;
    }

    public void a(int i2) {
        this.k = i2;
    }

    private void a(PlayerChunkMap playerchunkmap, CompletableFuture<ChunkResult<Chunk>> completablefuture, Executor executor, FullChunkStatus fullchunkstatus) {
        this.u.cancel(false);
        CompletableFuture completablefuture1 = new CompletableFuture();
        completablefuture1.thenRunAsync(() -> playerchunkmap.a(this.d, fullchunkstatus), executor);
        this.u = completablefuture1;
        completablefuture.thenAccept(chunkresult -> chunkresult.a((T chunk) -> completablefuture1.complete(null)));
    }

    private void a(PlayerChunkMap playerchunkmap, FullChunkStatus fullchunkstatus) {
        this.u.cancel(false);
        playerchunkmap.a(this.d, fullchunkstatus);
    }

    protected void callEventIfUnloading(PlayerChunkMap playerchunkmap) {
        FullChunkStatus oldFullChunkStatus = ChunkLevel.c(this.j);
        FullChunkStatus newFullChunkStatus = ChunkLevel.c(this.k);
        boolean oldIsFull = oldFullChunkStatus.a(FullChunkStatus.b);
        boolean newIsFull = newFullChunkStatus.a(FullChunkStatus.b);
        if (oldIsFull && !newIsFull) {
            ((CompletableFuture)this.c().thenAccept(either -> {
                Chunk chunk = either.b(null);
                if (chunk != null) {
                    playerchunkmap.callbackExecutor.execute(() -> {
                        chunk.i();
                        chunk.unloadCallback();
                    });
                }
            })).exceptionally(throwable -> {
                MinecraftServer.l.error("Failed to schedule unload callback for chunk " + String.valueOf(this.d), throwable);
                return null;
            });
            playerchunkmap.callbackExecutor.run();
        }
    }

    protected void a(PlayerChunkMap playerchunkmap, Executor executor) {
        FullChunkStatus fullchunkstatus = ChunkLevel.c(this.j);
        FullChunkStatus fullchunkstatus1 = ChunkLevel.c(this.k);
        boolean flag = fullchunkstatus.a(FullChunkStatus.b);
        boolean flag1 = fullchunkstatus1.a(FullChunkStatus.b);
        this.t |= flag1;
        if (!flag && flag1) {
            this.g = playerchunkmap.c(this);
            this.a(playerchunkmap, this.g, executor, FullChunkStatus.b);
            this.b(this.g);
        }
        if (flag && !flag1) {
            this.g.complete(a);
            this.g = e;
        }
        boolean flag2 = fullchunkstatus.a(FullChunkStatus.c);
        boolean flag3 = fullchunkstatus1.a(FullChunkStatus.c);
        if (!flag2 && flag3) {
            this.h = playerchunkmap.b(this);
            this.a(playerchunkmap, this.h, executor, FullChunkStatus.c);
            this.b(this.h);
        }
        if (flag2 && !flag3) {
            this.h.complete(a);
            this.h = e;
        }
        boolean flag4 = fullchunkstatus.a(FullChunkStatus.d);
        boolean flag5 = fullchunkstatus1.a(FullChunkStatus.d);
        if (!flag4 && flag5) {
            if (this.i != e) {
                throw SystemUtils.b(new IllegalStateException());
            }
            this.i = playerchunkmap.a(this);
            this.a(playerchunkmap, this.i, executor, FullChunkStatus.d);
            this.b(this.i);
        }
        if (flag4 && !flag5) {
            this.i.complete(a);
            this.i = e;
        }
        if (!fullchunkstatus1.a(fullchunkstatus)) {
            this.a(playerchunkmap, fullchunkstatus1);
        }
        this.r.onLevelChange(this.d, this::k, this.k, this::b);
        this.j = this.k;
        if (!fullchunkstatus.a(FullChunkStatus.b) && fullchunkstatus1.a(FullChunkStatus.b)) {
            ((CompletableFuture)this.c().thenAccept(either -> {
                Chunk chunk = either.b(null);
                if (chunk != null) {
                    playerchunkmap.callbackExecutor.execute(() -> chunk.loadCallback());
                }
            })).exceptionally(throwable -> {
                MinecraftServer.l.error("Failed to schedule load callback for chunk " + String.valueOf(this.d), throwable);
                return null;
            });
            playerchunkmap.callbackExecutor.run();
        }
    }

    public boolean l() {
        return this.t;
    }

    public void m() {
        this.t = ChunkLevel.c(this.k).a(FullChunkStatus.b);
    }

    @FunctionalInterface
    public static interface a {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface b {
        public List<EntityPlayer> a(ChunkCoordIntPair var1, boolean var2);
    }
}

