/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import org.slf4j.Logger;

public class ParticleUnflatteningFix
extends DataFix {
    private static final Logger a = LogUtils.getLogger();

    public ParticleUnflatteningFix(Schema var0) {
        super(var0, true);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.z);
        Type var1 = this.getOutputSchema().getType(DataConverterTypes.z);
        return this.writeFixAndRead("ParticleUnflatteningFix", var0, var1, this::a);
    }

    private <T> Dynamic<T> a(Dynamic<T> var0) {
        Optional var1 = var0.asString().result();
        if (var1.isEmpty()) {
            return var0;
        }
        String var2 = (String)var1.get();
        String[] var3 = var2.split(" ", 2);
        String var4 = DataConverterSchemaNamed.a(var3[0]);
        Dynamic<T> var5 = var0.createMap(Map.of(var0.createString("type"), var0.createString(var4)));
        return switch (var4) {
            case "minecraft:item" -> {
                if (var3.length > 1) {
                    yield this.a(var5, var3[1]);
                }
                yield var5;
            }
            case "minecraft:block", "minecraft:block_marker", "minecraft:falling_dust", "minecraft:dust_pillar" -> {
                if (var3.length > 1) {
                    yield this.b(var5, var3[1]);
                }
                yield var5;
            }
            case "minecraft:dust" -> {
                if (var3.length > 1) {
                    yield this.d(var5, var3[1]);
                }
                yield var5;
            }
            case "minecraft:dust_color_transition" -> {
                if (var3.length > 1) {
                    yield this.e(var5, var3[1]);
                }
                yield var5;
            }
            case "minecraft:sculk_charge" -> {
                if (var3.length > 1) {
                    yield this.f(var5, var3[1]);
                }
                yield var5;
            }
            case "minecraft:vibration" -> {
                if (var3.length > 1) {
                    yield this.g(var5, var3[1]);
                }
                yield var5;
            }
            case "minecraft:shriek" -> {
                if (var3.length > 1) {
                    yield this.h(var5, var3[1]);
                }
                yield var5;
            }
            default -> var5;
        };
    }

    private <T> Dynamic<T> a(Dynamic<T> var0, String var1) {
        int var2 = var1.indexOf("{");
        Dynamic var3 = var0.createMap(Map.of(var0.createString("Count"), var0.createInt(1)));
        if (var2 == -1) {
            var3 = var3.set("id", var0.createString(var1));
        } else {
            var3 = var3.set("id", var0.createString(var1.substring(0, var2)));
            Dynamic<T> var4 = ParticleUnflatteningFix.a(var0.getOps(), var1.substring(var2));
            if (var4 != null) {
                var3 = var3.set("tag", var4);
            }
        }
        return var0.set("item", var3);
    }

    @Nullable
    private static <T> Dynamic<T> a(DynamicOps<T> var0, String var1) {
        try {
            return new Dynamic(var0, MojangsonParser.a(var0).b(var1));
        }
        catch (Exception var2) {
            a.warn("Failed to parse tag: {}", (Object)var1, (Object)var2);
            return null;
        }
    }

    private <T> Dynamic<T> b(Dynamic<T> var0, String var1) {
        int var2 = var1.indexOf("[");
        Dynamic var3 = var0.emptyMap();
        if (var2 == -1) {
            var3 = var3.set("Name", var0.createString(DataConverterSchemaNamed.a(var1)));
        } else {
            var3 = var3.set("Name", var0.createString(DataConverterSchemaNamed.a(var1.substring(0, var2))));
            Map<Dynamic<T>, Dynamic<T>> var4 = ParticleUnflatteningFix.c(var0, var1.substring(var2));
            if (!var4.isEmpty()) {
                var3 = var3.set("Properties", var0.createMap(var4));
            }
        }
        return var0.set("block_state", var3);
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> c(Dynamic<T> var0, String var1) {
        try {
            HashMap<Dynamic<T>, Dynamic<T>> var2 = new HashMap<Dynamic<T>, Dynamic<T>>();
            StringReader var3 = new StringReader(var1);
            var3.expect('[');
            var3.skipWhitespace();
            while (var3.canRead() && var3.peek() != ']') {
                var3.skipWhitespace();
                String var4 = var3.readString();
                var3.skipWhitespace();
                var3.expect('=');
                var3.skipWhitespace();
                String var5 = var3.readString();
                var3.skipWhitespace();
                var2.put(var0.createString(var4), var0.createString(var5));
                if (!var3.canRead()) continue;
                if (var3.peek() != ',') break;
                var3.skip();
            }
            var3.expect(']');
            return var2;
        }
        catch (Exception var2) {
            a.warn("Failed to parse block properties: {}", (Object)var1, (Object)var2);
            return Map.of();
        }
    }

    private static <T> Dynamic<T> a(Dynamic<T> var0, StringReader var1) throws CommandSyntaxException {
        float var2 = var1.readFloat();
        var1.expect(' ');
        float var3 = var1.readFloat();
        var1.expect(' ');
        float var4 = var1.readFloat();
        return var0.createList(Stream.of(Float.valueOf(var2), Float.valueOf(var3), Float.valueOf(var4)).map(arg_0 -> var0.createFloat(arg_0)));
    }

    private <T> Dynamic<T> d(Dynamic<T> var0, String var1) {
        try {
            StringReader var2 = new StringReader(var1);
            Dynamic<T> var3 = ParticleUnflatteningFix.a(var0, var2);
            var2.expect(' ');
            float var4 = var2.readFloat();
            return var0.set("color", var3).set("scale", var0.createFloat(var4));
        }
        catch (Exception var2) {
            a.warn("Failed to parse particle options: {}", (Object)var1, (Object)var2);
            return var0;
        }
    }

    private <T> Dynamic<T> e(Dynamic<T> var0, String var1) {
        try {
            StringReader var2 = new StringReader(var1);
            Dynamic<T> var3 = ParticleUnflatteningFix.a(var0, var2);
            var2.expect(' ');
            float var4 = var2.readFloat();
            var2.expect(' ');
            Dynamic<T> var5 = ParticleUnflatteningFix.a(var0, var2);
            return var0.set("from_color", var3).set("to_color", var5).set("scale", var0.createFloat(var4));
        }
        catch (Exception var2) {
            a.warn("Failed to parse particle options: {}", (Object)var1, (Object)var2);
            return var0;
        }
    }

    private <T> Dynamic<T> f(Dynamic<T> var0, String var1) {
        try {
            StringReader var2 = new StringReader(var1);
            float var3 = var2.readFloat();
            return var0.set("roll", var0.createFloat(var3));
        }
        catch (Exception var2) {
            a.warn("Failed to parse particle options: {}", (Object)var1, (Object)var2);
            return var0;
        }
    }

    private <T> Dynamic<T> g(Dynamic<T> var0, String var1) {
        try {
            StringReader var2 = new StringReader(var1);
            float var3 = (float)var2.readDouble();
            var2.expect(' ');
            float var4 = (float)var2.readDouble();
            var2.expect(' ');
            float var5 = (float)var2.readDouble();
            var2.expect(' ');
            int var6 = var2.readInt();
            Dynamic var7 = var0.createIntList(IntStream.of(MathHelper.d(var3), MathHelper.d(var4), MathHelper.d(var5)));
            Dynamic var8 = var0.createMap(Map.of(var0.createString("type"), var0.createString("minecraft:block"), var0.createString("pos"), var7));
            return var0.set("destination", var8).set("arrival_in_ticks", var0.createInt(var6));
        }
        catch (Exception var2) {
            a.warn("Failed to parse particle options: {}", (Object)var1, (Object)var2);
            return var0;
        }
    }

    private <T> Dynamic<T> h(Dynamic<T> var0, String var1) {
        try {
            StringReader var2 = new StringReader(var1);
            int var3 = var2.readInt();
            return var0.set("delay", var0.createInt(var3));
        }
        catch (Exception var2) {
            a.warn("Failed to parse particle options: {}", (Object)var1, (Object)var2);
            return var0;
        }
    }
}

