/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R5.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R5.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable,
WaypointTransmitter {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    public static final String l = "attributes";
    public static final String m = "sleeping_pos";
    public static final String n = "equipment";
    public static final String o = "Brain";
    public static final String p = "FallFlying";
    public static final String q = "HurtTime";
    public static final String r = "DeathTime";
    public static final String s = "HurtByTimestamp";
    public static final String t = "Health";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier e = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int u = 98;
    public static final int aM = 100;
    public static final int aN = 105;
    public static final int aO = 106;
    public static final int aP = 6;
    public static final int aQ = 100;
    private static final int bQ = 40;
    public static final double aR = 0.003;
    public static final double aS = 0.08;
    public static final int aT = 20;
    protected static final float aU = 0.98f;
    private static final int bR = 10;
    private static final int bS = 2;
    public static final float aV = 0.42f;
    private static final double bT = 128.0;
    protected static final int aW = 1;
    protected static final int aX = 2;
    public static final int aY = 4;
    protected static final DataWatcherObject<Byte> aZ = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> bU = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> bV = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bZ = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int ca = 15;
    protected static final EntitySize ba = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float bb = 0.5f;
    public static final float bc = 0.5f;
    public static final Predicate<EntityLiving> bd = entityliving -> {
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            ItemStack itemstack = entityhuman.a(EnumItemSlot.f);
            return !itemstack.a(TagsItem.cw);
        }
        return true;
    };
    private static final Dynamic<?> cb = new Dynamic((DynamicOps)JavaOps.INSTANCE, Map.of("memories", Map.of()));
    private final AttributeMapBase cc;
    public CombatTracker cd = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> ce = Maps.newHashMap();
    private final Map<EnumItemSlot, ItemStack> cf = SystemUtils.a(EnumItemSlot.class, (K enumitemslot) -> ItemStack.l);
    public boolean be;
    private boolean cg = false;
    public EnumHand bf;
    public int bg;
    public int bh;
    public int bi;
    public int bj;
    public int bk;
    public int bl;
    public float bm;
    public float bn;
    protected int bo;
    public final WalkAnimationState bp = new WalkAnimationState();
    public int bq = 20;
    public float br;
    public float bs;
    public float bt;
    public float bu;
    public final ElytraAnimationState bv = new ElytraAnimationState(this);
    @Nullable
    public EntityReference<EntityHuman> bw;
    protected int bx;
    protected boolean by;
    protected int bz;
    public float bA;
    protected boolean bB;
    public float bC;
    public float bD;
    public float bE;
    protected InterpolationHandler bF = new InterpolationHandler(this);
    protected double bG;
    protected int bH;
    public boolean ch = true;
    @Nullable
    public EntityReference<EntityLiving> ci;
    public int cj;
    @Nullable
    private EntityLiving ck;
    private int cl;
    private float cm;
    private int cn;
    private float co;
    protected ItemStack bI;
    public int bJ;
    protected int bK;
    private BlockPosition cp;
    private Optional<BlockPosition> cq;
    @Nullable
    private DamageSource cr;
    private long cs;
    protected int bL;
    protected float bM;
    @Nullable
    protected ItemStack bN;
    private float ct;
    private float cu;
    protected BehaviorController<?> bO;
    protected boolean cv;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> cw;
    public final EntityEquipment bP;
    private Waypoint.a cx;
    public int expToDrop;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();

    @Override
    public float getBukkitYaw() {
        return this.cE();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bz;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> entitytypes, net.minecraft.world.level.World world) {
        super(entitytypes, world);
        this.bI = ItemStack.l;
        this.cq = Optional.empty();
        this.cw = new EnumMap(EnumItemSlot.class);
        this.cx = new Waypoint.a();
        this.cc = new AttributeMapBase(AttributeDefaults.a(entitytypes));
        this.craftAttributes = new CraftAttributeMap(this.cc);
        this.ay.a(bU, Float.valueOf((float)this.h(GenericAttributes.t).g()));
        this.bP = this.eg();
        this.V = true;
        this.ay();
        this.v((float)(Math.random() * 6.2831854820251465));
        this.bt = this.dP();
        this.bO = this.a(cb);
    }

    @Contract(pure=true)
    protected EntityEquipment eg() {
        return new EntityEquipment();
    }

    public BehaviorController<?> eh() {
        return this.bO;
    }

    protected BehaviorController.b<?> ei() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.ei().a(dynamic);
    }

    @Override
    public void c(WorldServer worldserver) {
        this.a(worldserver, this.ea().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entitytypes) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(aZ, (byte)0);
        datawatcher_a.a(bV, List.of());
        datawatcher_a.a(bW, false);
        datawatcher_a.a(bX, 0);
        datawatcher_a.a(bY, 0);
        datawatcher_a.a(bU, Float.valueOf(1.0f));
        datawatcher_a.a(bZ, Optional.empty());
    }

    public static AttributeProvider.Builder ej() {
        return AttributeProvider.a().a(GenericAttributes.t).a(GenericAttributes.q).a(GenericAttributes.w).a(GenericAttributes.a).a(GenericAttributes.b).a(GenericAttributes.s).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.o).a(GenericAttributes.y).a(GenericAttributes.l).a(GenericAttributes.p).a(GenericAttributes.x).a(GenericAttributes.h).a(GenericAttributes.j).a(GenericAttributes.G).a(GenericAttributes.v).a(GenericAttributes.d).a(GenericAttributes.i).a(GenericAttributes.H);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        net.minecraft.world.level.World world;
        if (!this.bm()) {
            this.bu();
        }
        if ((world = this.ai()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (flag && this.am > 0.0) {
                this.b(worldserver, blockposition);
                double d1 = Math.max(0, MathHelper.a(this.h(this.am)));
                if (d1 > 0.0 && !iblockdata.l()) {
                    double d2 = this.dC();
                    double d3 = this.dE();
                    double d4 = this.dI();
                    BlockPosition blockposition1 = this.dx();
                    if (blockposition.u() != blockposition1.u() || blockposition.w() != blockposition1.w()) {
                        double d5 = d2 - (double)blockposition.u() - 0.5;
                        double d6 = d4 - (double)blockposition.w() - 0.5;
                        double d7 = Math.max(Math.abs(d5), Math.abs(d6));
                        d2 = (double)blockposition.u() + 0.5 + d5 / d7 * 0.5;
                        d4 = (double)blockposition.w() + 0.5 + d6 / d7 * 0.5;
                    }
                    double d8 = Math.min((double)0.2f + d1 / 15.0, 2.5);
                    int i2 = (int)(150.0 * d8);
                    if (this instanceof EntityPlayer) {
                        worldserver.sendParticlesSource((EntityPlayer)this, new ParticleParamBlock(Particles.b, iblockdata), false, false, d2, d3, d4, i2, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        worldserver.a(new ParticleParamBlock(Particles.b, iblockdata), d2, d3, d4, i2, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
            }
        }
        super.a(d0, flag, iblockdata, blockposition);
        if (flag) {
            this.cq = Optional.empty();
        }
    }

    public boolean ek() {
        return this.ap().a(TagsEntity.m);
    }

    public float b(float f2) {
        return MathHelper.h(f2, this.cu, this.ct);
    }

    public boolean el() {
        return this.dA().b() < (double)1.0E-5f && this.bp();
    }

    @Override
    public void az() {
        EntityLiving entityliving;
        net.minecraft.world.level.World world;
        WorldServer worldserver;
        this.bm = this.bn;
        if (this.ax) {
            this.fW().ifPresent(this::a);
        }
        if ((worldserver = (WorldServer)this.ai()) instanceof WorldServer) {
            WorldServer worldserver1 = worldserver;
            EnchantmentManager.b(worldserver1, this);
        }
        super.az();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("livingEntityBaseTick");
        if (this.bl() || this.ai().C) {
            this.aI();
        }
        if (this.bO() && (world = this.ai()) instanceof WorldServer) {
            double d1;
            double d0;
            worldserver = (WorldServer)world;
            boolean flag = this instanceof EntityHuman;
            if (this.bP()) {
                this.a(worldserver, this.ea().g(), 1.0f);
            } else if (flag && !worldserver.F_().a(this.cV()) && (d0 = worldserver.F_().a(this) + worldserver.F_().n()) < 0.0 && (d1 = worldserver.F_().o()) > 0.0) {
                this.a(worldserver, this.ea().x(), (float)Math.max(1, MathHelper.a(-d0 * d1)));
            }
            if (((Entity)this).a(TagsFluid.a) && !worldserver.a_(BlockPosition.a(this.dC(), this.dG(), this.dI())).a(Blocks.nK)) {
                boolean flag1;
                boolean bl = flag1 = !this.ek() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gt().a);
                if (flag1) {
                    this.j(this.l(this.cw()));
                    if (this.cw() == -20) {
                        this.j(0);
                        worldserver.a((Entity)this, (byte)67);
                        this.a(worldserver, this.ea().i(), 2.0f);
                    }
                } else if (this.cw() < this.cv()) {
                    this.j(this.m(this.cw()));
                }
                if (this.cc() && this.dm() != null && this.dm().ce()) {
                    this.bS();
                }
            } else if (this.cw() < this.cv()) {
                this.j(this.m(this.cw()));
            }
            BlockPosition blockposition = this.dx();
            if (!com.google.common.base.Objects.equal((Object)this.cp, (Object)blockposition)) {
                this.cp = blockposition;
                this.b(worldserver, blockposition);
            }
        }
        if (this.bj > 0) {
            --this.bj;
        }
        if (this.aw > 0 && !(this instanceof EntityPlayer)) {
            --this.aw;
        }
        if (this.eM() && this.ai().h(this)) {
            this.es();
        }
        if (this.bx > 0) {
            --this.bx;
        } else {
            this.bw = null;
        }
        if (this.ck != null && !this.ck.bO()) {
            this.ck = null;
        }
        if ((entityliving = this.ew()) != null) {
            if (!entityliving.bO()) {
                this.a((EntityLiving)null);
            } else if (this.as - this.cj > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.eD();
        this.bu = this.bt;
        this.bs = this.br;
        this.aa = this.dP();
        this.ab = this.dR();
        gameprofilerfiller.c();
    }

    @Override
    protected float aW() {
        return MathHelper.h((float)this.i(GenericAttributes.v), super.aW(), 1.0f);
    }

    public float em() {
        return 0.0f;
    }

    protected void en() {
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
        if (attributemodifiable != null && attributemodifiable.a(c) != null) {
            attributemodifiable.c(c);
        }
    }

    protected void eo() {
        int i2;
        if (!this.bw().l() && (i2 = this.cy()) > 0) {
            AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.cz();
            attributemodifiable.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        EnchantmentManager.a(worldserver, this);
    }

    public boolean g_() {
        return false;
    }

    public float ep() {
        return this.g_() ? 0.5f : 1.0f;
    }

    public final float eq() {
        AttributeMapBase attributemapbase = this.fg();
        return attributemapbase == null ? 1.0f : this.c((float)attributemapbase.c(GenericAttributes.z));
    }

    protected float c(float f2) {
        return f2;
    }

    public boolean er() {
        return true;
    }

    protected void es() {
        ++this.bl;
        if (this.bl >= 20 && !this.ai().B_() && !this.dU()) {
            this.ai().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean et() {
        return !this.g_();
    }

    protected boolean eu() {
        return !this.g_();
    }

    protected int l(int i2) {
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
        double d0 = attributemodifiable != null ? attributemodifiable.g() : 0.0;
        return d0 > 0.0 && this.ar.j() >= 1.0 / (d0 + 1.0) ? i2 : i2 - 1;
    }

    protected int m(int i2) {
        return Math.min(i2 + 4, this.cv());
    }

    public final int a(WorldServer worldserver, @Nullable Entity entity) {
        return EnchantmentManager.a(worldserver, entity, (Entity)this, this.e(worldserver));
    }

    protected int e(WorldServer worldserver) {
        return 0;
    }

    protected boolean ev() {
        return false;
    }

    @Nullable
    public EntityLiving ew() {
        return EntityReference.a(this.ci, this.ai(), EntityLiving.class);
    }

    @Nullable
    public EntityHuman ex() {
        return EntityReference.a(this.bw, this.ai(), EntityHuman.class);
    }

    @Override
    public EntityLiving ak() {
        return this.ew();
    }

    public int ey() {
        return this.cj;
    }

    public void a(EntityHuman entityhuman, int i2) {
        this.a(new EntityReference<EntityHuman>(entityhuman), i2);
    }

    public void a(UUID uuid, int i2) {
        this.a(new EntityReference<EntityHuman>(uuid), i2);
    }

    private void a(EntityReference<EntityHuman> entityreference, int i2) {
        this.bw = entityreference;
        this.bx = i2;
    }

    public void a(@Nullable EntityLiving entityliving) {
        this.ci = entityliving != null ? new EntityReference<EntityLiving>(entityliving) : null;
        this.cj = this.as;
    }

    @Nullable
    public EntityLiving ez() {
        return this.ck;
    }

    public int eA() {
        return this.cl;
    }

    public void C(Entity entity) {
        this.ck = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.cl = this.as;
    }

    public int eB() {
        return this.bz;
    }

    public void n(int i2) {
        this.bz = i2;
    }

    public boolean eC() {
        return this.cg;
    }

    public void r(boolean flag) {
        this.cg = flag;
    }

    protected boolean b(EnumItemSlot enumitemslot) {
        return true;
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1) {
        this.onEquipItem(enumitemslot, itemstack, itemstack1, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        if (!(this.ai().B_() || this.am() || ItemStack.c(itemstack, itemstack1) || this.ax)) {
            Equippable equippable = itemstack1.a(DataComponents.D);
            if (!this.be() && equippable != null && enumitemslot == equippable.b() && !silent) {
                this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), this.a(enumitemslot, itemstack1, equippable), this.do(), 1.0f, 1.0f, this.ar.g());
            }
            if (this.b(enumitemslot)) {
                this.c(equippable != null ? GameEvent.v : GameEvent.S);
            }
        }
    }

    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return equippable.c();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        net.minecraft.world.level.World world;
        if ((entity_removalreason == Entity.RemovalReason.a || entity_removalreason == Entity.RemovalReason.b) && (world = this.ai()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, entity_removalreason);
        }
        super.remove(entity_removalreason, cause);
        this.bO.a();
    }

    @Override
    public void b(Entity.RemovalReason entity_removalreason) {
        super.b(entity_removalreason);
        net.minecraft.world.level.World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.h().c(this);
        }
    }

    protected void a(WorldServer worldserver, Entity.RemovalReason entity_removalreason) {
        for (MobEffect mobeffect : this.eI()) {
            mobeffect.a(worldserver, this, entity_removalreason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.ce.clear();
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        valueoutput.a(t, this.eL());
        valueoutput.a(q, (short)this.bj);
        valueoutput.a(s, this.cj);
        valueoutput.a(r, (short)this.bl);
        valueoutput.a("AbsorptionAmount", this.fD());
        valueoutput.a(l, AttributeModifiable.a.b, this.fg().d());
        if (!this.ce.isEmpty()) {
            valueoutput.a(b, MobEffect.d.listOf(), List.copyOf(this.ce.values()));
        }
        valueoutput.a(p, this.fQ());
        this.fW().ifPresent(blockposition -> valueoutput.a(m, BlockPosition.a, blockposition));
        DataResult dataresult = this.bO.a(DynamicOpsNBT.a).map(nbtbase -> new Dynamic((DynamicOps)DynamicOpsNBT.a, nbtbase));
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(dynamic -> valueoutput.a(o, Codec.PASSTHROUGH, dynamic));
        if (this.bw != null) {
            this.bw.a(valueoutput, "last_hurt_by_player");
            valueoutput.a("last_hurt_by_player_memory_time", this.bx);
        }
        if (this.ci != null) {
            this.ci.a(valueoutput, "last_hurt_by_mob");
            valueoutput.a("ticks_since_last_hurt_by_mob", this.as - this.cj);
        }
        if (!this.bP.a()) {
            valueoutput.a(n, EntityEquipment.a, this.bP);
        }
        if (this.cx.a()) {
            valueoutput.a("locator_bar_icon", Waypoint.a.a, this.cx);
        }
    }

    @Nullable
    public EntityItem a(ItemStack itemstack, boolean flag, boolean flag1) {
        return this.drop(itemstack, flag, flag1, true);
    }

    @Nullable
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        if (itemstack.f()) {
            return null;
        }
        if (this.ai().C) {
            this.a(EnumHand.a);
            return null;
        }
        EntityItem entityitem = this.b(itemstack, flag, flag1);
        if (entityitem != null) {
            if (callEvent && this instanceof EntityPlayer) {
                Player player = (Player)this.getBukkitEntity();
                Item drop = (Item)entityitem.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                    if (flag1 && (cur == null || cur.getAmount() == 0)) {
                        player.getInventory().setItemInHand(drop.getItemStack());
                    } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        cur.setAmount(cur.getAmount() + 1);
                        player.getInventory().setItemInHand(cur);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.ai().b(entityitem);
        }
        return entityitem;
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.F(valueinput.a("AbsorptionAmount", 0.0f));
        if (this.ai() != null && !this.ai().C) {
            Optional<List<AttributeModifiable.a>> optional = valueinput.a(l, AttributeModifiable.a.b);
            AttributeMapBase attributemapbase = this.fg();
            Objects.requireNonNull(attributemapbase);
            optional.ifPresent(attributemapbase::a);
        }
        List list = valueinput.a(b, MobEffect.d.listOf()).orElse(List.of());
        this.ce.clear();
        for (MobEffect mobeffect : list) {
            this.ce.put(mobeffect.c(), mobeffect);
        }
        float maxHealth = valueinput.a("Bukkit.MaxHealth", -1.0f);
        if (maxHealth > 0.0f) {
            this.h(GenericAttributes.t).a(maxHealth);
        }
        this.x(valueinput.a(t, this.fa()));
        this.bj = valueinput.a(q, (short)0);
        this.bl = valueinput.a(r, (short)0);
        this.cj = valueinput.a(s, 0);
        valueinput.g("Team").ifPresent(s2 -> {
            boolean flag;
            Scoreboard scoreboard = this.ai().S();
            ScoreboardTeam scoreboardteam = scoreboard.b((String)s2);
            boolean bl = flag = scoreboardteam != null && scoreboard.a(this.cL(), scoreboardteam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", s2);
            }
        });
        this.b(7, valueinput.a(p, false));
        valueinput.a(m, BlockPosition.a).ifPresentOrElse(blockposition -> {
            this.g((BlockPosition)blockposition);
            this.ay.a(aD, EntityPose.c);
            if (!this.ax) {
                this.a((BlockPosition)blockposition);
            }
        }, this::fX);
        valueinput.a(o, Codec.PASSTHROUGH).ifPresent(dynamic -> {
            this.bO = this.a((Dynamic<?>)dynamic);
        });
        this.bw = EntityReference.a(valueinput, "last_hurt_by_player");
        this.bx = valueinput.a("last_hurt_by_player_memory_time", 0);
        this.ci = EntityReference.a(valueinput, "last_hurt_by_mob");
        this.cj = valueinput.a("ticks_since_last_hurt_by_mob", 0) + this.as;
        this.bP.a(valueinput.a(n, EntityEquipment.a).orElseGet(EntityEquipment::new));
        this.cx = valueinput.a("locator_bar_icon", Waypoint.a.a).orElseGet(Waypoint.a::new);
    }

    protected void eD() {
        net.minecraft.world.level.World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Iterator<Holder<MobEffectList>> iterator = this.ce.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder<MobEffectList> holder = iterator.next();
                    MobEffect mobeffect = this.ce.get(holder);
                    if (!mobeffect.a(worldserver, this, () -> this.a(mobeffect, true, (Entity)null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.c(List.of(mobeffect));
                        continue;
                    }
                    if (mobeffect.d() % 600 != 0) continue;
                    this.a(mobeffect, false, (Entity)null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect e2 : this.effectsToProcess) {
                if (e2.effect != null) {
                    this.addEffect(e2.effect, e2.cause);
                    continue;
                }
                this.removeEffect(e2.type, e2.cause);
            }
            this.effectsToProcess.clear();
            if (this.ch) {
                this.K();
                this.p();
                this.ch = false;
            }
        } else {
            for (MobEffect mobeffect1 : this.ce.values()) {
                mobeffect1.i();
            }
            List<ParticleParam> list = this.ay.a(bV);
            if (!list.isEmpty()) {
                int j2;
                boolean flag = this.ay.a(bW);
                int i2 = this.cs() ? 15 : 4;
                int n2 = j2 = flag ? 5 : 1;
                if (this.ar.a(i2 * j2) == 0) {
                    this.ai().a(SystemUtils.a(list, this.ar), this.d(0.5), this.dF(), this.g(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    protected void K() {
        if (this.ce.isEmpty()) {
            this.eG();
            this.l(false);
        } else {
            this.l(this.d(MobEffects.n));
            this.l();
        }
    }

    private void l() {
        List<ParticleParam> list = this.ce.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.ay.a(bV, list);
        this.ay.a(bW, EntityLiving.d(this.ce.values()));
    }

    private void p() {
        boolean flag = this.cr();
        if (this.i(6) != flag) {
            this.b(6, flag);
        }
    }

    public double D(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.cj()) {
            d0 *= 0.8;
        }
        if (this.cs()) {
            float f2 = this.fj();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.a(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.ap();
            if (entitytypes == EntityTypes.bh && itemstack.a(Items.vN) || entitytypes == EntityTypes.bQ && itemstack.a(Items.vQ) || entitytypes == EntityTypes.aT && itemstack.a(Items.vT) || entitytypes == EntityTypes.aU && itemstack.a(Items.vT) || entitytypes == EntityTypes.F && itemstack.a(Items.vR)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving entityliving) {
        return entityliving instanceof EntityHuman && this.ai().an() == EnumDifficulty.a ? false : entityliving.eE();
    }

    public boolean eE() {
        return !this.cG() && this.eF();
    }

    public boolean eF() {
        return !this.am() && this.bO();
    }

    public static boolean d(Collection<MobEffect> collection) {
        for (MobEffect mobeffect : collection) {
            if (!mobeffect.g() || mobeffect.f()) continue;
            return false;
        }
        return true;
    }

    protected void eG() {
        this.ay.a(bV, List.of());
    }

    public boolean eH() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.ai().C) {
            return false;
        }
        if (this.ce.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.ce.values().iterator();
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eI() {
        return this.ce.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eJ() {
        return this.ce;
    }

    public boolean d(Holder<MobEffectList> holder) {
        return this.ce.containsKey(holder);
    }

    @Nullable
    public MobEffect e(Holder<MobEffectList> holder) {
        return this.ce.get(holder);
    }

    public float a(Holder<MobEffectList> holder, float f2) {
        MobEffect mobeffect = this.e(holder);
        return mobeffect != null ? mobeffect.a(this, f2) : 0.0f;
    }

    public final boolean a(MobEffect mobeffect) {
        return this.b(mobeffect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return this.addEffect(mobeffect, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        AsyncCatcher.catchOp("effect add");
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.b(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.ce.get(mobeffect.c());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.ce.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            flag = true;
            mobeffect.b(this);
        } else if (event.isOverride()) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.a(this);
        return flag;
    }

    public boolean b(MobEffect mobeffect) {
        return this.ap().a(TagsEntity.G) ? !mobeffect.a(MobEffects.M) : (this.ap().a(TagsEntity.F) ? !mobeffect.a(MobEffects.L) : (!this.ap().a(TagsEntity.w) ? true : !mobeffect.a(MobEffects.j) && !mobeffect.a(MobEffects.s)));
    }

    public void c(MobEffect mobeffect, @Nullable Entity entity) {
        if (this.b(mobeffect)) {
            MobEffect mobeffect1 = this.ce.put(mobeffect.c(), mobeffect);
            if (mobeffect1 == null) {
                this.a(mobeffect, entity);
            } else {
                mobeffect.d(mobeffect1);
                this.a(mobeffect, true, entity);
            }
        }
    }

    public boolean eK() {
        return this.ap().a(TagsEntity.x);
    }

    @Nullable
    public final MobEffect f(Holder<MobEffectList> holder) {
        return this.removeEffectNoUpdate(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public final MobEffect removeEffectNoUpdate(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(holder, cause));
            return null;
        }
        MobEffect effect = this.ce.get(holder);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.ce.remove(holder);
    }

    public boolean g(Holder<MobEffectList> holder) {
        return this.removeEffect(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.removeEffectNoUpdate(holder, cause);
        if (mobeffect != null) {
            this.c(List.of(mobeffect));
            return true;
        }
        return false;
    }

    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        if (!this.ai().C) {
            this.ch = true;
            mobeffect.c().a().a(this.fg(), mobeffect.e());
            this.c(mobeffect);
        }
    }

    public void c(MobEffect mobeffect) {
        for (Entity entity : this.da()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.g.b(new PacketPlayOutEntityEffect(this.ar(), mobeffect, false));
        }
    }

    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        if (!this.ai().C) {
            this.ch = true;
            if (flag) {
                MobEffectList mobeffectlist = mobeffect.c().a();
                mobeffectlist.a(this.fg());
                mobeffectlist.a(this.fg(), mobeffect.e());
                this.H();
            }
            this.c(mobeffect);
        }
    }

    protected void c(Collection<MobEffect> collection) {
        if (!this.ai().C) {
            this.ch = true;
            for (MobEffect mobeffect : collection) {
                mobeffect.c().a().a(this.fg());
                for (Entity entity : this.da()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    entityplayer.g.b(new PacketPlayOutRemoveEntityEffect(this.ar(), mobeffect.c()));
                }
            }
            this.H();
        }
    }

    private void H() {
        Set<AttributeModifiable> set = this.fg().b();
        for (AttributeModifiable attributemodifiable : set) {
            this.a(attributemodifiable.a());
        }
        set.clear();
    }

    protected void a(Holder<AttributeBase> holder) {
        net.minecraft.world.level.World world;
        if (holder.a(GenericAttributes.t)) {
            float f2 = this.fa();
            if (this.eL() > f2) {
                this.x(f2);
            }
        } else if (holder.a(GenericAttributes.s)) {
            float f1 = this.fb();
            if (this.fD() > f1) {
                this.E(f1);
            }
        } else if (holder.a(GenericAttributes.z)) {
            this.j_();
        } else if (holder.a(GenericAttributes.H) && (world = this.ai()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ServerWaypointManager serverwaypointmanager = worldserver.h();
            if (this.cc.c(holder) > 0.0) {
                serverwaypointmanager.a(this);
            } else {
                serverwaypointmanager.c(this);
            }
        }
    }

    public void d(float f2) {
        this.heal(f2, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        float f1 = this.eL();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason);
            if (this.valid) {
                this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.x((float)((double)this.eL() + event.getAmount()));
            }
        }
    }

    public float eL() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.ay.a(bU).floatValue();
    }

    public void x(float f2) {
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (f2 < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)f2 > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(f2);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.ay.a(bU, Float.valueOf(MathHelper.a(f2, 0.0f, this.fa())));
    }

    public boolean eM() {
        return this.eL() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity1;
        boolean flag2;
        boolean flag;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (this.dU() || this.by || this.eL() <= 0.0f) {
            return false;
        }
        if (damagesource.a(DamageTypeTags.i) && this.d(MobEffects.l)) {
            return false;
        }
        if (this.fY()) {
            this.fZ();
        }
        this.bz = 0;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f1 = f2;
        EntityDamageEvent event = this.handleEntityDamage(damagesource, f2);
        f2 = 0.0f;
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        float f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
        boolean bl = flag = f22 > 0.0f;
        if (Float.isNaN(f2 -= f22) || Float.isInfinite(f2)) {
            f2 = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.aw > (float)this.bq / 2.0f && !damagesource.a(DamageTypeTags.e)) {
            if (f2 <= this.bA) {
                return false;
            }
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage() - this.bA, event)) {
                return false;
            }
            this.bA = f2;
            flag1 = false;
        } else {
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            this.bA = f2;
            this.aw = this.bq;
            this.bj = this.bk = 10;
        }
        this.f(damagesource);
        this.g(damagesource);
        if (flag1) {
            BlocksAttacks blocksattacks = this.fI().a(DataComponents.I);
            if (flag && blocksattacks != null) {
                blocksattacks.a(worldserver, this);
            } else {
                worldserver.a((Entity)this, damagesource);
            }
            if (!damagesource.a(DamageTypeTags.r) && !flag) {
                this.bG();
            }
            if (!damagesource.a(DamageTypeTags.z)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity = damagesource.c();
                if (entity instanceof IProjectile) {
                    IProjectile iprojectile = (IProjectile)entity;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = iprojectile.a_(this, damagesource);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (damagesource.i() != null) {
                    d0 = damagesource.i().a() - this.dC();
                    d1 = damagesource.i().c() - this.dI();
                }
                this.knockback(0.4f, d0, d1, entity, entity == null ? EntityKnockbackEvent.KnockbackCause.DAMAGE : EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (this.eM()) {
            if (!this.j(damagesource)) {
                if (flag1) {
                    this.b(this.f_());
                    this.i(damagesource);
                }
                this.a(damagesource);
            }
        } else if (flag1) {
            this.h(damagesource);
            this.i(damagesource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.cr = damagesource;
            this.cs = this.ai().ae();
            for (MobEffect mobeffect : new LinkedList<MobEffect>(this.eI())) {
                mobeffect.a(worldserver, this, damagesource, f2);
            }
        }
        if (this instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this;
            CriterionTriggers.i.a(entityplayer, damagesource, f1, f2, flag);
            if (f22 > 0.0f && f22 < 3.4028235E37f) {
                entityplayer.a(StatisticList.L, Math.round(f22 * 10.0f));
            }
        }
        if ((entity1 = damagesource.d()) instanceof EntityPlayer) {
            EntityPlayer entityplayer1 = (EntityPlayer)entity1;
            CriterionTriggers.h.a(entityplayer1, this, damagesource, f1, f2, flag);
        }
        return flag2;
    }

    public float b(WorldServer worldserver, DamageSource damagesource, float f2) {
        return this.actuallyDoItemBlocking(worldserver, damagesource, this.calculateItemBlocking(damagesource, f2));
    }

    private float calculateItemBlocking(DamageSource damagesource, float f2) {
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemstack = this.fO();
        if (itemstack == null) {
            return 0.0f;
        }
        BlocksAttacks blocksattacks = itemstack.a(DataComponents.I);
        if (blocksattacks != null) {
            Optional<TagKey<DamageType>> optional = blocksattacks.f();
            Objects.requireNonNull(damagesource);
            if (!optional.map(damagesource::a).orElse(false).booleanValue()) {
                double d0;
                EntityArrow entityarrow;
                Entity entity = damagesource.c();
                if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).t() > 0) {
                    return 0.0f;
                }
                Vec3D vec3d = damagesource.i();
                if (vec3d != null) {
                    Vec3D vec3d1 = this.d(0.0f, this.cE());
                    Vec3D vec3d2 = vec3d.d(this.dv());
                    vec3d2 = new Vec3D(vec3d2.d, 0.0, vec3d2.f).d();
                    d0 = Math.acos(vec3d2.b(vec3d1));
                } else {
                    d0 = 3.1415927410125732;
                }
                float f1 = blocksattacks.a(damagesource, f2, d0);
                return f1;
            }
        }
        return 0.0f;
    }

    private float actuallyDoItemBlocking(WorldServer worldserver, DamageSource damagesource, float f1) {
        BlocksAttacks blocksattacks;
        ItemStack itemstack = this.fO();
        if (itemstack != null && (blocksattacks = itemstack.a(DataComponents.I)) != null) {
            Entity entity1;
            blocksattacks.a(this.ai(), itemstack, this, this.fH(), f1);
            if (!damagesource.a(DamageTypeTags.j) && (entity1 = damagesource.c()) instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity1;
                this.b(worldserver, entityliving);
            }
            return f1;
        }
        return 0.0f;
    }

    private void i(DamageSource damagesource) {
        if (damagesource.a(DamageTypes.P)) {
            SoundCategory soundcategory = this instanceof EntityHuman ? SoundCategory.h : SoundCategory.f;
            this.ai().a((Entity)null, this.dv().d, this.dv().e, this.dv().f, SoundEffects.Ba, soundcategory);
        }
    }

    protected void f(DamageSource damagesource) {
        Entity entity = damagesource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (!(damagesource.a(DamageTypeTags.q) || damagesource.a(DamageTypes.I) && this.ap().a(TagsEntity.E))) {
                this.a(entityliving);
            }
        }
    }

    @Nullable
    protected EntityHuman g(DamageSource damagesource) {
        EntityWolf entitywolf;
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            this.a(entityhuman, 100);
        } else if (entity instanceof EntityWolf && (entitywolf = (EntityWolf)entity).m()) {
            if (entitywolf.d() != null) {
                this.a(entitywolf.d().c(), 100);
            } else {
                this.bw = null;
                this.bx = 0;
            }
        }
        return EntityReference.a(this.bw, this.ai(), EntityHuman.class);
    }

    protected void b(WorldServer worldserver, EntityLiving entityliving) {
        entityliving.d(this);
    }

    protected void d(EntityLiving entityliving) {
        entityliving.knockback(0.5, entityliving.dC() - this.dC(), entityliving.dI() - this.dI(), null, EntityKnockbackEvent.KnockbackCause.SHIELD_BLOCK);
    }

    private boolean j(DamageSource damagesource) {
        if (damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemstack = null;
        DeathProtection deathprotection = null;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.l;
        for (EnumHand enumhand : EnumHand.values()) {
            itemstack1 = this.b(enumhand);
            deathprotection = itemstack1.a(DataComponents.H);
            if (deathprotection == null) continue;
            hand = enumhand;
            itemstack = itemstack1.v();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.f()) {
                itemstack1.h(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(itemstack.h()));
                CriterionTriggers.C.a(entityplayer, itemstack);
                this.c(GameEvent.C);
            }
            this.x(1.0f);
            deathprotection.a(itemstack, this);
            this.ai().a((Entity)this, (byte)35);
        }
        return deathprotection != null;
    }

    @Nullable
    public DamageSource eN() {
        if (this.ai().ae() - this.cs > 40L) {
            this.cr = null;
        }
        return this.cr;
    }

    protected void h(DamageSource damagesource) {
        this.b(this.e(damagesource));
    }

    public void b(@Nullable SoundEffect soundeffect) {
        if (soundeffect != null) {
            this.a(soundeffect, this.fk(), this.fl());
        }
    }

    private void g(ItemStack itemstack) {
        if (!itemstack.f()) {
            Holder<SoundEffect> holder = itemstack.a(DataComponents.au);
            if (holder != null && !this.be()) {
                this.ai().a(this.dC(), this.dE(), this.dI(), holder.a(), this.do(), 0.8f, 0.8f + this.ai().A.i() * 0.4f, false);
            }
            this.b(itemstack, 5);
        }
    }

    public void a(DamageSource damagesource) {
        if (!this.dU() && !this.by) {
            Entity entity = damagesource.d();
            EntityLiving entityliving = this.eZ();
            if (entityliving != null) {
                entityliving.a((Entity)this, damagesource);
            }
            if (this.fY()) {
                this.fZ();
            }
            if (!this.ai().C && this.i_() && SpigotConfig.logNamedDeaths) {
                a.info("Named entity {} died: {}", (Object)this, (Object)this.eY().a().getString());
            }
            this.by = true;
            this.eY().c();
            net.minecraft.world.level.World world = this.ai();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (entity == null || entity.a(worldserver, this)) {
                    this.c(GameEvent.p);
                    this.b(worldserver, damagesource);
                    this.e(entityliving);
                }
                this.ai().a((Entity)this, (byte)3);
            }
            this.b(EntityPose.h);
        }
    }

    protected void e(@Nullable EntityLiving entityliving) {
        net.minecraft.world.level.World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            boolean flag = false;
            if (entityliving instanceof EntityWither) {
                if (worldserver.P().c(GameRules.d)) {
                    BlockPosition blockposition = this.dx();
                    IBlockData iblockdata = Blocks.cn.m();
                    if (this.ai().a_(blockposition).l() && iblockdata.a((IWorldReader)this.ai(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.ai(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.ai(), this.dC(), this.dE(), this.dI(), new ItemStack(Items.dJ));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.ai().b(entityitem);
                }
            }
        }
    }

    protected void b(WorldServer worldserver, DamageSource damagesource) {
        boolean flag = this.bx > 0;
        this.f(worldserver);
        if (this.eu() && worldserver.P().c(GameRules.g)) {
            this.b(worldserver, damagesource, flag);
            this.a(worldserver, damagesource, flag);
        }
        CraftEventFactory.callEntityDeathEvent(this, damagesource, this.drops);
        this.drops = new ArrayList();
        this.b(worldserver, damagesource.d());
    }

    protected void f(WorldServer worldserver) {
    }

    public int getExpReward(WorldServer worldserver, @Nullable Entity entity) {
        if (!this.eQ() && (this.ev() || this.bx > 0 && this.et() && worldserver.P().c(GameRules.g))) {
            return this.a(worldserver, entity);
        }
        return 0;
    }

    protected void b(WorldServer worldserver, @Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.a(worldserver, this.dv(), this.expToDrop);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
    }

    public long eO() {
        return 0L;
    }

    protected float b(Entity entity, DamageSource damagesource) {
        float f2 = (float)this.i(GenericAttributes.d);
        net.minecraft.world.level.World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return EnchantmentManager.d(worldserver, this.ed(), entity, damagesource, f2);
        }
        return f2;
    }

    protected void b(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        Optional<ResourceKey<LootTable>> optional = this.ee();
        if (!optional.isEmpty()) {
            LootTable loottable = worldserver.q().bc().a(optional.get());
            LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.a, this).a(LootContextParameters.f, this.dv()).a(LootContextParameters.c, damagesource).b(LootContextParameters.d, damagesource.d()).b(LootContextParameters.e, damagesource.c());
            EntityHuman entityhuman = this.ex();
            if (flag && entityhuman != null) {
                lootparams_a = lootparams_a.a(LootContextParameters.b, entityhuman).a(entityhuman.em());
            }
            LootParams lootparams = lootparams_a.a(LootContextParameterSets.g);
            loottable.a(lootparams, this.eO(), (ItemStack itemstack) -> this.a(worldserver, (ItemStack)itemstack));
        }
    }

    public boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, BiConsumer<WorldServer, ItemStack> biconsumer) {
        return this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.f, this.dv()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), biconsumer);
    }

    protected void a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, ItemStack itemstack, BiConsumer<WorldServer, ItemStack> biconsumer) {
        this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.f, this.dv()).a(LootContextParameters.a, this).a(LootContextParameters.i, itemstack).a(LootContextParameterSets.s), biconsumer);
    }

    protected boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, Function<LootParams.a, LootParams> function, BiConsumer<WorldServer, ItemStack> biconsumer) {
        LootParams lootparams;
        LootTable loottable = worldserver.q().bc().a(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.a(lootparams = function.apply(new LootParams.a(worldserver)));
        if (!list.isEmpty()) {
            list.forEach(itemstack -> biconsumer.accept(worldserver, (ItemStack)itemstack));
            return true;
        }
        return false;
    }

    public void p(double d0, double d1, double d2) {
        this.knockback(d0, d1, d2, null, EntityKnockbackEvent.KnockbackCause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, Entity attacker, EntityKnockbackEvent.KnockbackCause cause) {
        d0 *= 1.0 - this.i(GenericAttributes.q);
        Vec3D vec3d = this.dA();
        while (d1 * d1 + d2 * d2 < (double)1.0E-5f) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D vec3d1 = new Vec3D(d1, 0.0, d2).d().c(d0);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, cause, d0, vec3d1, vec3d.d / 2.0 - vec3d1.d, this.aK() ? Math.min(0.4, vec3d.e / 2.0 + d0) : vec3d.e, vec3d.f / 2.0 - vec3d1.f);
        if (event.isCancelled()) {
            return;
        }
        this.aE = true;
        this.n(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ());
    }

    public void a(double d0, double d1) {
    }

    @Nullable
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.kT;
    }

    @Nullable
    protected SoundEffect f_() {
        return SoundEffects.kO;
    }

    private SoundEffect q(int i2) {
        return i2 > 4 ? this.eT().b() : this.eT().a();
    }

    public void eP() {
        this.cv = true;
    }

    public boolean eQ() {
        return this.cv;
    }

    public float eR() {
        return 0.0f;
    }

    protected AxisAlignedBB eS() {
        AxisAlignedBB axisalignedbb = this.cV();
        Entity entity = this.dm();
        if (entity != null) {
            Vec3D vec3d = entity.n(this);
            return axisalignedbb.b(Math.max(vec3d.e, axisalignedbb.b));
        }
        return axisalignedbb;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot enumitemslot) {
        return (Map)this.cw.computeIfAbsent(enumitemslot, enumitemslot1 -> new Reference2ObjectArrayMap());
    }

    public a eT() {
        return new a(SoundEffects.kU, SoundEffects.kM);
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.e(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.f_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.q(fallHeight);
    }

    public Optional<BlockPosition> eU() {
        return this.cq;
    }

    public boolean eV() {
        if (this.am()) {
            return false;
        }
        BlockPosition blockposition = this.dx();
        IBlockData iblockdata = this.dy();
        if (iblockdata.a(TagsBlock.aV)) {
            this.cq = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.cq = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition blockposition, IBlockData iblockdata) {
        if (!iblockdata.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData iblockdata1 = this.ai().a_(blockposition.e());
        return iblockdata1.a(Blocks.da) && iblockdata1.c(BlockLadder.b) == iblockdata.c(BlockTrapdoor.f);
    }

    @Override
    public boolean bO() {
        return !this.dU() && this.eL() > 0.0f;
    }

    public boolean a(EntityLiving entityliving, double d0, boolean flag, boolean flag1, double ... adouble) {
        Vec3D vec3d = entityliving.h(1.0f).d();
        for (double d1 : adouble) {
            Vec3D vec3d1 = new Vec3D(this.dC() - entityliving.dC(), d1 - entityliving.dG(), this.dI() - entityliving.dI());
            double d2 = vec3d1.g();
            vec3d1 = vec3d1.d();
            double d3 = vec3d.b(vec3d1);
            double d4 = flag ? d2 : 1.0;
            if (!(d3 > 1.0 - d0 / d4) || !entityliving.a(this, flag1 ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, d1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cI() {
        return this.y(0.0f);
    }

    protected final int y(float f2) {
        return MathHelper.d(f2 + 3.0f);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        boolean flag = super.a(d0, f2, damagesource);
        int i2 = this.a(d0, f2);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.ai(), damagesource, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.eW();
            return true;
        }
        return flag;
    }

    protected int a(double d0, float f2) {
        if (this.ap().a(TagsEntity.o)) {
            return 0;
        }
        double d1 = this.h(d0);
        return MathHelper.a(d1 * (double)f2 * this.i(GenericAttributes.l));
    }

    private double h(double d0) {
        return d0 + 1.0E-6 - this.i(GenericAttributes.y);
    }

    protected void eW() {
        if (!this.be()) {
            int i2 = MathHelper.a(this.dC());
            int j2 = MathHelper.a(this.dE() - (double)0.2f);
            int k2 = MathHelper.a(this.dI());
            IBlockData iblockdata = this.ai().a_(new BlockPosition(i2, j2, k2));
            if (!iblockdata.l()) {
                SoundEffectType soundeffecttype = iblockdata.A();
                this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
            }
        }
    }

    @Override
    public void q(float f2) {
        this.bj = this.bk = 10;
    }

    public int eX() {
        return MathHelper.a(this.i(GenericAttributes.a));
    }

    protected void c(DamageSource damagesource, float f2) {
    }

    protected void d(DamageSource damagesource, float f2) {
    }

    protected void a(DamageSource damagesource, float f2, EnumItemSlot ... aenumitemslot) {
        if (f2 > 0.0f) {
            int i2 = (int)Math.max(1.0f, f2 / 4.0f);
            for (EnumItemSlot enumitemslot : aenumitemslot) {
                ItemStack itemstack = this.a(enumitemslot);
                Equippable equippable = itemstack.a(DataComponents.D);
                if (equippable == null || !equippable.i() || !itemstack.m() || !itemstack.a(damagesource)) continue;
                itemstack.a(i2, this, enumitemslot);
            }
        }
    }

    protected float e(DamageSource damagesource, float f2) {
        if (!damagesource.a(DamageTypeTags.b)) {
            f2 = CombatMath.a(this, f2, damagesource, this.eX(), (float)this.i(GenericAttributes.b));
        }
        return f2;
    }

    protected float f(DamageSource damagesource, float f2) {
        float f4;
        if (damagesource.a(DamageTypeTags.f)) {
            return f2;
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (damagesource.a(DamageTypeTags.h)) {
            return f2;
        }
        net.minecraft.world.level.World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f4 = EnchantmentManager.b(worldserver, this, damagesource);
        } else {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            f2 = CombatMath.a(f2, f4);
        }
        return f2;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float f2) {
        float originalDamage = f2;
        com.google.common.base.Function<Double, Double> freezing = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.o) && EntityLiving.this.ap().a(TagsEntity.l)) {
                    return -(f2 - f2 * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)f2)).floatValue();
        com.google.common.base.Function<Double, Double> hardHat = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.a(EnumItemSlot.f).f()) {
                    return -(f2 - f2 * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(f2 += freezingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> blocking = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -((double)EntityLiving.this.calculateItemBlocking(damagesource, f2.floatValue()));
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
        com.google.common.base.Function<Double, Double> armor = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> resistance = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.d(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                    int i2 = (EntityLiving.this.e(MobEffects.k).e() + 1) * 5;
                    int j2 = 25 - i2;
                    float f1 = f2.floatValue() * (float)j2;
                    return -(f2 - (double)Math.max(f1 / 25.0f, 0.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
        com.google.common.base.Function<Double, Double> magic = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.f(damagesource, f2.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
        com.google.common.base.Function<Double, Double> absorption = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.fD(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption);
    }

    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.a(worldserver, damagesource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damagesource.d() instanceof EntityHuman) {
                ((EntityHuman)damagesource.d()).gO();
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.N, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.J, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                this.d(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.b)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.c(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.actuallyDoItemBlocking(worldserver, damagesource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.E(Math.max(this.fD() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.M, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.I, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.K, Math.round(f2 * 10.0f));
                    }
                }
                this.eY().a(damagesource, f2);
                this.x(this.eL() - f2);
                if (!human) {
                    this.E(this.fD() - f2);
                }
                this.c(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damagesource, f2, originalDamage, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.L, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damagesource.d(), this, damagesource, f2, originalDamage, true);
                }
                return true;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker eY() {
        return this.cd;
    }

    @Nullable
    public EntityLiving eZ() {
        return this.bw != null ? (EntityLiving)this.bw.a(this.ai(), EntityHuman.class) : (this.ci != null ? this.ci.a(this.ai(), EntityLiving.class) : null);
    }

    public final float fa() {
        return (float)this.i(GenericAttributes.t);
    }

    public final float fb() {
        return (float)this.i(GenericAttributes.s);
    }

    public final int fc() {
        return this.ay.a(bX);
    }

    public final void o(int i2) {
        this.setArrowCount(i2, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.fc(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.ay.a(bX, event.getNewAmount());
    }

    public final int fd() {
        return this.ay.a(bY);
    }

    public final void p(int i2) {
        this.ay.a(bY, i2);
    }

    private int I() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.d(MobEffects.d) ? 6 + (1 + this.e(MobEffects.d).e()) * 2 : 6);
    }

    public void a(EnumHand enumhand) {
        this.a(enumhand, false);
    }

    public void a(EnumHand enumhand, boolean flag) {
        if (!this.be || this.bg >= this.I() / 2 || this.bg < 0) {
            this.bg = -1;
            this.be = true;
            this.bf = enumhand;
            if (this.ai() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, enumhand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.ai()).n();
                if (flag) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damagesource) {
        this.bp.a(1.5f);
        this.aw = 20;
        this.bj = this.bk = 10;
        SoundEffect soundeffect = this.e(damagesource);
        if (soundeffect != null) {
            this.a(soundeffect, this.fk(), (this.ar.i() - this.ar.i()) * 0.2f + 1.0f);
        }
        this.cr = damagesource;
        this.cs = this.ai().ae();
    }

    @Override
    public void b(byte b0) {
        switch (b0) {
            case 3: {
                SoundEffect soundeffect = this.f_();
                if (soundeffect != null) {
                    this.a(soundeffect, this.fk(), (this.ar.i() - this.ar.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.x(0.0f);
                this.a(this.ea().p());
                break;
            }
            case 46: {
                int i2 = 128;
                for (int j2 = 0; j2 < 128; ++j2) {
                    double d0 = (double)j2 / 127.0;
                    float f2 = (this.ar.i() - 0.5f) * 0.2f;
                    float f1 = (this.ar.i() - 0.5f) * 0.2f;
                    float f22 = (this.ar.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.X, this.dC()) + (this.ar.j() - 0.5) * (double)this.ds() * 2.0;
                    double d2 = MathHelper.d(d0, this.Y, this.dE()) + this.ar.j() * (double)this.dt();
                    double d3 = MathHelper.d(d0, this.Z, this.dI()) + (this.ar.j() - 0.5) * (double)this.ds() * 2.0;
                    this.ai().a(Particles.af, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                break;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.L();
                break;
            }
            case 60: {
                this.fe();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            case 67: {
                this.J();
                break;
            }
            case 68: {
                this.g(this.a(EnumItemSlot.h));
                break;
            }
            default: {
                super.b(b0);
            }
        }
    }

    public void fe() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.ar.k() * 0.02;
            double d1 = this.ar.k() * 0.02;
            double d2 = this.ar.k() * 0.02;
            double d3 = 10.0;
            this.ai().a(Particles.ae, this.d(1.0) - d0 * 10.0, this.dF() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
        }
    }

    private void J() {
        Vec3D vec3d = this.dA();
        for (int i2 = 0; i2 < 8; ++i2) {
            double d0 = this.ar.a(0.0, 1.0);
            double d1 = this.ar.a(0.0, 1.0);
            double d2 = this.ar.a(0.0, 1.0);
            this.ai().a(Particles.d, this.dC() + d0, this.dE() + d1, this.dI() + d2, vec3d.d, vec3d.e, vec3d.f);
        }
    }

    private void L() {
        ItemStack itemstack = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void aJ() {
        this.a(this.ea().o(), 4.0f);
    }

    protected void ff() {
        int i2 = this.I();
        if (this.be) {
            ++this.bg;
            if (this.bg >= i2) {
                this.bg = 0;
                this.be = false;
            }
        } else {
            this.bg = 0;
        }
        this.bn = (float)this.bg / (float)i2;
    }

    @Nullable
    public AttributeModifiable h(Holder<AttributeBase> holder) {
        return this.fg().a(holder);
    }

    public double i(Holder<AttributeBase> holder) {
        return this.fg().c(holder);
    }

    public double j(Holder<AttributeBase> holder) {
        return this.fg().d(holder);
    }

    public AttributeMapBase fg() {
        return this.cc;
    }

    public ItemStack fh() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fi() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack a(EnumMainHand enummainhand) {
        return this.fF() == enummainhand ? this.fh() : this.fi();
    }

    @Override
    @Nonnull
    public ItemStack ed() {
        return this.fh();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.fh()) || predicate.test(this.fi());
    }

    public ItemStack b(EnumHand enumhand) {
        if (enumhand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (enumhand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
    }

    public void a(EnumHand enumhand, ItemStack itemstack) {
        if (enumhand == EnumHand.a) {
            this.a(EnumItemSlot.a, itemstack);
        } else {
            if (enumhand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
            }
            this.a(EnumItemSlot.b, itemstack);
        }
    }

    public boolean d(EnumItemSlot enumitemslot) {
        return !this.a(enumitemslot).f();
    }

    public boolean e(EnumItemSlot enumitemslot) {
        return true;
    }

    public ItemStack a(EnumItemSlot enumitemslot) {
        return this.bP.a(enumitemslot);
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack, false);
    }

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.onEquipItem(enumitemslot, this.bP.a(enumitemslot, itemstack), itemstack, silent);
    }

    public float fj() {
        int i2 = 0;
        int j2 = 0;
        for (EnumItemSlot enumitemslot : EquipmentSlotGroup.i) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            ItemStack itemstack = this.a(enumitemslot);
            if (!itemstack.f()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void i(boolean flag) {
        super.i(flag);
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
        attributemodifiable.c(e.a());
        if (flag) {
            attributemodifiable.b(e);
        }
    }

    protected float fk() {
        return 1.0f;
    }

    public float fl() {
        return this.g_() ? (this.ar.i() - this.ar.i()) * 0.2f + 1.5f : (this.ar.i() - this.ar.i()) * 0.2f + 1.0f;
    }

    protected boolean fm() {
        return this.eM();
    }

    @Override
    public void h(Entity entity) {
        if (!this.fY()) {
            super.h(entity);
        }
    }

    private void G(Entity entity) {
        Vec3D vec3d;
        if (this.dU()) {
            vec3d = this.dv();
        } else if (!entity.dU() && !this.ai().a_(entity.dx()).a(TagsBlock.aP)) {
            vec3d = entity.b(this);
        } else {
            boolean flag;
            double d0 = Math.max(this.dE(), entity.dE());
            vec3d = new Vec3D(this.dC(), d0, this.dI());
            boolean bl = flag = this.ds() <= 4.0f && this.dt() <= 4.0f;
            if (flag) {
                double d1 = (double)this.dt() / 2.0;
                Vec3D vec3d1 = vec3d.b(0.0, d1, 0.0);
                VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, this.ds(), this.dt(), this.ds()));
                vec3d = this.ai().a((Entity)this, voxelshape, vec3d1, (double)this.ds(), (double)this.dt(), (double)this.ds()).map(vec3d2 -> vec3d2.b(0.0, -d1, 0.0)).orElse(vec3d);
            }
        }
        this.m(vec3d.d, vec3d.e, vec3d.f);
    }

    @Override
    public boolean cQ() {
        return this.cP();
    }

    protected float fn() {
        return this.z(1.0f);
    }

    protected float z(float f2) {
        return (float)this.i(GenericAttributes.p) * f2 * this.aV() + this.fo();
    }

    public float fo() {
        return this.d(MobEffects.h) ? 0.1f * ((float)this.e(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void s() {
        float f2 = this.fn();
        if (f2 > 1.0E-5f) {
            Vec3D vec3d = this.dA();
            this.n(vec3d.d, Math.max((double)f2, vec3d.e), vec3d.f);
            if (this.cm()) {
                float f1 = this.dP() * ((float)Math.PI / 180);
                this.j(new Vec3D((double)(-MathHelper.a(f1)) * 0.2, 0.0, (double)MathHelper.b(f1) * 0.2));
            }
            this.aE = true;
        }
    }

    protected void fp() {
        this.i(this.dA().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> tagkey) {
        this.i(this.dA().b(0.0, 0.04f, 0.0));
    }

    protected float fq() {
        return 0.8f;
    }

    public boolean a(Fluid fluid) {
        return false;
    }

    @Override
    protected double bg() {
        return this.i(GenericAttributes.o);
    }

    protected double fr() {
        boolean flag = this.dA().e <= 0.0;
        return flag && this.d(MobEffects.B) ? Math.min(this.bh(), 0.01) : this.bh();
    }

    public void k(Vec3D vec3d) {
        Fluid fluid = this.ai().b_(this.dx());
        if ((this.bm() || this.bA()) && this.er() && !this.a(fluid)) {
            this.m(vec3d);
        } else if (this.fQ()) {
            this.n(vec3d);
        } else {
            this.a(vec3d);
        }
    }

    protected void a(Vec3D vec3d, float f2) {
        this.a(vec3d, 0.02f, 0.02f, f2);
    }

    protected void a(Vec3D vec3d, float f2, float f1, float f22) {
        if (this.bm()) {
            this.a(f2, vec3d);
            this.a(EnumMoveType.a, this.dA());
            this.i(this.dA().c((double)0.8f));
        } else if (this.bA()) {
            this.a(f1, vec3d);
            this.a(EnumMoveType.a, this.dA());
            this.i(this.dA().c(0.5));
        } else {
            this.a(f22, vec3d);
            this.a(EnumMoveType.a, this.dA());
            this.i(this.dA().c((double)0.91f));
        }
    }

    private void a(Vec3D vec3d) {
        BlockPosition blockposition = this.aT();
        float f2 = this.aK() ? this.ai().a_(blockposition).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3d1 = this.b(vec3d, f2);
        double d0 = vec3d1.e;
        MobEffect mobeffect = this.e(MobEffects.y);
        d0 = mobeffect != null ? (d0 += (0.05 * (double)(mobeffect.e() + 1) - vec3d1.e) * 0.2) : (this.ai().C && !this.ai().D(blockposition) ? (this.dE() > (double)this.ai().L_() ? -0.1 : 0.0) : (d0 -= this.fr()));
        if (this.eC()) {
            this.n(vec3d1.d, d0, vec3d1.f);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.n(vec3d1.d * (double)f1, d0 * (double)f22, vec3d1.f * (double)f1);
        }
    }

    private void m(Vec3D vec3d) {
        boolean flag = this.dA().e <= 0.0;
        double d0 = this.dE();
        double d1 = this.fr();
        if (this.bm()) {
            float f2 = this.cm() ? 0.9f : this.fq();
            float f1 = 0.02f;
            float f22 = (float)this.i(GenericAttributes.G);
            if (!this.aK()) {
                f22 *= 0.5f;
            }
            if (f22 > 0.0f) {
                f2 += (0.54600006f - f2) * f22;
                f1 += (this.fu() - f1) * f22;
            }
            if (this.d(MobEffects.D)) {
                f2 = 0.96f;
            }
            this.a(f1, vec3d);
            this.a(EnumMoveType.a, this.dA());
            Vec3D vec3d1 = this.dA();
            if (this.ac && this.eV()) {
                vec3d1 = new Vec3D(vec3d1.d, 0.2, vec3d1.f);
            }
            vec3d1 = vec3d1.d(f2, 0.8f, f2);
            this.i(this.a(d1, flag, vec3d1));
        } else {
            this.a(0.02f, vec3d);
            this.a(EnumMoveType.a, this.dA());
            if (this.b(TagsFluid.b) <= this.dr()) {
                this.i(this.dA().d(0.5, 0.8f, 0.5));
                Vec3D vec3d2 = this.a(d1, flag, this.dA());
                this.i(vec3d2);
            } else {
                this.i(this.dA().c(0.5));
            }
            if (d1 != 0.0) {
                this.i(this.dA().b(0.0, -d1 / 4.0, 0.0));
            }
        }
        Vec3D vec3d3 = this.dA();
        if (this.ac && this.f(vec3d3.d, vec3d3.e + (double)0.6f - this.dE() + d0, vec3d3.f)) {
            this.n(vec3d3.d, 0.3f, vec3d3.f);
        }
    }

    private void n(Vec3D vec3d) {
        if (this.eV()) {
            this.a(vec3d);
            this.fs();
        } else {
            Vec3D vec3d1 = this.dA();
            double d0 = vec3d1.i();
            this.i(this.o(vec3d1));
            this.a(EnumMoveType.a, this.dA());
            if (!this.ai().C) {
                double d1 = this.dA().i();
                this.c(d0, d1);
            }
        }
    }

    public void fs() {
        if (CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            return;
        }
        this.b(7, true);
        this.b(7, false);
    }

    private Vec3D o(Vec3D vec3d) {
        Vec3D vec3d1 = this.bW();
        float f2 = this.dR() * ((float)Math.PI / 180);
        double d0 = Math.sqrt(vec3d1.d * vec3d1.d + vec3d1.f * vec3d1.f);
        double d1 = vec3d.i();
        double d2 = this.fr();
        double d3 = MathHelper.k(Math.cos(f2));
        vec3d = vec3d.b(0.0, d2 * (-1.0 + d3 * 0.75), 0.0);
        if (vec3d.e < 0.0 && d0 > 0.0) {
            double d4 = vec3d.e * -0.1 * d3;
            vec3d = vec3d.b(vec3d1.d * d4 / d0, d4, vec3d1.f * d4 / d0);
        }
        if (f2 < 0.0f && d0 > 0.0) {
            double d5 = d1 * (double)(-MathHelper.a(f2)) * 0.04;
            vec3d = vec3d.b(-vec3d1.d * d5 / d0, d5 * 3.2, -vec3d1.f * d5 / d0);
        }
        if (d0 > 0.0) {
            vec3d = vec3d.b((vec3d1.d / d0 * d1 - vec3d.d) * 0.1, 0.0, (vec3d1.f / d0 * d1 - vec3d.f) * 0.1);
        }
        return vec3d.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double d0, double d1) {
        double d2;
        float f2;
        if (this.ac && (f2 = (float)((d2 = d0 - d1) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            this.a(this.ea().n(), f2);
        }
    }

    private void c(EntityHuman entityhuman, Vec3D vec3d) {
        Vec3D vec3d1 = this.b(entityhuman, vec3d);
        this.a(entityhuman, vec3d1);
        if (this.dk()) {
            this.B(this.c(entityhuman));
            this.k(vec3d1);
        } else {
            this.i(Vec3D.c);
        }
    }

    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
    }

    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return vec3d;
    }

    protected float c(EntityHuman entityhuman) {
        return this.fu();
    }

    public void s(boolean flag) {
        float f2 = (float)MathHelper.g(this.dC() - this.X, flag ? this.dE() - this.Y : 0.0, this.dI() - this.Z);
        if (!this.cc() && this.bO()) {
            this.A(f2);
        } else {
            this.bp.a();
        }
    }

    protected void A(float f2) {
        float f1 = Math.min(f2 * 4.0f, 1.0f);
        this.bp.a(f1, 0.4f, this.g_() ? 3.0f : 1.0f);
    }

    private Vec3D b(Vec3D vec3d, float f2) {
        this.a(this.G(f2), vec3d);
        this.i(this.p(this.dA()));
        this.a(EnumMoveType.a, this.dA());
        Vec3D vec3d1 = this.dA();
        if ((this.ac || this.bB) && (this.eV() || this.aJ && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.d, 0.2, vec3d1.f);
        }
        return vec3d1;
    }

    public Vec3D a(double d0, boolean flag, Vec3D vec3d) {
        if (d0 != 0.0 && !this.cm()) {
            double d1 = flag && Math.abs(vec3d.e - 0.005) >= 0.003 && Math.abs(vec3d.e - d0 / 16.0) < 0.003 ? -0.003 : vec3d.e - d0 / 16.0;
            return new Vec3D(vec3d.d, d1, vec3d.f);
        }
        return vec3d;
    }

    private Vec3D p(Vec3D vec3d) {
        if (this.eV()) {
            this.j();
            float f2 = 0.15f;
            double d0 = MathHelper.a(vec3d.d, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(vec3d.f, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(vec3d.e, (double)-0.15f);
            if (d2 < 0.0 && !this.dy().a(Blocks.oz) && this.fP() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            vec3d = new Vec3D(d0, d2, d1);
        }
        return vec3d;
    }

    private float G(float f2) {
        return this.aK() ? this.fu() * (0.21600002f / (f2 * f2 * f2)) : this.ft();
    }

    protected float ft() {
        return this.cY() instanceof EntityHuman ? this.fu() * 0.1f : 0.02f;
    }

    public float fu() {
        return this.cm;
    }

    public void B(float f2) {
        this.cm = f2;
    }

    public boolean c(WorldServer worldserver, Entity entity) {
        this.C(entity);
        return false;
    }

    @Override
    public void g() {
        SpigotTimings.timerEntityBaseTick.startTiming();
        super.g();
        this.P();
        this.Q();
        if (!this.ai().C) {
            int j2;
            int i2 = this.fc();
            if (i2 > 0) {
                if (this.bh <= 0) {
                    this.bh = 20 * (30 - i2);
                }
                --this.bh;
                if (this.bh <= 0) {
                    this.o(i2 - 1);
                }
            }
            if ((j2 = this.fd()) > 0) {
                if (this.bi <= 0) {
                    this.bi = 20 * (30 - j2);
                }
                --this.bi;
                if (this.bi <= 0) {
                    this.p(j2 - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.as % 20 == 0) {
                this.eY().c();
            }
            if (this.fY() && !this.R()) {
                this.fZ();
            }
        }
        if (!this.dU()) {
            SpigotTimings.timerEntityBaseTick.stopTiming();
            this.e_();
            SpigotTimings.timerEntityTickRest.startTiming();
        }
        double d0 = this.dC() - this.X;
        double d1 = this.dI() - this.Z;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.br;
        if (f2 > 0.0025000002f) {
            float f22 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f3 = MathHelper.e(MathHelper.h(this.dP()) - f22);
            f1 = 95.0f < f3 && f3 < 265.0f ? f22 - 180.0f : f22;
        }
        if (this.bn > 0.0f) {
            f1 = this.dP();
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("headTurn");
        this.C(f1);
        gameprofilerfiller.c();
        gameprofilerfiller.a("rangeChecks");
        while (this.dP() - this.aa < -180.0f) {
            this.aa -= 360.0f;
        }
        while (this.dP() - this.aa >= 180.0f) {
            this.aa += 360.0f;
        }
        while (this.br - this.bs < -180.0f) {
            this.bs -= 360.0f;
        }
        while (this.br - this.bs >= 180.0f) {
            this.bs += 360.0f;
        }
        while (this.dR() - this.ab < -180.0f) {
            this.ab -= 360.0f;
        }
        while (this.dR() - this.ab >= 180.0f) {
            this.ab += 360.0f;
        }
        while (this.bt - this.bu < -180.0f) {
            this.bu -= 360.0f;
        }
        while (this.bt - this.bu >= 180.0f) {
            this.bu += 360.0f;
        }
        gameprofilerfiller.c();
        this.bK = this.fQ() ? ++this.bK : 0;
        if (this.fY()) {
            this.w(0.0f);
        }
        this.H();
        this.bv.a();
        SpigotTimings.timerEntityTickRest.stopTiming();
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EnumItemSlot, ItemStack> map = this.O();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> O() {
        Map map = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.j) {
            ItemStack itemstack1;
            ItemStack itemstack = this.cf.get(enumItemSlot);
            if (!this.a(itemstack, itemstack1 = this.a(enumItemSlot))) continue;
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumItemSlot, itemstack1);
            AttributeMapBase attributemapbase = this.fg();
            if (itemstack.f()) continue;
            this.a(itemstack, enumItemSlot, attributemapbase);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot enumitemslot1 = (EnumItemSlot)entry.getKey();
                ItemStack itemstack2 = (ItemStack)entry.getValue();
                if (itemstack2.f() || itemstack2.q()) continue;
                itemstack2.a(enumitemslot1, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    AttributeModifiable attributemodifiable = this.cc.a((Holder<AttributeBase>)holder);
                    if (attributemodifiable != null) {
                        attributemodifiable.c(attributemodifier.a());
                        attributemodifiable.b((AttributeModifier)attributemodifier);
                    }
                });
                net.minecraft.world.level.World world = this.ai();
                if (!(world instanceof WorldServer)) continue;
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, itemstack2, this, enumitemslot1);
            }
        }
        return map;
    }

    public boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return !ItemStack.a(itemstack1, itemstack);
    }

    private void a(Map<EnumItemSlot, ItemStack> map) {
        ItemStack itemstack = map.get(EnumItemSlot.a);
        ItemStack itemstack1 = map.get(EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.a(itemstack, this.cf.get(EnumItemSlot.b)) && ItemStack.a(itemstack1, this.cf.get(EnumItemSlot.a))) {
            ((WorldServer)this.ai()).n().b(this, new PacketPlayOutEntityStatus(this, 55));
            map.remove(EnumItemSlot.a);
            map.remove(EnumItemSlot.b);
            this.cf.put(EnumItemSlot.a, itemstack.v());
            this.cf.put(EnumItemSlot.b, itemstack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> map) {
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.v();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            this.cf.put((EnumItemSlot)enumitemslot, itemstack1);
        });
        ((WorldServer)this.ai()).n().b(this, new PacketPlayOutEntityEquipment(this.ar(), list));
    }

    protected void C(float f2) {
        float f1 = MathHelper.h(f2 - this.br);
        this.br += f1 * 0.3f;
        float f22 = MathHelper.h(this.dP() - this.br);
        float f3 = this.fv();
        if (Math.abs(f22) > f3) {
            this.br += f22 - (float)MathHelper.j((double)f22) * f3;
        }
    }

    protected float fv() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void e_() {
        if (this.cn > 0) {
            --this.cn;
        }
        if (this.bU()) {
            this.l_().e();
        } else if (!this.dk()) {
            this.i(this.dA().c(0.98));
        }
        if (this.bH > 0) {
            this.a(this.bH, this.bG);
            --this.bH;
        }
        this.bP.a((Entity)this);
        vec3d = this.dA();
        d0 = vec3d.d;
        d1 = vec3d.e;
        d2 = vec3d.f;
        if (this.ap().equals(EntityTypes.bU)) {
            if (vec3d.j() < 9.0E-6) {
                d0 = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(vec3d.d) < 0.003) {
                d0 = 0.0;
            }
            if (Math.abs(vec3d.f) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(vec3d.e) < 0.003) {
            d1 = 0.0;
        }
        this.n(d0, d1, d2);
        gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("ai");
        SpigotTimings.timerEntityAI.startTiming();
        this.fw();
        if (this.fm()) {
            this.bB = false;
            this.bC = 0.0f;
            this.bE = 0.0f;
        } else if (this.dl() && !this.ai().C) {
            gameprofilerfiller.a("newAi");
            this.fB();
            gameprofilerfiller.c();
        }
        SpigotTimings.timerEntityAI.stopTiming();
        gameprofilerfiller.c();
        gameprofilerfiller.a("jump");
        if (this.bB && this.er()) {
            d3 = this.bA() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.bm() != false && d3 > 0.0;
            d4 = this.dr();
            if (!flag || this.aK() && d3 <= d4) {
                if (!this.bA() || this.aK() && d3 <= d4) {
                    if ((this.aK() || flag && d3 <= d4) && this.cn == 0) {
                        this.s();
                        this.cn = 10;
                    }
                } else {
                    this.c(TagsFluid.b);
                }
            } else {
                this.c(TagsFluid.a);
            }
        } else {
            this.cn = 0;
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("travel");
        if (this.fQ()) {
            this.fz();
        }
        axisalignedbb = this.cV();
        vec3d1 = new Vec3D(this.bC, this.bD, this.bE);
        if (this.d(MobEffects.B) || this.d(MobEffects.y)) {
            this.j();
        }
        SpigotTimings.timerEntityAIMove.startTiming();
        entityliving = this.cY();
        if (!(entityliving instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.bO()) {
            this.c(entityhuman, vec3d1);
        } else if (this.dk() && this.dl()) {
            this.k(vec3d1);
        }
        SpigotTimings.timerEntityAIMove.stopTiming();
        if (!this.ai().B_() || this.di()) {
            this.aL();
        }
        if (this.ai().B_()) {
            this.s(this instanceof EntityBird);
        }
        gameprofilerfiller.c();
        world = this.ai();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            gameprofilerfiller.a("freezing");
            if (!this.aI || !this.dN()) {
                this.k(Math.max(0, this.cy() - 2));
            }
            this.en();
            this.eo();
            if (this.as % 40 == 0 && this.cA() && this.dN()) {
                this.a(worldserver, this.ea().v(), 1.0f);
            }
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("push");
        if (this.bL > 0) {
            --this.bL;
            this.a(axisalignedbb, this.cV());
        }
        SpigotTimings.timerEntityAICollision.startTiming();
        this.o();
        SpigotTimings.timerEntityAICollision.stopTiming();
        gameprofilerfiller.c();
        world = this.ai();
        if (world instanceof WorldServer) {
            worldserver1 = (WorldServer)world;
            if (this.fx() && this.bo()) {
                this.a(worldserver1, this.ea().i(), 1.0f);
            }
        }
    }

    protected void fw() {
        this.bC *= 0.98f;
        this.bE *= 0.98f;
    }

    public boolean fx() {
        return false;
    }

    public boolean fy() {
        return this.bB;
    }

    protected void fz() {
        this.cC();
        if (!this.ai().C) {
            if (!this.fA()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bK + 1;
            if (i2 % 10 == 0) {
                int j2 = i2 / 10;
                if (j2 % 2 == 0) {
                    List<EnumItemSlot> list = EnumItemSlot.j.stream().filter(enumitemslot -> EntityLiving.b(this.a((EnumItemSlot)enumitemslot), enumitemslot)).toList();
                    EnumItemSlot enumitemslot2 = SystemUtils.a(list, this.ar);
                    this.a(enumitemslot2).a(1, this, enumitemslot2);
                }
                this.c(GameEvent.n);
            }
        }
    }

    protected boolean fA() {
        if (!(this.aK() || this.cc() || this.d(MobEffects.y))) {
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                if (!EntityLiving.b(this.a(enumitemslot), enumitemslot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fB() {
    }

    protected void o() {
        List<Entity> list = this.ai().i(this, this.cV());
        if (!list.isEmpty()) {
            WorldServer worldserver;
            int i2;
            net.minecraft.world.level.World world = this.ai();
            if (world instanceof WorldServer && (i2 = (worldserver = (WorldServer)world).P().d(GameRules.w)) > 0 && list.size() > i2 - 1 && this.ar.a(4) == 0) {
                int j2 = 0;
                for (Entity entity : list) {
                    if (entity.cc()) continue;
                    ++j2;
                }
                if (j2 > i2 - 1) {
                    this.a(worldserver, this.ea().h(), 6.0f);
                }
            }
            for (Entity entity1 : list) {
                this.E(entity1);
            }
        }
    }

    protected void a(AxisAlignedBB axisalignedbb, AxisAlignedBB axisalignedbb1) {
        AxisAlignedBB axisalignedbb2 = axisalignedbb.b(axisalignedbb1);
        List<Entity> list = this.ai().a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityLiving)) continue;
                this.f((EntityLiving)entity);
                this.bL = 0;
                this.i(this.dA().c(-0.2));
                break;
            }
        } else if (this.ac) {
            this.bL = 0;
        }
        if (!this.ai().C && this.bL <= 0) {
            this.c(4, false);
            this.bM = 0.0f;
            this.bN = null;
        }
    }

    protected void E(Entity entity) {
        entity.h(this);
    }

    protected void f(EntityLiving entityliving) {
    }

    public boolean fC() {
        return (this.ay.a(aZ) & 4) != 0;
    }

    @Override
    public void bS() {
        Entity entity = this.dm();
        super.bS();
        if (entity != null && entity != this.dm() && !this.ai().C) {
            this.G(entity);
        }
    }

    @Override
    public void r() {
        super.r();
        this.j();
    }

    @Override
    public InterpolationHandler l_() {
        return this.bF;
    }

    @Override
    public void a(float f2, int i2) {
        this.bG = f2;
        this.bH = i2;
    }

    public void t(boolean flag) {
        this.bB = flag;
    }

    public void a(EntityItem entityitem) {
        Entity entity = entityitem.ah_();
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.R.a((EntityPlayer)entity, entityitem.e(), this);
        }
    }

    public void a(Entity entity, int i2) {
        if (!entity.dU() && !this.ai().C && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.ai()).n().b(entity, new PacketPlayOutCollect(entity.ar(), this.ar(), i2));
        }
    }

    public boolean F(Entity entity) {
        return this.a(entity, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity.dG());
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption raytrace_blockcollisionoption, RayTrace.FluidCollisionOption raytrace_fluidcollisionoption, double d0) {
        if (entity.ai() != this.ai()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dC(), this.dG(), this.dI());
        Vec3D vec3d1 = new Vec3D(entity.dC(), d0, entity.dI());
        return vec3d1.f(vec3d) > 128.0 ? false : this.ai().a(new RayTrace(vec3d, vec3d1, raytrace_blockcollisionoption, raytrace_fluidcollisionoption, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float j(float f2) {
        return f2 == 1.0f ? this.bt : MathHelper.i(f2, this.bu, this.bt);
    }

    public float D(float f2) {
        float f1 = this.bn - this.bm;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.bm + f1 * f2;
    }

    @Override
    public boolean bK() {
        return !this.dU() && this.collides;
    }

    @Override
    public boolean bL() {
        return this.bO() && !this.am() && !this.eV() && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bL() && this.collides != this.collidableExemptions.contains(entity.cK());
    }

    @Override
    public float cE() {
        return this.bt;
    }

    @Override
    public void r(float f2) {
        this.bt = f2;
    }

    @Override
    public void s(float f2) {
        this.br = f2;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.l(super.a(enumdirection_enumaxis, blockutil_rectangle));
    }

    public static Vec3D l(Vec3D vec3d) {
        return new Vec3D(vec3d.d, vec3d.e, 0.0);
    }

    public float fD() {
        return this.co;
    }

    public final void E(float f2) {
        this.F(MathHelper.a(f2, 0.0f, this.fb()));
    }

    protected void F(float f2) {
        this.co = f2;
    }

    public void h_() {
    }

    public void P_() {
    }

    protected void fE() {
        this.ch = true;
    }

    public abstract EnumMainHand fF();

    public boolean fG() {
        return (this.ay.a(aZ) & 1) > 0;
    }

    public EnumHand fH() {
        return (this.ay.a(aZ) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    private void P() {
        if (this.fG()) {
            if (ItemStack.b(this.b(this.fH()), this.bI)) {
                this.bI = this.b(this.fH());
                this.a(this.bI);
            } else {
                this.fM();
            }
        }
    }

    @Nullable
    private EntityItem b(ItemStack itemstack, boolean flag, boolean flag1) {
        if (itemstack.f()) {
            return null;
        }
        double d0 = this.dG() - (double)0.3f;
        EntityItem entityitem = new EntityItem(this.ai(), this.dC(), d0, this.dI(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.b((Entity)this);
        }
        if (flag) {
            float f2 = this.ar.i() * 0.5f;
            float f1 = this.ar.i() * ((float)Math.PI * 2);
            entityitem.n(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f2 = 0.3f;
            float f3 = MathHelper.a(this.dR() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dR() * ((float)Math.PI / 180));
            float f5 = MathHelper.a(this.dP() * ((float)Math.PI / 180));
            float f6 = MathHelper.b(this.dP() * ((float)Math.PI / 180));
            float f7 = this.ar.i() * ((float)Math.PI * 2);
            float f8 = 0.02f * this.ar.i();
            entityitem.n((double)(-f5 * f4 * 0.3f) + Math.cos(f7) * (double)f8, -f3 * 0.3f + 0.1f + (this.ar.i() - this.ar.i()) * 0.1f, (double)(f6 * f4 * 0.3f) + Math.sin(f7) * (double)f8);
        }
        return entityitem;
    }

    protected void a(ItemStack itemstack) {
        itemstack.b(this.ai(), this, this.fJ());
        if (--this.bJ == 0 && !this.ai().C && !itemstack.x()) {
            this.w();
        }
    }

    private void Q() {
        this.cu = this.ct;
        this.ct = this.co() ? Math.min(1.0f, this.ct + 0.09f) : Math.max(0.0f, this.ct - 0.09f);
    }

    public void c(int i2, boolean flag) {
        int j2 = this.ay.a(aZ).byteValue();
        j2 = flag ? (j2 |= i2) : (j2 &= ~i2);
        this.ay.a(aZ, (byte)j2);
    }

    public void c(EnumHand enumhand) {
        ItemStack itemstack = this.b(enumhand);
        if (!itemstack.f() && !this.fG()) {
            this.bI = itemstack;
            this.bJ = itemstack.a(this);
            if (!this.ai().C) {
                this.c(1, true);
                this.c(2, enumhand == EnumHand.b);
                this.c(GameEvent.D);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (bZ.equals(datawatcherobject)) {
            if (this.ai().C) {
                this.fW().ifPresent(this::a);
            }
        } else if (aZ.equals(datawatcherobject) && this.ai().C) {
            if (this.fG() && this.bI.f()) {
                this.bI = this.b(this.fH());
                if (!this.bI.f()) {
                    this.bJ = this.bI.a(this);
                }
            } else if (!this.fG() && !this.bI.f()) {
                this.bI = ItemStack.l;
                this.bJ = 0;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.bu = this.bt;
        this.bs = this.br = this.bt;
    }

    @Override
    public float t(float f2) {
        return MathHelper.h(f2, this.bs, this.br);
    }

    public void b(ItemStack itemstack, int i2) {
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.ar.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.dR() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dP() * ((float)Math.PI / 180));
            double d0 = (double)(-this.ar.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.ar.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.dR() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dP() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dC(), this.dG(), this.dI());
            this.ai().a(new ParticleParamItem(Particles.U, itemstack), vec3d1.d, vec3d1.e, vec3d1.f, vec3d.d, vec3d.e + 0.05, vec3d.f);
        }
    }

    protected void w() {
        if (!this.ai().C || this.fG()) {
            EnumHand enumhand = this.fH();
            if (!this.bI.equals(this.b(enumhand))) {
                this.fL();
            } else if (!this.bI.f() && this.fG()) {
                ItemStack itemstack;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bI);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.bI.a(DataComponents.w);
                        if (consumable != null) {
                            consumable.cancelUsingItem(entityPlayer, this.bI);
                        }
                        entityPlayer.getBukkitEntity().updateInventory();
                        entityPlayer.getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bI.a(this.ai(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.ai(), this);
                } else {
                    itemstack = this.bI.a(this.ai(), this);
                }
                if (itemstack != this.bI) {
                    this.a(enumhand, itemstack);
                }
                this.fM();
            }
        }
    }

    public void b(ItemStack itemstack) {
    }

    public ItemStack fI() {
        return this.bI;
    }

    public int fJ() {
        return this.bJ;
    }

    public int fK() {
        return this.fG() ? this.bI.a(this) - this.fJ() : 0;
    }

    public void fL() {
        ItemStack itemstack = this.b(this.fH());
        if (!this.bI.f() && ItemStack.b(itemstack, this.bI)) {
            this.bI = itemstack;
            this.bI.a(this.ai(), this, this.fJ());
            if (this.bI.x()) {
                this.P();
            }
        }
        this.fM();
    }

    public void fM() {
        if (!this.ai().C) {
            boolean flag = this.fG();
            this.c(1, false);
            if (flag) {
                this.c(GameEvent.C);
            }
        }
        this.bI = ItemStack.l;
        this.bJ = 0;
    }

    public boolean fN() {
        return this.fO() != null;
    }

    @Nullable
    public ItemStack fO() {
        int i2;
        if (!this.fG()) {
            return null;
        }
        BlocksAttacks blocksattacks = this.bI.a(DataComponents.I);
        if (blocksattacks != null && (i2 = this.bI.h().a(this.bI, this) - this.bJ) >= blocksattacks.a()) {
            return this.bI;
        }
        return null;
    }

    public boolean fP() {
        return this.cg();
    }

    public boolean fQ() {
        return this.i(7);
    }

    @Override
    public boolean co() {
        return super.co() || !this.fQ() && this.c(EntityPose.b);
    }

    public int fR() {
        return this.bK;
    }

    public boolean b(double d0, double d1, double d2, boolean flag) {
        return this.randomTeleport(d0, d1, d2, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dC();
        double d4 = this.dE();
        double d5 = this.dI();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        net.minecraft.world.level.World world = this.ai();
        if (world.D(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.L_()) {
                BlockPosition blockposition1 = blockposition.e();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.a_(d0, d6, d2);
                if (world.g(this) && !world.d(this.cV())) {
                    flag1 = true;
                }
                this.a_(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.ai().getWorld(), d3, d4, d5), new Location((World)this.ai().getWorld(), d0, d6, d2));
                        this.ai().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).g.teleport(d0, d6, d2, this.dP(), this.dR(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        EntityCreature entitycreature = (EntityCreature)this;
        entitycreature.S().n();
        return Optional.of(true);
    }

    public boolean fS() {
        return !this.eM();
    }

    public boolean fT() {
        return true;
    }

    public void a(BlockPosition blockposition, boolean flag) {
    }

    public boolean fU() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose entitypose) {
        return entitypose == EntityPose.c ? ba : this.e(entitypose).a(this.eq());
    }

    protected EntitySize e(EntityPose entitypose) {
        return this.ap().n().a(this.ep());
    }

    public ImmutableList<EntityPose> fV() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB f(EntityPose entitypose) {
        EntitySize entitysize = this.a(entitypose);
        return new AxisAlignedBB(-entitysize.a() / 2.0f, 0.0, -entitysize.a() / 2.0f, entitysize.a() / 2.0f, entitysize.b(), entitysize.a() / 2.0f);
    }

    protected boolean g(EntityPose entitypose) {
        AxisAlignedBB axisalignedbb = this.a(entitypose).a(this.dv());
        return this.ai().b(this, axisalignedbb);
    }

    @Override
    public boolean o(boolean flag) {
        return super.o(flag) && !this.fY();
    }

    public Optional<BlockPosition> fW() {
        return this.ay.a(bZ);
    }

    public void g(BlockPosition blockposition) {
        this.ay.a(bZ, Optional.of(blockposition));
    }

    public void fX() {
        this.ay.a(bZ, Optional.empty());
    }

    public boolean fY() {
        return this.fW().isPresent();
    }

    public void b(BlockPosition blockposition) {
        IBlockData iblockdata;
        if (this.cc()) {
            this.bS();
        }
        if ((iblockdata = this.ai().a_(blockposition)).b() instanceof BlockBed) {
            this.ai().a(blockposition, (IBlockData)iblockdata.b(BlockBed.c, true), 3);
        }
        this.b(EntityPose.c);
        this.a(blockposition);
        this.g(blockposition);
        this.i(Vec3D.c);
        this.aE = true;
    }

    private void a(BlockPosition blockposition) {
        this.a_((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.6875, (double)blockposition.w() + 0.5);
    }

    private boolean R() {
        return this.fW().map(blockposition -> this.ai().a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void fZ() {
        Optional<BlockPosition> optional = this.fW();
        net.minecraft.world.level.World world = this.ai();
        Objects.requireNonNull(world);
        optional.filter(world::D).ifPresent(blockposition -> {
            IBlockData iblockdata = this.ai().a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = (EnumDirection)iblockdata.c(BlockBed.f);
                this.ai().a((BlockPosition)blockposition, (IBlockData)iblockdata.b(BlockBed.c, false), 3);
                Vec3D vec3d = BlockBed.a(this.ap(), (ICollisionAccess)this.ai(), blockposition, enumdirection, this.dP()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.d();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec3d1.f, vec3d1.d) * 57.2957763671875 - 90.0);
                this.a_(vec3d.d, vec3d.e, vec3d.f);
                this.v(f2);
                this.w(0.0f);
            }
        });
        Vec3D vec3d = this.dv();
        this.b(EntityPose.a);
        this.a_(vec3d.d, vec3d.e, vec3d.f);
        this.fX();
    }

    @Nullable
    public EnumDirection ga() {
        BlockPosition blockposition = this.fW().orElse(null);
        return blockposition != null ? BlockBed.a(this.ai(), blockposition) : null;
    }

    @Override
    public boolean bP() {
        return !this.fY() && super.bP();
    }

    public ItemStack d(ItemStack itemstack) {
        return ItemStack.l;
    }

    private static byte g(EnumItemSlot enumitemslot) {
        return switch (enumitemslot) {
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
            case EnumItemSlot.h -> 68;
            default -> throw new MatchException(null, null);
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot enumitemslot) {
        this.ai().a((Entity)this, EntityLiving.g(enumitemslot));
        this.a(this.a(enumitemslot), enumitemslot, this.cc);
    }

    private void a(ItemStack itemstack, EnumItemSlot enumitemslot, AttributeMapBase attributemapbase) {
        itemstack.a(enumitemslot, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
            AttributeModifiable attributemodifiable = attributemapbase.a((Holder<AttributeBase>)holder);
            if (attributemodifiable != null) {
                attributemodifiable.e((AttributeModifier)attributemodifier);
            }
        });
        EnchantmentManager.a(itemstack, this, enumitemslot);
    }

    public static EnumItemSlot d(EnumHand enumhand) {
        return enumhand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b;
    }

    public final boolean e(ItemStack itemstack) {
        if (this.bO() && !this.am()) {
            Equippable equippable = itemstack.a(DataComponents.D);
            if (equippable != null && equippable.g()) {
                EnumItemSlot enumitemslot = equippable.b();
                return this.e(enumitemslot) && equippable.a(this.ap()) ? this.a(enumitemslot).f() && this.f(enumitemslot) : false;
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot enumitemslot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack itemstack) {
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable != null && this.e(equippable.b()) ? equippable.b() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack itemstack, EnumItemSlot enumitemslot) {
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable == null ? enumitemslot == EnumItemSlot.a && this.e(EnumItemSlot.a) : enumitemslot == equippable.b() && this.e(equippable.b()) && equippable.a(this.ap());
    }

    private static SlotAccess a(EntityLiving entityliving, EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.f && enumitemslot != EnumItemSlot.a && enumitemslot != EnumItemSlot.b ? SlotAccess.a(entityliving, enumitemslot, (ItemStack itemstack) -> itemstack.f() || entityliving.f((ItemStack)itemstack) == enumitemslot) : SlotAccess.a(entityliving, enumitemslot);
    }

    @Nullable
    private static EnumItemSlot r(int i2) {
        return i2 == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (i2 == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (i2 == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (i2 == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (i2 == 98 ? EnumItemSlot.a : (i2 == 99 ? EnumItemSlot.b : (i2 == 105 ? EnumItemSlot.g : (i2 == 106 ? EnumItemSlot.h : null)))))));
    }

    @Override
    public SlotAccess a_(int i2) {
        EnumItemSlot enumitemslot = EntityLiving.r(i2);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(i2);
    }

    @Override
    public boolean dN() {
        if (this.am()) {
            return false;
        }
        for (EnumItemSlot enumitemslot : EquipmentSlotGroup.i) {
            if (!this.a(enumitemslot).a(TagsItem.bx)) continue;
            return false;
        }
        return super.dN();
    }

    @Override
    public boolean cr() {
        return !this.ai().B_() && this.d(MobEffects.x) || super.cr();
    }

    @Override
    public float dQ() {
        return this.br;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        float f2 = packetplayoutspawnentity.n();
        float f1 = packetplayoutspawnentity.m();
        this.e(d0, d1, d2);
        this.br = packetplayoutspawnentity.o();
        this.bt = packetplayoutspawnentity.o();
        this.bs = this.br;
        this.bu = this.bt;
        this.e(packetplayoutspawnentity.b());
        this.a_(packetplayoutspawnentity.e());
        this.a(d0, d1, d2, f2, f1);
        this.n(packetplayoutspawnentity.j(), packetplayoutspawnentity.k(), packetplayoutspawnentity.l());
    }

    public float gb() {
        Weapon weapon = this.ed().a(DataComponents.B);
        return weapon != null ? weapon.b() : 0.0f;
    }

    @Override
    public float dT() {
        float f2 = (float)this.i(GenericAttributes.C);
        return this.cY() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D n(Entity entity) {
        return this.dv().e(this.a(entity, this.a(this.aw()), this.eq() * this.ep()));
    }

    protected void a(int i2, double d0) {
        this.bt = (float)MathHelper.e(1.0 / (double)i2, (double)this.bt, d0);
    }

    @Override
    public void g(int i2) {
        super.g(MathHelper.c((double)i2 * this.i(GenericAttributes.h)));
    }

    public boolean gc() {
        return false;
    }

    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.d(damagesource) || EnchantmentManager.a(worldserver, this, damagesource);
    }

    public static boolean b(ItemStack itemstack, EnumItemSlot enumitemslot) {
        if (!itemstack.c(DataComponents.F)) {
            return false;
        }
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable != null && enumitemslot == equippable.b() && !itemstack.r();
    }

    @VisibleForTesting
    public int gd() {
        return this.bx;
    }

    @Override
    public boolean ge() {
        return this.i(GenericAttributes.H) > 0.0;
    }

    @Override
    public Optional<WaypointTransmitter.c> f(EntityPlayer entityplayer) {
        if (!this.ax && entityplayer != this) {
            if (WaypointTransmitter.a(this, entityplayer)) {
                return Optional.empty();
            }
            Waypoint.a waypoint_a = this.cx.a(this);
            return WaypointTransmitter.b(this, entityplayer) ? Optional.of(new WaypointTransmitter.d(this, waypoint_a, entityplayer)) : (!WaypointTransmitter.a(this.dz(), entityplayer) ? Optional.of(new WaypointTransmitter.f(this, waypoint_a, entityplayer)) : Optional.of(new WaypointTransmitter.e(this, waypoint_a, entityplayer)));
        }
        return Optional.empty();
    }

    @Override
    public Waypoint.a gf() {
        return this.cx;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

