/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFox
extends EntityAnimal {
    private static final DataWatcherObject<Integer> co = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> cp = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int cq = 1;
    public static final int ck = 4;
    public static final int cl = 8;
    public static final int cm = 16;
    private static final int cr = 32;
    private static final int cs = 64;
    private static final int ct = 128;
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cu = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cv = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    static final Predicate<EntityItem> cw = entityitem -> !entityitem.n() && entityitem.bO();
    private static final Predicate<Entity> cx = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.ez() != null && entityliving.eA() < entityliving.as + 600;
    };
    static final Predicate<Entity> cy = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> cz = entity -> !entity.cj() && IEntitySelector.e.test((Entity)entity);
    private static final int cA = 600;
    private static final EntitySize cB = EntityTypes.ab.n().a(0.5f).b(0.2975f);
    private static final Codec<List<EntityReference<EntityLiving>>> cC = EntityReference.a().listOf();
    private static final boolean cD = false;
    private static final boolean cE = false;
    private static final boolean cF = false;
    private PathfinderGoal cG;
    private PathfinderGoal cH;
    private PathfinderGoal cI;
    private float cJ;
    private float cM;
    float cN;
    float cO;
    private int cP;

    public EntityFox(EntityTypes<? extends EntityFox> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cd = new k();
        this.ce = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.a_(true);
        this.S().a(32.0f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cu, Optional.empty());
        datawatcher_a.a(cv, Optional.empty());
        datawatcher_a.a(co, Type.c.a());
        datawatcher_a.a(cp, (byte)0);
    }

    @Override
    protected void H() {
        this.cG = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, (entityliving, worldserver) -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.cH = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.ck);
        this.cI = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, (entityliving, worldserver) -> entityliving instanceof EntityFishSchool);
        this.ch.a(0, new g());
        this.ch.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.ai()));
        this.ch.a(1, new b());
        this.ch.a(2, new n(2.2));
        this.ch.a(3, new e(this, 1.0));
        this.ch.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> cz.test((Entity)entityliving) && !this.j((EntityLiving)entityliving) && !this.gV()));
        this.ch.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).m() && !this.gV()));
        this.ch.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.gV()));
        this.ch.a(5, new u());
        this.ch.a(6, new o());
        this.ch.a(6, new s(1.25));
        this.ch.a(7, new l((double)1.2f, true));
        this.ch.a(7, new t());
        this.ch.a(8, new h(this, 1.25));
        this.ch.a(9, new q(32, 200));
        this.ch.a(10, new f((double)1.2f, 12, 1));
        this.ch.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.ch.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.ch.a(11, new p());
        this.ch.a(12, new j(this, EntityHuman.class, 24.0f));
        this.ch.a(13, new r());
        this.ci.a(3, new a(EntityLiving.class, false, false, (entityliving, worldserver) -> cx.test(entityliving) && !this.j(entityliving)));
    }

    @Override
    public void e_() {
        if (!this.ai().C && this.bO() && this.dl()) {
            EntityLiving entityliving;
            ++this.cP;
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (this.j(itemstack)) {
                if (this.cP > 600) {
                    ItemStack itemstack1 = itemstack.a(this.ai(), (EntityLiving)this);
                    if (!itemstack1.f()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.cP = 0;
                } else if (this.cP > 560 && this.ar.i() < 0.1f) {
                    this.gN();
                    this.ai().a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.e()) == null || !entityliving.bO()) {
                this.z(false);
                this.A(false);
            }
        }
        if (this.fY() || this.fm()) {
            this.bB = false;
            this.bC = 0.0f;
            this.bE = 0.0f;
        }
        super.e_();
        if (this.gV() && this.ar.i() < 0.05f) {
            this.a(SoundEffects.jS, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean fm() {
        return this.eM();
    }

    private boolean j(ItemStack itemstack) {
        return itemstack.c(DataComponents.v) && this.e() == null && this.aK() && !this.fY();
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.2f) {
            float f2 = randomsource.i();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.pF) : (f2 < 0.2f ? new ItemStack(Items.rY) : (f2 < 0.4f ? (randomsource.h() ? new ItemStack(Items.wg) : new ItemStack(Items.wh)) : (f2 < 0.6f ? new ItemStack(Items.qB) : (f2 < 0.8f ? new ItemStack(Items.rK) : new ItemStack(Items.qy)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 45) {
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (!itemstack.f()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.ar.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dR() * ((float)Math.PI / 180)).b(-this.dP() * ((float)Math.PI / 180));
                    this.ai().a(new ParticleParamItem(Particles.U, itemstack), this.dC() + this.bW().d / 2.0, this.dE(), this.dI() + this.bW().f / 2.0, vec3d.d, vec3d.e + 0.05, vec3d.f);
                }
            }
        } else {
            super.b(b0);
        }
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gM().a(GenericAttributes.w, 0.3f).a(GenericAttributes.t, 10.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.y, 5.0).a(GenericAttributes.n, 32.0);
    }

    @Nullable
    public EntityFox b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityFox entityfox = EntityTypes.ab.a(worldserver, EntitySpawnReason.e);
        if (entityfox != null) {
            entityfox.a(this.ar.h() ? this.n() : ((EntityFox)entityageable).n());
        }
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cj) && EntityFox.a(generatoraccess, blockposition);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        Holder<BiomeBase> holder = worldaccess.v(this.dx());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (groupdataentity instanceof i) {
            i entityfox_i = (i)groupdataentity;
            entityfox_type = entityfox_i.a;
            if (entityfox_i.a() >= 2) {
                flag = true;
            }
        } else {
            groupdataentity = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.c_(-24000);
        }
        if (worldaccess instanceof WorldServer) {
            this.gL();
        }
        this.a(worldaccess.H_(), difficultydamagescaler);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private void gL() {
        if (this.n() == Type.a) {
            this.ci.a(4, this.cG);
            this.ci.a(4, this.cH);
            this.ci.a(6, this.cI);
        } else {
            this.ci.a(4, this.cI);
            this.ci.a(6, this.cG);
            this.ci.a(6, this.cH);
        }
    }

    @Override
    protected void gN() {
        this.a(SoundEffects.jW, 1.0f, 1.0f);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.g_() ? cB : super.e(entitypose);
    }

    public Type n() {
        return Type.a(this.ay.a(co));
    }

    public void a(Type entityfox_type) {
        this.ay.a(co, entityfox_type.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.az ? EntityFox.c(datacomponenttype, this.n()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.az);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.az) {
            this.a(EntityFox.c(DataComponents.az, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    Stream<EntityReference<EntityLiving>> gT() {
        return Stream.concat(this.ay.a(cu).stream(), this.ay.a(cv).stream());
    }

    void i(EntityLiving entityliving) {
        this.a(new EntityReference<EntityLiving>(entityliving));
    }

    private void a(EntityReference<EntityLiving> entityreference) {
        if (this.ay.a(cu).isPresent()) {
            this.ay.a(cv, Optional.of(entityreference));
        } else {
            this.ay.a(cu, Optional.of(entityreference));
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Trusted", cC, this.gT().toList());
        valueoutput.a("Sleeping", this.fY());
        valueoutput.a("Type", Type.d, this.n());
        valueoutput.a("Sitting", this.t());
        valueoutput.a("Crouching", this.cl());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.gU();
        valueinput.a("Trusted", cC).orElse(List.of()).forEach(this::a);
        this.D(valueinput.a("Sleeping", false));
        this.a(valueinput.a("Type", Type.d).orElse(Type.c));
        this.x(valueinput.a("Sitting", false));
        this.z(valueinput.a("Crouching", false));
        if (this.ai() instanceof WorldServer) {
            this.gL();
        }
    }

    private void gU() {
        this.ay.a(cu, Optional.empty());
        this.ay.a(cv, Optional.empty());
    }

    public boolean t() {
        return this.s(1);
    }

    public void x(boolean flag) {
        this.d(1, flag);
    }

    public boolean gH() {
        return this.s(64);
    }

    void B(boolean flag) {
        this.d(64, flag);
    }

    boolean gV() {
        return this.s(128);
    }

    void C(boolean flag) {
        this.d(128, flag);
    }

    @Override
    public boolean fY() {
        return this.s(32);
    }

    public void D(boolean flag) {
        this.d(32, flag);
    }

    private void d(int i2, boolean flag) {
        if (flag) {
            this.ay.a(cp, (byte)(this.ay.a(cp) | i2));
        } else {
            this.ay.a(cp, (byte)(this.ay.a(cp) & ~i2));
        }
    }

    private boolean s(int i2) {
        return (this.ay.a(cp) & i2) != 0;
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.a && this.fU();
    }

    @Override
    public boolean g(ItemStack itemstack) {
        ItemStack itemstack1 = this.a(EnumItemSlot.a);
        return itemstack1.f() || this.cP > 0 && itemstack.c(DataComponents.v) && !itemstack1.c(DataComponents.v);
    }

    private void k(ItemStack itemstack) {
        if (!itemstack.f() && !this.ai().C) {
            EntityItem entityitem = new EntityItem(this.ai(), this.dC() + this.bW().d, this.dE() + 1.0, this.dI() + this.bW().f, itemstack);
            entityitem.b(40);
            entityitem.b((Entity)this);
            this.a(SoundEffects.kb, 1.0f, 1.0f);
            this.ai().b(entityitem);
        }
    }

    private void l(ItemStack itemstack) {
        EntityItem entityitem = new EntityItem(this.ai(), this.dC(), this.dE(), this.dI(), itemstack);
        this.ai().b(entityitem);
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        ItemStack itemstack = entityitem.e();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entityitem, itemstack.M() - 1, !this.g(itemstack)).isCancelled()) {
            itemstack = entityitem.e();
            int i2 = itemstack.M();
            if (i2 > 1) {
                this.l(itemstack.a(i2 - 1));
            }
            this.k(this.a(EnumItemSlot.a));
            this.a(entityitem);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.g(EnumItemSlot.a);
            this.a((Entity)entityitem, itemstack.M());
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            this.cP = 0;
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.dl()) {
            boolean flag = this.bm();
            if (flag || this.e() != null || this.ai().ag()) {
                this.gW();
            }
            if (flag || this.fY()) {
                this.x(false);
            }
            if (this.gH() && this.ai().A.i() < 0.2f) {
                BlockPosition blockposition = this.dx();
                IBlockData iblockdata = this.ai().a_(blockposition);
                this.ai().c(2001, blockposition, Block.j(iblockdata));
            }
        }
        this.cM = this.cJ;
        this.cJ = this.gK() ? (this.cJ += (1.0f - this.cJ) * 0.4f) : (this.cJ += (0.0f - this.cJ) * 0.4f);
        this.cO = this.cN;
        if (this.cl()) {
            this.cN += 0.2f;
            if (this.cN > 3.0f) {
                this.cN = 3.0f;
            }
        } else {
            this.cN = 0.0f;
        }
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.av);
    }

    @Override
    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
        ((EntityFox)entityinsentient).i(entityhuman);
    }

    public boolean gI() {
        return this.s(16);
    }

    public void y(boolean flag) {
        this.d(16, flag);
    }

    public boolean gJ() {
        return this.cN == 3.0f;
    }

    public void z(boolean flag) {
        this.d(4, flag);
    }

    @Override
    public boolean cl() {
        return this.s(4);
    }

    public void A(boolean flag) {
        this.d(8, flag);
    }

    public boolean gK() {
        return this.s(8);
    }

    public float J(float f2) {
        return MathHelper.h(f2, this.cM, this.cJ) * 0.11f * (float)Math.PI;
    }

    public float K(float f2) {
        return MathHelper.h(f2, this.cO, this.cN);
    }

    @Override
    public void g(@Nullable EntityLiving entityliving) {
        if (this.gV() && entityliving == null) {
            this.C(false);
        }
        super.g(entityliving);
    }

    void gW() {
        this.D(false);
    }

    void gX() {
        this.A(false);
        this.z(false);
        this.x(false);
        this.D(false);
        this.C(false);
        this.B(false);
    }

    boolean gY() {
        return !this.fY() && !this.t() && !this.gH();
    }

    @Override
    public void X() {
        SoundEffect soundeffect = this.p();
        if (soundeffect == SoundEffects.jY) {
            this.a(soundeffect, 2.0f, this.fl());
        } else {
            super.X();
        }
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        List<Entity> list;
        if (this.fY()) {
            return SoundEffects.jZ;
        }
        if (!this.ai().W() && this.ar.i() < 0.1f && (list = this.ai().a(EntityHuman.class, this.cV().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.jY;
        }
        return SoundEffects.jT;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.jX;
    }

    @Override
    @Nullable
    protected SoundEffect f_() {
        return SoundEffects.jV;
    }

    boolean j(EntityLiving entityliving) {
        return this.gT().anyMatch(entityreference -> entityreference.a(entityliving));
    }

    @Override
    protected void b(WorldServer worldserver, DamageSource damagesource) {
        ItemStack itemstack = this.a(EnumItemSlot.a);
        if (!itemstack.f()) {
            this.a(worldserver, itemstack);
            this.a(EnumItemSlot.a, ItemStack.l);
        }
        super.b(worldserver, damagesource);
    }

    public static boolean a(EntityFox entityfox, EntityLiving entityliving) {
        double d0 = entityliving.dI() - entityfox.dI();
        double d1 = entityliving.dC() - entityfox.dC();
        double d2 = d0 / d1;
        int i2 = 6;
        for (int j2 = 0; j2 < 6; ++j2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j2 / 6.0f) : d3 / d2;
            for (int k2 = 1; k2 < 4; ++k2) {
                if (entityfox.ai().a_(BlockPosition.a(entityfox.dC() + d4, entityfox.dE() + (double)k2, entityfox.dI() + d3)).v()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.55f * this.cW(), this.ds() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fY()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gI() && !EntityFox.this.cl() && !EntityFox.this.gK() && !EntityFox.this.gH();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gY()) {
                super.a();
            }
        }
    }

    public static enum Type implements INamable
    {
        a(0, "red"),
        b(1, "snow");

        public static final Type c;
        public static final INamable.a<Type> d;
        private static final IntFunction<Type> f;
        public static final StreamCodec<ByteBuf, Type> e;
        private final int g;
        private final String h;

        private Type(int i2, String s2) {
            this.g = i2;
            this.h = s2;
        }

        @Override
        public String c() {
            return this.h;
        }

        public int a() {
            return this.g;
        }

        public static Type a(int i2) {
            return f.apply(i2);
        }

        public static Type a(Holder<BiomeBase> holder) {
            return holder.a(BiomeTags.at) ? b : a;
        }

        static {
            c = a;
            d = INamable.a(Type::values);
            f = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
            e = ByteBufCodecs.a(f, Type::a);
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void d() {
            super.d();
            EntityFox.this.gX();
        }

        @Override
        public boolean b() {
            return EntityFox.this.bm() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bA();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityFox.this.gH();
        }

        @Override
        public boolean c() {
            return this.b() && this.a > 0;
        }

        @Override
        public void d() {
            this.a = this.a(40);
        }

        @Override
        public void e() {
            EntityFox.this.B(false);
        }

        @Override
        public void a() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.gV() && super.h();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(EntityFox entityFox, double d0) {
            super(entityFox, d0);
        }

        @Override
        public void d() {
            ((EntityFox)this.a).gX();
            ((EntityFox)this.c).gX();
            super.d();
        }

        @Override
        protected void g() {
            WorldServer worldserver = this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.gQ();
                EntityPlayer entityplayer1 = this.c.gQ();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.i(entityplayer);
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.i(entityplayer1);
                }
                entityfox.c_(-24000);
                entityfox.b(this.a.dC(), this.a.dE(), this.a.dI(), 0.0f, 0.0f);
                int experience = this.a.ec().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.Q);
                    CriterionTriggers.p.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.gS();
                this.c.gS();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (worldserver.P().c(GameRules.g) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dC(), this.a.dE(), this.a.dI(), experience));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            if (EntityFox.this.fY()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.e();
            return entityliving != null && entityliving.bO() && cy.test(entityliving) && EntityFox.this.g((Entity)entityliving) > 36.0 && !EntityFox.this.cl() && !EntityFox.this.gK() && !EntityFox.this.bB;
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.B(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.A(true);
                EntityFox.this.z(true);
                EntityFox.this.S().n();
                EntityFox.this.P().a(entityliving, (float)EntityFox.this.gh(), (float)EntityFox.this.gg());
            } else {
                EntityFox.this.A(false);
                EntityFox.this.z(false);
            }
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null) {
                EntityFox.this.P().a(entityliving, (float)EntityFox.this.gh(), (float)EntityFox.this.gg());
                if (EntityFox.this.g((Entity)entityliving) <= 36.0) {
                    EntityFox.this.A(true);
                    EntityFox.this.z(true);
                    EntityFox.this.S().n();
                } else {
                    EntityFox.this.S().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean b() {
            if (!EntityFox.this.gJ()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null && entityliving.bO()) {
                if (entityliving.cT() != entityliving.cS()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.S().a((Entity)entityliving, 0);
                    EntityFox.this.z(false);
                    EntityFox.this.A(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null && entityliving.bO()) {
                double d0 = EntityFox.this.dA().e;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.dR()) >= 15.0f || !EntityFox.this.aK()) && !EntityFox.this.gH();
            }
            return false;
        }

        @Override
        public boolean W_() {
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.t(true);
            EntityFox.this.y(true);
            EntityFox.this.A(false);
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null) {
                EntityFox.this.P().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dC() - EntityFox.this.dC(), entityliving.dE() - EntityFox.this.dE(), entityliving.dI() - EntityFox.this.dI()).d();
                EntityFox.this.i(EntityFox.this.dA().b(vec3d.d * 0.8, 0.9, vec3d.f * 0.8));
            }
            EntityFox.this.S().n();
        }

        @Override
        public void e() {
            EntityFox.this.z(false);
            EntityFox.this.cN = 0.0f;
            EntityFox.this.cO = 0.0f;
            EntityFox.this.A(false);
            EntityFox.this.y(false);
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null) {
                EntityFox.this.P().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.gH()) {
                Vec3D vec3d = EntityFox.this.dA();
                if (vec3d.e * vec3d.e < (double)0.03f && EntityFox.this.dR() != 0.0f) {
                    EntityFox.this.w(MathHelper.i(0.2f, EntityFox.this.dR(), 0.0f));
                } else {
                    double d0 = vec3d.i();
                    double d1 = Math.signum(-vec3d.e) * Math.acos(d0 / vec3d.g()) * 57.2957763671875;
                    EntityFox.this.w((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.f((Entity)entityliving) <= 2.0f) {
                EntityFox.this.c(net.minecraft.world.entity.animal.EntityFox$o.a(EntityFox.this.ai()), (Entity)entityliving);
            } else if (EntityFox.this.dR() > 0.0f && EntityFox.this.aK() && (float)EntityFox.this.dA().e != 0.0f && EntityFox.this.ai().a_(EntityFox.this.dx()).a(Blocks.ed)) {
                EntityFox.this.w(60.0f);
                EntityFox.this.g((EntityLiving)null);
                EntityFox.this.B(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.fY() && this.a.e() == null) {
                if (EntityFox.this.ai().ag() && EntityFox.this.ai().h(this.a.dx())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.dx();
                return EntityFox.this.ai().W() && EntityFox.this.ai().h(blockposition) && !((WorldServer)EntityFox.this.ai()).c(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.gX();
            super.d();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving entityliving) {
            if (this.b(entityliving)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.EntityFox$l.a(this.a), (Entity)entityliving);
                EntityFox.this.a(SoundEffects.jU, 1.0f, 1.0f);
            }
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
            super.d();
        }

        @Override
        public boolean b() {
            return !EntityFox.this.t() && !EntityFox.this.fY() && !EntityFox.this.cl() && !EntityFox.this.gH() && super.b();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.ar.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            return EntityFox.this.bC == 0.0f && EntityFox.this.bD == 0.0f && EntityFox.this.bE == 0.0f ? this.k() || EntityFox.this.fY() : false;
        }

        @Override
        public boolean c() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.ai().W() && this.h() && !this.i() && !EntityFox.this.aI;
        }

        @Override
        public void e() {
            this.d = EntityFox.this.ar.a(c);
            EntityFox.this.gX();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.z(false);
            EntityFox.this.A(false);
            EntityFox.this.t(false);
            EntityFox.this.D(true);
            EntityFox.this.S().n();
            EntityFox.this.Q().a(EntityFox.this.dC(), EntityFox.this.dE(), EntityFox.this.dI(), 0.0);
        }
    }

    private static class h
    extends PathfinderGoalFollowParent {
        private final EntityFox d;

        public h(EntityFox entityfox, double d0) {
            super(entityfox, d0);
            this.d = entityfox;
        }

        @Override
        public boolean b() {
            return !this.d.gV() && super.b();
        }

        @Override
        public boolean c() {
            return !this.d.gV() && super.c();
        }

        @Override
        public void d() {
            this.d.gX();
            super.d();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void d() {
            EntityFox.this.gX();
            super.d();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        @Override
        public boolean c() {
            return super.c() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fY() && !EntityFox.this.t() && !EntityFox.this.gV() && EntityFox.this.e() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            IBlockData iblockdata = iworldreader.a_(blockposition);
            return iblockdata.a(Blocks.oP) && iblockdata.c(BlockSweetBerryBush.c) >= 2 || CaveVines.j_(iblockdata);
        }

        @Override
        public void a() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.ar.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.ka, 1.0f, 1.0f);
            }
            super.a();
        }

        protected void o() {
            if (net.minecraft.world.entity.animal.EntityFox$f.a(EntityFox.this.ai()).P().c(GameRules.d)) {
                IBlockData iblockdata = EntityFox.this.ai().a_(this.e);
                if (iblockdata.a(Blocks.oP)) {
                    this.b(iblockdata);
                } else if (CaveVines.j_(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData iblockdata) {
            CaveVines.a(EntityFox.this, iblockdata, EntityFox.this.ai(), this.e);
        }

        private void b(IBlockData iblockdata) {
            int i2 = iblockdata.c(BlockSweetBerryBush.c);
            iblockdata.b(BlockSweetBerryBush.c, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)iblockdata.b(BlockSweetBerryBush.c, 1))) {
                return;
            }
            int j2 = 1 + EntityFox.this.ai().A.a(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.f()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.ya));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.ai(), this.e, new ItemStack(Items.ya, j2));
            }
            EntityFox.this.a(SoundEffects.AV, 1.0f, 1.0f);
            EntityFox.this.ai().a(this.e, (IBlockData)iblockdata.b(BlockSweetBerryBush.c, 1), 2);
            EntityFox.this.ai().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean b() {
            return !EntityFox.this.fY() && super.b();
        }

        @Override
        public void d() {
            this.g = 0;
            EntityFox.this.x(false);
            super.d();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.a(EnumItemSlot.a).f()) {
                return false;
            }
            if (EntityFox.this.e() == null && EntityFox.this.ew() == null) {
                if (!EntityFox.this.gY()) {
                    return false;
                }
                if (EntityFox.this.ec().a(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.ai().a(EntityItem.class, EntityFox.this.cV().c(8.0, 8.0, 8.0), cw);
                return !list.isEmpty() && EntityFox.this.a(EnumItemSlot.a).f();
            }
            return false;
        }

        @Override
        public void a() {
            List<EntityItem> list = EntityFox.this.ai().a(EntityItem.class, EntityFox.this.cV().c(8.0, 8.0, 8.0), cw);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.f() && !list.isEmpty()) {
                EntityFox.this.S().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void d() {
            List<EntityItem> list = EntityFox.this.ai().a(EntityItem.class, EntityFox.this.cV().c(8.0, 8.0, 8.0), cw);
            if (!list.isEmpty()) {
                EntityFox.this.S().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient entityinsentient, Class oclass, float f2) {
            super(entityinsentient, oclass, f2);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.gH() && !EntityFox.this.gK();
        }

        @Override
        public boolean c() {
            return super.c() && !EntityFox.this.gH() && !EntityFox.this.gK();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityFox.this.ew() == null && EntityFox.this.ec().i() < 0.02f && !EntityFox.this.fY() && EntityFox.this.e() == null && EntityFox.this.S().l() && !this.i() && !EntityFox.this.gI() && !EntityFox.this.cl();
        }

        @Override
        public boolean c() {
            return this.f > 0;
        }

        @Override
        public void d() {
            this.k();
            this.f = 2 + EntityFox.this.ec().a(3);
            EntityFox.this.x(true);
            EntityFox.this.S().n();
        }

        @Override
        public void e() {
            EntityFox.this.x(false);
        }

        @Override
        public void a() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.P().a(EntityFox.this.dC() + this.c, EntityFox.this.dG(), EntityFox.this.dI() + this.d, EntityFox.this.gh(), EntityFox.this.gg());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.ec().j();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.ec().a(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, PathfinderTargetCondition.a pathfindertargetcondition_a) {
            super(EntityFox.this, oclass, 10, flag, flag1, pathfindertargetcondition_a);
        }

        @Override
        public boolean b() {
            if (this.b > 0 && this.e.ec().a(this.b) != 0) {
                return false;
            }
            WorldServer worldserver = net.minecraft.world.entity.animal.EntityFox$a.a(EntityFox.this.ai());
            for (EntityReference<EntityLiving> entityreference : EntityFox.this.gT().toList()) {
                EntityLiving entityliving = entityreference.a(worldserver, EntityLiving.class);
                if (entityliving == null) continue;
                this.k = entityliving;
                this.j = entityliving.ew();
                int i2 = entityliving.ey();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void d() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.ey();
            }
            EntityFox.this.a(SoundEffects.jS, 1.0f, 1.0f);
            EntityFox.this.C(true);
            EntityFox.this.gW();
            super.d();
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type entityfox_type) {
            super(false);
            this.a = entityfox_type;
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = BlockPosition.a(EntityFox.this.dC(), EntityFox.this.cV().e, EntityFox.this.dI());
            return !EntityFox.this.ai().h(blockposition) && EntityFox.this.c(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !net.minecraft.world.entity.animal.EntityFox$d.a(EntityFox.this.ai()).a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cV().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class c
    implements PathfinderTargetCondition.a {
        @Override
        public boolean test(EntityLiving entityliving, WorldServer worldserver) {
            if (entityliving instanceof EntityFox) {
                return false;
            }
            if (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster)) {
                EntityHuman entityhuman;
                if (entityliving instanceof EntityTameableAnimal) {
                    return !((EntityTameableAnimal)entityliving).m();
                }
                if (entityliving instanceof EntityHuman && ((entityhuman = (EntityHuman)entityliving).am() || entityhuman.gI())) {
                    return false;
                }
                if (EntityFox.this.j(entityliving)) {
                    return false;
                }
                return !entityliving.fY() && !entityliving.cj();
            }
            return true;
        }
    }
}

