/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap ck = new PathfinderGoalHorseTrap(this);
    private static final int cl = 18000;
    private static final boolean cm = false;
    private static final int co = 0;
    private static final EntitySize cp = EntityTypes.bi.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bi.m() - 0.03125f, 0.0f)).a(0.5f);
    private boolean cq = false;
    public int cr = 0;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> entitytypes, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)entitytypes, world);
    }

    public static AttributeProvider.Builder m() {
        return EntityHorseSkeleton.hh().a(GenericAttributes.t, 15.0).a(GenericAttributes.w, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return !EntitySpawnReason.a(entityspawnreason) ? EntityAnimal.b(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource) : EntitySpawnReason.b(entityspawnreason) || EntityHorseSkeleton.a(generatoraccess, blockposition);
    }

    @Override
    protected void a(RandomSource randomsource) {
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.p);
        Objects.requireNonNull(randomsource);
        attributemodifiable.a(EntityHorseSkeleton.a(randomsource::j));
    }

    @Override
    protected void gZ() {
    }

    @Override
    protected SoundEffect p() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.yx : SoundEffects.yt;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.yu;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.yv;
    }

    @Override
    protected SoundEffect aY() {
        if (this.aK()) {
            if (!this.cd()) {
                return SoundEffects.yA;
            }
            ++this.cG;
            if (this.cG > 5 && this.cG % 3 == 0) {
                return SoundEffects.yy;
            }
            if (this.cG <= 5) {
                return SoundEffects.yA;
            }
        }
        return SoundEffects.yw;
    }

    @Override
    protected void g(float f2) {
        if (this.aK()) {
            super.g(0.3f);
        } else {
            super.g(Math.min(0.1f, f2 * 25.0f));
        }
    }

    @Override
    protected void ho() {
        if (this.bm()) {
            this.a(SoundEffects.yz, 0.4f, 1.0f);
        } else {
            super.ho();
        }
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.g_() ? cp : super.e(entitypose);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.n() && this.cr++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("SkeletonTrap", this.n());
        valueoutput.a("SkeletonTrapTime", this.cr);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.x(valueinput.a("SkeletonTrap", false));
        this.cr = valueinput.a("SkeletonTrapTime", 0);
    }

    @Override
    protected float fq() {
        return 0.96f;
    }

    public boolean n() {
        return this.cq;
    }

    public void x(boolean flag) {
        if (flag != this.cq) {
            this.cq = flag;
            if (flag) {
                this.ch.a(1, this.ck);
            } else {
                this.ch.a(this.ck);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.bi.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return !this.gY() ? EnumInteractionResult.e : super.b(entityhuman, enumhand);
    }
}

