/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int cq = 1700;
    private static final int cr = 6000;
    private static final int cs = 30;
    private static final int ct = 120;
    private static final int cu = 48000;
    private static final float cv = 0.4f;
    private static final EntitySize cw = EntitySize.b(EntityTypes.bl.l(), EntityTypes.bl.m() - 0.4f).b(0.81f);
    private static final DataWatcherObject<State> cx = DataWatcher.a(Sniffer.class, DataWatcherRegistry.G);
    private static final DataWatcherObject<Integer> cy = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState ck = new AnimationState();
    public final AnimationState cl = new AnimationState();
    public final AnimationState cm = new AnimationState();
    public final AnimationState co = new AnimationState();
    public final AnimationState cp = new AnimationState();

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gM().a(GenericAttributes.w, 0.1f).a(GenericAttributes.t, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super(entitytypes, world);
        this.S().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cx, State.a);
        datawatcher_a.a(cy, 0);
    }

    @Override
    public void L() {
        super.L();
        if (this.cb() || this.bm()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void N() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.gU() == State.f ? cw.a(this.ep()) : super.e(entitypose);
    }

    public boolean n() {
        return this.gU() == State.e;
    }

    public boolean t() {
        return this.bO.c(MemoryModuleType.S).orElse(false);
    }

    public boolean gH() {
        return !this.t() && !this.gE() && !this.bm() && !this.gR() && this.aK() && !this.cc() && !this.R_();
    }

    public boolean gI() {
        return this.gU() == State.f || this.gU() == State.e;
    }

    private BlockPosition gL() {
        Vec3D vec3d = this.gT();
        return BlockPosition.a(vec3d.a(), this.dE() + (double)0.2f, vec3d.c());
    }

    private Vec3D gT() {
        return this.dv().e(this.bY().c(2.25));
    }

    @Override
    public boolean D() {
        return true;
    }

    @Override
    public Vec3D[] E() {
        return Leashable.a(this, -0.01, 0.63, 0.38, 1.15);
    }

    public State gU() {
        return this.ay.a(cx);
    }

    private Sniffer b(State sniffer_state) {
        this.ay.a(cx, sniffer_state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cx.equals(datawatcherobject)) {
            State sniffer_state = this.gU();
            this.gV();
            switch (sniffer_state.ordinal()) {
                case 1: {
                    this.ck.b(this.as);
                    break;
                }
                case 2: {
                    this.cl.b(this.as);
                    break;
                }
                case 3: {
                    this.cm.b(this.as);
                }
                default: {
                    break;
                }
                case 5: {
                    this.co.b(this.as);
                    break;
                }
                case 6: {
                    this.cp.b(this.as);
                }
            }
            this.j_();
        }
        super.a(datawatcherobject);
    }

    private void gV() {
        this.co.a();
        this.cm.a();
        this.cp.a();
        this.ck.a();
        this.cl.a();
    }

    public Sniffer a(State sniffer_state) {
        switch (sniffer_state.ordinal()) {
            case 0: {
                this.b(State.a);
                break;
            }
            case 1: {
                this.a(SoundEffects.zZ, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case 2: {
                this.b(State.c).gW();
                break;
            }
            case 3: {
                this.a(SoundEffects.zV, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case 4: {
                this.b(State.e);
                break;
            }
            case 5: {
                this.b(State.f).gX();
                break;
            }
            case 6: {
                this.a(SoundEffects.zY, 1.0f, 1.0f);
                this.b(State.g);
            }
        }
        return this;
    }

    private Sniffer gW() {
        this.a(SoundEffects.zU, 1.0f, this.g_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer gX() {
        this.ay.a(cy, this.as + 120);
        this.ai().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer x(boolean flag) {
        if (flag) {
            this.i(this.aU());
        }
        return this;
    }

    public Optional<BlockPosition> gJ() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockposition -> this.ai().F_().a((BlockPosition)blockposition)).map(BlockPosition::e).filter(this::h).findFirst();
    }

    public boolean gK() {
        return !this.gE() && !this.t() && !this.g_() && !this.bm() && this.aK() && !this.cc() && this.h(this.gL().e());
    }

    private boolean h(BlockPosition blockposition) {
        return this.ai().a_(blockposition).a(TagsBlock.cz) && this.gZ().noneMatch(globalpos -> GlobalPos.a(this.ai().aj(), blockposition).equals(globalpos)) && Optional.ofNullable(this.S().a(blockposition, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void gY() {
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.ay.a(cy) == this.as) {
                BlockPosition blockposition = this.gL();
                this.a(worldserver, LootTables.aG, (WorldServer worldserver1, ItemStack itemstack) -> {
                    EntityItem entityitem = new EntityItem(this.ai(), blockposition.u(), blockposition.v(), blockposition.w(), (ItemStack)itemstack);
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    entityitem.i();
                    worldserver1.b(entityitem);
                });
                this.a(SoundEffects.zT, 1.0f, 1.0f);
                return;
            }
        }
    }

    private Sniffer a(AnimationState animationstate) {
        boolean flag;
        boolean bl = flag = animationstate.a((float)this.as) > 1700L && animationstate.a((float)this.as) < 6000L;
        if (flag) {
            BlockPosition blockposition = this.gL();
            IBlockData iblockdata = this.ai().a_(blockposition.e());
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3d = Vec3D.b(blockposition).b(0.0, -0.65f, 0.0);
                    this.ai().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.d, vec3d.e, vec3d.f, 0.0, 0.0, 0.0);
                }
                if (this.as % 10 == 0) {
                    this.ai().a(this.dC(), this.dE(), this.dI(), iblockdata.A().f(), this.do(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.as % 10 == 0) {
            this.ai().a(GameEvent.u, this.gL(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer i(BlockPosition blockposition) {
        List list = this.gZ().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.ai().aj(), blockposition));
        this.eh().a(MemoryModuleType.aR, list);
        return this;
    }

    public Stream<GlobalPos> gZ() {
        return this.eh().c(MemoryModuleType.aR).stream().flatMap(Collection::stream);
    }

    @Override
    public void s() {
        double d1;
        super.s();
        double d0 = this.ce.c();
        if (d0 > 0.0 && (d1 = this.dA().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        ItemStack itemstack = new ItemStack(Items.kU);
        EntityItem entityitem = new EntityItem(worldserver, this.dv().a(), this.dv().b(), this.dv().c(), itemstack);
        entityitem.i();
        this.a(worldserver, entityanimal, (EntityAgeable)null);
        this.a(SoundEffects.Aa, 1.0f, (this.ar.i() - this.ar.i()) * 0.2f + 0.5f);
        worldserver.b(entityitem);
    }

    @Override
    public void a(DamageSource damagesource) {
        this.a(State.a);
        super.a(damagesource);
    }

    @Override
    public void g() {
        switch (this.gU().ordinal()) {
            case 4: {
                this.ha();
                break;
            }
            case 5: {
                this.a(this.co).gY();
            }
        }
        super.g();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        boolean flag = this.i(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a() && flag) {
            this.gN();
        }
        return enuminteractionresult;
    }

    @Override
    protected void gN() {
        this.ai().a((Entity)null, this, SoundEffects.zP, SoundCategory.g, 1.0f, MathHelper.b(this.ai().A, 0.8f, 1.2f));
    }

    private void ha() {
        if (this.ai().B_() && this.as % 20 == 0) {
            this.ai().a(this.dC(), this.dE(), this.dI(), SoundEffects.zW, this.do(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.zO, 0.15f, 1.0f);
    }

    @Override
    protected SoundEffect p() {
        return Set.of(State.f, State.e).contains((Object)this.gU()) ? null : SoundEffects.zQ;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.zR;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.zS;
    }

    @Override
    public int gh() {
        return 50;
    }

    @Override
    public void a(boolean flag) {
        this.c_(flag ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.bl.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        if (!(entityanimal instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)entityanimal;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.gU()) && set.contains((Object)sniffer.gU()) && super.a(entityanimal);
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.at);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.ei().a(dynamic));
    }

    public BehaviorController<Sniffer> eh() {
        return super.eh();
    }

    protected BehaviorController.b<Sniffer> ei() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("snifferBrain");
        this.eh().a(worldserver, this);
        gameprofilerfiller.b("snifferActivityUpdate");
        SnifferAi.a(this);
        gameprofilerfiller.c();
        super.a(worldserver);
    }

    @Override
    protected void ah() {
        super.ah();
        PacketDebug.a(this);
    }

    public static enum State {
        a(0),
        b(1),
        c(2),
        d(3),
        e(4),
        f(5),
        g(6);

        public static final IntFunction<State> h;
        public static final StreamCodec<ByteBuf, State> i;
        private final int j;

        private State(int i2) {
            this.j = i2;
        }

        public int a() {
            return this.j;
        }

        static {
            h = ByIdMap.a(State::a, State.values(), ByIdMap.a.a);
            i = ByteBufCodecs.a(h, State::a);
        }
    }
}

