/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private static final int a = 20;
    private static final int b = 40;
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> c = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack d = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void e() {
            super.e();
            EntitySkeletonAbstract.this.w(false);
        }

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.w(true);
        }
    };

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.n();
    }

    @Override
    protected void H() {
        this.ch.a(2, new PathfinderGoalRestrictSun(this));
        this.ch.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.ch.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.ch.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.ch.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.ch.a(6, new PathfinderGoalRandomLookaround(this));
        this.ci.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ci.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.ci.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.ci.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.ck));
    }

    public static AttributeProvider.Builder l() {
        return EntityMonster.gM().a(GenericAttributes.w, 0.25);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.m(), 0.15f, 1.0f);
    }

    abstract SoundEffect m();

    @Override
    public void e_() {
        boolean flag = this.gB();
        if (flag) {
            ItemStack itemstack = this.a(EnumItemSlot.f);
            if (!itemstack.f()) {
                if (itemstack.m()) {
                    Item item = itemstack.h();
                    itemstack.b(itemstack.o() + this.ar.a(2));
                    if (itemstack.o() >= itemstack.p()) {
                        this.a(item, EnumItemSlot.f);
                        this.a(EnumItemSlot.f, ItemStack.l);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.e(8.0f);
            }
        }
        super.e_();
    }

    @Override
    public void r() {
        super.r();
        Entity entity = this.dn();
        if (entity instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)entity;
            this.br = entitycreature.br;
        }
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        this.a(EnumItemSlot.a, new ItemStack(Items.pA));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        groupdataentity = super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        RandomSource randomsource = worldaccess.H_();
        this.a(randomsource, difficultydamagescaler);
        this.a(worldaccess, randomsource, difficultydamagescaler);
        this.n();
        this.a_(randomsource.i() < 0.55f * difficultydamagescaler.d());
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.ew : Blocks.ev));
                this.a(EnumItemSlot.f, 0.0f);
            }
        }
        return groupdataentity;
    }

    public void n() {
        if (this.ai() != null && !this.ai().C) {
            this.ch.a(this.d);
            this.ch.a(this.c);
            ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.pA));
            if (itemstack.a(Items.pA)) {
                int i2 = this.t();
                if (this.ai().an() != EnumDifficulty.d) {
                    i2 = this.gH();
                }
                this.c.c(i2);
                this.ch.a(4, this.c);
            } else {
                this.ch.a(4, this.d);
            }
        }
    }

    protected int t() {
        return 20;
    }

    protected int gH() {
        return 40;
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.pA));
        ItemStack itemstack1 = this.d(itemstack);
        EntityArrow entityarrow = this.a(itemstack1, f2, itemstack);
        double d0 = entityliving.dC() - this.dC();
        double d1 = entityliving.e(0.3333333333333333) - entityarrow.dE();
        double d2 = entityliving.dI() - this.dI();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.fh(), null, entityarrow, EnumHand.a, 0.8f, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == entityarrow.getBukkitEntity()) {
                IProjectile.a(entityarrow, worldserver, itemstack1, d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - worldserver.an().a() * 4);
            }
        }
        this.a(SoundEffects.yC, 1.0f, 1.0f / (this.ec().i() * 0.4f + 0.8f));
    }

    protected EntityArrow a(ItemStack itemstack, float f2, @Nullable ItemStack itemstack1) {
        return ProjectileHelper.a(this, itemstack, f2, itemstack1);
    }

    @Override
    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return itemprojectileweapon == Items.pA;
    }

    @Override
    public TagKey<Item> ad() {
        return TagsItem.bX;
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.n();
    }

    @Override
    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        super.onEquipItem(enumitemslot, itemstack, itemstack1, silent);
        if (!this.ai().C) {
            this.n();
        }
    }

    public boolean gI() {
        return this.cA();
    }
}

