/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private static final AttributeModifier f = new AttributeModifier(a, 0.5, AttributeModifier.Operation.b);
    private static final MinecraftKey ck = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier cl = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey cm = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey cn = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> co = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cp = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> cq = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float b = 0.05f;
    public static final int c = 50;
    public static final int d = 40;
    public static final int e = 7;
    private static final int cr = -1;
    private static final EntitySize cs = EntityTypes.bQ.n().a(0.5f).b(0.93f);
    private static final float ct = 0.1f;
    private static final Predicate<EnumDifficulty> cu = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private static final boolean cv = false;
    private static final boolean cw = false;
    private static final int cx = 0;
    private final PathfinderGoalBreakDoor cy;
    private boolean cz = false;
    private int cA = 0;
    public int cB;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombie(EntityTypes<? extends EntityZombie> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.cy = new PathfinderGoalBreakDoor(this, cu);
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bQ, world);
    }

    @Override
    protected void H() {
        this.ch.a(4, new a((EntityCreature)this, 1.0, 3));
        this.ch.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.ch.a(8, new PathfinderGoalRandomLookaround(this));
        this.m();
    }

    protected void m() {
        this.ch.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.ch.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gO));
        this.ch.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.ci.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.ci.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.ai().spigotConfig.zombieAggressiveTowardsVillager) {
            this.ci.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.ci.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.ci.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.ck));
    }

    public static AttributeProvider.Builder gK() {
        return EntityMonster.gM().a(GenericAttributes.n, 35.0).a(GenericAttributes.w, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.B);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(co, false);
        datawatcher_a.a(cp, 0);
        datawatcher_a.a(cq, false);
    }

    public boolean gN() {
        return this.au().a(cq);
    }

    public boolean gO() {
        return this.cz;
    }

    public void y(boolean flag) {
        if (this.cg.c()) {
            if (this.cz != flag) {
                this.cz = flag;
                this.cg.d(flag);
                if (flag) {
                    this.ch.a(1, this.cy);
                } else {
                    this.ch.a(this.cy);
                }
            }
        } else if (this.cz) {
            this.ch.a(this.cy);
            this.cz = false;
        }
    }

    @Override
    public boolean g_() {
        return this.au().a(co);
    }

    @Override
    protected int e(WorldServer worldserver) {
        if (this.g_()) {
            this.cc = (int)((double)this.cc * 2.5);
        }
        return super.e(worldserver);
    }

    @Override
    public void a(boolean flag) {
        this.au().a(co, flag);
        if (this.ai() != null && !this.ai().C) {
            AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
            attributemodifiable.c(a);
            if (flag) {
                attributemodifiable.b(f);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (co.equals(datawatcherobject)) {
            this.j_();
        }
        super.a(datawatcherobject);
    }

    protected boolean gI() {
        return true;
    }

    @Override
    public void g() {
        if (!this.ai().C && this.bO() && !this.gw()) {
            if (this.gN()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.cB -= elapsedTicks;
                if (this.cB < 0) {
                    this.ae_();
                }
            } else if (this.gI()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cA;
                    if (this.cA >= 600) {
                        this.r(300);
                    }
                } else {
                    this.cA = -1;
                }
            }
        }
        super.g();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void e_() {
        if (this.bO()) {
            boolean flag;
            boolean bl = flag = this.af_() && this.gB();
            if (flag) {
                ItemStack itemstack = this.a(EnumItemSlot.f);
                if (!itemstack.f()) {
                    if (itemstack.m()) {
                        Item item = itemstack.h();
                        itemstack.b(itemstack.o() + this.ar.a(2));
                        if (itemstack.o() >= itemstack.p()) {
                            this.a(item, EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.l);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.e(8.0f);
                }
            }
        }
        super.e_();
    }

    public void r(int i2) {
        this.lastTick = MinecraftServer.currentTick;
        this.cB = i2;
        this.au().a(cq, true);
    }

    protected void ae_() {
        this.b(EntityTypes.L);
        if (!this.be()) {
            this.ai().a((Entity)null, 1040, this.dx(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entitytypes) {
        EntityZombie converted = this.convertTo(entitytypes, ConversionParams.a(this, true, true), entityzombie -> entityzombie.J(entityzombie.ai().d_(entityzombie.dx()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer worldserver, EntityVillager entityvillager) {
        return EntityZombie.convertVillagerToZombieVillager(worldserver, entityvillager, this.dx(), this.be(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    public static EntityZombieVillager convertVillagerToZombieVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.bS, ConversionParams.a(entityvillager, true, true), entityzombievillager1 -> {
            entityzombievillager1.a((WorldAccess)worldserver, worldserver.d_(entityzombievillager1.dx()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            entityzombievillager1.a(entityvillager.gR());
            entityzombievillager1.a(entityvillager.hc().d());
            entityzombievillager1.a(entityvillager.gJ().a());
            entityzombievillager1.s(entityvillager.t());
            if (!silent) {
                worldserver.a((Entity)null, 1026, blockPosition, 0);
            }
        }, transformReason, spawnReason);
        return entityzombievillager;
    }

    protected boolean af_() {
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (!super.a(worldserver, damagesource, f2)) {
            return false;
        }
        EntityLiving entityliving = this.e();
        if (entityliving == null && damagesource.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)damagesource.d();
        }
        if (entityliving != null && worldserver.an() == EnumDifficulty.d && (double)this.ar.i() < this.i(GenericAttributes.B) && worldserver.P().c(GameRules.f)) {
            int i2 = MathHelper.a(this.dC());
            int j2 = MathHelper.a(this.dE());
            int k2 = MathHelper.a(this.dI());
            EntityTypes<? extends EntityZombie> entitytypes = this.ap();
            EntityZombie entityzombie = entitytypes.a(worldserver, EntitySpawnReason.j);
            if (entityzombie == null) {
                return true;
            }
            for (int l2 = 0; l2 < 50; ++l2) {
                int k1;
                int j1;
                int i1 = i2 + MathHelper.a(this.ar, 7, 40) * MathHelper.a(this.ar, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1 = j2 + MathHelper.a(this.ar, 7, 40) * MathHelper.a(this.ar, -1, 1), k1 = k2 + MathHelper.a(this.ar, 7, 40) * MathHelper.a(this.ar, -1, 1));
                if (!EntityPositionTypes.a(entitytypes, worldserver, blockposition) || !EntityPositionTypes.a(entitytypes, worldserver, EntitySpawnReason.j, blockposition, worldserver.A)) continue;
                entityzombie.a_(i1, j1, k1);
                if (worldserver.a((double)i1, (double)j1, (double)k1, 7.0) || !worldserver.f(entityzombie) || !worldserver.g(entityzombie) || !entityzombie.t() && worldserver.d(entityzombie.cV())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a((WorldAccess)worldserver, worldserver.d_(entityzombie.dx()), EntitySpawnReason.j, (GroupDataEntity)null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attributemodifiable = this.h(GenericAttributes.B);
                AttributeModifier attributemodifier = attributemodifiable.a(ck);
                double d0 = attributemodifier != null ? attributemodifier.b() : 0.0;
                attributemodifiable.c(ck);
                attributemodifiable.d(new AttributeModifier(ck, d0 - 0.05, AttributeModifier.Operation.a));
                entityzombie.h(GenericAttributes.B).d(cl);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        boolean flag = super.c(worldserver, entity);
        if (flag) {
            float f2 = this.ai().d_(this.dx()).b();
            if (this.fh().f() && this.cb() && this.ar.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), (float)(2 * (int)f2));
                this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect p() {
        return SoundEffects.EQ;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.Fa;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.EV;
    }

    protected SoundEffect n() {
        return SoundEffects.Fg;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.n(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> ap() {
        return super.ap();
    }

    protected boolean t() {
        return false;
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        float f2 = randomsource.i();
        float f3 = this.ai().an() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = randomsource.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.qg));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.qh));
            }
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsBaby", this.g_());
        valueoutput.a("CanBreakDoors", this.gO());
        valueoutput.a("InWaterTime", this.bm() ? this.cA : -1);
        valueoutput.a("DrownedConversionTime", this.gN() ? this.cB : -1);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("IsBaby", false));
        this.y(valueinput.a("CanBreakDoors", false));
        this.cA = valueinput.a("InWaterTime", 0);
        int i2 = valueinput.a("DrownedConversionTime", -1);
        if (i2 != -1) {
            this.r(i2);
        } else {
            this.au().a(cq, false);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        boolean flag = super.a(worldserver, entityliving);
        if ((worldserver.an() == EnumDifficulty.c || worldserver.an() == EnumDifficulty.d) && entityliving instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)entityliving;
            if (worldserver.an() != EnumDifficulty.d && this.ar.h()) {
                return flag;
            }
            if (this.a(worldserver, entityvillager)) {
                flag = false;
            }
        }
        return flag;
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.g_() ? cs : super.e(entitypose);
    }

    @Override
    public boolean g(ItemStack itemstack) {
        return itemstack.a(TagsItem.ar) && this.g_() && this.cc() ? false : super.g(itemstack);
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return itemstack.a(Items.sF) ? false : super.c(worldserver, itemstack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.H_();
        groupdataentity = super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        float f2 = difficultydamagescaler.d();
        if (entityspawnreason != EntitySpawnReason.i) {
            this.a_(randomsource.i() < 0.55f * f2);
        }
        if (groupdataentity == null) {
            groupdataentity = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (groupdataentity instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)groupdataentity;
            if (entityzombie_groupdatazombie.a) {
                this.a(true);
                if (entityzombie_groupdatazombie.b) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = worldaccess.a(EntityChicken.class, this.cV().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.x(true);
                            this.o(entitychicken);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.A.a(this.ai(), EntitySpawnReason.g)) != null) {
                        entitychicken1.b(this.dC(), this.dE(), this.dI(), this.dP(), 0.0f);
                        entitychicken1.a(worldaccess, difficultydamagescaler, EntitySpawnReason.g, (GroupDataEntity)null);
                        entitychicken1.x(true);
                        this.o(entitychicken1);
                        worldaccess.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.y(randomsource.i() < f2 * 0.1f);
            if (entityspawnreason != EntitySpawnReason.i) {
                this.a(randomsource, difficultydamagescaler);
                this.a(worldaccess, randomsource, difficultydamagescaler);
            }
        }
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.ew : Blocks.ev));
                this.a(EnumItemSlot.f, 0.0f);
            }
        }
        this.J(f2);
        return groupdataentity;
    }

    @VisibleForTesting
    public void b(int i2) {
        this.cA = i2;
    }

    @VisibleForTesting
    public void c(int i2) {
        this.cB = i2;
    }

    public static boolean a(RandomSource randomsource) {
        return randomsource.i() < 0.05f;
    }

    protected void J(float f2) {
        this.gP();
        this.h(GenericAttributes.q).c(new AttributeModifier(bW, this.ar.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.ar.j() * 1.5 * (double)f2;
        if (d0 > 1.0) {
            this.h(GenericAttributes.n).c(new AttributeModifier(cn, d0, AttributeModifier.Operation.c));
        }
        if (this.ar.i() < f2 * 0.05f) {
            this.h(GenericAttributes.B).c(new AttributeModifier(cm, this.ar.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.h(GenericAttributes.t).c(new AttributeModifier(cm, this.ar.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.y(true);
        }
    }

    protected void gP() {
        this.h(GenericAttributes.B).a(this.ar.j() * (double)0.1f);
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.a(worldserver, damagesource, flag);
        Entity entity = damagesource.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gI() && !(itemstack = this.gH()).f()) {
            entitycreeper.gJ();
            this.a(worldserver, itemstack);
        }
    }

    protected ItemStack gH() {
        return new ItemStack(Items.vQ);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature entitycreature, double d0, int i2) {
            super(Blocks.mL, entitycreature, d0, i2);
        }

        @Override
        public void a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            generatoraccess.a((Entity)null, blockposition, SoundEffects.EW, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.ar.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition blockposition) {
            world.a((Entity)null, blockposition, SoundEffects.BL, SoundCategory.e, 0.7f, 0.9f + world.A.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean flag, boolean flag1) {
            this.a = flag;
            this.b = flag1;
        }
    }
}

