/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private static final DataWatcherObject<Integer> cm = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int ck = 300;
    private static final int cn = 8;
    @Nullable
    private EntityHuman co;
    @Nullable
    protected MerchantRecipeList cl;
    private final InventorySubcontainer cp = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return (CraftAbstractVillager)this.getBukkitEntity();
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    public int m() {
        return this.ay.a(cm);
    }

    public void r(int i2) {
        this.ay.a(cm, i2);
    }

    @Override
    public int t() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cm, 0);
    }

    @Override
    public void g(@Nullable EntityHuman entityhuman) {
        this.co = entityhuman;
    }

    @Override
    @Nullable
    public EntityHuman gH() {
        return this.co;
    }

    public boolean gI() {
        return this.co != null;
    }

    @Override
    public MerchantRecipeList gJ() {
        if (this.ai().C) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.cl == null) {
            this.cl = new MerchantRecipeList();
            this.gO();
        }
        return this.cl;
    }

    @Override
    public void a(@Nullable MerchantRecipeList merchantrecipelist) {
    }

    @Override
    public void s(int i2) {
    }

    @Override
    public void a(MerchantRecipe merchantrecipe) {
        merchantrecipe.l();
        this.cb = -this.W();
        this.b(merchantrecipe);
        if (this.co instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.co, this, merchantrecipe.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gK() {
        return true;
    }

    @Override
    public void i(ItemStack itemstack) {
        if (!this.ai().C && this.cb > -this.W() + 20) {
            this.cb = -this.W();
            this.b(this.x(!itemstack.f()));
        }
    }

    @Override
    public SoundEffect gL() {
        return SoundEffects.CB;
    }

    protected SoundEffect x(boolean flag) {
        return flag ? SoundEffects.CB : SoundEffects.Cz;
    }

    public void gM() {
        this.b(SoundEffects.Cw);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        MerchantRecipeList merchantrecipelist;
        super.a(valueoutput);
        if (!this.ai().C && !(merchantrecipelist = this.gJ()).isEmpty()) {
            valueoutput.a("Offers", MerchantRecipeList.a, merchantrecipelist);
        }
        this.b_(valueoutput);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cl = valueinput.a("Offers", MerchantRecipeList.a).orElse(null);
        this.a_(valueinput);
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleporttransition) {
        this.gN();
        return super.b(teleporttransition);
    }

    protected void gN() {
        this.g((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damagesource) {
        super.a(damagesource);
        this.gN();
    }

    protected void a(ParticleParam particleparam) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.ar.k() * 0.02;
            double d1 = this.ar.k() * 0.02;
            double d2 = this.ar.k() * 0.02;
            this.ai().a(particleparam, this.d(1.0), this.dF() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean v() {
        return false;
    }

    @Override
    public InventorySubcontainer n() {
        return this.cp;
    }

    @Override
    public SlotAccess a_(int i2) {
        int j2 = i2 - 300;
        return j2 >= 0 && j2 < this.cp.b() ? SlotAccess.a(this.cp, j2) : super.a_(i2);
    }

    protected abstract void gO();

    protected void a(MerchantRecipeList merchantrecipelist, VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption, int i2) {
        ArrayList arraylist = Lists.newArrayList((Object[])avillagertrades_imerchantrecipeoption);
        int j2 = 0;
        while (j2 < i2 && !arraylist.isEmpty()) {
            MerchantRecipe merchantrecipe = ((VillagerTrades.IMerchantRecipeOption)arraylist.remove(this.ar.a(arraylist.size()))).a(this, this.ar);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                merchantrecipelist.add(CraftMerchantRecipe.fromBukkit(event.getRecipe()).toMinecraft());
            }
            ++j2;
        }
    }

    @Override
    public Vec3D u(float f2) {
        float f1 = MathHelper.h(f2, this.bs, this.br) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cV().c() - 1.0, 0.2);
        return this.p(f2).e(vec3d.b(-f1));
    }

    @Override
    public boolean gP() {
        return this.ai().C;
    }

    @Override
    public boolean h(EntityHuman entityhuman) {
        return this.gH() == entityhuman && this.bO() && entityhuman.b((Entity)this, 4.0);
    }
}

