/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class EntityHuman
extends EntityLiving {
    private static final Logger a = LogUtils.getLogger();
    public static final EnumMainHand bQ = EnumMainHand.b;
    public static final int bR = 0;
    public static final int bS = 20;
    public static final int bT = 100;
    public static final int bU = 10;
    public static final int bV = 200;
    public static final int bW = 499;
    public static final int bX = 500;
    public static final float bY = 4.5f;
    public static final float bZ = 3.0f;
    public static final float ca = 1.5f;
    public static final float cb = 0.6f;
    public static final float cc = 0.6f;
    public static final float cd = 1.62f;
    private static final int b = 40;
    public static final Vec3D ce = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize cf = EntitySize.b(0.6f, 1.8f).b(1.62f).a(EntityAttachments.a().a(EntityAttachment.b, ce));
    private static final Map<EntityPose, EntitySize> c = ImmutableMap.builder().put((Object)EntityPose.a, (Object)cf).put((Object)EntityPose.c, (Object)ba).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f).b(1.27f).a(EntityAttachments.a().a(EntityAttachment.b, ce))).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f).b(1.62f)).build();
    private static final DataWatcherObject<Float> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    protected static final DataWatcherObject<Byte> cg = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> ch = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> ci = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    protected static final DataWatcherObject<NBTTagCompound> cj = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    public static final int ck = 60;
    private static final short f = 0;
    private static final float g = 0.0f;
    private static final int h = 0;
    private static final int i = 0;
    private static final int j = 0;
    private static final int k = 0;
    private static final int cM = 0;
    private static final boolean cN = false;
    private static final int cO = 0;
    private long cP;
    final PlayerInventory cQ;
    protected InventoryEnderChest cl = new InventoryEnderChest(this);
    public final ContainerPlayer cm;
    public Container cn;
    protected FoodMetaData co = new FoodMetaData();
    protected int cp;
    private boolean cR = false;
    protected int cq = 60;
    public float cr;
    public float cs;
    public int ct;
    public double cu;
    public double cv;
    public double cw;
    public double cx;
    public double cy;
    public double cz;
    public int cS = 0;
    protected boolean cA;
    private final PlayerAbilities cT = new PlayerAbilities();
    public int cB = 0;
    public int cC = 0;
    public float cD = 0.0f;
    public int cE = 0;
    protected final float cF = 0.02f;
    private int cU;
    private final GameProfile cV;
    private boolean cW;
    private ItemStack cX = ItemStack.l;
    private final ItemCooldown cY = this.f();
    private Optional<GlobalPos> cZ = Optional.empty();
    @Nullable
    public EntityFishingHook cG;
    protected float cH;
    @Nullable
    public Vec3D cI;
    @Nullable
    public Entity cJ;
    private boolean da = false;
    private int db = 0;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, GameProfile gameprofile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bU, world);
        this.a_(gameprofile.getId());
        this.cV = gameprofile;
        this.cQ = new PlayerInventory(this, this.bP);
        this.cm = new ContainerPlayer(this.cQ, !world.C, this);
        this.cn = this.cm;
    }

    @Override
    protected EntityEquipment eg() {
        return new PlayerEquipment(this);
    }

    public boolean a(World world, BlockPosition blockposition, EnumGamemode enumgamemode) {
        if (!enumgamemode.f()) {
            return false;
        }
        if (enumgamemode == EnumGamemode.d) {
            return true;
        }
        if (this.gF()) {
            return false;
        }
        ItemStack itemstack = this.fh();
        return itemstack.f() || !itemstack.b(new ShapeDetectorBlock(world, blockposition, false));
    }

    public static AttributeProvider.Builder gg() {
        return EntityLiving.ej().a(GenericAttributes.c, 1.0).a(GenericAttributes.w, 0.1f).a(GenericAttributes.e).a(GenericAttributes.r).a(GenericAttributes.g, 4.5).a(GenericAttributes.k, 3.0).a(GenericAttributes.f).a(GenericAttributes.D).a(GenericAttributes.A).a(GenericAttributes.u).a(GenericAttributes.E).a(GenericAttributes.H, 6.0E7).a(GenericAttributes.I, 6.0E7);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(d, Float.valueOf(0.0f));
        datawatcher_a.a(e, 0);
        datawatcher_a.a(cg, (byte)0);
        datawatcher_a.a(ch, (byte)bQ.b());
        datawatcher_a.a(ci, new NBTTagCompound());
        datawatcher_a.a(cj, new NBTTagCompound());
    }

    @Override
    public void g() {
        this.aq = this.am();
        if (this.am() || this.cc()) {
            this.e(false);
        }
        if (this.ct > 0) {
            --this.ct;
        }
        if (this.fY()) {
            ++this.cS;
            if (this.cS > 100) {
                this.cS = 100;
            }
            if (!this.ai().C && this.ai().W()) {
                this.a(false, true);
            }
        } else if (this.cS > 0) {
            ++this.cS;
            if (this.cS >= 110) {
                this.cS = 0;
            }
        }
        this.gk();
        super.g();
        if (!this.ai().C && this.cn != null && !this.cn.b(this)) {
            this.p();
            this.cn = this.cm;
        }
        this.m();
        EntityHuman entityHuman = this;
        if (entityHuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityHuman;
            this.co.a(entityplayer);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bO()) {
                this.a(StatisticList.m);
            }
            if (this.cj()) {
                this.a(StatisticList.o);
            }
            if (!this.fY()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dC(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dI(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dC() || d1 != this.dI()) {
            this.a_(d0, this.dE(), d1);
        }
        ++this.bo;
        ItemStack itemstack = this.fh();
        if (!ItemStack.a(this.cX, itemstack)) {
            if (!ItemStack.b(this.cX, itemstack)) {
                this.gO();
            }
            this.cX = itemstack.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.pt)) {
            this.l();
        }
        this.cY.a();
        this.gl();
        if (this.db > 0) {
            --this.db;
        }
    }

    @Override
    protected float fv() {
        return this.fN() ? 15.0f : super.fv();
    }

    public boolean gh() {
        return this.cg();
    }

    protected boolean gi() {
        return this.cg();
    }

    protected boolean gj() {
        return this.cg();
    }

    protected boolean gk() {
        this.cA = ((Entity)this).a(TagsFluid.a);
        return this.cA;
    }

    @Override
    public void a(boolean flag, BlockPosition blockposition) {
        if (!this.gt().b) {
            super.a(flag, blockposition);
        }
    }

    @Override
    public void m(boolean flag) {
        if (!this.gt().b) {
            super.m(flag);
        }
    }

    private void l() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            Equippable equippable = itemstack.a(DataComponents.D);
            if (!itemstack.a(item) || equippable == null || equippable.b() != enumitemslot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown f() {
        return new ItemCooldown();
    }

    private void m() {
        this.cu = this.cx;
        this.cv = this.cy;
        this.cw = this.cz;
        double d0 = this.dC() - this.cx;
        double d1 = this.dE() - this.cy;
        double d2 = this.dI() - this.cz;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.cu = this.cx = this.dC();
        }
        if (d2 > 10.0) {
            this.cw = this.cz = this.dI();
        }
        if (d1 > 10.0) {
            this.cv = this.cy = this.dE();
        }
        if (d0 < -10.0) {
            this.cu = this.cx = this.dC();
        }
        if (d2 < -10.0) {
            this.cw = this.cz = this.dI();
        }
        if (d1 < -10.0) {
            this.cv = this.cy = this.dE();
        }
        this.cx += d0 * 0.25;
        this.cz += d2 * 0.25;
        this.cy += d1 * 0.25;
    }

    protected void gl() {
        if (this.h(EntityPose.d)) {
            EntityPose entitypose = this.n();
            EntityPose entitypose1 = !(this.am() || this.cc() || this.h(entitypose)) ? (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    private EntityPose n() {
        return this.fY() ? EntityPose.c : (this.cn() ? EntityPose.d : (this.fQ() ? EntityPose.b : (this.fC() ? EntityPose.e : (this.cg() && !this.cT.b ? EntityPose.f : EntityPose.a))));
    }

    protected boolean h(EntityPose entitypose) {
        return this.ai().a((Entity)this, this.a(entitypose).a(this.dv()).h(1.0E-7));
    }

    @Override
    protected SoundEffect aY() {
        return SoundEffects.vI;
    }

    @Override
    protected SoundEffect aZ() {
        return SoundEffects.vG;
    }

    @Override
    protected SoundEffect ba() {
        return SoundEffects.vH;
    }

    @Override
    public int ca() {
        return 10;
    }

    @Override
    public void a(SoundEffect soundeffect, float f2, float f1) {
        this.ai().a((Entity)this, this.dC(), this.dE(), this.dI(), soundeffect, this.do(), f2, f1);
    }

    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public SoundCategory do() {
        return SoundCategory.h;
    }

    @Override
    public int dp() {
        return 20;
    }

    @Override
    public void b(byte b0) {
        if (b0 == 9) {
            this.w();
        } else if (b0 == 23) {
            this.cW = false;
        } else if (b0 == 22) {
            this.cW = true;
        } else {
            super.b(b0);
        }
    }

    public void p() {
        this.cn = this.cm;
    }

    protected void q() {
    }

    @Override
    public void r() {
        if (!this.ai().C && this.gi() && this.cc()) {
            this.bS();
            if (!this.cc()) {
                this.h(false);
                return;
            }
        }
        super.r();
        this.cr = this.cs;
        this.cs = 0.0f;
    }

    @Override
    public void e_() {
        if (this.cp > 0) {
            --this.cp;
        }
        this.i();
        this.cQ.l();
        this.cr = this.cs;
        if (this.cT.b && !this.cc()) {
            this.j();
        }
        super.e_();
        this.ff();
        this.bt = this.dP();
        this.B((float)this.i(GenericAttributes.w));
        float f2 = this.aK() && !this.eM() && !this.cn() ? Math.min(0.1f, (float)this.dA().i()) : 0.0f;
        this.cs += (f2 - this.cs) * 0.4f;
        if (this.eL() > 0.0f && !this.am()) {
            AxisAlignedBB axisalignedbb = this.cc() && !this.dm().dU() ? this.cV().b(this.dm().cV()).c(1.0, 0.0, 1.0) : this.cV().c(1.0, 0.5, 1.0);
            List<Entity> list = this.ai().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.ap() == EntityTypes.W) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dU()) continue;
                this.d(entity);
            }
            if (!list1.isEmpty()) {
                this.d((Entity)SystemUtils.a(list1, this.ar));
            }
        }
        this.d(this.gL());
        this.d(this.gM());
        if (!this.ai().C && (this.am > 0.5 || this.bm()) || this.cT.b || this.fY() || this.aI) {
            this.gH();
        }
    }

    protected void i() {
    }

    private void d(NBTTagCompound nbttagcompound) {
        EntityTypes entitytypes;
        if (!(nbttagcompound.j() || nbttagcompound.b("Silent", false) || this.ai().A.a(200) != 0 || (entitytypes = (EntityTypes)nbttagcompound.a("id", EntityTypes.a).orElse(null)) != EntityTypes.aQ || EntityParrot.a(this.ai(), this))) {
            this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), EntityParrot.a(this.ai(), this.ai().A), this.do(), 1.0f, EntityParrot.a(this.ai().A));
        }
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gm() {
        return this.ay.a(e);
    }

    public void q(int i2) {
        this.ay.a(e, i2);
    }

    public void r(int i2) {
        int j2 = this.gm();
        this.ay.a(e, j2 + i2);
    }

    public void a(int i2, float f2, ItemStack itemstack) {
        this.bL = i2;
        this.bM = f2;
        this.bN = itemstack;
        if (!this.ai().C) {
            this.gH();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public ItemStack ed() {
        return this.fC() && this.bN != null ? this.bN : super.ed();
    }

    @Override
    public void a(DamageSource damagesource) {
        World world;
        super.a(damagesource);
        this.ay();
        if (!this.am() && (world = this.ai()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.b(worldserver, damagesource);
        }
        if (damagesource != null) {
            this.n(-MathHelper.b((this.eR() + this.dP()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eR() + this.dP()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.n(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.O);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aI();
        this.d(false);
        this.a(Optional.of(GlobalPos.a(this.ai().aj(), this.dx())));
    }

    @Override
    protected void f(WorldServer worldserver) {
        super.f(worldserver);
        if (!worldserver.P().c(GameRules.e)) {
            this.gn();
            this.cQ.m();
        }
    }

    protected void gn() {
        for (int i2 = 0; i2 < this.cQ.b(); ++i2) {
            ItemStack itemstack = this.cQ.a(i2);
            if (itemstack.f() || !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D)) continue;
            this.cQ.b(i2);
        }
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return damagesource.k().d().a();
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.vy;
    }

    public void g(ItemStack itemstack) {
    }

    @Nullable
    public EntityItem a(ItemStack itemstack, boolean flag) {
        return this.a(itemstack, false, flag);
    }

    public float c(IBlockData iblockdata) {
        float f2 = this.cQ.g().a(iblockdata);
        if (f2 > 1.0f) {
            f2 += (float)this.i(GenericAttributes.u);
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.d(MobEffects.d)) {
            float f22 = switch (this.e(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f2 *= f22;
        }
        f2 *= (float)this.i(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            f2 *= (float)this.h(GenericAttributes.D).g();
        }
        if (!this.aK()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData iblockdata) {
        return !iblockdata.C() || this.cQ.g().b(iblockdata);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a_(this.cV.getId());
        this.cQ.a(valueinput.c("Inventory", ItemStackWithSlot.a));
        this.cQ.c(valueinput.a("SelectedItemSlot", 0));
        this.cS = valueinput.a("SleepTimer", (short)0);
        this.cD = valueinput.a("XpP", 0.0f);
        this.cB = valueinput.a("XpLevel", 0);
        this.cC = valueinput.a("XpTotal", 0);
        this.cE = valueinput.a("XpSeed", 0);
        if (this.cE == 0) {
            this.cE = this.ar.f();
        }
        this.q(valueinput.a("Score", 0));
        this.co.a(valueinput);
        Optional<PlayerAbilities.a> optional = valueinput.a("abilities", PlayerAbilities.a.a);
        PlayerAbilities playerabilities = this.cT;
        Objects.requireNonNull(this.cT);
        optional.ifPresent(playerabilities::a);
        this.h(GenericAttributes.w).a(this.cT.b());
        this.cl.b(valueinput.c("EnderItems", ItemStackWithSlot.a));
        this.b(valueinput.a("ShoulderEntityLeft", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
        this.c(valueinput.a("ShoulderEntityRight", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
        this.a(valueinput.a("LastDeathLocation", GlobalPos.b));
        this.cI = valueinput.a("current_explosion_impact_pos", Vec3D.a).orElse(null);
        this.da = valueinput.a("ignore_fall_damage_from_current_explosion", false);
        this.db = valueinput.a("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        GameProfileSerializer.a(valueoutput);
        this.cQ.a(valueoutput.a("Inventory", ItemStackWithSlot.a));
        valueoutput.a("SelectedItemSlot", this.cQ.f());
        valueoutput.a("SleepTimer", (short)this.cS);
        valueoutput.a("XpP", this.cD);
        valueoutput.a("XpLevel", this.cB);
        valueoutput.a("XpTotal", this.cC);
        valueoutput.a("XpSeed", this.cE);
        valueoutput.a("Score", this.gm());
        this.co.a(valueoutput);
        valueoutput.a("abilities", PlayerAbilities.a.a, this.cT.c());
        this.cl.b(valueoutput.a("EnderItems", ItemStackWithSlot.a));
        if (!this.gL().j()) {
            valueoutput.a("ShoulderEntityLeft", NBTTagCompound.a, this.gL());
        }
        if (!this.gM().j()) {
            valueoutput.a("ShoulderEntityRight", NBTTagCompound.a, this.gM());
        }
        this.cZ.ifPresent(globalpos -> valueoutput.a("LastDeathLocation", GlobalPos.b, globalpos));
        valueoutput.b("current_explosion_impact_pos", Vec3D.a, this.cI);
        valueoutput.a("ignore_fall_damage_from_current_explosion", this.da);
        valueoutput.a("current_impulse_context_reset_grace_time", this.db);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return super.a(worldserver, damagesource) ? true : (damagesource.a(DamageTypeTags.n) ? !worldserver.P().c(GameRules.I) : (damagesource.a(DamageTypeTags.m) ? !worldserver.P().c(GameRules.J) : (damagesource.a(DamageTypeTags.i) ? !worldserver.P().c(GameRules.K) : (damagesource.a(DamageTypeTags.o) ? !worldserver.P().c(GameRules.L) : false))));
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        boolean damaged;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (this.cT.a && !damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bz = 0;
        if (this.eM()) {
            return false;
        }
        if (damagesource.g()) {
            if (worldserver.an() == EnumDifficulty.a) {
                return false;
            }
            if (worldserver.an() == EnumDifficulty.b) {
                f2 = Math.min(f2 / 2.0f + 1.0f, f2);
            }
            if (worldserver.an() == EnumDifficulty.d) {
                f2 = f2 * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(worldserver, damagesource, f2)) {
            this.gH();
        }
        return damaged;
    }

    @Override
    protected void b(WorldServer worldserver, EntityLiving entityliving) {
        super.b(worldserver, entityliving);
        ItemStack itemstack = this.fO();
        BlocksAttacks blocksattacks = itemstack != null ? itemstack.a(DataComponents.I) : null;
        float f2 = entityliving.gb();
        if (f2 > 0.0f && blocksattacks != null) {
            blocksattacks.a(worldserver, this, f2, itemstack);
        }
    }

    @Override
    public boolean eE() {
        return !this.gt().a && super.eE();
    }

    public boolean a(EntityHuman entityhuman) {
        Team team;
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)entityhuman;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = entityhuman.ai().getCraftServer().getOfflinePlayer(entityhuman.cM());
            team = entityhuman.ai().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.ai().getCraftServer().getOfflinePlayer(this.cM()));
    }

    @Override
    protected void c(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.f);
    }

    @Override
    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        return super.actuallyHurt(worldserver, damagesource, f2, event);
    }

    public boolean X() {
        return false;
    }

    public void a(TileEntitySign tileentitysign, boolean flag) {
    }

    public void a(CommandBlockListenerAbstract commandblocklistenerabstract) {
    }

    public void a(TileEntityCommand tileentitycommand) {
    }

    public void a(TileEntityStructure tileentitystructure) {
    }

    public void a(TestBlockEntity testblockentity) {
    }

    public void a(TestInstanceBlockEntity testinstanceblockentity) {
    }

    public void a(TileEntityJigsaw tileentityjigsaw) {
    }

    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
    }

    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        return OptionalInt.empty();
    }

    public void b(Holder<Dialog> holder) {
    }

    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
    }

    public void a(ItemStack itemstack, EnumHand enumhand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand enumhand) {
        if (this.am()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.e;
        }
        ItemStack itemstack = this.b(enumhand);
        ItemStack itemstack1 = itemstack.v();
        EnumInteractionResult enuminteractionresult = entity.a(this, enumhand);
        if (enuminteractionresult.a()) {
            if (this.gc() && itemstack == this.b(enumhand) && itemstack.M() < itemstack1.M()) {
                itemstack.e(itemstack1.M());
            }
            return enuminteractionresult;
        }
        if (!itemstack.f() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.gc()) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, enumhand)).a()) {
                this.ai().a(GameEvent.r, entity.dv(), GameEvent.a.a(this));
                if (itemstack.f() && !this.gc()) {
                    this.a(enumhand, ItemStack.l);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void ab() {
        super.ab();
        this.W = 0;
    }

    @Override
    protected boolean fm() {
        return super.fm() || this.fY();
    }

    @Override
    public boolean er() {
        return !this.cT.b;
    }

    @Override
    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        float f2 = this.dT();
        if (!this.cT.b && vec3d.e <= 0.0 && (enummovetype == EnumMoveType.a || enummovetype == EnumMoveType.b) && this.gj() && this.H(f2)) {
            double d0;
            double d1 = vec3d.f;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = vec3d.d; d0 != 0.0 && this.q(d0, 0.0, f2); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.q(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.q(d0, d1, f2)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d0, vec3d.e, d1);
        }
        return vec3d;
    }

    private boolean H(float f2) {
        return this.aK() || this.am < (double)f2 && !this.q(0.0, 0.0, (double)f2 - this.am);
    }

    private boolean q(double d0, double d1, double d2) {
        AxisAlignedBB axisalignedbb = this.cV();
        return this.ai().a((Entity)this, new AxisAlignedBB(axisalignedbb.a + 1.0E-7 + d0, axisalignedbb.b - d2 - 1.0E-7, axisalignedbb.c + 1.0E-7 + d1, axisalignedbb.d - 1.0E-7 + d0, axisalignedbb.b, axisalignedbb.f - 1.0E-7 + d1));
    }

    public void e(Entity entity) {
        if (entity.cF() && !entity.w(this)) {
            float f2 = this.fC() ? this.bM : (float)this.i(GenericAttributes.c);
            ItemStack itemstack = this.ed();
            DamageSource damagesource = Optional.ofNullable(itemstack.h().a(this)).orElse(this.ea().a(this));
            float f1 = this.a(entity, f2, damagesource) - f2;
            float f22 = this.G(0.5f);
            f2 *= 0.2f + f22 * f22 * 0.8f;
            f1 *= f22;
            if (entity.ap().a(TagsEntity.H) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(entity, damagesource, f1, false)) {
                    return;
                }
                if (iprojectile.a(ProjectileDeflection.c, this, this, true)) {
                    this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.vr, this.do());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                double d1;
                double d0;
                boolean flag2;
                boolean flag1;
                boolean flag;
                boolean bl = flag = f22 > 0.9f;
                if (this.cm() && flag) {
                    this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.vq, this.do(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += itemstack.h().a(entity, f2, damagesource);
                boolean bl2 = flag2 = flag && this.am > 0.0 && !this.aK() && !this.eV() && !this.bm() && !this.d(MobEffects.o) && !this.cc() && entity instanceof EntityLiving && !this.cm();
                if (flag2) {
                    f2 *= 1.5f;
                }
                float f3 = f2 + f1;
                boolean flag3 = false;
                if (flag && !flag2 && !flag1 && this.aK() && (d0 = this.ae().j()) < MathHelper.k(d1 = (double)this.fu() * 2.5) && this.b(EnumHand.a).a(TagsItem.bL)) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                if (entity instanceof EntityLiving) {
                    EntityLiving entityliving = (EntityLiving)entity;
                    f4 = entityliving.eL();
                }
                Vec3D vec3d = entity.dA();
                boolean flag4 = entity.b(damagesource, f3);
                if (flag4) {
                    float f5 = this.b(entity, damagesource) + (flag1 ? 1.0f : 0.0f);
                    if (f5 > 0.0f) {
                        if (entity instanceof EntityLiving) {
                            EntityLiving entityliving1 = (EntityLiving)entity;
                            entityliving1.p(f5 * 0.5f, MathHelper.a(this.dP() * ((float)Math.PI / 180)), -MathHelper.b(this.dP() * ((float)Math.PI / 180)));
                        } else {
                            entity.i(-MathHelper.a(this.dP() * ((float)Math.PI / 180)) * f5 * 0.5f, 0.1, MathHelper.b(this.dP() * ((float)Math.PI / 180)) * f5 * 0.5f);
                        }
                        this.i(this.dA().d(0.6, 1.0, 0.6));
                        this.i(false);
                    }
                    if (flag3) {
                        float f6 = 1.0f + (float)this.i(GenericAttributes.E) * f2;
                        for (EntityLiving entityliving2 : this.ai().a(EntityLiving.class, entity.cV().c(1.0, 0.25, 1.0))) {
                            WorldServer worldserver;
                            EntityArmorStand entityarmorstand;
                            if (entityliving2 == this || entityliving2 == entity || this.t(entityliving2) || entityliving2 instanceof EntityArmorStand && (entityarmorstand = (EntityArmorStand)entityliving2).t() || !(this.g(entityliving2) < 9.0)) continue;
                            float f7 = this.a((Entity)entityliving2, f6, damagesource) * f22;
                            World world = this.ai();
                            if (!(world instanceof WorldServer) || !entityliving2.a(worldserver = (WorldServer)world, damagesource, f7)) continue;
                            entityliving2.p(0.4f, MathHelper.a(this.dP() * ((float)Math.PI / 180)), -MathHelper.b(this.dP() * ((float)Math.PI / 180)));
                            EnchantmentManager.a(worldserver, (Entity)entityliving2, damagesource);
                        }
                        this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.vt, this.do(), 1.0f, 1.0f);
                        this.go();
                    }
                    if (entity instanceof EntityPlayer && entity.ag) {
                        boolean cancelled = false;
                        Player player = (Player)entity.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)entity).g.b(new PacketPlayOutEntityVelocity(entity));
                            entity.ag = false;
                            entity.i(vec3d);
                        }
                    }
                    if (flag2) {
                        this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.vp, this.do(), 1.0f, 1.0f);
                        this.b(entity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.vs, this.do(), 1.0f, 1.0f);
                        } else {
                            this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.vu, this.do(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(entity);
                    }
                    this.C(entity);
                    Entity entity1 = entity;
                    if (entity instanceof EntityComplexPart) {
                        entity1 = ((EntityComplexPart)entity).a;
                    }
                    boolean flag5 = false;
                    World world1 = this.ai();
                    if (world1 instanceof WorldServer) {
                        WorldServer worldserver1 = (WorldServer)world1;
                        if (entity1 instanceof EntityLiving) {
                            EntityLiving entityliving3 = (EntityLiving)entity1;
                            flag5 = itemstack.a(entityliving3, (EntityLiving)this);
                        }
                        EnchantmentManager.a(worldserver1, entity, damagesource);
                    }
                    if (!this.ai().C && !itemstack.f() && entity1 instanceof EntityLiving) {
                        if (flag5) {
                            itemstack.b((EntityLiving)entity1, (EntityLiving)this);
                        }
                        if (itemstack.f()) {
                            if (itemstack == this.fh()) {
                                this.a(EnumHand.a, ItemStack.l);
                            } else {
                                this.a(EnumHand.b, ItemStack.l);
                            }
                        }
                    }
                    if (entity instanceof EntityLiving) {
                        float f8 = f4 - ((EntityLiving)entity).eL();
                        this.a(StatisticList.H, Math.round(f8 * 10.0f));
                        if (this.ai() instanceof WorldServer && f8 > 2.0f) {
                            int i2 = (int)((double)f8 * 0.5);
                            ((WorldServer)this.ai()).a(Particles.g, entity.dC(), entity.e(0.5), entity.dI(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.ai().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.vr, this.do(), 1.0f, 1.0f);
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return f2;
    }

    @Override
    protected void f(EntityLiving entityliving) {
        this.e((Entity)entityliving);
    }

    public void b(Entity entity) {
    }

    public void c(Entity entity) {
    }

    public void go() {
        double d0 = -MathHelper.a(this.dP() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dP() * ((float)Math.PI / 180));
        if (this.ai() instanceof WorldServer) {
            ((WorldServer)this.ai()).a(Particles.am, this.dC() + d0, this.e(0.5), this.dI() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void gp() {
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.cm.a(this);
        if (this.cn != null && this.gv()) {
            this.q();
        }
    }

    @Override
    public boolean aa_() {
        return true;
    }

    @Override
    protected boolean dj() {
        return this.gq();
    }

    public boolean gq() {
        return false;
    }

    @Override
    public boolean dk() {
        return !this.ai().C || this.gq();
    }

    @Override
    public boolean dl() {
        return !this.ai().C || this.gq();
    }

    public GameProfile gr() {
        return this.cV;
    }

    public PlayerInventory gs() {
        return this.cQ;
    }

    public PlayerAbilities gt() {
        return this.cT;
    }

    @Override
    public boolean gc() {
        return this.cT.d;
    }

    public boolean gu() {
        return this.cT.d;
    }

    public void a(ItemStack itemstack, ItemStack itemstack1, ClickAction clickaction) {
    }

    public boolean gv() {
        return this.cn != this.cm;
    }

    public boolean gw() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition blockposition) {
        return this.startSleepInBed(blockposition, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cS = 0;
        return Either.right((Object)((Object)Unit.a));
    }

    public void a(boolean flag, boolean flag1) {
        super.fZ();
        if (this.ai() instanceof WorldServer && flag1) {
            ((WorldServer)this.ai()).f();
        }
        this.cS = flag ? 0 : 100;
    }

    @Override
    public void fZ() {
        this.a(true, true);
    }

    public boolean gx() {
        return this.fY() && this.cS >= 100;
    }

    public int gy() {
        return this.cS;
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
    }

    public void a(MinecraftKey minecraftkey) {
        this.b(StatisticList.i.b(minecraftkey));
    }

    public void a(MinecraftKey minecraftkey, int i2) {
        this.a(StatisticList.i.b(minecraftkey), i2);
    }

    public void b(Statistic<?> statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic<?> statistic, int i2) {
    }

    public void a(Statistic<?> statistic) {
    }

    public int a(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> list) {
    }

    public int b(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    @Override
    public void k(Vec3D vec3d) {
        if (this.cc()) {
            super.k(vec3d);
        } else {
            if (this.cn()) {
                double d1;
                double d0 = this.bW().e;
                double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
                if (d0 <= 0.0 || this.bB || !this.ai().b_(BlockPosition.a(this.dC(), this.dE() + 1.0 - 0.1, this.dI())).c()) {
                    Vec3D vec3d1 = this.dA();
                    this.i(vec3d1.b(0.0, (d0 - vec3d1.e) * d1, 0.0));
                }
            }
            if (this.gt().b) {
                double d2 = this.dA().e;
                super.k(vec3d);
                this.i(this.dA().a(EnumDirection.EnumAxis.b, d2 * 0.6));
            } else {
                super.k(vec3d);
            }
        }
    }

    @Override
    protected boolean fA() {
        return !this.cT.b && super.fA();
    }

    @Override
    public void bs() {
        if (this.cT.b) {
            this.j(false);
        } else {
            super.bs();
        }
    }

    protected boolean h(BlockPosition blockposition) {
        return !this.ai().a_(blockposition).j(this.ai(), blockposition);
    }

    @Override
    public float fu() {
        return (float)this.i(GenericAttributes.w);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        double d1;
        boolean flag;
        if (this.cT.c) {
            return false;
        }
        if (d0 >= 2.0) {
            this.a(StatisticList.t, (int)Math.round(d0 * 100.0));
        }
        boolean bl = flag = this.cI != null && this.da;
        if (flag) {
            boolean flag1;
            d1 = Math.min(d0, this.cI.e - this.dE());
            boolean bl2 = flag1 = d1 <= 0.0;
            if (flag1) {
                this.gZ();
            } else {
                this.gY();
            }
        } else {
            d1 = d0;
        }
        if (d1 > 0.0 && super.a(d1, f2, damagesource)) {
            this.gZ();
            return true;
        }
        this.b(d0, f2, damagesource);
        return false;
    }

    public boolean gz() {
        if (!this.fQ() && this.fA() && !this.bm()) {
            this.gA();
            return true;
        }
        return false;
    }

    public void gA() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bv() {
        if (!this.am()) {
            super.bv();
        }
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        if (this.bm()) {
            this.bb();
            this.b(iblockdata);
        } else {
            BlockPosition blockposition1 = this.e(blockposition);
            if (!blockposition.equals(blockposition1)) {
                IBlockData iblockdata1 = this.ai().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bs)) {
                    this.a(iblockdata1, iblockdata);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(blockposition, iblockdata);
            }
        }
    }

    @Override
    public EntityLiving.a eT() {
        return new EntityLiving.a(SoundEffects.vF, SoundEffects.vv);
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        this.b(StatisticList.g.b(entityliving.ap()));
        return true;
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
        if (!this.cT.b) {
            super.a(iblockdata, vec3d);
        }
        this.gY();
    }

    public void d(int i2) {
        this.r(i2);
        this.cD += (float)i2 / (float)this.gC();
        this.cC = MathHelper.a(this.cC + i2, 0, Integer.MAX_VALUE);
        while (this.cD < 0.0f) {
            float f2 = this.cD * (float)this.gC();
            if (this.cB > 0) {
                this.c(-1);
                this.cD = 1.0f + f2 / (float)this.gC();
                continue;
            }
            this.c(-1);
            this.cD = 0.0f;
        }
        while (this.cD >= 1.0f) {
            this.cD = (this.cD - 1.0f) * (float)this.gC();
            this.c(1);
            this.cD /= (float)this.gC();
        }
    }

    public int gB() {
        return this.cE;
    }

    public void a(ItemStack itemstack, int i2) {
        this.cB -= i2;
        if (this.cB < 0) {
            this.cB = 0;
            this.cD = 0.0f;
            this.cC = 0;
        }
        this.cE = this.ar.f();
    }

    public void c(int i2) {
        this.cB = IntMath.saturatedAdd((int)this.cB, (int)i2);
        if (this.cB < 0) {
            this.cB = 0;
            this.cD = 0.0f;
            this.cC = 0;
        }
        if (i2 > 0 && this.cB % 5 == 0 && (float)this.cU < (float)this.as - 100.0f) {
            float f2 = this.cB > 30 ? 1.0f : (float)this.cB / 30.0f;
            this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.vE, this.do(), f2 * 0.75f, 1.0f);
            this.cU = this.as;
        }
    }

    public int gC() {
        return this.cB >= 30 ? 112 + (this.cB - 30) * 9 : (this.cB >= 15 ? 37 + (this.cB - 15) * 5 : 7 + this.cB * 2);
    }

    public void a(float f2) {
        this.causeFoodExhaustion(f2, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cT.a || this.ai().C || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.co.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> Z() {
        return Optional.empty();
    }

    public FoodMetaData gD() {
        return this.co;
    }

    public boolean u(boolean flag) {
        return this.cT.a || flag || this.co.b();
    }

    public boolean gE() {
        return this.eL() > 0.0f && this.eL() < this.fa();
    }

    public boolean gF() {
        return this.cT.e;
    }

    public boolean a(BlockPosition blockposition, EnumDirection enumdirection, ItemStack itemstack) {
        if (this.cT.e) {
            return true;
        }
        BlockPosition blockposition1 = blockposition.a(enumdirection.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.ai(), blockposition1, false);
        return itemstack.a(shapedetectorblock);
    }

    @Override
    protected int e(WorldServer worldserver) {
        return !worldserver.P().c(GameRules.e) && !this.am() ? Math.min(this.cB * 7, 100) : 0;
    }

    @Override
    protected boolean ev() {
        return true;
    }

    @Override
    public boolean cQ() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bj() {
        return this.cT.b || this.aK() && this.cj() ? Entity.MovementEmission.a : Entity.MovementEmission.d;
    }

    public void x() {
    }

    @Override
    public IChatBaseComponent aj() {
        return IChatBaseComponent.b(this.cV.getName());
    }

    public InventoryEnderChest gG() {
        return this.cl;
    }

    @Override
    protected boolean b(EnumItemSlot enumitemslot) {
        return enumitemslot.a() == EnumItemSlot.Function.b;
    }

    public boolean h(ItemStack itemstack) {
        return this.cQ.g(itemstack);
    }

    public boolean a(NBTTagCompound nbttagcompound) {
        if (!this.cc() && this.aK() && !this.bm() && !this.aI) {
            if (this.gL().j()) {
                this.b(nbttagcompound);
                this.cP = this.ai().ae();
                return true;
            }
            if (this.gM().j()) {
                this.c(nbttagcompound);
                this.cP = this.ai().ae();
                return true;
            }
            return false;
        }
        return false;
    }

    protected void gH() {
        if (this.cP + 20L < this.ai().ae()) {
            if (this.respawnEntityOnShoulder(this.gL())) {
                this.b(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gM())) {
                this.c(new NBTTagCompound());
            }
        }
    }

    public Entity getEntityOnShoulder(NBTTagCompound nbttagcompound) {
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!nbttagcompound.j()) {
                try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this.ef(), a);){
                    Entity entity2 = EntityTypes.a(TagValueInput.a(problemreporter_j.a(() -> ".shoulder"), (HolderLookup.a)worldserver.K_(), nbttagcompound), (World)worldserver, EntitySpawnReason.r).map(entity -> {
                        if (entity instanceof EntityTameableAnimal) {
                            EntityTameableAnimal entitytameableanimal = (EntityTameableAnimal)entity;
                            entitytameableanimal.i(this);
                        }
                        entity.a_(this.dC(), this.dE() + (double)0.7f, this.dI());
                        return entity;
                    }).orElse(null);
                    return entity2;
                }
            }
        }
        return null;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        Entity entity = this.getEntityOnShoulder(nbttagcompound);
        if (entity != null) {
            return ((WorldServer)this.ai()).addWithUUID(entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
        }
        return true;
    }

    @Nullable
    public abstract EnumGamemode a();

    @Override
    public boolean am() {
        return this.a() == EnumGamemode.d;
    }

    @Override
    public boolean bJ() {
        return !this.am() && super.bJ();
    }

    @Override
    public boolean cn() {
        return !this.cT.b && !this.am() && super.cn();
    }

    public boolean gI() {
        return this.a() == EnumGamemode.b;
    }

    @Override
    public boolean cN() {
        return !this.cT.b;
    }

    public Scoreboard gJ() {
        return this.ai().S();
    }

    @Override
    public IChatBaseComponent Q_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cu(), this.aj());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent ichatmutablecomponent) {
        String s2 = this.gr().getName();
        return ichatmutablecomponent.a(chatmodifier -> chatmodifier.a(new ChatClickable.SuggestCommand("/tell " + s2 + " ")).a(this.cU()).a(s2));
    }

    @Override
    public String cM() {
        return this.gr().getName();
    }

    @Override
    protected void F(float f2) {
        this.au().a(d, Float.valueOf(f2));
    }

    @Override
    public float fD() {
        return this.au().a(d).floatValue();
    }

    public boolean a(PlayerModelPart playermodelpart) {
        return (this.au().a(cg) & playermodelpart.a()) == playermodelpart.a();
    }

    @Override
    public SlotAccess a_(int i2) {
        if (i2 == 499) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHuman.this.cn.g();
                }

                @Override
                public boolean a(ItemStack itemstack) {
                    EntityHuman.this.cn.a(itemstack);
                    return true;
                }
            };
        }
        final int j2 = i2 - 500;
        if (j2 >= 0 && j2 < 4) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHuman.this.cm.r().a(j2);
                }

                @Override
                public boolean a(ItemStack itemstack) {
                    EntityHuman.this.cm.r().a(j2, itemstack);
                    EntityHuman.this.cm.a(EntityHuman.this.cQ);
                    return true;
                }
            };
        }
        if (i2 >= 0 && i2 < this.cQ.i().size()) {
            return SlotAccess.a(this.cQ, i2);
        }
        int k2 = i2 - 200;
        return k2 >= 0 && k2 < this.cl.b() ? SlotAccess.a(this.cl, k2) : super.a_(i2);
    }

    public boolean gK() {
        return this.cW;
    }

    public void v(boolean flag) {
        this.cW = flag;
    }

    @Override
    public void h(int i2) {
        super.h(this.cT.a ? Math.min(i2, 1) : i2);
    }

    @Override
    public EnumMainHand fF() {
        return this.ay.a(ch) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void b(EnumMainHand enummainhand) {
        this.ay.a(ch, (byte)(enummainhand != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gL() {
        return this.ay.a(ci);
    }

    public void b(NBTTagCompound nbttagcompound) {
        this.ay.a(ci, nbttagcompound);
    }

    public NBTTagCompound gM() {
        return this.ay.a(cj);
    }

    public void c(NBTTagCompound nbttagcompound) {
        this.ay.a(cj, nbttagcompound);
    }

    public float gN() {
        return (float)(1.0 / this.i(GenericAttributes.e) * 20.0);
    }

    public float G(float f2) {
        return MathHelper.a(((float)this.bo + f2) / this.gN(), 0.0f, 1.0f);
    }

    public void gO() {
        this.bo = 0;
    }

    public ItemCooldown gP() {
        return this.cY;
    }

    @Override
    protected float aW() {
        return !this.cT.b && !this.fQ() ? super.aW() : 1.0f;
    }

    @Override
    public float em() {
        return (float)this.i(GenericAttributes.r);
    }

    public boolean gQ() {
        return this.cT.d && this.G() >= 2;
    }

    public int G() {
        return 0;
    }

    public boolean s(int i2) {
        return this.G() >= i2;
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return c.getOrDefault((Object)entitypose, cf);
    }

    @Override
    public ImmutableList<EntityPose> fV() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    @Override
    public ItemStack d(ItemStack itemstack) {
        if (!(itemstack.h() instanceof ItemProjectileWeapon)) {
            return ItemStack.l;
        }
        Predicate<ItemStack> predicate = ((ItemProjectileWeapon)itemstack.h()).c();
        ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.f()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)itemstack.h()).a();
        for (int i2 = 0; i2 < this.cQ.b(); ++i2) {
            ItemStack itemstack2 = this.cQ.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.gc() ? new ItemStack(Items.pB) : ItemStack.l;
    }

    @Override
    public Vec3D u(float f2) {
        float f3;
        double d0 = 0.22 * (this.fF() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.h(f2 * 0.5f, this.dR(), this.ab) * ((float)Math.PI / 180);
        float f22 = MathHelper.h(f2, this.bs, this.br) * ((float)Math.PI / 180);
        if (!this.fQ() && !this.fC()) {
            if (this.co()) {
                return this.p(f2).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f22));
            }
            double d1 = this.cV().c() - 1.0;
            double d2 = this.cl() ? -0.2 : 0.07;
            return this.p(f2).e(new Vec3D(d0, d1, d2).b(-f22));
        }
        Vec3D vec3d = this.h(f2);
        Vec3D vec3d1 = this.dA();
        double d3 = vec3d1.j();
        double d4 = vec3d.j();
        if (d3 > 0.0 && d4 > 0.0) {
            double d5 = (vec3d1.d * vec3d.d + vec3d1.f * vec3d.f) / Math.sqrt(d3 * d4);
            double d6 = vec3d1.d * vec3d.f - vec3d1.f * vec3d.d;
            f3 = (float)(Math.signum(d6) * Math.acos(d5));
        } else {
            f3 = 0.0f;
        }
        return this.p(f2).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f22));
    }

    @Override
    public boolean dY() {
        return true;
    }

    public boolean gR() {
        return this.fG() && this.fI().a(Items.sw);
    }

    @Override
    public boolean dX() {
        return false;
    }

    public Optional<GlobalPos> gS() {
        return this.cZ;
    }

    public void a(Optional<GlobalPos> optional) {
        this.cZ = optional;
    }

    @Override
    public float eR() {
        return this.cH;
    }

    @Override
    public void q(float f2) {
        super.q(f2);
        this.cH = f2;
    }

    @Override
    public boolean dS() {
        return true;
    }

    @Override
    protected float ft() {
        return this.cT.b && !this.cc() ? (this.cm() ? this.cT.a() * 2.0f : this.cT.a()) : (this.cm() ? 0.025999999f : 0.02f);
    }

    public boolean gT() {
        return this.cR || this.cq <= 0;
    }

    public void gU() {
        if (!this.cR) {
            --this.cq;
        }
    }

    public void w(boolean flag) {
        this.cR = flag;
        if (!this.cR) {
            this.cq = 60;
        }
    }

    public double gV() {
        return this.i(GenericAttributes.g);
    }

    public double gW() {
        return this.i(GenericAttributes.k);
    }

    public boolean b(Entity entity, double d0) {
        return entity.dU() ? false : this.a(entity.cV(), d0);
    }

    public boolean a(AxisAlignedBB axisalignedbb, double d0) {
        double d1 = this.gW() + d0;
        return axisalignedbb.e(this.bI()) < d1 * d1;
    }

    public boolean a(BlockPosition blockposition, double d0) {
        double d1 = this.gV() + d0;
        return new AxisAlignedBB(blockposition).e(this.bI()) < d1 * d1;
    }

    public void x(boolean flag) {
        this.da = flag;
        this.db = flag ? 40 : 0;
    }

    public boolean gX() {
        return this.da;
    }

    public void gY() {
        if (this.db == 0) {
            this.gZ();
        }
    }

    public void gZ() {
        this.db = 0;
        this.cJ = null;
        this.cI = null;
        this.da = false;
    }

    public boolean ha() {
        return false;
    }

    @Override
    public boolean eV() {
        return this.cT.b ? false : super.eV();
    }

    public String hb() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.aj().getString()).add("id", this.ar()).add("pos", (Object)this.dv()).add("mode", (Object)this.a()).add("permission", this.G()).toString();
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

