/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> a = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    private static final DataWatcherObject<OptionalInt> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.v);
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    private static final int d = 0;
    private static final int f = 0;
    private static final boolean g = false;
    public int h = 0;
    public int i = 0;
    @Nullable
    public EntityLiving j;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    public EntityFireworks(World world, double d0, double d1, double d2, ItemStack itemstack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.aa, world);
        this.h = 0;
        this.a_(d0, d1, d2);
        this.ay.a(a, itemstack.v());
        int i2 = 1;
        Fireworks fireworks = itemstack.a(DataComponents.aj);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.n(this.ar.a(0.0, 0.002297), 0.05, this.ar.a(0.0, 0.002297));
        this.i = 10 * i2 + this.ar.a(6) + this.ar.a(7);
    }

    public EntityFireworks(World world, @Nullable Entity entity, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack);
        this.c(entity);
    }

    public EntityFireworks(World world, ItemStack itemstack, EntityLiving entityliving) {
        this(world, entityliving, entityliving.dC(), entityliving.dE(), entityliving.dI(), itemstack);
        this.ay.a(b, OptionalInt.of(entityliving.ar()));
        this.j = entityliving;
    }

    public EntityFireworks(World world, ItemStack itemstack, double d0, double d1, double d2, boolean flag) {
        this(world, d0, d1, d2, itemstack);
        this.ay.a(c, flag);
    }

    public EntityFireworks(World world, ItemStack itemstack, Entity entity, double d0, double d1, double d2, boolean flag) {
        this(world, itemstack, d0, d1, d2, flag);
        this.c(entity);
    }

    @Override
    public void inactiveTick() {
        World world;
        ++this.h;
        if (this.h > this.i && (world = this.ai()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.inactiveTick();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(a, EntityFireworks.n());
        datawatcher_a.a(b, OptionalInt.empty());
        datawatcher_a.a(c, false);
    }

    @Override
    public boolean a(double d0) {
        return d0 < 4096.0 && !this.l();
    }

    @Override
    public boolean j(double d0, double d1, double d2) {
        return super.j(d0, d1, d2) && !this.l();
    }

    @Override
    public void g() {
        World world;
        MovingObjectPosition movingobjectposition;
        super.g();
        if (this.l()) {
            if (this.j == null) {
                this.ay.a(b).ifPresent(i2 -> {
                    Entity entity = this.ai().a(i2);
                    if (entity instanceof EntityLiving) {
                        this.j = (EntityLiving)entity;
                    }
                });
            }
            if (this.j != null) {
                Vec3D vec3d;
                if (this.j.fQ()) {
                    Vec3D vec3d1 = this.j.bW();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3D vec3d2 = this.j.dA();
                    this.j.i(vec3d2.b(vec3d1.d * 0.1 + (vec3d1.d * 1.5 - vec3d2.d) * 0.5, vec3d1.e * 0.1 + (vec3d1.e * 1.5 - vec3d2.e) * 0.5, vec3d1.f * 0.1 + (vec3d1.f * 1.5 - vec3d2.f) * 0.5));
                    vec3d = this.j.a(Items.vW);
                } else {
                    vec3d = Vec3D.c;
                }
                this.a_(this.j.dC() + vec3d.d, this.j.dE() + vec3d.e, this.j.dI() + vec3d.f);
                this.i(this.j.dA());
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        } else {
            if (!this.f()) {
                double d2 = this.ac ? 1.0 : 1.15;
                this.i(this.dA().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            Vec3D vec3d3 = this.dA();
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
            this.a(EnumMoveType.a, vec3d3);
            this.aL();
            this.i(vec3d3);
        }
        if (!this.aq && this.bO() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
            this.aE = true;
        }
        this.z();
        if (this.h == 0 && !this.be()) {
            this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.jC, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.h;
        if (this.ai().C && this.h % 2 < 2) {
            this.ai().a(Particles.D, this.dC(), this.dE(), this.dI(), this.ar.k() * 0.05, -this.dA().e * 0.5, this.ar.k() * 0.05);
        }
        if (this.h > this.i && (world = this.ai()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    private void b(WorldServer worldserver) {
        worldserver.a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.ah_());
        this.e(worldserver);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = new BlockPosition(movingobjectpositionblock.b());
        this.ai().a_(blockposition).a(this.ai(), blockposition, (Entity)this, InsideBlockEffectApplier.a);
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.i() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.a(movingobjectpositionblock);
    }

    private boolean i() {
        return !this.m().isEmpty();
    }

    private void e(WorldServer worldserver) {
        float f2 = 0.0f;
        List<FireworkExplosion> list = this.m();
        if (!list.isEmpty()) {
            f2 = 5.0f + (float)(list.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.j != null) {
                this.j.a(worldserver, this.ea().a(this, this.ah_()), 5.0f + (float)(list.size() * 2));
            }
            double d0 = 5.0;
            Vec3D vec3d = this.dv();
            for (EntityLiving entityliving : this.ai().a(EntityLiving.class, this.cV().g(5.0))) {
                if (entityliving == this.j || !(this.g(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec3d1 = new Vec3D(entityliving.dC(), entityliving.e(0.5 * (double)i2), entityliving.dI());
                    MovingObjectPositionBlock movingobjectposition = this.ai().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (((MovingObjectPosition)movingobjectposition).d() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(entityliving)) / 5.0);
                entityliving.a(worldserver, this.ea().a(this, this.ah_()), f1);
            }
        }
    }

    private boolean l() {
        return this.ay.a(b).isPresent();
    }

    public boolean f() {
        return this.ay.a(c);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 17 && this.ai().C) {
            Vec3D vec3d = this.dA();
            this.ai().a(this.dC(), this.dE(), this.dI(), vec3d.d, vec3d.e, vec3d.f, this.m());
        }
        super.b(b0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Life", this.h);
        valueoutput.a("LifeTime", this.i);
        valueoutput.a("FireworksItem", ItemStack.b, this.e());
        valueoutput.a("ShotAtAngle", this.ay.a(c));
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.h = valueinput.a("Life", 0);
        this.i = valueinput.a("LifeTime", 0);
        this.ay.a(a, valueinput.a("FireworksItem", ItemStack.b).orElse(EntityFireworks.n()));
        this.ay.a(c, valueinput.a("ShotAtAngle", false));
    }

    private List<FireworkExplosion> m() {
        ItemStack itemstack = this.ay.a(a);
        Fireworks fireworks = itemstack.a(DataComponents.aj);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack e() {
        return this.ay.a(a);
    }

    @Override
    public boolean cF() {
        return false;
    }

    private static ItemStack n() {
        return new ItemStack(Items.vW);
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = entityliving.dv().d - this.dv().d;
        double d1 = entityliving.dv().f - this.dv().f;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

