/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.PluginManager;

public abstract class BlockPressurePlateAbstract
extends Block {
    private static final VoxelShape c = Block.b(14.0, 0.0, 0.5);
    private static final VoxelShape d = Block.b(14.0, 0.0, 1.0);
    protected static final AxisAlignedBB a = Block.b(14.0, 0.0, 4.0).e().getFirst();
    protected final BlockSetType b;

    protected BlockPressurePlateAbstract(BlockBase.Info blockbase_info, BlockSetType blocksettype) {
        super(blockbase_info.a(blocksettype.g()));
        this.b = blocksettype;
    }

    protected abstract MapCodec<? extends BlockPressurePlateAbstract> a();

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.h(iblockdata) > 0 ? c : d;
    }

    protected int b() {
        return 20;
    }

    @Override
    public boolean a(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        return enumdirection == EnumDirection.a && !iblockdata.a(iworldreader, blockposition) ? Blocks.a.m() : super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        return BlockPressurePlateAbstract.c(iworldreader, blockposition1) || BlockPressurePlateAbstract.a(iworldreader, blockposition1, EnumDirection.b);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        int i2 = this.h(iblockdata);
        if (i2 > 0) {
            this.a((Entity)null, (World)worldserver, blockposition, iblockdata, i2);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        int i2;
        if (!world.C && (i2 = this.h(iblockdata)) == 0) {
            this.a(entity, world, blockposition, iblockdata, i2);
        }
    }

    private void a(@Nullable Entity entity, World world, BlockPosition blockposition, IBlockData iblockdata, int i2) {
        int j2 = this.b(world, blockposition);
        boolean flag = i2 > 0;
        boolean flag1 = j2 > 0;
        CraftWorld bworld = world.getWorld();
        PluginManager manager = world.getCraftServer().getPluginManager();
        if (flag != flag1) {
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bworld.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), i2, j2);
            manager.callEvent((Event)eventRedstone);
            flag1 = eventRedstone.getNewCurrent() > 0;
            j2 = eventRedstone.getNewCurrent();
        }
        if (i2 != j2) {
            IBlockData iblockdata1 = this.a(iblockdata, j2);
            world.a(blockposition, iblockdata1, 2);
            this.a(world, blockposition);
            world.b(blockposition, iblockdata, iblockdata1);
        }
        if (!flag1 && flag) {
            world.a((Entity)null, blockposition, this.b.l(), SoundCategory.e);
            world.a(entity, GameEvent.e, blockposition);
        } else if (flag1 && !flag) {
            world.a((Entity)null, blockposition, this.b.m(), SoundCategory.e);
            world.a(entity, GameEvent.a, blockposition);
        }
        if (flag1) {
            world.a(new BlockPosition(blockposition), (Block)this, this.b());
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, boolean flag) {
        if (!flag && this.h(iblockdata) > 0) {
            this.a(worldserver, blockposition);
        }
    }

    protected void a(World world, BlockPosition blockposition) {
        world.a(blockposition, this);
        world.a(blockposition.e(), this);
    }

    @Override
    protected int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return this.h(iblockdata);
    }

    @Override
    protected int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.b ? this.h(iblockdata) : 0;
    }

    @Override
    protected boolean f_(IBlockData iblockdata) {
        return true;
    }

    protected static int a(World world, AxisAlignedBB axisalignedbb, Class<? extends Entity> oclass) {
        return BlockPressurePlateAbstract.getEntities(world, axisalignedbb, oclass).size();
    }

    protected static <T extends Entity> List<T> getEntities(World world, AxisAlignedBB axisalignedbb, Class<T> oclass) {
        return world.a(oclass, axisalignedbb, IEntitySelector.f.and(entity -> !entity.n_()));
    }

    protected abstract int b(World var1, BlockPosition var2);

    protected abstract int h(IBlockData var1);

    protected abstract IBlockData a(IBlockData var1, int var2);
}

