/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R5.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;

public abstract class TileEntity {
    public CustomTimingsHandler tickTimer = SpigotTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Codec<TileEntityTypes<?>> d = BuiltInRegistries.j.q();
    private static final Logger e = LogUtils.getLogger();
    private final TileEntityTypes<?> f;
    @Nullable
    protected World n;
    protected final BlockPosition o;
    protected boolean p;
    private IBlockData g;
    private DataComponentMap h = DataComponentMap.a;

    public TileEntity(TileEntityTypes<?> tileentitytypes, BlockPosition blockposition, IBlockData iblockdata) {
        this.f = tileentitytypes;
        this.o = blockposition.j();
        this.a(iblockdata);
        this.g = iblockdata;
    }

    private void a(IBlockData iblockdata) {
        if (!this.b(iblockdata)) {
            String s2 = this.p();
            throw new IllegalStateException("Invalid block entity " + s2 + " state at " + String.valueOf(this.o) + ", got " + String.valueOf(iblockdata));
        }
    }

    public boolean b(IBlockData iblockdata) {
        return this.f.a(iblockdata);
    }

    public static BlockPosition a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        int i2 = nbttagcompound.b("x", 0);
        int j2 = nbttagcompound.b("y", 0);
        int k2 = nbttagcompound.b("z", 0);
        int l2 = SectionPosition.a(i2);
        int i1 = SectionPosition.a(k2);
        if (chunkcoordintpair != null && (l2 != chunkcoordintpair.h || i1 != chunkcoordintpair.i)) {
            e.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)nbttagcompound, (Object)chunkcoordintpair);
            i2 = chunkcoordintpair.a(SectionPosition.b(i2));
            k2 = chunkcoordintpair.b(SectionPosition.b(k2));
        }
        return new BlockPosition(i2, j2, k2);
    }

    @Nullable
    public World i() {
        return this.n;
    }

    public void a(World world) {
        this.n = world;
    }

    public boolean l() {
        return this.n != null;
    }

    protected void a(ValueInput valueinput) {
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
        valueinput.a("PublicBukkitValues").ifPresent(persistentDataTag -> this.persistentDataContainer.putAll((ValueInput)persistentDataTag));
    }

    public final void b(ValueInput valueinput) {
        this.a(valueinput);
        this.h = valueinput.a("components", DataComponentMap.b).orElse(DataComponentMap.a);
    }

    public final void c(ValueInput valueinput) {
        this.a(valueinput);
    }

    protected void a(ValueOutput valueoutput) {
    }

    public final NBTTagCompound b(HolderLookup.a holderlookup_a) {
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this.t(), e);){
            TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, holderlookup_a);
            this.c(tagvalueoutput);
            NBTTagCompound nBTTagCompound = tagvalueoutput.b();
            return nBTTagCompound;
        }
    }

    public void c(ValueOutput valueoutput) {
        this.e(valueoutput);
        this.h(valueoutput);
    }

    public void d(ValueOutput valueoutput) {
        this.e(valueoutput);
        this.g(valueoutput);
    }

    public final NBTTagCompound c(HolderLookup.a holderlookup_a) {
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this.t(), e);){
            TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, holderlookup_a);
            this.e(tagvalueoutput);
            NBTTagCompound nBTTagCompound = tagvalueoutput.b();
            return nBTTagCompound;
        }
    }

    public void e(ValueOutput valueoutput) {
        this.a(valueoutput);
        valueoutput.a("components", DataComponentMap.b, this.h);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            this.persistentDataContainer.store(valueoutput.a("PublicBukkitValues"));
        }
    }

    public final NBTTagCompound d(HolderLookup.a holderlookup_a) {
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this.t(), e);){
            TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, holderlookup_a);
            this.f(tagvalueoutput);
            NBTTagCompound nBTTagCompound = tagvalueoutput.b();
            return nBTTagCompound;
        }
    }

    public void f(ValueOutput valueoutput) {
        this.a(valueoutput);
    }

    private void g(ValueOutput valueoutput) {
        TileEntity.a(valueoutput, this.q());
    }

    public static void a(ValueOutput valueoutput, TileEntityTypes<?> tileentitytypes) {
        valueoutput.a("id", d, tileentitytypes);
    }

    private void h(ValueOutput valueoutput) {
        this.g(valueoutput);
        valueoutput.a("x", this.o.u());
        valueoutput.a("y", this.o.v());
        valueoutput.a("z", this.o.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition blockposition, IBlockData iblockdata, NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        Object tileentity;
        TileEntityTypes tileentitytypes = nbttagcompound.a("id", d).orElse(null);
        if (tileentitytypes == null) {
            e.error("Skipping block entity with invalid type: {}", (Object)nbttagcompound.a("id"));
            return null;
        }
        try {
            tileentity = tileentitytypes.a(blockposition, iblockdata);
        }
        catch (Throwable throwable) {
            e.error("Failed to create block entity {} for block {} at position {} ", new Object[]{tileentitytypes, blockposition, iblockdata, throwable});
            return null;
        }
        ProblemReporter.j problemreporter_j = new ProblemReporter.j(((TileEntity)tileentity).t(), e);
        try {
            ((TileEntity)tileentity).b(TagValueInput.a((ProblemReporter)problemreporter_j, holderlookup_a, nbttagcompound));
            Object t2 = tileentity;
            problemreporter_j.close();
            return t2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    problemreporter_j.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable1) {
                e.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{tileentitytypes, blockposition, iblockdata, throwable1});
                return null;
            }
        }
    }

    public void e() {
        if (this.n != null) {
            TileEntity.a(this.n, this.o, this.g);
        }
    }

    protected static void a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        world.q(blockposition);
        if (!iblockdata.l()) {
            world.b(blockposition, iblockdata.b());
        }
    }

    public BlockPosition aA_() {
        return this.o;
    }

    public IBlockData m() {
        return this.g;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> ax_() {
        return null;
    }

    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        return new NBTTagCompound();
    }

    public boolean n() {
        return this.p;
    }

    public void av_() {
        this.p = true;
    }

    public void o() {
        this.p = false;
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata) {
        TileEntity tileEntity = this;
        if (tileEntity instanceof IInventory) {
            IInventory iinventory = (IInventory)((Object)tileEntity);
            if (this.n != null) {
                InventoryUtils.a(this.n, blockposition, iinventory);
            }
        }
    }

    public boolean a_(int i2, int j2) {
        return false;
    }

    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.a("Name", this::p);
        IBlockData iblockdata = this.m();
        Objects.requireNonNull(iblockdata);
        crashreportsystemdetails.a("Cached block", iblockdata::toString);
        if (this.n == null) {
            crashreportsystemdetails.a("Block location", () -> String.valueOf(this.o) + " (world missing)");
        } else {
            iblockdata = this.n.a_(this.o);
            Objects.requireNonNull(iblockdata);
            crashreportsystemdetails.a("Actual block", iblockdata::toString);
            CrashReportSystemDetails.a(crashreportsystemdetails, this.n, this.o);
        }
    }

    public String p() {
        String s2 = String.valueOf(BuiltInRegistries.j.b(this.q()));
        return s2 + " // " + this.getClass().getCanonicalName();
    }

    public TileEntityTypes<?> q() {
        return this.f;
    }

    @Deprecated
    public void c(IBlockData iblockdata) {
        this.a(iblockdata);
        this.g = iblockdata;
    }

    protected void a(DataComponentGetter datacomponentgetter) {
    }

    public final void a(ItemStack itemstack) {
        this.a(itemstack.c(), itemstack.d());
    }

    public final void a(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        this.applyComponentsSet(datacomponentmap, datacomponentpatch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.aa);
        set.add(DataComponents.aq);
        final PatchedDataComponentMap datacomponentmap1 = PatchedDataComponentMap.a(datacomponentmap, datacomponentpatch);
        this.a(new DataComponentGetter(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<? extends T> datacomponenttype) {
                set.add(datacomponenttype);
                return datacomponentmap1.a(datacomponenttype);
            }

            @Override
            public <T> T a(DataComponentType<? extends T> datacomponenttype, T t0) {
                set.add(datacomponenttype);
                return datacomponentmap1.a(datacomponenttype, t0);
            }
        });
        Objects.requireNonNull(set);
        DataComponentPatch datacomponentpatch1 = datacomponentpatch.a(set::contains);
        this.h = datacomponentpatch1.e().a();
        set.remove(DataComponents.aa);
        set.remove(DataComponents.aq);
        return set;
    }

    protected void a(DataComponentMap.a datacomponentmap_a) {
    }

    @Deprecated
    public void b(ValueOutput valueoutput) {
    }

    public final DataComponentMap r() {
        DataComponentMap.a datacomponentmap_a = DataComponentMap.a();
        datacomponentmap_a.a(this.h);
        this.a(datacomponentmap_a);
        return datacomponentmap_a.a();
    }

    public DataComponentMap s() {
        return this.h;
    }

    public void a(DataComponentMap datacomponentmap) {
        this.h = datacomponentmap;
    }

    @Nullable
    public static IChatBaseComponent a(ValueInput valueinput, String s2) {
        return valueinput.a(s2, ComponentSerialization.a).orElse(null);
    }

    public ProblemReporter.f t() {
        return new a(this);
    }

    public InventoryHolder getOwner() {
        if (this.n == null) {
            return null;
        }
        BlockState state = this.n.getWorld().getBlockAt(this.o.u(), this.o.v(), this.o.w()).getState();
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    private record a(TileEntity a) implements ProblemReporter.f
    {
        @Override
        public String get() {
            String s2 = this.a.p();
            return s2 + "@" + String.valueOf(this.a.aA_());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockEntity", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockEntity", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockEntity", "a"}, this, o2);
        }
    }
}

