/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R5.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;

public class TileEntitySign
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 90;
    private static final int c = 10;
    private static final boolean d = false;
    @Nullable
    public UUID e;
    private SignText f;
    private SignText g;
    private boolean h = false;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent ichatbasecomponent) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return wrapper.f() != null ? wrapper.f().getBukkitEntity() : new CraftBlockCommandSender(wrapper, TileEntitySign.this);
        }

        @Override
        public boolean x_() {
            return false;
        }

        @Override
        public boolean y_() {
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }
    };

    public TileEntitySign(BlockPosition blockposition, IBlockData iblockdata) {
        this((TileEntityTypes)TileEntityTypes.h, blockposition, iblockdata);
    }

    public TileEntitySign(TileEntityTypes tileentitytypes, BlockPosition blockposition, IBlockData iblockdata) {
        super(tileentitytypes, blockposition, iblockdata);
        this.f = this.f();
        this.g = this.f();
    }

    protected SignText f() {
        return new SignText();
    }

    public boolean a(EntityHuman entityhuman) {
        Block block = this.m().b();
        if (block instanceof BlockSign) {
            float f1;
            BlockSign blocksign = (BlockSign)block;
            Vec3D vec3d = blocksign.o(this.m());
            double d0 = entityhuman.dC() - ((double)this.aA_().u() + vec3d.d);
            double d1 = entityhuman.dI() - ((double)this.aA_().w() + vec3d.f);
            float f2 = blocksign.h(this.m());
            return MathHelper.d(f2, f1 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText a(boolean flag) {
        return flag ? this.f : this.g;
    }

    public SignText j() {
        return this.f;
    }

    public SignText k() {
        return this.g;
    }

    public int a() {
        return 10;
    }

    public int c() {
        return 90;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("front_text", SignText.a, this.f);
        valueoutput.a("back_text", SignText.a, this.g);
        valueoutput.a("is_waxed", this.h);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.f = valueinput.a("front_text", SignText.a).map(this::a).orElseGet(SignText::new);
        this.g = valueinput.a("back_text", SignText.a).map(this::a).orElseGet(SignText::new);
        this.h = valueinput.a("is_waxed", false);
    }

    private SignText a(SignText signtext) {
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent ichatbasecomponent = this.a(signtext.a(i2, false));
            IChatBaseComponent ichatbasecomponent1 = this.a(signtext.a(i2, true));
            signtext = signtext.a(i2, ichatbasecomponent, ichatbasecomponent1);
        }
        return signtext;
    }

    private IChatBaseComponent a(IChatBaseComponent ichatbasecomponent) {
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            try {
                return ChatComponentUtils.a(this.a((EntityHuman)null, worldserver, this.o), ichatbasecomponent, (Entity)null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return ichatbasecomponent;
    }

    public void a(EntityHuman entityhuman, boolean flag, List<FilteredText> list) {
        if (!this.w() && entityhuman.cK().equals(this.v()) && this.n != null) {
            this.a(signtext -> this.setMessages(entityhuman, list, (SignText)signtext, flag), flag);
            this.a((UUID)null);
            this.n.a(this.aA_(), this.m(), this.m(), 3);
        } else {
            a.warn("Player {} just tried to change non-editable sign", (Object)entityhuman.aj().getString());
            ((EntityPlayer)entityhuman).g.b(this.u());
        }
    }

    public boolean a(UnaryOperator<SignText> unaryoperator, boolean flag) {
        SignText signtext = this.a(flag);
        return this.a((SignText)unaryoperator.apply(signtext), flag);
    }

    private SignText setMessages(EntityHuman entityhuman, List<FilteredText> list, SignText signtext, boolean front) {
        SignText originalText = signtext;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FilteredText filteredtext = list.get(i2);
            ChatModifier chatmodifier = signtext.a(i2, entityhuman.X()).a();
            signtext = entityhuman.X() ? signtext.a(i2, IChatBaseComponent.b(filteredtext.b()).b(chatmodifier)) : signtext.a(i2, IChatBaseComponent.b(filteredtext.d()).b(chatmodifier), IChatBaseComponent.b(filteredtext.b()).b(chatmodifier));
        }
        CraftPlayer player = ((EntityPlayer)entityhuman).getBukkitEntity();
        String[] lines = new String[4];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            lines[i3] = CraftChatMessage.fromComponent(signtext.a(i3, entityhuman.X()));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.n, this.o), (Player)player, (String[])lines.clone(), front ? Side.FRONT : Side.BACK);
        entityhuman.ai().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return originalText;
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(event.getLines());
        for (int i4 = 0; i4 < components.length; ++i4) {
            if (Objects.equals(lines[i4], event.getLine(i4))) continue;
            signtext = signtext.a(i4, components[i4]);
        }
        return signtext;
    }

    public boolean a(SignText signtext, boolean flag) {
        return flag ? this.c(signtext) : this.b(signtext);
    }

    private boolean b(SignText signtext) {
        if (signtext != this.g) {
            this.g = signtext;
            this.x();
            return true;
        }
        return false;
    }

    private boolean c(SignText signtext) {
        if (signtext != this.f) {
            this.f = signtext;
            this.x();
            return true;
        }
        return false;
    }

    public boolean a(boolean flag, EntityHuman entityhuman) {
        return this.w() && this.a(flag).b(entityhuman);
    }

    public boolean a(WorldServer worldserver, EntityHuman entityhuman, BlockPosition blockposition, boolean flag) {
        boolean flag1 = false;
        for (IChatBaseComponent ichatbasecomponent : this.a(flag).b(entityhuman.X())) {
            ChatModifier chatmodifier = ichatbasecomponent.a();
            ChatClickable chatclickable = chatmodifier.i();
            boolean b0 = false;
            if (chatclickable instanceof ChatClickable.RunCommand) {
                ChatClickable.RunCommand chatclickable_runcommand = (ChatClickable.RunCommand)chatclickable;
                worldserver.q().aG().a(this.a(entityhuman, worldserver, blockposition), chatclickable_runcommand.b());
                flag1 = true;
                continue;
            }
            if (chatclickable instanceof ChatClickable.h) {
                ChatClickable.h chatclickable_h = (ChatClickable.h)chatclickable;
                entityhuman.b(chatclickable_h.b());
                flag1 = true;
                continue;
            }
            if (!(chatclickable instanceof ChatClickable.d)) continue;
            ChatClickable.d chatclickable_d = (ChatClickable.d)chatclickable;
            worldserver.q().handleCustomClickAction(chatclickable_d.b(), chatclickable_d.c(), (EntityPlayer)entityhuman);
            flag1 = true;
        }
        return flag1;
    }

    private CommandListenerWrapper a(@Nullable EntityHuman entityhuman, WorldServer worldserver, BlockPosition blockposition) {
        String s2 = entityhuman == null ? "Sign" : entityhuman.aj().getString();
        IChatBaseComponent ichatbasecomponent = entityhuman == null ? IChatBaseComponent.b("Sign") : entityhuman.Q_();
        return new CommandListenerWrapper(this.commandSource, Vec3D.b(blockposition), Vec2F.a, worldserver, 2, s2, ichatbasecomponent, worldserver.q(), entityhuman);
    }

    public PacketPlayOutTileEntityData u() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        return this.d(holderlookup_a);
    }

    public void a(@Nullable UUID uuid) {
        this.e = uuid;
    }

    @Nullable
    public UUID v() {
        if (this.n != null && this.e != null) {
            this.a(this, this.n, this.e);
        }
        return this.e;
    }

    private void x() {
        this.e();
        if (this.n != null) {
            this.n.a(this.aA_(), this.m(), this.m(), 3);
        }
    }

    public boolean w() {
        return this.h;
    }

    public boolean b(boolean flag) {
        if (this.h != flag) {
            this.h = flag;
            this.x();
            return true;
        }
        return false;
    }

    public boolean b(UUID uuid) {
        EntityHuman entityhuman = this.n.a(uuid);
        return entityhuman == null || !entityhuman.a(this.aA_(), 4.0);
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntitySign tileentitysign) {
        UUID uuid = tileentitysign.v();
        if (uuid != null) {
            tileentitysign.a(tileentitysign, world, uuid);
        }
    }

    private void a(TileEntitySign tileentitysign, World world, UUID uuid) {
        if (tileentitysign.b(uuid)) {
            tileentitysign.a((UUID)null);
        }
    }

    public SoundEffect d() {
        return SoundEffects.DE;
    }
}

