/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class TrialSpawner {
    private static final Logger b = LogUtils.getLogger();
    public static final int a = 40;
    private static final int c = 36000;
    private static final int d = 14;
    private static final int e = 47;
    private static final int f = MathHelper.i(47);
    private static final float g = 0.02f;
    private final TrialSpawnerData h = new TrialSpawnerData();
    public b i;
    public final c j;
    private PlayerDetector k;
    private final PlayerDetector.a l;
    private boolean m;
    public boolean n;

    public TrialSpawner(b trialspawner_b, c trialspawner_c, PlayerDetector playerdetector, PlayerDetector.a playerdetector_a) {
        this.i = trialspawner_b;
        this.j = trialspawner_c;
        this.k = playerdetector;
        this.l = playerdetector_a;
    }

    public TrialSpawnerConfig a() {
        return this.n ? this.i.b().a() : this.i.c.a();
    }

    public TrialSpawnerConfig b() {
        return this.i.c.a();
    }

    public TrialSpawnerConfig c() {
        return this.i.d.a();
    }

    public void a(ValueInput valueinput) {
        Optional<TrialSpawnerData.a> optional = valueinput.a(TrialSpawnerData.a.a);
        TrialSpawnerData trialspawnerdata = this.h;
        Objects.requireNonNull(this.h);
        optional.ifPresent(trialspawnerdata::a);
        this.i = valueinput.a(net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$b.a).orElse(net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$b.b);
    }

    public void a(ValueOutput valueoutput) {
        valueoutput.a(TrialSpawnerData.a.a, this.h.a());
        valueoutput.a(net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$b.a, this.i);
    }

    public void a(WorldServer worldserver, BlockPosition blockposition) {
        worldserver.a(blockposition, (IBlockData)worldserver.a_(blockposition).b(TrialSpawnerBlock.c, true), 3);
        worldserver.c(3020, blockposition, 1);
        this.n = true;
        this.h.a(this, worldserver);
    }

    public void b(WorldServer worldserver, BlockPosition blockposition) {
        worldserver.a(blockposition, (IBlockData)worldserver.a_(blockposition).b(TrialSpawnerBlock.c, false), 3);
        this.n = false;
    }

    public boolean d() {
        return this.n;
    }

    public int e() {
        return this.i.e;
    }

    public int f() {
        return this.i.f;
    }

    public TrialSpawnerState g() {
        return this.j.d();
    }

    public TrialSpawnerData h() {
        return this.h;
    }

    public void a(World world, TrialSpawnerState trialspawnerstate) {
        this.j.a(world, trialspawnerstate);
    }

    public void i() {
        this.j.f();
    }

    public PlayerDetector j() {
        return this.k;
    }

    public PlayerDetector.a k() {
        return this.l;
    }

    public boolean a(WorldServer worldserver) {
        return this.m ? true : (worldserver.an() == EnumDifficulty.a ? false : worldserver.P().c(GameRules.f));
    }

    public Optional<UUID> c(WorldServer worldserver, BlockPosition blockposition) {
        RandomSource randomsource = worldserver.H_();
        MobSpawnerData mobspawnerdata = this.h.b(this, worldserver.H_());
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(() -> "spawner@" + String.valueOf(blockposition), b);){
            Object entityinsentient;
            MobSpawnerData.a mobspawnerdata_a;
            ValueInput valueinput = TagValueInput.a((ProblemReporter)problemreporter_j, (HolderLookup.a)worldserver.K_(), mobspawnerdata.d());
            Optional<EntityTypes<?>> optional = EntityTypes.a(valueinput);
            if (optional.isEmpty()) {
                Optional<UUID> optional2 = Optional.empty();
                return optional2;
            }
            Vec3D vec3d = valueinput.a("Pos", Vec3D.a).orElseGet(() -> {
                TrialSpawnerConfig trialspawnerconfig = this.a();
                return new Vec3D((double)blockposition.u() + (randomsource.j() - randomsource.j()) * (double)trialspawnerconfig.c() + 0.5, blockposition.v() + randomsource.a(3) - 1, (double)blockposition.w() + (randomsource.j() - randomsource.j()) * (double)trialspawnerconfig.c() + 0.5);
            });
            if (!worldserver.b(optional.get().a(vec3d.d, vec3d.e, vec3d.f))) {
                Optional<UUID> optional3 = Optional.empty();
                return optional3;
            }
            if (!TrialSpawner.a((World)worldserver, blockposition.b(), vec3d)) {
                Optional<UUID> optional4 = Optional.empty();
                return optional4;
            }
            BlockPosition blockposition1 = BlockPosition.a(vec3d);
            if (!EntityPositionTypes.a(optional.get(), worldserver, EntitySpawnReason.q, blockposition1, worldserver.H_())) {
                Optional<UUID> optional5 = Optional.empty();
                return optional5;
            }
            if (mobspawnerdata.b().isPresent() && !(mobspawnerdata_a = mobspawnerdata.b().get()).a(blockposition1, worldserver)) {
                Optional<UUID> optional6 = Optional.empty();
                return optional6;
            }
            Entity entity = EntityTypes.a(valueinput, (World)worldserver, EntitySpawnReason.q, (Entity entity1) -> {
                entity1.b(vec3d.d, vec3d.e, vec3d.f, randomsource.i() * 360.0f, 0.0f);
                return entity1;
            });
            if (entity == null) {
                Optional<UUID> optional7 = Optional.empty();
                return optional7;
            }
            if (entity instanceof EntityInsentient) {
                boolean flag;
                entityinsentient = (EntityInsentient)entity;
                if (!((EntityInsentient)entityinsentient).a((IWorldReader)worldserver)) {
                    Optional<UUID> optional8 = Optional.empty();
                    return optional8;
                }
                boolean bl = flag = mobspawnerdata.a().i() == 1 && mobspawnerdata.a().i("id").isPresent();
                if (flag) {
                    ((EntityInsentient)entityinsentient).a((WorldAccess)worldserver, worldserver.d_(((Entity)entityinsentient).dx()), EntitySpawnReason.q, (GroupDataEntity)null);
                }
                ((EntityInsentient)entityinsentient).gp();
                Optional<EquipmentTable> optional1 = mobspawnerdata.c();
                Objects.requireNonNull(entityinsentient);
                optional1.ifPresent(arg_0 -> entityinsentient.a(arg_0));
            }
            if (CraftEventFactory.callTrialSpawnerSpawnEvent(entity, blockposition).isCancelled()) {
                entityinsentient = Optional.empty();
                return entityinsentient;
            }
            if (!worldserver.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER)) {
                entityinsentient = Optional.empty();
                return entityinsentient;
            }
            a trialspawner_a = this.n ? net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b : net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.a;
            worldserver.c(3011, blockposition, trialspawner_a.a());
            worldserver.c(3012, blockposition1, trialspawner_a.a());
            worldserver.a(entity, GameEvent.t, blockposition1);
            Optional<UUID> optional9 = Optional.of(entity.cK());
            return optional9;
        }
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, ResourceKey<LootTable> resourcekey) {
        LootParams lootparams;
        LootTable loottable = worldserver.q().bc().a(resourcekey);
        ObjectArrayList objectarraylist = loottable.a(lootparams = new LootParams.a(worldserver).a(LootContextParameterSets.b));
        if (!objectarraylist.isEmpty()) {
            BlockDispenseLootEvent spawnerDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(worldserver, blockposition, null, objectarraylist);
            if (spawnerDispenseLootEvent.isCancelled()) {
                return;
            }
            objectarraylist = new ObjectArrayList(spawnerDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList());
            for (ItemStack itemstack : objectarraylist) {
                DispenseBehaviorItem.a(worldserver, itemstack, 2, EnumDirection.b, Vec3D.c(blockposition).a(EnumDirection.b, 1.2));
            }
            worldserver.c(3014, blockposition, 0);
        }
    }

    public void a(World world, BlockPosition blockposition, boolean flag) {
        RandomSource randomsource;
        TrialSpawnerState trialspawnerstate = this.g();
        trialspawnerstate.a(world, blockposition, flag);
        if (trialspawnerstate.d()) {
            double d0 = Math.max(0L, this.h.d - world.ae());
            this.h.i = this.h.h;
            this.h.h = (this.h.h + trialspawnerstate.b() / (d0 + 200.0)) % 360.0;
        }
        if (trialspawnerstate.e() && (randomsource = world.H_()).i() <= 0.02f) {
            SoundEffect soundeffect = flag ? SoundEffects.nc : SoundEffects.nb;
            world.a(blockposition, soundeffect, SoundCategory.e, randomsource.i() * 0.25f + 0.75f, randomsource.i() + 0.5f, false);
        }
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, boolean flag) {
        TrialSpawnerState trialspawnerstate1;
        this.n = flag;
        TrialSpawnerState trialspawnerstate = this.g();
        if (this.h.b.removeIf(uuid -> TrialSpawner.a(worldserver, blockposition, uuid))) {
            this.h.d = worldserver.ae() + (long)this.a().h();
        }
        if ((trialspawnerstate1 = trialspawnerstate.a(blockposition, this, worldserver)) != trialspawnerstate) {
            this.a((World)worldserver, trialspawnerstate1);
        }
    }

    private static boolean a(WorldServer worldserver, BlockPosition blockposition, UUID uuid) {
        Entity entity = worldserver.b(uuid);
        return entity == null || !entity.bO() || !entity.ai().aj().equals(worldserver.aj()) || entity.dx().j(blockposition) > (double)f;
    }

    private static boolean a(World world, Vec3D vec3d, Vec3D vec3d1) {
        MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d1, vec3d, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        return movingobjectpositionblock.b().equals(BlockPosition.a(vec3d)) || movingobjectpositionblock.d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public static void a(World world, BlockPosition blockposition, RandomSource randomsource, ParticleType particletype) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)blockposition.u() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d1 = (double)blockposition.v() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d2 = (double)blockposition.w() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            world.a(Particles.ah, d0, d1, d2, 0.0, 0.0, 0.0);
            world.a(particletype, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void a(World world, BlockPosition blockposition, RandomSource randomsource) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)blockposition.u() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d1 = (double)blockposition.v() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d2 = (double)blockposition.w() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d3 = randomsource.k() * 0.02;
            double d4 = randomsource.k() * 0.02;
            double d5 = randomsource.k() * 0.02;
            world.a(Particles.bh, d0, d1, d2, d3, d4, d5);
            world.a(Particles.N, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void a(World world, BlockPosition blockposition, RandomSource randomsource, int i2, ParticleParam particleparam) {
        for (int j2 = 0; j2 < 30 + Math.min(i2, 10) * 5; ++j2) {
            double d0 = (double)(2.0f * randomsource.i() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * randomsource.i() - 1.0f) * 0.65;
            double d2 = (double)blockposition.u() + 0.5 + d0;
            double d3 = (double)blockposition.v() + 0.1 + (double)randomsource.i() * 0.8;
            double d4 = (double)blockposition.w() + 0.5 + d1;
            world.a(particleparam, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void b(World world, BlockPosition blockposition, RandomSource randomsource) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)blockposition.u() + 0.4 + randomsource.j() * 0.2;
            double d1 = (double)blockposition.v() + 0.4 + randomsource.j() * 0.2;
            double d2 = (double)blockposition.w() + 0.4 + randomsource.j() * 0.2;
            double d3 = randomsource.k() * 0.02;
            double d4 = randomsource.k() * 0.02;
            double d5 = randomsource.k() * 0.02;
            world.a(Particles.aM, d0, d1, d2, d3, d4, d5 * 0.25);
            world.a(Particles.ah, d0, d1, d2, d3, d4, d5);
        }
    }

    public void a(EntityTypes<?> entitytypes, World world) {
        this.h.b();
        this.i = this.i.a(entitytypes);
        this.a(world, TrialSpawnerState.a);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void a(PlayerDetector playerdetector) {
        this.k = playerdetector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void l() {
        this.m = true;
    }

    public static final class b
    extends Record {
        private final Holder<TrialSpawnerConfig> c;
        private final Holder<TrialSpawnerConfig> d;
        private final int e;
        private final int f;
        public static final MapCodec<b> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TrialSpawnerConfig.c.optionalFieldOf("normal_config", Holder.a(TrialSpawnerConfig.a)).forGetter(b::a), (App)TrialSpawnerConfig.c.optionalFieldOf("ominous_config", Holder.a(TrialSpawnerConfig.a)).forGetter(b::b), (App)ExtraCodecs.o.optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(b::c), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(b::d)).apply((Applicative)instance, b::new));
        public static final b b = new b(Holder.a(TrialSpawnerConfig.a), Holder.a(TrialSpawnerConfig.a), 36000, 14);

        public b(Holder<TrialSpawnerConfig> normal, Holder<TrialSpawnerConfig> ominous, int targetCooldownLength, int requiredPlayerRange) {
            this.c = normal;
            this.d = ominous;
            this.e = targetCooldownLength;
            this.f = requiredPlayerRange;
        }

        public b a(EntityTypes<?> entitytypes) {
            return new b(Holder.a(this.c.a().a(entitytypes)), Holder.a(this.d.a().a(entitytypes)), this.e, this.f);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "c", "d", "e", "f"}, this, o2);
        }

        public Holder<TrialSpawnerConfig> a() {
            return this.c;
        }

        public Holder<TrialSpawnerConfig> b() {
            return this.d;
        }

        public int c() {
            return this.e;
        }

        public int d() {
            return this.f;
        }
    }

    public static interface c {
        public void a(World var1, TrialSpawnerState var2);

        public TrialSpawnerState d();

        public void f();
    }

    public static enum a {
        a(Particles.F),
        b(Particles.N);

        public final ParticleType c;

        private a(ParticleType particletype) {
            this.c = particletype;
        }

        public static a a(int i2) {
            a[] atrialspawner_a = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.values();
            return i2 <= atrialspawner_a.length && i2 >= 0 ? atrialspawner_a[i2] : a;
        }

        public int a() {
            return this.ordinal();
        }
    }
}

